##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import wizard
import netsvc
import time

_line_form = '''<?xml version="1.0"?>
<form string="Split Invoice">
	<separator string="Split Invoice" colspan="4"/>
	<field name="invoice_id" colspan="3"/>
	<field name="date"/>
	<field name="manual_taxes"/>
	<field name="state"/>
	<separator string="Transactions (remove those to split)" colspan="4"/>
	<field name="invoice_lines" colspan="4" string=""/>
</form>'''

_line_fields = {
	'date': {'string':'Invoice Date', 'type':'date'},
	'manual_taxes': {'string':'Preserve Manual Taxes ?', 'type':'boolean'},
	'invoice_lines': {'string':'Preserved lines', 'type':'many2many', 'relation':'account.invoice.line','domain':"[('invoice_id','=',invoice_id)]"},
	'invoice_id': {'string':'Invoice', 'type':'many2one', 'relation':'account.invoice', 'readonly':True},
	'state': {'string':'Set State To', 'type':'selection', 'selection':[('draft','Keep Draft'),('open','Open'),('pro-forma','PRO-Forma')]},
}

def _invoice_split(self, uid, datas, res_get=False):
	service = netsvc.LocalService("object_proxy")
	invoice = service.execute(uid, 'account.invoice', 'read', [datas['id']], ['name', 'type', 'number', 'reference', 'project_id', 'comment', 'state', 'date_invoice', 'date_due', 'partner_id', 'address_contact_id', 'address_invoice_id', 'partner_contact', 'partner_insite', 'partner_ref', 'payment_term', 'account_id'])[0]

	del invoice['id']

	invoice['date_invoice'] = datas['form']['date']
	for field in ('address_contact_id','address_invoice_id','partner_id','project_id','account_id'):
		invoice[field] = invoice[field] and invoice[field][0]

	# create a new invoice
	invoice_id = service.execute(uid, 'account.invoice', 'create', invoice)
	
	# set the invoice_id field of the invoice lines to point to the newly created invoice
	service.execute(uid, 'account.invoice.line', 'write', datas['form']['invoice_lines'][0][2], {'invoice_id':invoice_id})

	return {}

def _line_get(self, uid, datas, res_get=False):
	service = netsvc.LocalService("object_proxy")
	invoice = service.execute(uid, 'account.invoice', 'read', [datas['id']], ['invoice_line','date_invoice','state'])[0]
	if invoice['state']!='draft':
		raise wizard.except_wizard('Invoice not draft !', 'You can split only DRAFT Invoices !\nSet the invoice to draft and retry.')

	datas['form']['invoice_id']=datas['id']
	datas['form']['invoice_lines']=invoice['invoice_line']
	datas['form']['manual_taxes']=0
	datas['form']['date']=invoice['date_invoice']

	print datas
	return datas['form']

class wiz_reconcile(wizard.interface):
	states = {
		'init': {
			'actions': [_line_get],
			'result': {'type': 'form', 'arch':_line_form, 'fields':_line_fields, 'state':[('split','Split Invoice'),('end','Cancel')]}
		},
		'split': {
			'actions': [_invoice_split],
			'result': {'type': 'state', 'state':'end'}
		}
	}
wiz_reconcile('account.invoice.split')

