##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import gobject
import gtk
from gtk import glade
import copy

import gettext

import wid_int
import wid_common
import form
import common

import rpc
import gettext


class dialog(object):
	def __init__(self, model, fields, arch, parent, state='Edition', value=None, win=None):
		self.win_gl = glade.XML(common.terp_path("terp.glade"),"dia_form_win_many2one",gettext.textdomain())
		self.dia = self.win_gl.get_widget('dia_form_win_many2one')

		self.form = form.form(arch, fields, model, parent=parent, window=self.dia)
		if value:
			self.form.value = value
		self.form.state_set('valid')


		self.sw = self.win_gl.get_widget('many2one_vp')
		self.sw.add(self.form.widget)

		self.dia.set_title('Ressource '+state+': '+self.form.name)
		self.dia.set_transient_for(win)
		self.dia.show_all()

	def run(self, datas={}):
		end = False
		while not end:
			res = self.dia.run()
			end = (res != gtk.RESPONSE_OK) or self.form.validate()
		if res==gtk.RESPONSE_OK:
			datas = self.form.value
			return (res==gtk.RESPONSE_OK, datas)
		return (False, False)

	def destroy(self):
		self.dia.destroy()

class reference(wid_int.wid_int):
	def __init__(self, parent, attrs={}):
		wid_int.wid_int.__init__(self, parent, attrs)
		self.win_gl = glade.XML(common.terp_path("terp.glade"),"widget_reference_model")
		self.win_gl.signal_connect('on_reference_new_button_press', self.sig_new )
		self.win_gl.signal_connect('on_reference_edit_button_press', self.sig_edit )
		self.widget = self.win_gl.get_widget('widget_reference_model')

		self.widget_combo = self.win_gl.get_widget('reference_model')
		self.widget_combo.child.set_editable(False)
		self.set_popdown(attrs.get('selection',[]))

		self.win_gl.get_widget('but_reference_new').set_property('can-focus',False)
		self.win_gl.get_widget('but_reference_open').set_property('can-focus',False)

		self.wid_text = self.win_gl.get_widget('reference_entry')
		self.ok=True
		self.widget_combo.connect('changed', self.sig_changed_combo)
		self.wid_text.connect('changed', self.sig_changed)
		self.wid_text.connect('activate', self.sig_activate)
		self.wid_text.connect('button_press_event', self._menu_open)
		self._value=None

	def get_model(self):
		res = self.widget_combo.child.get_text()
		return self._selection.get(res, False)

	def set_popdown(self, selection):
		model = gtk.ListStore(gobject.TYPE_STRING)
		self._selection={}
		self._selection2={}
		lst = []
		for (i,j) in selection:
			name = str(j)
			lst.append(name)
			self._selection[name]=i
			self._selection2[i]=name
		for l in lst:
			i = model.append()
			model.set(i, 0, l)
			self.widget_combo.child.set_text(l)
		self.widget_combo.set_model(model)
		self.widget_combo.set_text_column(0)
		return lst

	def _readonly_set(self, value):
		wid_int.wid_int._readonly_set(self, value)
		self.wid_text.set_editable(not value)
		self.wid_text.set_sensitive(not value)

	def _color_widget(self):
		return self.wid_text

	def _value_get(self):
		if self._value:
			return self.get_model()+','+str(self._value[0])
		else:
			return False

	def _menu_sig_pref(self, obj):
		self._menu_sig_default_set()

	def _menu_sig_default(self, obj):
		res = rpc.session.rpc_exec_auth('/object', 'execute', self.attrs['model'], 'default_get', [self.attrs['name']])
		self.value = res.get(self.attrs['name'], False)

	def sig_activate(self, *args):
		self.ok = False
		arg = self._domain_get(self.parent)
		arg2 = self._context_get(self.parent)
		res = self.trigger('many2one_sel', (self.model, self.name, self.wid_text.get_text(),self.get_model(),arg,arg2))
		if res:
			self.wid_text.set_text(str(res[1]))
			self.state_set('valid')
		self._value = res
		if self.attrs.get('on_change',False):
			self.on_change(self.attrs['on_change'])
		self.ok=True
		return self._value

	def sig_new(self, *args):
		(fields, model, arch) = self.trigger('template_get', (self.get_model(), 'form', self.attrs.get('view',False)) )
		val = self.trigger('default_get', (model,fields) )
		dia = dialog(model, fields, arch, self, state='Creation', value=val, win=self._window_get())
		end = res = False
		while not end:
			res = dia.run()
			if not res[0]:
				end = True
			else:
				try:
					res = rpc.session.rpc_exec_auth('/object', 'execute', model, 'create', res[1])
					if res:
						self.value = res
						if self.attrs.get('on_change',False):
							self.on_change(self.attrs['on_change'])
						end = True
				except rpc.rpc_exception, e:
					dia.form.state_propagate(e.data.split(','))
					common.error(_('Error: ')+str(e.type), e.message, e.data)
		dia.destroy()

	def sig_edit(self, *args):
		id = self._value and self._value[0]
		if id:
			(fields, model, arch) = self.trigger('template_get', (self.get_model(), 'form', self.attrs.get('view',False)) )
			try:
				val = rpc.session.rpc_exec_auth('/object', 'execute', model, 'read', [id])
			except rpc.rpc_exception, e:
				logging.getLogger('view.form').warning(_('Unable to read resource')+' %s, %d!' % (model,id))
			if val:
				dia = dialog(model, fields, arch, self, state='Edition', value=val[0])
				end = res = False
				while not end:
					res = dia.run()
					if not res[0]:
						end = True
					else:
						try:
							rpc.session.rpc_exec_auth('/object', 'execute', model, 'write', [id], res[1])
							end = True
						except rpc.rpc_exception, e:
							dia.form.state_propagate(e.data.split(','))
							common.error(_('Error: ')+str(e.type), e.message, e.data)
				dia.destroy()
			else:
				common.message(_('This record did not exist !'), gtk.MESSAGE_WARNING)
		else:
			self.sig_activate()
			#common.message(_('Error !\nYou can not edit an unexisting resource !'), gtk.MESSAGE_WARNING)

	def sig_changed_combo(self, *args):
		self.wid_text.set_text('')
		self._value = False

	def sig_changed(self, *args):
		if self.attrs.get('on_change',False) and self._value and self.ok:
			self._value = False
			self.on_change(self.attrs['on_change'])
			wid_int.wid_int.sig_changed(self)
		if self.ok:
			self._value = False

	def _value_set(self, value):
		self.ok = False
		if value:
			model,id = value.split(',')
			self.widget_combo.child.set_text(self._selection2[model])
			self.sig_changed()
			context = self._context_get(self.parent)
			name = self.trigger('name_id_get', (int(id), self.get_model(), context))
			if name:
				self._value = name
				self.wid_text.set_text( name[1] or '' )
			else:
				self._value=False
				self.wid_text.set_text( '' )
			self.state_set('valid')
		else:
			self._value = None
			self.wid_text.set_text( '' )
			self.state_set('valid')
		self.ok = True

	def clear(self):
		self.value = False
		return False

	value = property(_value_get, _value_set, None,
	  'The content of the widget or ValueError if not valid')
	value2 = property(_value_get, _value_set, None,
	  'The content of the widget or ValueError if not valid')

