##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import time
import gtk
from gtk import glade

import common
import wid_int
import locale

DT_FORMAT = '%Y-%m-%d'
DHM_FORMAT = '%Y-%m-%d %H:%M'
HM_FORMAT = '%H:%M'

class calendar(wid_int.wid_int):
	def __init__(self, parent, attrs={}):
		wid_int.wid_int.__init__(self, parent, attrs)
		self.win_gl = glade.XML(common.terp_path("terp.glade"),"widget_calendar")
		self.win_gl.signal_connect('on_but_calendar_clicked', self.cal_open)
		self.widget = self.win_gl.get_widget('widget_calendar')
		self.entry = self.win_gl.get_widget('ent_calendar')
		self.entry.connect('button_press_event', self._menu_open)
		self.state_set('valid')
		self.widget.connect('focus-in-event', lambda x,y: self._focus_in())
		self.widget.connect('focus-out-event', lambda x,y: self._focus_out())
		self.readonly=False

	def _color_widget(self):
		return self.entry

	def _readonly_set(self, value):
		wid_int.wid_int._readonly_set(self, value)
		self.entry.set_editable(not value)
		self.entry.set_sensitive(not value)


	def _value_get(self):
		str = self.entry.get_text()
		if str=='':
			return False
		try:
			date = time.strptime(str, '%d %m %Y')
		except:
			return False
		return time.strftime(DT_FORMAT, date)

	def validate(self):
		dt = self.entry.get_text()
		if not self.constraint['required'] and not dt:
			return True
		try:
			date = time.strptime(dt, '%d %m %Y')
		except ValueError:
			self.state_set('invalid')
			return False
		return wid_int.wid_int.validate(self)

	def _value_set(self, value):
		if not value:
			self.entry.set_text('')
		else:
			if len(value)>10:
				value=value[:10]
			date = time.strptime(value, DT_FORMAT)
			self.entry.set_text(time.strftime('%d %m %Y', date))

	value = property(_value_get, _value_set, None,
				'The content of the widget or ValueError if not valid')

	def cal_open(self, widget=None, val=None):
		if self.readonly:
			common.message(_('This widget is readonly !'))
			return True
		win_gl = glade.XML(common.terp_path("terp.glade"),"dia_form_wid_calendar")
		win = win_gl.get_widget('dia_form_wid_calendar')
		cal = win_gl.get_widget('cal_calendar')
		def close_window(widget, event):
			if event.type==gtk.gdk._2BUTTON_PRESS:
				win.activate_default()
		cal.connect('button_press_event', close_window)
		win.set_transient_for(self._window_get())
		win.set_destroy_with_parent(True)
		try:
			val = self.value
			if val:
				cal.select_month(int(val[5:7])-1, int(val[0:4]))
				cal.select_day(int(val[8:10]))
		except ValueError:
			pass
		response = win.run()
		if response == gtk.RESPONSE_OK:
			dt = cal.get_date()
			month = str(dt[1]+1)
			if len(month)<2:
				month='0'+month
			day = str(dt[2])
			if len(day)<2:
				day='0'+day
			self.value = str(dt[0])+'-'+month+'-'+day
		win.destroy()

	def clear(self):
		self.value = ''
        
class datetime(wid_int.wid_int):
	def __init__(self, parent, attrs={}):
		wid_int.wid_int.__init__(self, parent, attrs)
		self.win_gl = glade.XML(common.terp_path("terp.glade"),"widget_calendar")
		self.win_gl.signal_connect('on_but_calendar_clicked', self.cal_open)
		self.widget = self.win_gl.get_widget('widget_calendar')
		self.entry = self.win_gl.get_widget('ent_calendar')
		self.entry.connect('button_press_event', self._menu_open)
		self.state_set('valid')
		self.widget.connect('focus-in-event', lambda x,y: self._focus_in())
		self.widget.connect('focus-out-event', lambda x,y: self._focus_out())
		self.readonly=False

	def _color_widget(self):
		return self.entry

	def _readonly_set(self, value):
		self.readonly = value
		self.entry.set_editable(not value)
		self.entry.set_sensitive(not value)

	def _value_get(self):
		str = self.entry.get_text()
		if str=='':
			return False
		try:
			date = time.strptime(str, '%d %m %Y %H:%M')
		except:
			return False
		return time.strftime(DHM_FORMAT, date)

	def validate(self):
		dt = self.entry.get_text()
		if not self.constraint['required'] and not dt:
			return True
		try:
			date = time.strptime(dt, '%d %m %Y %H:%M')
		except ValueError:
			self.state_set('invalid')
			return False
		return wid_int.wid_int.validate(self)

	def _value_set(self, value):
		if not value:
			self.entry.set_text('')
		else:
			if len(value)>16:
				value=value[:16]
			try:
				date = time.strptime(value, DHM_FORMAT)
				self.entry.set_text(time.strftime('%d %m %Y %H:%M', date))
			except:
				self.entry.set_text(time.strftime('%d %m %Y %H:%M'))

	value = property(_value_get, _value_set, None,
				'The content of the widget or ValueError if not valid')

	def cal_open(self, widget=None, val=None):
		if self.readonly:
			common.message(_('This widget is readonly !'))
			return True
		win_gl = glade.XML(common.terp_path("terp.glade"),"dia_form_wid_datetime")
		win = win_gl.get_widget('dia_form_wid_datetime')
		hour = win_gl.get_widget('hour')
		minute = win_gl.get_widget('minute')
		cal = win_gl.get_widget('calendar')
		def close_window(widget, event):
			if event.type==gtk.gdk._2BUTTON_PRESS:
				win.activate_default()
		cal.connect('button_press_event', close_window)
		win.set_transient_for(self._window_get())
		win.set_destroy_with_parent(True)
		try:
			val = self.value
			if val:
				hour.set_value(int(val[11:13]))
				minute.set_value(int(val[-2:]))
				cal.select_month(int(val[5:7])-1, int(val[0:4]))
				cal.select_day(int(val[8:10]))
		except ValueError:
			pass
		response = win.run()
		if response == gtk.RESPONSE_OK:
			hr = int(hour.get_value())
			mi = int(minute.get_value())
			dt = cal.get_date()
			month = str(dt[1]+1)
			if len(month)<2:
				month='0'+month
			day = str(dt[2])
			if len(day)<2:
				day='0'+day
			self.value = '%s-%s-%s %s:%s' % (str(dt[0]), month, day, hr, mi)
		win.destroy()

	def clear(self):
		self.value = ''

class stime(wid_int.wid_int):
	def __init__(self, parent, attrs={}):
		wid_int.wid_int.__init__(self, parent, attrs)
		self.win_gl = glade.XML(common.terp_path("terp.glade"),"widget_time")
		self.widget = self.win_gl.get_widget('widget_time')
		self.entry = self.win_gl.get_widget('widget_time_entry')
		self.value=False

	def _readonly_set(self, value):
		self.readonly = value
		self.entry.set_editable(not value)
		self.entry.set_sensitive(not value)

	def _color_widget(self):
		return self.entry

	def validate(self):
		dt = self.entry.get_text()
		if not self.constraint['required'] and not dt:
			return True
		try:
			t = time.strptime(dt, '%H:%M')
		except ValueError:
			self.state_set('invalid')
			return False
		return wid_int.wid_int.validate(self)

	def _value_get(self):
		str = self.entry.get_text()
		if str=='':
			return False 
		try: 
			t = time.strptime(str, '%H:%M')
		except:
			return False
		return time.strftime(HM_FORMAT, t)

	def _value_set(self, value):
		self.entry.set_text(value or '00:00')

	value = property(_value_get, _value_set, None,
	  'The content of the widget or ValueError if not valid')
	value2 = property(_value_get, _value_set, None,
	  'The content of the widget or ValueError if not valid')
# vim:tw=0:noexpandtab
