##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import types

import gtk
import gobject
from gtk import glade
import gettext

import rpc
import widget
import win_selection
import win_preference
import win_filter
import win_search
import win_export
import win_import
import win_list

import common
import service
import options
import copy

def _form_read(name, value):
	if not value[1]:
		return []
	c = {}
	c.update(value[2])
	c.update(rpc.session.context)
	res = rpc.session.rpc_exec_auth('/object', 'execute', value[0], 'read', value[1], False, c)
	return res

def _template_get(name, value):
	if (len(value)==2) or (not value[2]):
		res = rpc.session.rpc_exec_auth('/object', 'execute', value[0], 'fields_view_get', 0, value[1], rpc.session.context)
	else:
		view_id = rpc.session.rpc_exec_auth('/object', 'execute', 'ir.ui.view', 'search', [('name','=',value[2])])
		res = rpc.session.rpc_exec_auth('/object', 'execute', value[0], 'fields_view_get', view_id[0], value[1], rpc.session.context)
	return (res['fields'], res['model'], res['arch'])

def _many2one_sel(name, value):
	context = value[5]
	context.update(rpc.session.context)
	
	if len(value)==7:
		sel_multi = value[6]
	else:
		sel_multi = False

	ids = rpc.session.rpc_exec_auth('/object', 'execute', value[3], 'name_search', value[2], value[4], 'ilike', context)
	if len(ids)==1:
		if sel_multi:
			res = [id[0] for id in ids]
		else:
			res = [ids[0][0]]
	else:
		res = rpc.session.rpc_exec_auth('/object', 'execute', value[3], 'fields_view_get', False, 'form', rpc.session.context)
		win = win_search.win_search(value[3], res, {'name':value[2]}, value[4], sel_multi=sel_multi, preload=True, ids=map(lambda x:x[0], ids), context=context)
		res = win.go()
		
	if res:
		res2 = rpc.session.rpc_exec_auth('/object', 'execute', value[3], 'name_get', res, context)
		if sel_multi:
			return res2
		return res2[0]
	return None

def _default_get(name, value):
	return rpc.session.rpc_exec_auth('/object', 'execute', value[0], 'default_get', value[1])

def _translate_signal(name, value):
	if not value[0]:
		common.message('You need to save ressource before adding translations')
		return
	uid = rpc.session.uid

	win = gtk.Dialog('Add Translation')

	lang_ids = rpc.session.rpc_exec_auth('/object', 'execute', 'res.lang', 'search', [('translatable','=','1')])
	langs = rpc.session.rpc_exec_auth('/object', 'execute', 'res.lang', 'read', lang_ids, ['code'])

	#Add english ; default value not in res.lang
	langs.append({'code':'en'})
	code = rpc.session.context.get('lang', 'en')

	#change 'en' to false for context
	def adapt_context(val):
		if val == 'en':
			return False
		else:
			return val

	#widget accessor fucntions
	def value_get(widget):
		if type(widget) == type(gtk.Entry()):
			return widget.get_text()
		elif type(widget.child) == type(gtk.TextView()):
			buffer = widget.child.get_buffer()
			iter_start = buffer.get_start_iter()
			iter_end = buffer.get_end_iter()
			return buffer.get_text(iter_start,iter_end,False)
		else:
			return None

	def value_set(widget, value):
		if type(widget) == type(gtk.Entry()):
			widget.set_text(value)
		elif type(widget.child) == type(gtk.TextView()):
			if value==False:
				value=''
			buffer = widget.child.get_buffer()
			buffer.delete(buffer.get_start_iter(), buffer.get_end_iter())
			iter_start = buffer.get_start_iter()
			buffer.insert(iter_start, value)

	def widget_duplicate(widget):
		if type(widget) == type(gtk.Entry()):
			return gtk.Entry()
		elif type(widget.child) == type(gtk.TextView()):
			tv = gtk.TextView()
			tv.set_wrap_mode(gtk.WRAP_WORD)
			sw = gtk.ScrolledWindow()
			sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_ALWAYS)
			sw.set_shadow_type(gtk.SHADOW_NONE)
			sw.set_size_request(-1, 80)
			sw.add(tv)
			tv.set_accepts_tab(False)
			return sw
		else:
			return None
	entries_list = []
	win.vbox.set_spacing(5)
	vbox = gtk.VBox()
	
	for lang in langs:
		context = copy.copy(rpc.session.context)
		context['lang'] = adapt_context(lang['code'])
		val = rpc.session.rpc_exec_auth('/object', 'execute', value[1], 'read', [value[0]], [value[2]], context)
		val = val[0]
		
		label = gtk.Label(lang['code'] or 'en')
		entry = widget_duplicate(value[4])

		hbox = gtk.HBox(homogeneous=True, spacing=0)
		if code == lang['code']:
			value_set(entry,value_get(value[4]))
		else:
			value_set(entry,val[value[2]])
		
		entries_list.append((val['id'], lang['code'], entry))
		hbox.pack_start(label, expand=False, fill=False)
		hbox.pack_start(entry, expand=True, fill=True)
		vbox.pack_start(hbox, expand=True, fill=True)
	
	sv = gtk.ScrolledWindow()
	sv.set_policy(gtk.POLICY_AUTOMATIC,gtk.POLICY_AUTOMATIC )
	sv.add_with_viewport(vbox)
	win.vbox.pack_start(sv)
	win.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)
	win.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
	win.resize(320,240)
	win.show_all()
	
	ok = False
	data = []
	while not ok:
		response = win.run()
		ok = True
		#res = None
		if response == gtk.RESPONSE_OK:
			to_save = map(lambda x : (x[0], x[1], value_get(x[2])), entries_list)
			while to_save != []:
				new_val = {}
				new_val['id'],new_val['lang'], new_val['value'] = to_save.pop()
				
				#update form field
				if new_val['lang'] == code:
					value_set(value[4],new_val['value'])
			
				context = copy.copy(rpc.session.context)
				context['lang'] = adapt_context(new_val['lang'])
				rpc.session.rpc_exec_auth('/object', 'execute', value[1], 'write', [value[0]], {str(value[2]):  new_val['value']}, context)
		if response == gtk.RESPONSE_CANCEL:
			win.destroy()
			return
	win.destroy()
	return

def _many2many_name_get(name, value):
#	context = value[2]
#	context.update(rpc.session.context)
	context = rpc.session.context
	return rpc.session.rpc_exec_auth('/object', 'execute', value[0], 'name_get', value[1], context)

def _many2one_name_get(name, value):
	context = value[2]
	context.update(rpc.session.context)
	name = rpc.session.rpc_exec_auth('/object', 'execute', value[1], 'name_get', [value[0]], context)
	if not len(name):
		return None
	return name[0]

def _char_selection(domain, args):
	res = rpc.session.rpc_exec_auth('/object', 'execute', args[0], 'distinct_field_get', args[1], args[2], domain)
	if len(res)>1:
		d = {}
		for x in res:
			d[x]=x
		res = common.selection(_('select field value:'), d)
		if res:
			return res[1]
		else:
			return None
	elif len(res)==1:
		return res[0]
	else:
		return None

class form(object):
	def __init__(self, view, model, res_id=False, domain=[], mode_form=True, window=None, context={}):
		self.model = model
		fields = view['fields']
		xml  = view['arch']
		view_name = view['name']
		self.view_data = view
		self.style='form'
		self.previous_action = None
		self.glade = glade.XML(common.terp_path("terp.glade"),'win_form_container')
		self.widget = self.glade.get_widget('win_form_container')
		self.widget.show_all()
		self.fields = fields
		self.domain = domain
		self.context = context
		self.tree = None
		self.triggers = [('template_get', _template_get, None), 
			('name_id_get', _many2one_name_get, None),
			('names_get', _many2many_name_get, None),
			('form_read', _form_read, None),
			('char_selection', _char_selection, self.domain),
			('many2one_sel', _many2one_sel, None),
			('translate_signal', _translate_signal, None),
			('default_get', _default_get, None),
			('action_execute', self._form_action_action, None),
			('object_execute', self._form_action_object, None),
			('workflow_execute', self._form_action_workflow, None),
			]
		self.form = widget.form(xml, fields, self.model, triggers = self.triggers, parent=window, window=window)
		self.name = self.form.name

		vp = gtk.Viewport()
		vp.add(self.form.widget)
		vp.set_shadow_type(gtk.SHADOW_NONE)
		vp.show()
		self.vp = vp

		sw = gtk.ScrolledWindow()
		sw.set_shadow_type(gtk.SHADOW_NONE)
		sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		sw.add(vp)
		sw.show()
		self.sw = sw
		
		self.has_backup = False
		self.backup = {}
		self.mode_form = True

		self.widget.pack_start(sw)
		self.handlers = {
			'but_new': ('New',self.sig_new),
			'but_copy': ('Copy',self.sig_copy),
			'but_save': ('Save',self.sig_save),
			'but_save_as': ('Save As',self.sig_save_as),
			'but_import': ('Import',self.sig_import),
			'but_filter': ('Filter',self.sig_filter),
			'but_print_repeat': ('Repeat',self.sig_print_repeat),
			'but_remove': ('Remove',self.sig_remove),
			'but_search': ('Search',self.sig_search),
			'but_previous': ('Previous',self.sig_previous),
			'but_next': ('Next', self.sig_next),
			'but_preference': ('Preferences', self.sig_preference),
			'but_goto_id': ('Go To ID...', self.sig_goto),
			'but_log': ('Access log', self.sig_logs),
			'but_print': ('Print', self.sig_print),
			'but_reload': (_('Reload'),self.sig_reload),
			'but_print_html': ('Print', self.sig_print_html),
			'but_action': ('Print', self.sig_action),
			'but_switch': ('Switch', self.sig_switch),
			'but_attach': ('Attach', self.sig_attach),
			'but_close': ('Close',self.sig_close)
		}
		self.search = []
		self.search_pos = 0
		if res_id:
			if type(res_id)==type(1):
				self.search=[res_id]
				self.res_read(res_id)
			else:
				self.search=res_id
				self.res_read(res_id[0])
		else:
			self.sig_new(autosave=False)
		if not mode_form:
			self.sig_switch(autosave=False,testchange=False)

	def sig_goto(self, *args):
		glade2 = glade.XML(common.terp_path("terp.glade"),'dia_goto_id')
		win = glade2.get_widget('dia_goto_id')
		widget = glade2.get_widget('goto_spinbutton')
		response = win.run()
		win.destroy()
		if response == gtk.RESPONSE_OK:
			self.search = [int(widget.get_value())]
			self.search_pos=0
			self.sig_reload()

	def ids_get(self):
		return self.search

	def id_get(self):
		try:
			return self.search[self.search_pos]
		except IndexError:
			return None

	def _form_action_action(self, name, value):
		id = self.sig_save(sig_new=False)
		if id:
			id2 = value[2] or id
			obj = service.LocalService('action.main')
			action_id = int(value[0])
			obj.execute(action_id, {'model':value[1], 'id': id2, 'ids': [id2]})
			self.sig_reload()

	def _form_action_object(self, name, value):
		id = self.sig_save(sig_new=False, auto_continue=False)
		if id:
			id2 = value[2] or id
			rpc.session.rpc_exec_auth('/object', 'execute', value[1], value[0], [id2], rpc.session.context)
			self.sig_reload()

	def _form_action_workflow(self, name, value):
		id = self.sig_save(sig_new=False, auto_continue=False)
		if id:
			rpc.session.rpc_exec_auth('/object', 'exec_workflow', value[1], value[0], id)
			self.sig_reload()

	def sig_attach(self, widget=None):
		if not self.mode_form:
			pos = self.tree.sel_ids_get()
			if len(pos)<>1:
				common.message(_('You have to select one, and only one, ressource !'))
				return False
		if not self.sig_autosave():
			return False
		if len(self.search)>self.search_pos:
			import win_attach
			win = win_attach.win_attach(self.model, self.search[self.search_pos])
			win.go()
		else:
			common.message(_('No resource selected !'))

	def sig_switch(self, widget=None, mode=None, autosave=True, testchange=True):
		if testchange and self.test_change():
			return
		if autosave:
			if not self.sig_autosave() and self.state=='edit':
				return
		if mode!=None and self.mode_form==mode:
			return
		if self.mode_form:
			self.vp.remove(self.form.widget)
			self.form.widget.hide()
		else:
			if self.tree:
				self.sw.remove(self.tree.widget)
				self.tree.widget.hide()
		self.mode_form = mode or not self.mode_form
		if self.mode_form:
			self.sig_reload()
			self.form.widget.show()
			self.vp.add(self.form.widget)
			self.sw.add(self.vp)
		else:
			if not self.tree:
				self.tree = win_list.win_list(self.model, sel_multi=False, context=self.context)
				self.tree.tree.isform = True
				self.tree.tree.save_callback = self._save_obj
				self.tree.tree.message_callback = self.message
				self.tree.tree.state_callback = self.message_state
			self.tree.reload(self.search)
			self.tree.sel_pos_set(self.search_pos)
			self.tree.widget.show()
			self.sw.remove(self.vp)
			self.sw.add(self.tree.widget)
			self.tree.widget.connect('row_activated', self._sig_row_activated)

	def _sig_row_activated(self, *args):
		pos = self.tree.sel_ids_get()
		if len(pos):
			pos= pos[0]
			i = 0
			for i in range(len(self.search)):
				if self.search[i]==pos:
					self.search_pos=i
					break
			self.sig_switch(mode=True)
			self.sig_reload()

	def sig_filter(self, widget=None):
		if not self.sig_autosave():
			return
		if len(self.search):
			win = win_filter.win_filter(self.model, self.search, True)
			self.search_pos=0
			res = win.go()
			if res!=None:
				self.search = res
				self.search_pos = 0
				self.sig_reload()
		else:
			self.message(_('Next: No record selected!'))

	def _id_get(self):
		if self.mode_form:
			id = self.form.id
		else:
			self.search_pos = self.tree.sel_pos_get()
			if self.search_pos:
				id = self.search[self.tree.sel_pos_get()]
			else:
				id=False
		return id

	def sig_logs(self, widget=None):
		id = self._id_get()
		if not id:
			common.message('You have to select one ressource!')
			return False
		res = rpc.session.rpc_exec_auth('/object', 'execute', self.model, 'perm_read', [id])
		message = ''
		for line in res:
			todo = [('id', 'ID'), ('create_uid', 'Creation User'), ('create_date','Creation Date'),('write_uid','Latest Modification by'), ('write_date','Latest Modification Date'), ('uid','Owner'), ('gid','Group Owner'), ('level','Access Level')]
			for (key,val) in todo:
				if line[key] and key in ('create_uid','write_uid','uid'):
					line[key] = line[key][1]
				message+=val+': '+str(line[key] or '/')+'\n'
		common.message(message)
		return True

	def sig_remove(self, widget=None):
		if self.mode_form==False:
			common.message('You can not remove in list mode !')
			return False
		if self.state=='edit':
			if common.sur(_('Are you sure you want\nto remove this record?')):
				try:
					if self.mode_form:
						id = self.form.id
					else:
						ids = self.tree.sel_ids_get()
						id = ids[0]
					rpc.session.rpc_exec_auth('/object', 'execute', self.model, 'unlink', [id])
					
					self.message(_('Resource removed.'))
					
					if self.search_pos<len(self.search):
						del self.search[self.search_pos]
						if self.search_pos == len(self.search):
							self.search_pos = 0
						self.sig_reload()
					else:
						self.sig_reload()
				except rpc.rpc_exception, e:
					self.message(_('Error removing resource!'))
		else:
			self.message(_('No resource selected!'))

	def sig_import(self, widget=None):
		fields = []
		if self.tree:
			fields = map(lambda x: (x,self.fields[x]['string']), self.tree.fields_order)
		win = win_import.win_import(self.model, self.fields, fields)
		res = win.go()

	def sig_save_as(self, widget=None):
		if not self.sig_autosave():
			return True
		fields = []
		if self.tree:
			fields = map(lambda x: (x,self.fields[x]['string']), self.tree.fields_order)
		win = win_export.win_export(self.model, self.search, self.fields, fields)
		res = win.go()

	def sig_new(self, widget=None, autosave=True, testchange=False):
		if autosave:
			if not self.sig_autosave() and self.state=='edit':
				return
		if testchange or not self.test_change():
			if self.mode_form or (self.tree and not self.tree.tree.editable):
				self.context.update(rpc.session.context)
				def_val = rpc.session.rpc_exec_auth('/object', 'execute', self.model, 'default_get', self.fields.keys(), self.context)
				self.form.clear()
				if self.domain:
					self.form.value=dict(map(lambda x: (x[0],x[2]),self.domain))
				print 'DEFAULT VAL', def_val
				self.form.value = def_val
				#if widget:
				#	self.search = []
				#	self.search_pos = 0
				self.backup = self.form.value
				self.has_backup = True
				self.state = 'new'
				self.id=0
				self.message_state(_('New document'))
				self.message('')
				self.sig_switch(mode=True, autosave=False,testchange=False)
			elif self.tree and self.tree.tree.editable:
				self.tree.tree.create_line()
				if self.tree.tree.create_new == 'bottom':
					path = len(self.tree.tree.model) - 1
				else:
					path = 0
				self.tree.tree.widget.edit_line(path)
	
	def sig_copy(self, *args):
		res_id = self._id_get()
		new_id = rpc.session.rpc_exec_auth('/object', 'execute', self.model, 'copy', res_id)
		if isinstance(new_id, (list, tuple)):
			self.search = new_id
		else:
			self.search = [new_id]
		self.search_pos=0
		self.sig_reload()

	def sig_autosave(self):
		#FIXME : stange, isn't it ?
		return True
		if self.mode_form and options.options['form.autosave']:
			return self._form_save()
		return True

	def _save_obj(self, id, data):
		self._remote_filter(data)
		if id is not None:
			self.context.update(rpc.session.context)
			udata = copy.copy(data)
			rpc.session.rpc_exec_auth('/object', 'execute', self.model, 'write', [id], data, self.context)
			return id
		else:
			# Create the ressource
			d=dict(map(lambda x: (x[0],x[2]),self.domain))
			data.update(d)
			self.context.update(rpc.session.context)
			return rpc.session.rpc_exec_auth('/object', 'execute', self.model, 'create', data, self.context)

	def _remote_filter(self, data):
		for field in data:
			if field in self.fields and self.fields[field]['type'] == 'many2one' and isinstance(data[field], (tuple, list)):
				data[field] = data[field][0]

	def _form_save(self, auto_continue=True):
		if self.form.validate():
			try:
				val = copy.copy(self.form.value)
				for key, value in val.items():
					if value and  self.fields.get(key, False) and self.fields[key]['type'] in ('many2one',):
						val[key] = val[key][0]
				self.context.update(rpc.session.context)
				if self.state=='new':
					d=dict(map(lambda x: (x[0],x[2]),self.domain))
					val.update(d)
					id = rpc.session.rpc_exec_auth('/object', 'execute', self.model, 'create', val, self.context)
					self.search.append(id)
					if auto_continue:
						self.search_pos = 0
					else:
						self.search_pos = len(self.search)-1
					if self.form.first:
						try:
							self.form.first.grab_focus()
						except:
							print 'ERROR FOCUS WIDGET!'
					return id
				elif self.state=='edit':
					id = self.form.id
					rpc.session.rpc_exec_auth('/object', 'execute', self.model, 'write', [id], val, self.context)
					if self.form.first:
						try:
							self.form.first.grab_focus()
						except:
							print 'ERROR FOCUS WIDGET!'
					return id
				else:
					raise 'Unknown state !'
			except rpc.rpc_exception, e:
				if e.type=='ValidateError':
					self.form.state_propagate(e.data.split(','))
				else:
					common.error(e.type, e.message, e.data)
				return False
		else:
			self.message(_('Invalid Form, correct red fields!'))
			return False

	def sig_save(self, widget=None, sig_new=True, auto_continue=True):
		if self.mode_form:
			res = self._form_save(auto_continue=auto_continue)
			if res and sig_new:
				self.sig_new(testchange=True)
			return res

	def test_change(self):
		if self.has_backup and self.form.value != self.backup:
			res = not common.sur('This resource has been modified and not saved !\nDo you want to continue ?')
			if not res:
				self.has_backup = False
			return res
		return False

	def res_read(self, id):
		c = {}
		c.update(self.context)
		c.update(rpc.session.context)
		fields = rpc.session.rpc_exec_auth('/object', 'execute', self.model, 'read', [id], self.fields.keys(), c)
		self.state='edit'
		self.form.value = fields[0]
		self.backup = self.form.value
		self.has_backup = True
		self.message_state(_('Editing document: ')+str(id))
		return

	def sig_previous(self, widget=None):
		if not self.sig_autosave():
			return
		if self.mode_form:
			if not self.test_change():
				if self.search_pos==0:
					self.search_pos=len(self.search)-1
					self.message(_('End of search'))
				else:
					self.search_pos-=1
				self.sig_reload()
		else:
			self.search_pos=self.tree.sel_pos_get()
			if self.search_pos==0:
				self.search_pos = len(self.search)-1
			else:
				self.search_pos-=1
			self.tree.sel_pos_set(self.search_pos)

	def sig_next(self, widget=None):
		if not self.sig_autosave():
			return
		if self.mode_form:
			if not self.test_change():
				if self.search_pos>=(len(self.search)-1):
					self.search_pos=0
					self.message(_('End of search'))
				else:
					self.search_pos+=1
				self.sig_reload()
		else:
			self.search_pos=self.tree.sel_pos_get()
			if self.search_pos>=(len(self.search)-1):
				self.search_pos=0
			else:
				self.search_pos+=1
			self.tree.sel_pos_set(self.search_pos)

	def _sig_reload_status(self):
		if len(self.search):
			self.message(_('Record: ')+str(self.search_pos+1)+' / '+str(len(self.search)))
		else:
			self.message(_('No record selected!'))

	def sig_reload(self):
		if self.mode_form:
			if (self.search_pos<0) or (self.search_pos>=len(self.search)):
				self.message(_('Search error!'))
			else:
				self.res_read(self.search[self.search_pos])
				self._sig_reload_status()
		else:
			self.tree.reload(self.search)
			self._sig_reload_status()

	def sig_action(self, keyword='client_action_multi', previous=False, report_type='pdf'):
		if self.mode_form:
			if self.state=='edit':
				ids = [self.form.id]
				id = self.form.id
				if not self.sig_save(sig_new=False):
					return False
			else:
				ids = []
		else:
			ids = [o[0]['id'] for o in self.tree.tree.model if 'id' in o[0]]
			id = self.form.id
		if len(ids):
			obj = service.LocalService('action.main')
			if previous and self.previous_action:
				obj._exec_action(self.previous_action[1], {'model':self.model, 'id': id or False, 'ids':ids, 'report_type': report_type})
			else:
				res = obj.exec_keyword(keyword, {'model':self.model, 'id': id or False, 'ids':ids, 'report_type': report_type})
				if res:
					self.previous_action = res
			self.sig_reload()
		else:
			self.message(_('No record selected!'))

	def sig_print_repeat(self):
		self.sig_action('client_print_multi', True)

	def sig_print_html(self):
		self.sig_action('client_print_multi', report_type='html')

	def sig_print(self):
		self.sig_action('client_print_multi')

	def _val_filter(self, val):
		search = []
		for x in val.keys():
			if val[x]:
				t = type(val[x])
				if t is types.IntType or t is types.FloatType:
					search.append( (x, '=', val[x]) )
				elif t is types.StringType:
					search.append( (x, 'like', val[x]) )
				elif t is types.DictType:
					res = self._val_filter(val[x])
					if res:
						search.append( (x, 'like', res) )
		return search

	def sig_search(self, widget=None):
		if not self.sig_autosave() and self.state=='edit':
			return
		if not self.test_change():
			dom = self.domain
			win = win_search.win_search(self.model, self.view_data, [], dom, triggers = self.triggers, context=self.context)
			res = win.go()
			if res:
				self.search = res
				self.search_pos = 0
				self.sig_reload()

	def message_state(self, message, context='message'):
		sb = self.glade.get_widget('stat_state')
		cid = sb.get_context_id(context)
		sb.push(cid, message)

	def message(self, message, context='message'):
		sb = self.glade.get_widget('stat_form')
		cid = sb.get_context_id(context)
		sb.push(cid, message)

	def sig_preference(self, widget=None):
		actions = rpc.session.rpc_exec_auth('/object', 'execute', 'ir.values', 'get', 'meta', False, [(self.model,False)], True, rpc.session.context, True)
		id = self.form.id
		if id and len(actions):
			win = win_preference.win_preference(self.model, id, actions)
			win.run()
		elif id:
			common.message(_('No preference available for this resource !'))
		else:
			common.message(_('Select a resource !'))

	def sig_close(self, urgent=False):
		if self.test_change():
			return False
		if not self.sig_autosave():
			return True
		return True
