#ifndef INDII_TINT_REG_COMPONENTS_HPP
#define INDII_TINT_REG_COMPONENTS_HPP

#include "wx/string.h"

namespace indii {
  namespace tint {
    namespace reg {
/**
 * Allows querying of installed components.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * @version $Rev: 107 $
 * @date $Date: 2009-09-12 15:46:17 +0800 (Sat, 12 Sep 2009) $
 */
class Components {
public:
  /**
   * Component ids.
   */
  enum Component {
    /**
     * Standalone.
     */
    STANDALONE,
    
    /**
     * Photoshop filter plugin.
     */
    PS_FILTER,

    /**
     * Paint Shop Pro filter plugin.
     */
    PSP_FILTER,

    /**
     * No. components.
     */
    NUM_COMPONENTS
    
  };
  
  /**
   * Is component activated?
   *
   * @param c The component.
   *
   * @return True if the component is activated, false otherwise.
   */
  static bool isActivated(const Component c);

  /**
   * Are all components activated?
   *
   * @return True if all components are activated, false otherwise.
   */
  static bool allActivated();
  
  /**
   * Activate component.
   *
   * @param c The component.
   * @param key The activation key.
   *
   * @return True if the component was successfully activated, false
   * otherwise.
   */
  static bool activate(const Component c, const wxString& key);

};

    }
  }
}
 
#endif

