#ifndef INDII_TINT_GUI_TINTREGISTRATION_HPP
#define INDII_TINT_GUI_TINTREGISTRATION_HPP

#include "wx/dialog.h"
#include "wx/textctrl.h"

namespace indii {
  namespace tint {
    namespace gui {
/**
 * Photoshop registration dialog.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * @version $Rev: 75 $
 * @date $Date: 2009-03-15 23:18:20 +0900 (Sun, 15 Mar 2009) $
 */
class TintRegistration : public wxDialog {
public:
  /**
   * Constructor.
   *
   * @param parent Parent.
   */
  TintRegistration(wxWindow* parent);

  /**
   * Destructor.
   */
  ~TintRegistration();

  /**
   * URL button event.
   */
  void OnButtonUrl(wxCommandEvent& evt);

  /**
   * OK button event.
   */
  void OnButtonOk(wxCommandEvent& evt);

  /**
   * Cancel button event.
   */
  void OnButtonCancel(wxCommandEvent& evt);

  /**
   * Close.
   */
  void OnClose(wxCloseEvent& evt);

private:
  /**
   * Key textbox.
   */
  wxTextCtrl* txtKey;

  /*
   * Control ids.
   */
  enum ID {
    ID_BUT_URL
  };

  DECLARE_EVENT_TABLE()

};

    }
  }
}

#endif
