#ifndef INDII_TINT_GUI_PREVIEWIMAGE_HPP
#define INDII_TINT_GUI_PREVIEWIMAGE_HPP

#include "../ImageResource.hpp"
#include "../ClusterModel.hpp"
#include "../ClusterModelObserver.hpp"

#include "wx/scrolwin.h"
#include "wx/bitmap.h"
#include "wx/dcclient.h"

namespace indii {
  namespace tint {
    namespace gui {
/**
 * Image preview.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * @version $Rev: 127 $
 * @date $Date: 2010-01-24 14:21:23 +0800 (Sun, 24 Jan 2010) $
 */
class PreviewImage : public wxScrolledWindow, public ClusterModelObserver {
public:
  /**
   * Constructor.
   *
   * @param parent Parent window.
   * @param res Image resource manager. Caller retains ownership.
   * @param model Cluster model. Caller retains ownership.
   */
  PreviewImage(wxWindow* parent, ImageResource* res, ClusterModel* model);

  /**
   * Destructor.
   */
  ~PreviewImage();

  /**
   * Zoom in.
   */
  void zoomIn();

  /**
   * Zoom out.
   */
  void zoomOut();

  /**
   * Zoom to 1:1
   */
  void zoomNormal();

  /**
   * Zoom to fit.
   */
  void zoomFit();

  /*
   * Model events.
   */
  virtual void notifyNumClustersChange();
  virtual void notifyClusterChange(const unsigned int i);  
  virtual void notifySaturationDecayChange();
  virtual void notifyCentroidDecayChange();
  virtual void notifySaturationSoftnessChange();
  virtual void notifyCentroidSoftnessChange();
  virtual void notifyGreyscaleChange();

  /**
   * Handle paint event.
   */
  void OnPaint(wxPaintEvent& evt);

  /**
   * Handle resize event.
   */
  void OnSize(wxSizeEvent& evt);

  /*
   * Mouse events.
   */ 
  void OnMouseDown(wxMouseEvent& evt);
  void OnMouseUp(wxMouseEvent& evt);
  void OnMouseWheel(wxMouseEvent& evt);
  void OnMouseMove(wxMouseEvent& evt);
  void OnMouseEnter(wxMouseEvent& evt);
  void OnMouseLeave(wxMouseEvent& evt);
  void OnEraseBackground(wxEraseEvent& evt);

private:
  /**
   * Image resource manager.
   */
  ImageResource* res;

  /**
   * Cluster model.
   */
  ClusterModel* model;

  /**
   * Zoom numerator.
   */
  unsigned int zoomNumerator;

  /**
   * Zoom denominator.
   */
  unsigned int zoomDenominator;

  /**
   * Device context should be cleared before next paint (used to control
   * flicker, only clear device context when not doing so may be a problem).
   */
  bool clear;

  /**
   * B&W layer.
   */
  wxBitmap bg;

  /**
   * Alpha channel workspace.
   */
  channel a;

  /*
   * Dragging variables.
   */
  bool dragging;
  int mouseX, mouseY;

  /**
   * Update background.
   *
   * @param rect Rectangular update region.
   */
  void updateBackground();

  DECLARE_EVENT_TABLE()

};

    }
  }
}

#endif
