#include "ChannelMixerPane.hpp"

#include "wx/wx.h"
#include "wx/gbsizer.h"

using namespace indii::tint;
using namespace indii::tint::gui;

ChannelMixerPane::ChannelMixerPane(wxWindow* parent, ClusterModel* model) :
    TintPane(parent), model(model) {
  static const int PADDING = 4;
  watch(model);

  wxGridBagSizer* sizer = new wxGridBagSizer();
  sizer->SetFlexibleDirection(wxHORIZONTAL);
  sizer->AddGrowableCol(1);

  slideRed = new wxSlider(this, ID_SLIDE_RED,
      ColourSpace::uround(model->getRedMix()*255.0f), 0, 255);
  slideGreen = new wxSlider(this, ID_SLIDE_GREEN,
      ColourSpace::uround(model->getGreenMix()*255.0f), 0, 255);
  slideBlue = new wxSlider(this, ID_SLIDE_BLUE,
      ColourSpace::uround(model->getBlueMix()*255.0f), 0, 255);

  wxStaticText *labelRed, *labelGreen, *labelBlue;
  labelRed = new wxStaticText(this, -1, _("Red"));
  labelGreen = new wxStaticText(this, -1, _("Green"));
  labelBlue = new wxStaticText(this, -1, _("Blue"));

  sizer->Add(labelRed, wxGBPosition(0,0), wxDefaultSpan,
      wxALIGN_CENTRE_VERTICAL|wxTOP|wxLEFT|wxRIGHT, PADDING);
  sizer->Add(labelGreen, wxGBPosition(1,0), wxDefaultSpan,
      wxALIGN_CENTRE_VERTICAL|wxTOP|wxLEFT|wxRIGHT, PADDING);
  sizer->Add(labelBlue, wxGBPosition(2,0), wxDefaultSpan,
      wxALIGN_CENTRE_VERTICAL|wxTOP|wxLEFT|wxRIGHT|wxBOTTOM, PADDING);

  sizer->Add(slideRed, wxGBPosition(0,1), wxDefaultSpan,
      wxALIGN_CENTRE|wxEXPAND|wxTOP|wxRIGHT, PADDING);
  sizer->Add(slideGreen, wxGBPosition(1,1), wxDefaultSpan,
      wxALIGN_CENTRE|wxEXPAND|wxTOP|wxRIGHT, PADDING);
  sizer->Add(slideBlue, wxGBPosition(2,1), wxDefaultSpan,
      wxALIGN_CENTRE|wxEXPAND|wxTOP|wxRIGHT|wxBOTTOM, PADDING);

  SetSizerAndFit(sizer);
}

void ChannelMixerPane::notifyGreyscaleChange() {
  int r = ColourSpace::uround(model->getRedMix()*255.0f);
  int g = ColourSpace::uround(model->getGreenMix()*255.0f);
  int b = ColourSpace::uround(model->getBlueMix()*255.0f);

  if (slideRed->GetValue() != r) {
    slideRed->SetValue(r);
  }
  if (slideGreen->GetValue() != g) {
    slideGreen->SetValue(g);
  }
  if (slideBlue->GetValue() != b) {
    slideBlue->SetValue(b);
  }
}

void ChannelMixerPane::OnSlide(wxScrollEvent& evt) {
  float r = slideRed->GetValue() / 255.0f;
  float g = slideGreen->GetValue() / 255.0f;
  float b = slideBlue->GetValue() / 255.0f;

  model->setGreyscale(r, g, b);
}

BEGIN_EVENT_TABLE(ChannelMixerPane, wxPanel)

EVT_COMMAND_SCROLL_THUMBRELEASE(ID_SLIDE_RED, ChannelMixerPane::OnSlide)
EVT_COMMAND_SCROLL_THUMBRELEASE(ID_SLIDE_GREEN, ChannelMixerPane::OnSlide)
EVT_COMMAND_SCROLL_THUMBRELEASE(ID_SLIDE_BLUE, ChannelMixerPane::OnSlide)

EVT_COMMAND_SCROLL_TOP(ID_SLIDE_RED, ChannelMixerPane::OnSlide)
EVT_COMMAND_SCROLL_TOP(ID_SLIDE_GREEN, ChannelMixerPane::OnSlide)
EVT_COMMAND_SCROLL_TOP(ID_SLIDE_BLUE, ChannelMixerPane::OnSlide)

EVT_COMMAND_SCROLL_BOTTOM(ID_SLIDE_RED, ChannelMixerPane::OnSlide)
EVT_COMMAND_SCROLL_BOTTOM(ID_SLIDE_GREEN, ChannelMixerPane::OnSlide)
EVT_COMMAND_SCROLL_BOTTOM(ID_SLIDE_BLUE, ChannelMixerPane::OnSlide)

EVT_COMMAND_SCROLL_PAGEUP(ID_SLIDE_RED, ChannelMixerPane::OnSlide)
EVT_COMMAND_SCROLL_PAGEUP(ID_SLIDE_GREEN, ChannelMixerPane::OnSlide)
EVT_COMMAND_SCROLL_PAGEUP(ID_SLIDE_BLUE, ChannelMixerPane::OnSlide)

EVT_COMMAND_SCROLL_PAGEDOWN(ID_SLIDE_RED, ChannelMixerPane::OnSlide)
EVT_COMMAND_SCROLL_PAGEDOWN(ID_SLIDE_GREEN, ChannelMixerPane::OnSlide)
EVT_COMMAND_SCROLL_PAGEDOWN(ID_SLIDE_BLUE, ChannelMixerPane::OnSlide)

EVT_COMMAND_SCROLL_LINEUP(ID_SLIDE_RED, ChannelMixerPane::OnSlide)
EVT_COMMAND_SCROLL_LINEUP(ID_SLIDE_GREEN, ChannelMixerPane::OnSlide)
EVT_COMMAND_SCROLL_LINEUP(ID_SLIDE_BLUE, ChannelMixerPane::OnSlide)

EVT_COMMAND_SCROLL_LINEDOWN(ID_SLIDE_RED, ChannelMixerPane::OnSlide)
EVT_COMMAND_SCROLL_LINEDOWN(ID_SLIDE_GREEN, ChannelMixerPane::OnSlide)
EVT_COMMAND_SCROLL_LINEDOWN(ID_SLIDE_BLUE, ChannelMixerPane::OnSlide)

EVT_COMMAND_SCROLL_THUMBTRACK(ID_SLIDE_RED, ChannelMixerPane::OnSlide)
EVT_COMMAND_SCROLL_THUMBTRACK(ID_SLIDE_GREEN, ChannelMixerPane::OnSlide)
EVT_COMMAND_SCROLL_THUMBTRACK(ID_SLIDE_BLUE, ChannelMixerPane::OnSlide)

END_EVENT_TABLE()

