#ifndef INDII_TINT_MASKCACHE_HPP
#define INDII_TINT_MASKCACHE_HPP

#include "wx/image.h"
#include "wx/bitmap.h"

#include <map>

namespace indii {
  namespace tint {

/**
 * Cache of various masks of an image.
 *
 * @author Lawrence Murray <lawrence@indii.org>
 * @version $Rev: 74 $
 * @date $Date: 2009-03-02 14:59:56 +0900 (Mon, 02 Mar 2009) $
 */
class MaskCache {
public:
  /**
   * Constructor.
   *
   * @param image Original image representing mask. wxBLACK represents
   * background, wxWHITE foreground.
   */
  MaskCache(wxImage* image);
      
  /**
   * Destructor.
   */
  virtual ~MaskCache();
  
  /**
   * Get resized mask.
   *
   * @param width Width of the image.
   * @param height Height of the image.
   *
   * @return The resized mask. Caller has ownership.
   *
   * If either @p width or @p height is <= 0, a mask of the original size is
   * returned.
   */
  wxMask* get(const int width = 0, const int height = 0);

private:
  /**
   * Image dimension.
   */
  typedef std::pair<const int, const int> dim_t;
  
  /**
   * Image cache.
   */
  typedef std::map<dim_t,wxBitmap*> cache_t;
  
  /**
   * Image cache pair.
   */
  typedef std::pair<dim_t,wxBitmap*> cache_pair_t;
  
  /**
   * Original mask image.
   */
  wxImage* original;

  /**
   * Original mask.
   */
  wxBitmap* originalMask;
  
  /**
   * Cache.
   */
  cache_t cache;
  
};
  
  }
}

#endif

