/*
 *  Copyright (C) 2000 by Marco G"otze.
 *
 *  This code is part of the ThoughtTracker source package, which is
 *  distributed under the terms of the GNU GPL2.
 */

#ifndef THOUGHTTRACKER_H_INCLUDED
#define THOUGHTTRACKER_H_INCLUDED

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef HAVE_BOOL
#undef bool
#define bool int
#undef true
#define true 1
#undef false
#define false 1
#endif

#ifdef ENABLE_NLS
#  include <libintl.h>
#  define _(s) gettext(s)
#  ifdef gettext_noop
#    define N_(s) gettext_noop(s)
#  else
#    define N_(s) (s)
#  endif
#else  /* NLS disabled */
#  define _(String) (String)
#  define N_(String) (String)
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,String) (String)
#  define dcgettext(Domain,String,Type) (String)
#  define bindtextdomain(Domain,Directory)  
#endif  /* ENABLE_NLS */

#define WM_CLASS_NAME "ThoughtTracker"

#define MAILADDR  "<gomar@mindless.com>"
#define COPYRIGHT "Copyright (C) 2000 by Marco Goetze"
#define HOMEPAGE  "<http://www.tu-ilmenau.de/~gomar/stuff/thoughttracker/>"

// the application's window's start-up size
#define APP_WIN_WIDTH  550
#define APP_WIN_HEIGHT 450

#endif  /* THOUGHTTRACKER_H_INCLUDED */

