/*

    File: file_cwk.c

    Copyright (C) 2006 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 51
    Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include <stdio.h>
#include "types.h"
#include "photorec.h"

static const char* header_check_cwk(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery);
static void file_check_cwk(t_file_recovery *file_recovery);

const t_file_hint file_hint_cwk= {
  .extension="cwk",
  .description="AppleWorks",
  .min_header_distance=0,
  .min_filesize=8,
  .max_filesize=200*1024*1024,
  .recover=1,
  .header_check=&header_check_cwk,
  .data_check=NULL,
  .file_check=&file_check_cwk
};

static const char* header_check_cwk(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery)
{
  if(buffer[4]=='B' && buffer[5]=='O' && buffer[6]=='B' && buffer[7]=='O')
    return file_hint_cwk.extension;
  return NULL;
}

static void file_check_cwk(t_file_recovery *file_recovery)
{
  const unsigned char cwk_footer[4]= {0xf0, 0xf1, 0xf2, 0xf3};
  file_search_footer(file_recovery, cwk_footer,sizeof(cwk_footer));
  if(file_recovery->file_size>0)
    file_recovery->file_size+=4;
}
