/*

    File: hfsp.c

    Copyright (C) 1998-2005 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 59
    Temple Place - Suite 330, Boston MA 02111-1307, USA.

 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
 
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include "types.h"
#include "common.h"
#include "hfsp.h"
#include "intrf.h"
#include "fnctdsk.h"
static int set_HFSP_info(t_partition *partition, const struct hfsp_vh *vh);

int check_HFSP(t_param_disk *disk_car,t_partition *partition,const int debug)
{
  unsigned char buffer[8*DEFAULT_SECTOR_SIZE];
  if(disk_car->read(disk_car,sizeof(buffer), &buffer, partition->part_offset+0x400)!=0)
  { return 1; }
  if(test_HFSP(disk_car,(struct hfsp_vh *)&buffer,partition,debug,0)!=0)
    return 1;
  set_HFSP_info(partition,(struct hfsp_vh *)&buffer);
  return 0;
}

int recover_HFSP(t_param_disk *disk_car, const struct hfsp_vh *vh,t_partition *partition,const int debug, const int dump_ind, const int backup)
{
  uint64_t part_size;
  if(test_HFSP(disk_car,vh,partition,debug,dump_ind)!=0)
    return 1;
  part_size=(uint64_t)be32(vh->total_blocks)*be32(vh->blocksize);
  if(backup>0)
  {
    if(partition->part_offset+2*disk_car->sector_size<part_size)
      return 1;
    /* backup is at total_blocks-2 */
    partition->boot_sector=(part_size-0x400)/disk_car->sector_size;
    partition->part_offset=partition->part_offset+2*disk_car->sector_size-part_size;
  }
  partition->part_size=part_size;
  set_HFSP_info(partition,vh);
  partition->part_type_i386=P_HFSP;
  partition->part_type_mac=PMAC_HFS;
  if(debug>0)
  {
    ecrit_rapport("part_size %lu\n",(long unsigned)(partition->part_size/disk_car->sector_size));
  }
  return 0;
}

int test_HFSP(t_param_disk *disk_car, const struct hfsp_vh *vh,t_partition *partition,const int debug, const int dump_ind)
{
  if (vh->signature==be16(HFSP_VOLHEAD_SIG))
  {
    if(debug>0 || dump_ind!=0)
    {
      ecrit_rapport("\nHFS+ magic value at %u/%u/%u\n", offset2cylinder(disk_car,partition->part_offset),offset2head(disk_car,partition->part_offset),offset2sector(disk_car,partition->part_offset));
    }
    if(dump_ind!=0)
    {
      /* There is a little offset ... */
      dump(stdscr,vh,DEFAULT_SECTOR_SIZE);
    }
    if(debug>1)
    {
      ecrit_rapport("total_blocks %u\n",(unsigned) be32(vh->total_blocks));
      ecrit_rapport("blocksize %u\n",(unsigned) be32(vh->blocksize));
      ecrit_rapport("free_blocks %u\n",(unsigned) be32(vh->free_blocks));
    }
    if(be32(vh->blocksize)%512!=0)
      return 1;
    partition->upart_type=UP_HFSP;
    return 0;
  }
  return 1;
}

static int set_HFSP_info(t_partition *partition, const struct hfsp_vh *vh)
{
  partition->name[0]='\0';
  snprintf(partition->info,sizeof(partition->info),"HFS+");
  return 0;
}

