/*

    File: file_bmp.c

    Copyright (C) 1998-2005 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 59
    Temple Place - Suite 330, Boston MA 02111-1307, USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include "types.h"
#include "photorec.h"

static const char* header_check_bmp(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery);
static int data_check_bmp(const unsigned char *buffer, const unsigned int buffer_size, t_file_recovery *file_recovery);

const t_file_hint file_hint_bmp= {
  .extension="bmp",
  .description="BMP bitmap image",
  .min_header_distance=0,
  .min_filesize=65,
  .max_filesize=PHOTOREC_MAX_FILE_SIZE,
  .recover=1,
  .header_check=&header_check_bmp,
  .data_check=&data_check_bmp,
  .file_check=NULL
};

static uint64_t bmp_file_size=0;

static const char* header_check_bmp(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery)
{
  if(buffer[0]=='B' && buffer[1]=='M' &&
    buffer[6]==0x00 && buffer[7]==0x00 && buffer[8]==0x00 && buffer[9]==0x00)
  {
    bmp_file_size=(uint64_t)buffer[2]+(((uint64_t)buffer[3])<<8)+(((uint64_t)buffer[4])<<16)+(((uint64_t)buffer[5])<<24);
    return file_hint_bmp.extension;
  }
  return NULL;
}

static int data_check_bmp(const unsigned char *buffer, const unsigned int buffer_size, t_file_recovery *file_recovery)
{
  if(file_recovery->file_size>=bmp_file_size)
  {
    file_recovery->file_size=bmp_file_size;
    return 2;
  }
  return 1;
}

