#!/bin/sh
# default, host is empty, no cross compilation
#host=i586-pc-msdosdjgpp
#host=i386-pc-cygwin
#host=i386-pc-mingw32 not tested
# Comment the version definition to not compile the library
VER_TESTDISK=6.1
VER_E2FSPROGS=
VER_PROGSREISERFS=0.3.1-rc8
VER_NTFSPROGS=1.9.4
#VER_NTFSPROGS=1.12.0

host=
prefix=/usr/$host
if [ "$CC" == "gcc295" ];
then
  VER_NTFSPROGS=
fi
if [ -z $1 ];
then
  compiledir=.
else
  compiledir=$1
  if [ "$1" != "$CC" ];
  then
    VER_E2FSPROGS=1.38
    host=$1
    CC=$host-gcc
#    CC="$host-gcc -mno-cygwin"
    export CC
  fi
fi
LD=ld
export LD
AR=ar
export AR
LYNX=links
LIBEXT=$compiledir/e2fsprogs-$VER_E2FSPROGS/lib/ext2fs/libext2fs.a
LIBNTFS=$compiledir/ntfsprogs-$VER_NTFSPROGS/libntfs/.libs/libntfs.a
LIBREISER=$compiledir/progsreiserfs-$VER_PROGSREISERFS/libreiserfs/.libs/libreiserfs.a
pwd_saved=`pwd`
confdir=`(dirname "$0") 2>/dev/null`
cd $confdir
confdir=`pwd`
cd $pwd_saved

PWDSRC=`pwd|sed 's#^\w:/#/#'`/$compiledir

CONFIGUREOPT=
mkdir -p $compiledir
echo "This script will try to compile e2fsprogs progsreiserfs ntfsprogs libraries"
if [ "$VER_E2FSPROGS" != "" ];
then
CONFIGUREOPT="$CONFIGUREOPT --with-ext2fs-lib=${PWDSRC}/e2fsprogs-${VER_E2FSPROGS}/lib --with-ext2fs-includes=${PWDSRC}/e2fsprogs-${VER_E2FSPROGS}/lib"

if [ ! -e e2fsprogs-$VER_E2FSPROGS.tar.gz ];
then
	$LYNX http://prdownloads.sourceforge.net/e2fsprogs/e2fsprogs-$VER_E2FSPROGS.tar.gz
fi

if [ -e e2fsprogs-$VER_E2FSPROGS.tar.gz ];
then
  if [ ! -e $compiledir/e2fsprogs-$VER_E2FSPROGS/configure ];
  then
	tar xzf e2fsprogs-$VER_E2FSPROGS.tar.gz -C $compiledir
  fi
fi

if [ -d $compiledir/e2fsprogs-$VER_E2FSPROGS ];
then
  if [ ! -e $compiledir/e2fsprogs-$VER_E2FSPROGS/Makefile ];
  then
  	cd $compiledir/e2fsprogs-$VER_E2FSPROGS
	CFLAGS="$CFLAGS -DOMIT_COM_ERR" ./configure --host=$host --prefix=$prefix
	cd $pwd_saved
  fi
  if [ ! -e $LIBEXT ];
  then
	cd $compiledir/e2fsprogs-$VER_E2FSPROGS
	make libs
	cd $pwd_saved
  fi
fi
fi

if [ "$VER_PROGSREISERFS" != "" ];
then
CONFIGUREOPT="$CONFIGUREOPT --with-reiserfs-lib=${PWDSRC}/progsreiserfs-${VER_PROGSREISERFS}/libreiserfs/.libs/ --with-reiserfs-includes=${PWDSRC}/progsreiserfs-${VER_PROGSREISERFS}/include/ --with-dal-lib=${PWDSRC}/progsreiserfs-${VER_PROGSREISERFS}/libdal/.libs/"
if [ ! -e progsreiserfs-$VER_PROGSREISERFS.tar.gz ];
then
	$LYNX http://reiserfs.osdn.org.ua/snapshots/progsreiserfs-$VER_PROGSREISERFS.tar.gz
fi

if [ -e progsreiserfs-$VER_PROGSREISERFS.tar.gz ];
then
  if [ ! -e $compiledir/progsreiserfs-$VER_PROGSREISERFS/configure ];
  then
	tar xzf progsreiserfs-$VER_PROGSREISERFS.tar.gz -C $compiledir
  fi
fi

if [ -d $compiledir/progsreiserfs-$VER_PROGSREISERFS ];
then
  if [ ! -e $compiledir/progsreiserfs-$VER_PROGSREISERFS/Makefile ];
  then
	cd $compiledir/progsreiserfs-$VER_PROGSREISERFS
	./configure --host=$host --prefix=$prefix --disable-nls --disable-Werror
	cd $pwd_saved
  fi
  if [ ! -e $LIBREISER ];
  then
	cd $compiledir/progsreiserfs-$VER_PROGSREISERFS
	make
	cd $pwd_saved
  fi
fi
fi

if [ "$VER_NTFSPROGS" != "" ];
then
CONFIGUREOPT="$CONFIGUREOPT --with-ntfs-lib=${PWDSRC}/ntfsprogs-${VER_NTFSPROGS}/libntfs/.libs/ --with-ntfs-includes=${PWDSRC}/ntfsprogs-${VER_NTFSPROGS}/include/"
if [ ! -e ntfsprogs-$VER_NTFSPROGS.tar.gz ];
then
	$LYNX http://prdownloads.sourceforge.net/linux-ntfs/ntfsprogs-$VER_NTFSPROGS.tar.gz
fi

if [ -e ntfsprogs-$VER_NTFSPROGS.tar.gz ];
then
  if [ ! -e $compiledir/ntfsprogs-$VER_NTFSPROGS/configure ];
  then
	tar xzf ntfsprogs-$VER_NTFSPROGS.tar.gz -C $compiledir
  fi
fi

if [ -d $compiledir/ntfsprogs-$VER_NTFSPROGS ];
then
  if [ ! -e $compiledir/ntfsprogs-$VER_NTFSPROGS/Makefile ];
  then
	cd $compiledir/ntfsprogs-$VER_NTFSPROGS
# --disable-default-device-io-ops is need for NT 4
	./configure --host=$host --prefix=$prefix --disable-default-device-io-ops
	cd $pwd_saved
  fi
  if [ ! -e $LIBNTFS ];
  then
	cd $compiledir/ntfsprogs-$VER_NTFSPROGS
	make libs
	cd $pwd_saved
  fi
fi
fi

echo "Try to compile TestDisk"

if [ -d $compiledir ];
then
  if [ ! -e $compiledir/Makefile ];
  then
  	cd $compiledir
	$confdir/configure --host=$host $CONFIGUREOPT
	cd $pwd_saved
  fi
  cd $compiledir
  make static
  cd $pwd_saved
fi

