/*

    File: bfs.c

    Copyright (C) 1998-2004 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
 
#include "types.h"
#include "common.h"
#include "bfs.h"
#include "intrf.h"
#include "fnctdsk.h"

static int set_BeFS_info(t_param_disk *disk_car, const struct disk_super_block *beos_block,t_partition *partition,const int debug, const int dump_ind);
static int test_BeFS(t_param_disk *disk_car, const struct disk_super_block*beos_block,t_partition *partition,const int debug, const int dump_ind);

int check_BeFS(t_param_disk *disk_car,t_partition *partition,const int debug)
{
  unsigned char buffer[8*DEFAULT_SECTOR_SIZE];
  if(disk_car->read(disk_car,sizeof(buffer), &buffer, partition->part_offset)!=0)
    return 1;
  if(test_BeFS(disk_car,(struct disk_super_block*)&buffer[0x200],partition,debug,0)!=0)
    return 1;
  set_BeFS_info(disk_car,(struct disk_super_block*)&buffer[0x200],partition,debug,0);
  return 0;
}

int recover_BeFS(t_param_disk *disk_car, const struct disk_super_block *beos_block,t_partition *partition,const int debug, const int dump_ind)
{
  if(test_BeFS(disk_car,beos_block,partition,debug,dump_ind)!=0)
    return 1;
  set_BeFS_info(disk_car,beos_block,partition,debug,0);
  partition->part_size=beos_block->num_blocks*(1<<beos_block->block_shift);
  partition->part_type=(unsigned char)P_BEOS;
  return 0;
}

static int test_BeFS(t_param_disk *disk_car, const struct disk_super_block*beos_block,t_partition *partition,const int debug, const int dump_ind)
{
  if((beos_block->magic1==SUPER_BLOCK_MAGIC1)
     && (beos_block->magic2==(signed)SUPER_BLOCK_MAGIC2)
     && (beos_block->magic3==SUPER_BLOCK_MAGIC3))
  {
    partition->upart_type=UP_BEOS;
    if(dump_ind!=0)
    {
      ecrit_rapport("\nBeFS magic value at %u/%u/%u\n", offset2cylinder(disk_car,partition->part_offset),offset2head(disk_car,partition->part_offset),offset2sector(disk_car,partition->part_offset));
      dump(stdscr,beos_block,DEFAULT_SECTOR_SIZE);
    }
    return 0;
  }
  return 1;
}

static int set_BeFS_info(t_param_disk *disk_car, const struct disk_super_block *beos_block,t_partition *partition,const int debug, const int dump_ind)
{
  partition->info[0]='\0';
  set_part_name(partition,beos_block->name,B_OS_NAME_LENGTH);
  return 0;
}
