<?xml version="1.0"?>
<!-- WARNING: Tellico uses tc as the internal namespace declaration, and it must be identical here!! -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:tc="http://periapsis.org/tellico/"
                xmlns:str="http://exslt.org/strings"
                extension-element-prefixes="str"
                exclude-result-prefixes="tc"
                version="1.0">

<!--
   ===================================================================
   Tellico XSLT file - Group View Report

   Copyright (C) 2005 Robby Stephenson - robby@periapsis.org

   This XSLT stylesheet is designed to be used with the 'Tellico'
   application, which can be found at http://www.periapsis.org/tellico/

   ===================================================================
-->

<!-- import common templates -->
<!-- location depends on being installed correctly -->
<xsl:import href="../tellico-common.xsl"/>

<xsl:output method="html" version="xhtml" encoding="utf-8"/>

<xsl:key name="entriesById" match="tc:entry" use="@id"/>
<xsl:key name="loansByDate" match="tc:loan" use="@dueDate"/>

<xsl:template match="/">
 <xsl:apply-templates select="tc:tellico"/>
</xsl:template>

<xsl:template match="tc:tellico">
 <html>
  <head>
   <style type="text/css">
   body {
        font-family: sans-serif;
        background-color: #fff;
   }
   h1.colltitle {
        margin: 0px;
        padding-bottom: 5px;
        font-size: 2em;
        text-align: center;
   }
   table {
        margin-left: auto;
        margin-right: auto;
        margin-bottom: 30px;
   }
   td.groupName {
        margin-top: 10px;
        margin-bottom: 2px;
        padding-left: 4px;
        background: #ccc;
        font-size: 1.1em;
        font-weight: bolder;
   }
   td.fieldName {
        margin-top: 10px;
        margin-bottom: 2px;
        color: #666;
        background-color: #ccc;
        font-size: 1.1em;
        text-align: center;
        font-style: italic;
        padding-left: 4px;
        padding-right: 4px;
   }
   tr.r0 {
   }
   tr.r1 {
        background-color: #eee;
   }
   td.field {
        margin: 0px;
        padding: 0px 10px 0px 10px;
        border: 1px solid #eee;
        text-align: left;
   }
   </style>
   <title>Tellico</title>
  </head>
  <body>
   <xsl:apply-templates select="tc:collection"/>
  </body>
 </html>
</xsl:template>

<xsl:template match="tc:collection">
 <h1 class="colltitle">
  <xsl:value-of select="@title"/>
 </h1>

 <table>
  <tbody>
   <!-- TODO: this would need to be fixed for multiple collections -->
   <xsl:for-each select="../tc:borrowers/tc:borrower/tc:loan[generate-id(.)=generate-id(key('loansByDate', @dueDate)[1])]">
    <xsl:sort select="@dueDate"/>
    <tr>
     <td class="groupName">
      <xsl:value-of select="@dueDate"/>
     </td>
     <td class="fieldName"><i18n>Borrower</i18n></td>      
     <td class="fieldName"><i18n>Loan Date</i18n></td>      
     <td class="fieldName"><i18n>Note</i18n></td>
    </tr>
    
    <xsl:for-each select="key('loansByDate', @dueDate)">
     <tr class="r{position() mod 2}">
      <td class="field">
       <xsl:value-of select="key('entriesById', @entryRef)//tc:title"/>
      </td>
      <td class="field">
       <xsl:value-of select="../@name"/>
      </td>
      <td class="field">
       <xsl:value-of select="@loanDate"/>
      </td>
      <td class="field">
       <p><xsl:value-of select="text()"/></p>
      </td>
     </tr>
    </xsl:for-each>
   </xsl:for-each>
   
  </tbody>
 </table>

 <table>
  <tbody>
   <!-- TODO: this would need to be fixed for multiple collections -->
   <xsl:for-each select="../tc:borrowers/tc:borrower">
    <xsl:sort select="@name"/>
    <tr>
     <td class="groupName">
      <xsl:value-of select="@name"/>
     </td>
     <td class="fieldName"><i18n>Loan Date</i18n></td>      
     <td class="fieldName"><i18n>Due Date</i18n></td>      
     <td class="fieldName"><i18n>Note</i18n></td>      
    </tr>
    
    <xsl:for-each select="tc:loan">
     <tr class="r{position() mod 2}">
      <td class="field">
       <xsl:value-of select="key('entriesById', @entryRef)//tc:title"/>
      </td>
      <td class="field">
       <xsl:value-of select="@loanDate"/>
      </td>
      <td class="field">
       <xsl:value-of select="@dueDate"/>
      </td>
      <td class="field">
       <p><xsl:value-of select="text()"/></p>
      </td>
     </tr>
    </xsl:for-each>
   </xsl:for-each>
   
  </tbody>
 </table>

 <!--
 <hr/>
 <h4 xml:space="preserve"><i18n>Generated by</i18n> <a href="http://www.periapsis.org/tellico/">Tellico</a>.</h4>
-->
</xsl:template>

</xsl:stylesheet>
<!-- Local Variables: -->
<!-- sgml-indent-step: 1 -->
<!-- sgml-indent-data: 1 -->
<!-- End: -->
