/*
 * QtTelepathy, the Tapioca Qt4 Telepathy Client Library
 * Copyright (C) 2006 by Tobias Hunger <tobias.hunger@basyskom.de>
 * Copyright (C) 2006 by INdT
 *  @author Andre Moreira Magalhaes <andre.magalhaes@indt.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef QTTELEPATHY_CONNECTIONPRESENCE_H
#define QTTELEPATHY_CONNECTIONPRESENCE_H

#include <QtCore/QHash>
#include <QtCore/QString>
#include <QtDBus/QDBusArgument>
#include <QtTelepathy/Common/BaseTypes>

namespace org {
namespace freedesktop {
namespace Telepathy {

enum PresenceType {
    CONNECTION_PRESENCE_TYPE_NONE = 0,
    CONNECTION_PRESENCE_TYPE_OFFLINE,
    CONNECTION_PRESENCE_TYPE_AVAILABLE,
    CONNECTION_PRESENCE_TYPE_AWAY,
    CONNECTION_PRESENCE_TYPE_EXTENDED_AWAY,
    CONNECTION_PRESENCE_TYPE_HIDDEN
};

struct PresenceStateDefinition {
    uint type;
    bool maySetOnMyself;
    bool isExclusive;
    NVPairs arguments;
};
typedef QMap<QString, NVPairs> PresenceState;
typedef QMap<QString, PresenceStateDefinition> PresenceStateDefinitionMap;

struct PresenceStateInTime {
    quint32 time;
    PresenceState state;
};
typedef QMap<uint, PresenceStateInTime> PresenceStateInTimeMap;

} // namespace Telepathy
} // namespace freedesktop
} // namespace org

Q_DECLARE_METATYPE(org::freedesktop::Telepathy::PresenceState)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::PresenceStateDefinition)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::PresenceStateDefinitionMap)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::PresenceStateInTime)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::PresenceStateInTimeMap)

const QDBusArgument &operator>>(const QDBusArgument &argument, org::freedesktop::Telepathy::PresenceStateDefinition &stateDefinition);
QDBusArgument &operator<<(QDBusArgument &argument, const org::freedesktop::Telepathy::PresenceStateDefinition &stateDefinition);

const QDBusArgument &operator>>(const QDBusArgument &argument, org::freedesktop::Telepathy::PresenceStateInTime &stateInTime);
QDBusArgument &operator<<(QDBusArgument &argument, const org::freedesktop::Telepathy::PresenceStateInTime &stateInTime);

#endif
