/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test handle-mapper managers.
 * 
 * ti-handle-mapper.h:
 * Maps handle numbers to their respective data (like their names)
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_HANDLE_MAPPER_H__
#define __TI_HANDLE_MAPPER_H__

#include <glib-object.h>
#include <gtk/gtk.h>

#include "ti-connection.h"

typedef struct _TIHandleMapper TIHandleMapper;
typedef struct _TIHandleMapperClass TIHandleMapperClass;

/*
 * Type macros.
 */
#define TI_TYPE_HANDLE_MAPPER               ti_handle_mapper_get_type()
#define TI_HANDLE_MAPPER(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_HANDLE_MAPPER, TIHandleMapper))
#define TI_HANDLE_MAPPER_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_HANDLE_MAPPER, TIHandleMapperClass))
#define TT_IS_HANDLE_MAPPER(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_HANDLE_MAPPER))
#define TT_IS_HANDLE_MAPPER_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_HANDLE_MAPPER))
#define TI_HANDLE_MAPPER_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_HANDLE_MAPPER, TIHandleMapperClass))

struct _TIHandleMapper {
    GObject parent;
};

GType ti_handle_mapper_get_type (void);

/**
 * Creates a new handle_mapper
 *
 */
TIHandleMapper* ti_handle_mapper_new (TIConnection* connection);

/**
 * Set Handle
 * Sets an unnamed handle
 */
void ti_handle_mapper_set_handle (TIHandleMapper* handle_mapper, guint handle_type, guint handle_number);

/**
 * Set Handle Name
 *
 */
void ti_handle_mapper_set_handle_name (TIHandleMapper* handle_mapper, guint handle_type, guint handle_number, const gchar* name);

/**
 * Set Contact Handle Name
 *
 */
void ti_handle_mapper_set_contact_handle_name (TIHandleMapper* handle_mapper, guint handle_number, const gchar* name);

/**
 * Set List Handle Name
 *
 */
void ti_handle_mapper_set_list_handle_name (TIHandleMapper* handle_mapper, guint handle_number, const gchar* name);

/**
 * Set Room Handle Name
 *
 */
void ti_handle_mapper_set_room_handle_name (TIHandleMapper* handle_mapper, guint handle_number, const gchar* name);

/**
 * Get Handle Name
 *
 * @return Handle's name or NULL, if not found. Must be free'd after use.
 */
gchar* ti_handle_mapper_get_handle_name (TIHandleMapper* handle_mapper, guint handle_type, guint handle_number);

/**
 * Get Contact Handle Name
 *
 * @return Handle's name or NULL, if not found. Must be free'd after use.
 */
gchar* ti_handle_mapper_get_contact_handle_name (TIHandleMapper* handle_mapper, guint handle_number);

/**
 * Get Room Handle Name
 *
 * @return Handle's name or NULL, if not found. Must be free'd after use.
 */
gchar* ti_handle_mapper_get_room_handle_name (TIHandleMapper* handle_mapper, guint handle_number);

/**
 * Get List Handle Name
 *
 * @return Handle's name or NULL, if not found. Must be free'd after use.
 */
gchar* ti_handle_mapper_get_list_handle_name (TIHandleMapper* handle_mapper, guint handle_number);

/**
 * Invalidate Handle
 *
 * Destroy any info related to that handle
 */
void ti_handle_mapper_invalidate_handle (TIHandleMapper* handle_mapper, guint handle_type, guint handle_number);

/**
 * Invalidate Contact Handles
 *
 * Destroy any info related to that handles
 */
void ti_handle_mapper_invalidate_contact_handles (TIHandleMapper* handle_mapper, GArray* handle_numbers);

/**
 * Invalidate List Handles
 *
 * Destroy any info related to that handles
 */
void ti_handle_mapper_invalidate_list_handles (TIHandleMapper* handle_mapper, GArray* handle_numbers);

/**
 * Get a GtkListStore containing all handles. This list is automatically updated and
 * shouldn't be changed.
 *
 * @return A GtkListStore. Must be unref'ed after use.
 */
GtkListStore* ti_handle_mapper_get_handles_list_store (TIHandleMapper* handle_mapper);

/**
 * Get a GtkListStore containing all contact handles. This list is automatically updated and
 * shouldn't be changed.
 *
 * @return A GtkListStore. Must be unref'ed after use.
 */
GtkListStore* ti_handle_mapper_get_contact_handle_list_store (TIHandleMapper* handle_mapper);

#endif
