/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 * 
 * ti-dlg-about.c:
 * Classical About Dialog
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "ti-dlg-about.h"
#include "ti-config.h"
#include "ti-constants.h"

#include <glade/glade.h>

G_DEFINE_TYPE (TIDlgAbout, ti_dlg_about, G_TYPE_OBJECT);

/**
 * Instance private data.
 */
struct _TIDlgAboutPrivate {
    gboolean disposed;

    GtkWindow* parent;

    GtkWidget* dialog;
};
typedef struct _TIDlgAboutPrivate TIDlgAboutPrivate;

#define TI_DLG_ABOUT_GET_PRIVATE(object)  (G_TYPE_INSTANCE_GET_PRIVATE ((object), TI_TYPE_DLG_ABOUT, TIDlgAboutPrivate))

/* Function prototypes */
static void _ti_dlg_about_setup (TIDlgAbout* dlg_about);

/**
 * Drop all references to other objects.
 */
static void
ti_dlg_about_dispose (GObject *object)
{
    TIDlgAbout *dlg_about = TI_DLG_ABOUT (object);
    TIDlgAboutPrivate *priv = TI_DLG_ABOUT_GET_PRIVATE (dlg_about);

    if (priv->disposed)
        return;
    else
        priv->disposed = TRUE;

    G_OBJECT_CLASS (ti_dlg_about_parent_class)->dispose (object);
}

/**
 * Class initialization.
 */
static void
ti_dlg_about_class_init (TIDlgAboutClass *ti_dlg_about_class)
{
	GObjectClass *gobject_class = G_OBJECT_CLASS (ti_dlg_about_class);

	/* override base object methods */ 
	gobject_class->dispose = ti_dlg_about_dispose;
		
	/* Add private */
	g_type_class_add_private (ti_dlg_about_class, sizeof (TIDlgAboutPrivate));
}

/**
 * Instance initialization.
 */
static void
ti_dlg_about_init (TIDlgAbout *ti_dlg_about)
{
    TIDlgAboutPrivate *priv = TI_DLG_ABOUT_GET_PRIVATE (ti_dlg_about);

    priv->disposed = FALSE;
}

/**
 * Returns a new instance.
 */
TIDlgAbout*
ti_dlg_about_new (GtkWindow* parent) 
{
    TIDlgAbout* dialog = NULL;
    TIDlgAboutPrivate* priv = NULL;
    gchar* glade_file_path = NULL;

	dialog = g_object_new (TI_TYPE_DLG_ABOUT, NULL);
    priv = TI_DLG_ABOUT_GET_PRIVATE (dialog);

    priv->parent = parent;

    priv->dialog = gtk_about_dialog_new ();
    g_assert (GTK_IS_DIALOG (priv->dialog));

    gtk_window_set_transient_for (GTK_WINDOW (priv->dialog), GTK_WINDOW (priv->parent));
    gtk_window_set_position (GTK_WINDOW (priv->dialog), GTK_WIN_POS_CENTER_ON_PARENT);

    _ti_dlg_about_setup (dialog);

    g_free (glade_file_path);

    return dialog;
}

/**
 * Run
 */
void ti_dlg_about_run (TIDlgAbout* dlg_about)
{
    TIDlgAboutPrivate *priv = TI_DLG_ABOUT_GET_PRIVATE (dlg_about);

    gtk_widget_show_all (priv->dialog);
    gtk_dialog_run (GTK_DIALOG (priv->dialog));
    gtk_widget_hide_all (priv->dialog);
}

/**
 * Setup dialog
 * Connect signals, get widgets from gladexml, etc.
 */
static void
_ti_dlg_about_setup (TIDlgAbout* dlg_about)
{
    TIDlgAboutPrivate *priv = TI_DLG_ABOUT_GET_PRIVATE (dlg_about);
    const gchar *authors[] =  {"Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>", NULL};

    gtk_about_dialog_set_version (GTK_ABOUT_DIALOG (priv->dialog), TI_VERSION_STRING);
    gtk_about_dialog_set_copyright (GTK_ABOUT_DIALOG (priv->dialog), "Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia");

    gtk_about_dialog_set_license (GTK_ABOUT_DIALOG (priv->dialog),
        "This program is free software; you can redistribute it and/or modify\n"
        "it under the terms of the GNU Lesser General Public License as published by\n"
        "the Free Software Foundation; either version 2 of the License, or\n"
        "(at your option) any later version.\n"
        "\n"
        "This program is distributed in the hope that it will be useful,\n"
        "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
        "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the\n"
        "GNU Lesser General Public License for more details.\n"
        "\n"
        "You should have received a copy of the GNU Library General Public License\n"
        "along with this library; if not, write to the Free Software Foundation, Inc.,\n"
        "51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA");

    gtk_about_dialog_set_authors (GTK_ABOUT_DIALOG (priv->dialog), authors);

    gtk_about_dialog_set_comments (GTK_ABOUT_DIALOG (priv->dialog),
        "A telepathy client whose objective is to expose all interfaces and functionalities implemented by a given connection manager along with its connections, channels, etc.");

    gtk_about_dialog_set_website (GTK_ABOUT_DIALOG (priv->dialog), "http://telepathy.freedesktop.org/wiki/TelepathyInspector");
}
