// Copyright 2019, OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.15.8
// source: opentelemetry/proto/metrics/v1/metrics.proto

package v1

import (
	v11 "github.com/influxdata/influxdb-observability/otlp/common/v1"
	v1 "github.com/influxdata/influxdb-observability/otlp/resource/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// AggregationTemporality defines how a metric aggregator reports aggregated
// values. It describes how those values relate to the time interval over
// which they are aggregated.
type AggregationTemporality int32

const (
	// UNSPECIFIED is the default AggregationTemporality, it MUST not be used.
	AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED AggregationTemporality = 0
	// DELTA is an AggregationTemporality for a metric aggregator which reports
	// changes since last report time. Successive metrics contain aggregation of
	// values from continuous and non-overlapping intervals.
	//
	// The values for a DELTA metric are based only on the time interval
	// associated with one measurement cycle. There is no dependency on
	// previous measurements like is the case for CUMULATIVE metrics.
	//
	// For example, consider a system measuring the number of requests that
	// it receives and reports the sum of these requests every second as a
	// DELTA metric:
	//
	//   1. The system starts receiving at time=t_0.
	//   2. A request is received, the system measures 1 request.
	//   3. A request is received, the system measures 1 request.
	//   4. A request is received, the system measures 1 request.
	//   5. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_0 to
	//      t_0+1 with a value of 3.
	//   6. A request is received, the system measures 1 request.
	//   7. A request is received, the system measures 1 request.
	//   8. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_0+1 to
	//      t_0+2 with a value of 2.
	AggregationTemporality_AGGREGATION_TEMPORALITY_DELTA AggregationTemporality = 1
	// CUMULATIVE is an AggregationTemporality for a metric aggregator which
	// reports changes since a fixed start time. This means that current values
	// of a CUMULATIVE metric depend on all previous measurements since the
	// start time. Because of this, the sender is required to retain this state
	// in some form. If this state is lost or invalidated, the CUMULATIVE metric
	// values MUST be reset and a new fixed start time following the last
	// reported measurement time sent MUST be used.
	//
	// For example, consider a system measuring the number of requests that
	// it receives and reports the sum of these requests every second as a
	// CUMULATIVE metric:
	//
	//   1. The system starts receiving at time=t_0.
	//   2. A request is received, the system measures 1 request.
	//   3. A request is received, the system measures 1 request.
	//   4. A request is received, the system measures 1 request.
	//   5. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_0 to
	//      t_0+1 with a value of 3.
	//   6. A request is received, the system measures 1 request.
	//   7. A request is received, the system measures 1 request.
	//   8. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_0 to
	//      t_0+2 with a value of 5.
	//   9. The system experiences a fault and loses state.
	//   10. The system recovers and resumes receiving at time=t_1.
	//   11. A request is received, the system measures 1 request.
	//   12. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_1 to
	//      t_0+1 with a value of 1.
	//
	// Note: Even though, when reporting changes since last report time, using
	// CUMULATIVE is valid, it is not recommended. This may cause problems for
	// systems that do not use start_time to determine when the aggregation
	// value was reset (e.g. Prometheus).
	AggregationTemporality_AGGREGATION_TEMPORALITY_CUMULATIVE AggregationTemporality = 2
)

// Enum value maps for AggregationTemporality.
var (
	AggregationTemporality_name = map[int32]string{
		0: "AGGREGATION_TEMPORALITY_UNSPECIFIED",
		1: "AGGREGATION_TEMPORALITY_DELTA",
		2: "AGGREGATION_TEMPORALITY_CUMULATIVE",
	}
	AggregationTemporality_value = map[string]int32{
		"AGGREGATION_TEMPORALITY_UNSPECIFIED": 0,
		"AGGREGATION_TEMPORALITY_DELTA":       1,
		"AGGREGATION_TEMPORALITY_CUMULATIVE":  2,
	}
)

func (x AggregationTemporality) Enum() *AggregationTemporality {
	p := new(AggregationTemporality)
	*p = x
	return p
}

func (x AggregationTemporality) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AggregationTemporality) Descriptor() protoreflect.EnumDescriptor {
	return file_opentelemetry_proto_metrics_v1_metrics_proto_enumTypes[0].Descriptor()
}

func (AggregationTemporality) Type() protoreflect.EnumType {
	return &file_opentelemetry_proto_metrics_v1_metrics_proto_enumTypes[0]
}

func (x AggregationTemporality) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AggregationTemporality.Descriptor instead.
func (AggregationTemporality) EnumDescriptor() ([]byte, []int) {
	return file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{0}
}

// A collection of InstrumentationLibraryMetrics from a Resource.
type ResourceMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource for the metrics in this message.
	// If this field is not set then no resource info is known.
	Resource *v1.Resource `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// A list of metrics that originate from a resource.
	InstrumentationLibraryMetrics []*InstrumentationLibraryMetrics `protobuf:"bytes,2,rep,name=instrumentation_library_metrics,json=instrumentationLibraryMetrics,proto3" json:"instrumentation_library_metrics,omitempty"`
}

func (x *ResourceMetrics) Reset() {
	*x = ResourceMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceMetrics) ProtoMessage() {}

func (x *ResourceMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceMetrics.ProtoReflect.Descriptor instead.
func (*ResourceMetrics) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{0}
}

func (x *ResourceMetrics) GetResource() *v1.Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

func (x *ResourceMetrics) GetInstrumentationLibraryMetrics() []*InstrumentationLibraryMetrics {
	if x != nil {
		return x.InstrumentationLibraryMetrics
	}
	return nil
}

// A collection of Metrics produced by an InstrumentationLibrary.
type InstrumentationLibraryMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instrumentation library information for the metrics in this message.
	// If this field is not set then no library info is known.
	InstrumentationLibrary *v11.InstrumentationLibrary `protobuf:"bytes,1,opt,name=instrumentation_library,json=instrumentationLibrary,proto3" json:"instrumentation_library,omitempty"`
	// A list of metrics that originate from an instrumentation library.
	Metrics []*Metric `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *InstrumentationLibraryMetrics) Reset() {
	*x = InstrumentationLibraryMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstrumentationLibraryMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstrumentationLibraryMetrics) ProtoMessage() {}

func (x *InstrumentationLibraryMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstrumentationLibraryMetrics.ProtoReflect.Descriptor instead.
func (*InstrumentationLibraryMetrics) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{1}
}

func (x *InstrumentationLibraryMetrics) GetInstrumentationLibrary() *v11.InstrumentationLibrary {
	if x != nil {
		return x.InstrumentationLibrary
	}
	return nil
}

func (x *InstrumentationLibraryMetrics) GetMetrics() []*Metric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

// Defines a Metric which has one or more timeseries.
//
// The data model and relation between entities is shown in the
// diagram below. Here, "DataPoint" is the term used to refer to any
// one of the specific data point value types, and "points" is the term used
// to refer to any one of the lists of points contained in the Metric.
//
// - Metric is composed of a metadata and data.
// - Metadata part contains a name, description, unit.
// - Data is one of the possible types (Gauge, Sum, Histogram, etc.).
// - DataPoint contains timestamps, labels, and one of the possible value type
//   fields.
//
//     Metric
//  +------------+
//  |name        |
//  |description |
//  |unit        |     +------------------------------------+
//  |data        |---> |Gauge, Sum, Histogram, Summary, ... |
//  +------------+     +------------------------------------+
//
//    Data [One of Gauge, Sum, Histogram, Summary, ...]
//  +-----------+
//  |...        |  // Metadata about the Data.
//  |points     |--+
//  +-----------+  |
//                 |      +---------------------------+
//                 |      |DataPoint 1                |
//                 v      |+------+------+   +------+ |
//              +-----+   ||label |label |...|label | |
//              |  1  |-->||value1|value2|...|valueN| |
//              +-----+   |+------+------+   +------+ |
//              |  .  |   |+-----+                    |
//              |  .  |   ||value|                    |
//              |  .  |   |+-----+                    |
//              |  .  |   +---------------------------+
//              |  .  |                   .
//              |  .  |                   .
//              |  .  |                   .
//              |  .  |   +---------------------------+
//              |  .  |   |DataPoint M                |
//              +-----+   |+------+------+   +------+ |
//              |  M  |-->||label |label |...|label | |
//              +-----+   ||value1|value2|...|valueN| |
//                        |+------+------+   +------+ |
//                        |+-----+                    |
//                        ||value|                    |
//                        |+-----+                    |
//                        +---------------------------+
//
// All DataPoint types have three common fields:
// - Labels zero or more key-value pairs associated with the data point.
// - StartTimeUnixNano MUST be set to the start of the interval when the data's
//   type includes an AggregationTemporality. This field is not set otherwise.
// - TimeUnixNano MUST be set to:
//   - the moment when an aggregation is reported (independent of the
//     aggregation temporality).
//   - the instantaneous time of the event.
type Metric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name of the metric, including its DNS name prefix. It must be unique.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// description of the metric, which can be used in documentation.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// unit in which the metric value is reported. Follows the format
	// described by http://unitsofmeasure.org/ucum.html.
	Unit string `protobuf:"bytes,3,opt,name=unit,proto3" json:"unit,omitempty"`
	// Data determines the aggregation type (if any) of the metric, what is the
	// reported value type for the data points, as well as the relatationship to
	// the time interval over which they are reported.
	//
	// TODO: Update table after the decision on:
	// https://github.com/open-telemetry/opentelemetry-specification/issues/731.
	// By default, metrics recording using the OpenTelemetry API are exported as
	// (the table does not include MeasurementValueType to avoid extra rows):
	//
	//   Instrument         Type
	//   ----------------------------------------------
	//   Counter            Sum(aggregation_temporality=delta;is_monotonic=true)
	//   UpDownCounter      Sum(aggregation_temporality=delta;is_monotonic=false)
	//   ValueRecorder      TBD
	//   SumObserver        Sum(aggregation_temporality=cumulative;is_monotonic=true)
	//   UpDownSumObserver  Sum(aggregation_temporality=cumulative;is_monotonic=false)
	//   ValueObserver      Gauge()
	//
	// Types that are assignable to Data:
	//	*Metric_IntGauge
	//	*Metric_DoubleGauge
	//	*Metric_IntSum
	//	*Metric_DoubleSum
	//	*Metric_IntHistogram
	//	*Metric_DoubleHistogram
	//	*Metric_DoubleSummary
	Data isMetric_Data `protobuf_oneof:"data"`
}

func (x *Metric) Reset() {
	*x = Metric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Metric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metric) ProtoMessage() {}

func (x *Metric) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metric.ProtoReflect.Descriptor instead.
func (*Metric) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{2}
}

func (x *Metric) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Metric) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Metric) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

func (m *Metric) GetData() isMetric_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (x *Metric) GetIntGauge() *IntGauge {
	if x, ok := x.GetData().(*Metric_IntGauge); ok {
		return x.IntGauge
	}
	return nil
}

func (x *Metric) GetDoubleGauge() *DoubleGauge {
	if x, ok := x.GetData().(*Metric_DoubleGauge); ok {
		return x.DoubleGauge
	}
	return nil
}

func (x *Metric) GetIntSum() *IntSum {
	if x, ok := x.GetData().(*Metric_IntSum); ok {
		return x.IntSum
	}
	return nil
}

func (x *Metric) GetDoubleSum() *DoubleSum {
	if x, ok := x.GetData().(*Metric_DoubleSum); ok {
		return x.DoubleSum
	}
	return nil
}

func (x *Metric) GetIntHistogram() *IntHistogram {
	if x, ok := x.GetData().(*Metric_IntHistogram); ok {
		return x.IntHistogram
	}
	return nil
}

func (x *Metric) GetDoubleHistogram() *DoubleHistogram {
	if x, ok := x.GetData().(*Metric_DoubleHistogram); ok {
		return x.DoubleHistogram
	}
	return nil
}

func (x *Metric) GetDoubleSummary() *DoubleSummary {
	if x, ok := x.GetData().(*Metric_DoubleSummary); ok {
		return x.DoubleSummary
	}
	return nil
}

type isMetric_Data interface {
	isMetric_Data()
}

type Metric_IntGauge struct {
	IntGauge *IntGauge `protobuf:"bytes,4,opt,name=int_gauge,json=intGauge,proto3,oneof"`
}

type Metric_DoubleGauge struct {
	DoubleGauge *DoubleGauge `protobuf:"bytes,5,opt,name=double_gauge,json=doubleGauge,proto3,oneof"`
}

type Metric_IntSum struct {
	IntSum *IntSum `protobuf:"bytes,6,opt,name=int_sum,json=intSum,proto3,oneof"`
}

type Metric_DoubleSum struct {
	DoubleSum *DoubleSum `protobuf:"bytes,7,opt,name=double_sum,json=doubleSum,proto3,oneof"`
}

type Metric_IntHistogram struct {
	IntHistogram *IntHistogram `protobuf:"bytes,8,opt,name=int_histogram,json=intHistogram,proto3,oneof"`
}

type Metric_DoubleHistogram struct {
	DoubleHistogram *DoubleHistogram `protobuf:"bytes,9,opt,name=double_histogram,json=doubleHistogram,proto3,oneof"`
}

type Metric_DoubleSummary struct {
	DoubleSummary *DoubleSummary `protobuf:"bytes,11,opt,name=double_summary,json=doubleSummary,proto3,oneof"`
}

func (*Metric_IntGauge) isMetric_Data() {}

func (*Metric_DoubleGauge) isMetric_Data() {}

func (*Metric_IntSum) isMetric_Data() {}

func (*Metric_DoubleSum) isMetric_Data() {}

func (*Metric_IntHistogram) isMetric_Data() {}

func (*Metric_DoubleHistogram) isMetric_Data() {}

func (*Metric_DoubleSummary) isMetric_Data() {}

// Gauge represents the type of a int scalar metric that always exports the
// "current value" for every data point. It should be used for an "unknown"
// aggregation.
//
// A Gauge does not support different aggregation temporalities. Given the
// aggregation is unknown, points cannot be combined using the same
// aggregation, regardless of aggregation temporalities. Therefore,
// AggregationTemporality is not included. Consequently, this also means
// "StartTimeUnixNano" is ignored for all data points.
type IntGauge struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DataPoints []*IntDataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
}

func (x *IntGauge) Reset() {
	*x = IntGauge{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntGauge) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntGauge) ProtoMessage() {}

func (x *IntGauge) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntGauge.ProtoReflect.Descriptor instead.
func (*IntGauge) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{3}
}

func (x *IntGauge) GetDataPoints() []*IntDataPoint {
	if x != nil {
		return x.DataPoints
	}
	return nil
}

// Gauge represents the type of a double scalar metric that always exports the
// "current value" for every data point. It should be used for an "unknown"
// aggregation.
//
// A Gauge does not support different aggregation temporalities. Given the
// aggregation is unknown, points cannot be combined using the same
// aggregation, regardless of aggregation temporalities. Therefore,
// AggregationTemporality is not included. Consequently, this also means
// "StartTimeUnixNano" is ignored for all data points.
type DoubleGauge struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DataPoints []*DoubleDataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
}

func (x *DoubleGauge) Reset() {
	*x = DoubleGauge{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DoubleGauge) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DoubleGauge) ProtoMessage() {}

func (x *DoubleGauge) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DoubleGauge.ProtoReflect.Descriptor instead.
func (*DoubleGauge) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{4}
}

func (x *DoubleGauge) GetDataPoints() []*DoubleDataPoint {
	if x != nil {
		return x.DataPoints
	}
	return nil
}

// Sum represents the type of a numeric int scalar metric that is calculated as
// a sum of all reported measurements over a time interval.
type IntSum struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DataPoints []*IntDataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
	// aggregation_temporality describes if the aggregator reports delta changes
	// since last report time, or cumulative changes since a fixed start time.
	AggregationTemporality AggregationTemporality `protobuf:"varint,2,opt,name=aggregation_temporality,json=aggregationTemporality,proto3,enum=opentelemetry.proto.metrics.v1.AggregationTemporality" json:"aggregation_temporality,omitempty"`
	// If "true" means that the sum is monotonic.
	IsMonotonic bool `protobuf:"varint,3,opt,name=is_monotonic,json=isMonotonic,proto3" json:"is_monotonic,omitempty"`
}

func (x *IntSum) Reset() {
	*x = IntSum{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntSum) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntSum) ProtoMessage() {}

func (x *IntSum) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntSum.ProtoReflect.Descriptor instead.
func (*IntSum) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{5}
}

func (x *IntSum) GetDataPoints() []*IntDataPoint {
	if x != nil {
		return x.DataPoints
	}
	return nil
}

func (x *IntSum) GetAggregationTemporality() AggregationTemporality {
	if x != nil {
		return x.AggregationTemporality
	}
	return AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED
}

func (x *IntSum) GetIsMonotonic() bool {
	if x != nil {
		return x.IsMonotonic
	}
	return false
}

// Sum represents the type of a numeric double scalar metric that is calculated
// as a sum of all reported measurements over a time interval.
type DoubleSum struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DataPoints []*DoubleDataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
	// aggregation_temporality describes if the aggregator reports delta changes
	// since last report time, or cumulative changes since a fixed start time.
	AggregationTemporality AggregationTemporality `protobuf:"varint,2,opt,name=aggregation_temporality,json=aggregationTemporality,proto3,enum=opentelemetry.proto.metrics.v1.AggregationTemporality" json:"aggregation_temporality,omitempty"`
	// If "true" means that the sum is monotonic.
	IsMonotonic bool `protobuf:"varint,3,opt,name=is_monotonic,json=isMonotonic,proto3" json:"is_monotonic,omitempty"`
}

func (x *DoubleSum) Reset() {
	*x = DoubleSum{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DoubleSum) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DoubleSum) ProtoMessage() {}

func (x *DoubleSum) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DoubleSum.ProtoReflect.Descriptor instead.
func (*DoubleSum) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{6}
}

func (x *DoubleSum) GetDataPoints() []*DoubleDataPoint {
	if x != nil {
		return x.DataPoints
	}
	return nil
}

func (x *DoubleSum) GetAggregationTemporality() AggregationTemporality {
	if x != nil {
		return x.AggregationTemporality
	}
	return AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED
}

func (x *DoubleSum) GetIsMonotonic() bool {
	if x != nil {
		return x.IsMonotonic
	}
	return false
}

// Represents the type of a metric that is calculated by aggregating as a
// Histogram of all reported int measurements over a time interval.
type IntHistogram struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DataPoints []*IntHistogramDataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
	// aggregation_temporality describes if the aggregator reports delta changes
	// since last report time, or cumulative changes since a fixed start time.
	AggregationTemporality AggregationTemporality `protobuf:"varint,2,opt,name=aggregation_temporality,json=aggregationTemporality,proto3,enum=opentelemetry.proto.metrics.v1.AggregationTemporality" json:"aggregation_temporality,omitempty"`
}

func (x *IntHistogram) Reset() {
	*x = IntHistogram{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntHistogram) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntHistogram) ProtoMessage() {}

func (x *IntHistogram) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntHistogram.ProtoReflect.Descriptor instead.
func (*IntHistogram) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{7}
}

func (x *IntHistogram) GetDataPoints() []*IntHistogramDataPoint {
	if x != nil {
		return x.DataPoints
	}
	return nil
}

func (x *IntHistogram) GetAggregationTemporality() AggregationTemporality {
	if x != nil {
		return x.AggregationTemporality
	}
	return AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED
}

// Represents the type of a metric that is calculated by aggregating as a
// Histogram of all reported double measurements over a time interval.
type DoubleHistogram struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DataPoints []*DoubleHistogramDataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
	// aggregation_temporality describes if the aggregator reports delta changes
	// since last report time, or cumulative changes since a fixed start time.
	AggregationTemporality AggregationTemporality `protobuf:"varint,2,opt,name=aggregation_temporality,json=aggregationTemporality,proto3,enum=opentelemetry.proto.metrics.v1.AggregationTemporality" json:"aggregation_temporality,omitempty"`
}

func (x *DoubleHistogram) Reset() {
	*x = DoubleHistogram{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DoubleHistogram) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DoubleHistogram) ProtoMessage() {}

func (x *DoubleHistogram) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DoubleHistogram.ProtoReflect.Descriptor instead.
func (*DoubleHistogram) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{8}
}

func (x *DoubleHistogram) GetDataPoints() []*DoubleHistogramDataPoint {
	if x != nil {
		return x.DataPoints
	}
	return nil
}

func (x *DoubleHistogram) GetAggregationTemporality() AggregationTemporality {
	if x != nil {
		return x.AggregationTemporality
	}
	return AggregationTemporality_AGGREGATION_TEMPORALITY_UNSPECIFIED
}

// DoubleSummary metric data are used to convey quantile summaries,
// a Prometheus (see: https://prometheus.io/docs/concepts/metric_types/#summary)
// and OpenMetrics (see: https://github.com/OpenObservability/OpenMetrics/blob/4dbf6075567ab43296eed941037c12951faafb92/protos/prometheus.proto#L45)
// data type. These data points cannot always be merged in a meaningful way.
// While they can be useful in some applications, histogram data points are
// recommended for new applications.
type DoubleSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DataPoints []*DoubleSummaryDataPoint `protobuf:"bytes,1,rep,name=data_points,json=dataPoints,proto3" json:"data_points,omitempty"`
}

func (x *DoubleSummary) Reset() {
	*x = DoubleSummary{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DoubleSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DoubleSummary) ProtoMessage() {}

func (x *DoubleSummary) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DoubleSummary.ProtoReflect.Descriptor instead.
func (*DoubleSummary) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{9}
}

func (x *DoubleSummary) GetDataPoints() []*DoubleSummaryDataPoint {
	if x != nil {
		return x.DataPoints
	}
	return nil
}

// IntDataPoint is a single data point in a timeseries that describes the
// time-varying values of a int64 metric.
type IntDataPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of labels that uniquely identify this timeseries.
	Labels []*v11.StringKeyValue `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
	// start_time_unix_nano is the last time when the aggregation value was reset
	// to "zero". For some metric types this is ignored, see data types for more
	// details.
	//
	// The aggregation value is over the time interval (start_time_unix_nano,
	// time_unix_nano].
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	//
	// Value of 0 indicates that the timestamp is unspecified. In that case the
	// timestamp may be decided by the backend.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// time_unix_nano is the moment when this aggregation value was reported.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// value itself.
	Value int64 `protobuf:"fixed64,4,opt,name=value,proto3" json:"value,omitempty"`
	// (Optional) List of exemplars collected from
	// measurements that were used to form the data point
	Exemplars []*IntExemplar `protobuf:"bytes,5,rep,name=exemplars,proto3" json:"exemplars,omitempty"`
}

func (x *IntDataPoint) Reset() {
	*x = IntDataPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntDataPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntDataPoint) ProtoMessage() {}

func (x *IntDataPoint) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntDataPoint.ProtoReflect.Descriptor instead.
func (*IntDataPoint) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{10}
}

func (x *IntDataPoint) GetLabels() []*v11.StringKeyValue {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *IntDataPoint) GetStartTimeUnixNano() uint64 {
	if x != nil {
		return x.StartTimeUnixNano
	}
	return 0
}

func (x *IntDataPoint) GetTimeUnixNano() uint64 {
	if x != nil {
		return x.TimeUnixNano
	}
	return 0
}

func (x *IntDataPoint) GetValue() int64 {
	if x != nil {
		return x.Value
	}
	return 0
}

func (x *IntDataPoint) GetExemplars() []*IntExemplar {
	if x != nil {
		return x.Exemplars
	}
	return nil
}

// DoubleDataPoint is a single data point in a timeseries that describes the
// time-varying value of a double metric.
type DoubleDataPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of labels that uniquely identify this timeseries.
	Labels []*v11.StringKeyValue `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
	// start_time_unix_nano is the last time when the aggregation value was reset
	// to "zero". For some metric types this is ignored, see data types for more
	// details.
	//
	// The aggregation value is over the time interval (start_time_unix_nano,
	// time_unix_nano].
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	//
	// Value of 0 indicates that the timestamp is unspecified. In that case the
	// timestamp may be decided by the backend.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// time_unix_nano is the moment when this aggregation value was reported.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// value itself.
	Value float64 `protobuf:"fixed64,4,opt,name=value,proto3" json:"value,omitempty"`
	// (Optional) List of exemplars collected from
	// measurements that were used to form the data point
	Exemplars []*DoubleExemplar `protobuf:"bytes,5,rep,name=exemplars,proto3" json:"exemplars,omitempty"`
}

func (x *DoubleDataPoint) Reset() {
	*x = DoubleDataPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DoubleDataPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DoubleDataPoint) ProtoMessage() {}

func (x *DoubleDataPoint) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DoubleDataPoint.ProtoReflect.Descriptor instead.
func (*DoubleDataPoint) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{11}
}

func (x *DoubleDataPoint) GetLabels() []*v11.StringKeyValue {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *DoubleDataPoint) GetStartTimeUnixNano() uint64 {
	if x != nil {
		return x.StartTimeUnixNano
	}
	return 0
}

func (x *DoubleDataPoint) GetTimeUnixNano() uint64 {
	if x != nil {
		return x.TimeUnixNano
	}
	return 0
}

func (x *DoubleDataPoint) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

func (x *DoubleDataPoint) GetExemplars() []*DoubleExemplar {
	if x != nil {
		return x.Exemplars
	}
	return nil
}

// IntHistogramDataPoint is a single data point in a timeseries that describes
// the time-varying values of a Histogram of int values. A Histogram contains
// summary statistics for a population of values, it may optionally contain
// the distribution of those values across a set of buckets.
type IntHistogramDataPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of labels that uniquely identify this timeseries.
	Labels []*v11.StringKeyValue `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
	// start_time_unix_nano is the last time when the aggregation value was reset
	// to "zero". For some metric types this is ignored, see data types for more
	// details.
	//
	// The aggregation value is over the time interval (start_time_unix_nano,
	// time_unix_nano].
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	//
	// Value of 0 indicates that the timestamp is unspecified. In that case the
	// timestamp may be decided by the backend.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// time_unix_nano is the moment when this aggregation value was reported.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// count is the number of values in the population. Must be non-negative. This
	// value must be equal to the sum of the "count" fields in buckets if a
	// histogram is provided.
	Count uint64 `protobuf:"fixed64,4,opt,name=count,proto3" json:"count,omitempty"`
	// sum of the values in the population. If count is zero then this field
	// must be zero. This value must be equal to the sum of the "sum" fields in
	// buckets if a histogram is provided.
	Sum int64 `protobuf:"fixed64,5,opt,name=sum,proto3" json:"sum,omitempty"`
	// bucket_counts is an optional field contains the count values of histogram
	// for each bucket.
	//
	// The sum of the bucket_counts must equal the value in the count field.
	//
	// The number of elements in bucket_counts array must be by one greater than
	// the number of elements in explicit_bounds array.
	BucketCounts []uint64 `protobuf:"fixed64,6,rep,packed,name=bucket_counts,json=bucketCounts,proto3" json:"bucket_counts,omitempty"`
	// explicit_bounds specifies buckets with explicitly defined bounds for values.
	// The bucket boundaries are described by "bounds" field.
	//
	// This defines size(bounds) + 1 (= N) buckets. The boundaries for bucket
	// at index i are:
	//
	// (-infinity, bounds[i]) for i == 0
	// [bounds[i-1], bounds[i]) for 0 < i < N-1
	// [bounds[i], +infinity) for i == N-1
	// The values in bounds array must be strictly increasing.
	//
	// Note: only [a, b) intervals are currently supported for each bucket except the first one.
	// If we decide to also support (a, b] intervals we should add support for these by defining
	// a boolean value which decides what type of intervals to use.
	ExplicitBounds []float64 `protobuf:"fixed64,7,rep,packed,name=explicit_bounds,json=explicitBounds,proto3" json:"explicit_bounds,omitempty"`
	// (Optional) List of exemplars collected from
	// measurements that were used to form the data point
	Exemplars []*IntExemplar `protobuf:"bytes,8,rep,name=exemplars,proto3" json:"exemplars,omitempty"`
}

func (x *IntHistogramDataPoint) Reset() {
	*x = IntHistogramDataPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntHistogramDataPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntHistogramDataPoint) ProtoMessage() {}

func (x *IntHistogramDataPoint) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntHistogramDataPoint.ProtoReflect.Descriptor instead.
func (*IntHistogramDataPoint) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{12}
}

func (x *IntHistogramDataPoint) GetLabels() []*v11.StringKeyValue {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *IntHistogramDataPoint) GetStartTimeUnixNano() uint64 {
	if x != nil {
		return x.StartTimeUnixNano
	}
	return 0
}

func (x *IntHistogramDataPoint) GetTimeUnixNano() uint64 {
	if x != nil {
		return x.TimeUnixNano
	}
	return 0
}

func (x *IntHistogramDataPoint) GetCount() uint64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *IntHistogramDataPoint) GetSum() int64 {
	if x != nil {
		return x.Sum
	}
	return 0
}

func (x *IntHistogramDataPoint) GetBucketCounts() []uint64 {
	if x != nil {
		return x.BucketCounts
	}
	return nil
}

func (x *IntHistogramDataPoint) GetExplicitBounds() []float64 {
	if x != nil {
		return x.ExplicitBounds
	}
	return nil
}

func (x *IntHistogramDataPoint) GetExemplars() []*IntExemplar {
	if x != nil {
		return x.Exemplars
	}
	return nil
}

// HistogramDataPoint is a single data point in a timeseries that describes the
// time-varying values of a Histogram of double values. A Histogram contains
// summary statistics for a population of values, it may optionally contain the
// distribution of those values across a set of buckets.
type DoubleHistogramDataPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of labels that uniquely identify this timeseries.
	Labels []*v11.StringKeyValue `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
	// start_time_unix_nano is the last time when the aggregation value was reset
	// to "zero". For some metric types this is ignored, see data types for more
	// details.
	//
	// The aggregation value is over the time interval (start_time_unix_nano,
	// time_unix_nano].
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	//
	// Value of 0 indicates that the timestamp is unspecified. In that case the
	// timestamp may be decided by the backend.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// time_unix_nano is the moment when this aggregation value was reported.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// count is the number of values in the population. Must be non-negative. This
	// value must be equal to the sum of the "count" fields in buckets if a
	// histogram is provided.
	Count uint64 `protobuf:"fixed64,4,opt,name=count,proto3" json:"count,omitempty"`
	// sum of the values in the population. If count is zero then this field
	// must be zero. This value must be equal to the sum of the "sum" fields in
	// buckets if a histogram is provided.
	Sum float64 `protobuf:"fixed64,5,opt,name=sum,proto3" json:"sum,omitempty"`
	// bucket_counts is an optional field contains the count values of histogram
	// for each bucket.
	//
	// The sum of the bucket_counts must equal the value in the count field.
	//
	// The number of elements in bucket_counts array must be by one greater than
	// the number of elements in explicit_bounds array.
	BucketCounts []uint64 `protobuf:"fixed64,6,rep,packed,name=bucket_counts,json=bucketCounts,proto3" json:"bucket_counts,omitempty"`
	// explicit_bounds specifies buckets with explicitly defined bounds for values.
	// The bucket boundaries are described by "bounds" field.
	//
	// This defines size(bounds) + 1 (= N) buckets. The boundaries for bucket
	// at index i are:
	//
	// (-infinity, bounds[i]) for i == 0
	// [bounds[i-1], bounds[i]) for 0 < i < N-1
	// [bounds[i], +infinity) for i == N-1
	// The values in bounds array must be strictly increasing.
	//
	// Note: only [a, b) intervals are currently supported for each bucket except the first one.
	// If we decide to also support (a, b] intervals we should add support for these by defining
	// a boolean value which decides what type of intervals to use.
	ExplicitBounds []float64 `protobuf:"fixed64,7,rep,packed,name=explicit_bounds,json=explicitBounds,proto3" json:"explicit_bounds,omitempty"`
	// (Optional) List of exemplars collected from
	// measurements that were used to form the data point
	Exemplars []*DoubleExemplar `protobuf:"bytes,8,rep,name=exemplars,proto3" json:"exemplars,omitempty"`
}

func (x *DoubleHistogramDataPoint) Reset() {
	*x = DoubleHistogramDataPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DoubleHistogramDataPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DoubleHistogramDataPoint) ProtoMessage() {}

func (x *DoubleHistogramDataPoint) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DoubleHistogramDataPoint.ProtoReflect.Descriptor instead.
func (*DoubleHistogramDataPoint) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{13}
}

func (x *DoubleHistogramDataPoint) GetLabels() []*v11.StringKeyValue {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *DoubleHistogramDataPoint) GetStartTimeUnixNano() uint64 {
	if x != nil {
		return x.StartTimeUnixNano
	}
	return 0
}

func (x *DoubleHistogramDataPoint) GetTimeUnixNano() uint64 {
	if x != nil {
		return x.TimeUnixNano
	}
	return 0
}

func (x *DoubleHistogramDataPoint) GetCount() uint64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *DoubleHistogramDataPoint) GetSum() float64 {
	if x != nil {
		return x.Sum
	}
	return 0
}

func (x *DoubleHistogramDataPoint) GetBucketCounts() []uint64 {
	if x != nil {
		return x.BucketCounts
	}
	return nil
}

func (x *DoubleHistogramDataPoint) GetExplicitBounds() []float64 {
	if x != nil {
		return x.ExplicitBounds
	}
	return nil
}

func (x *DoubleHistogramDataPoint) GetExemplars() []*DoubleExemplar {
	if x != nil {
		return x.Exemplars
	}
	return nil
}

// DoubleSummaryDataPoint is a single data point in a timeseries that describes the
// time-varying values of a Summary metric.
type DoubleSummaryDataPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of labels that uniquely identify this timeseries.
	Labels []*v11.StringKeyValue `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
	// start_time_unix_nano is the last time when the aggregation value was reset
	// to "zero". For some metric types this is ignored, see data types for more
	// details.
	//
	// The aggregation value is over the time interval (start_time_unix_nano,
	// time_unix_nano].
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	//
	// Value of 0 indicates that the timestamp is unspecified. In that case the
	// timestamp may be decided by the backend.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// time_unix_nano is the moment when this aggregation value was reported.
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// count is the number of values in the population. Must be non-negative.
	Count uint64 `protobuf:"fixed64,4,opt,name=count,proto3" json:"count,omitempty"`
	// sum of the values in the population. If count is zero then this field
	// must be zero.
	Sum float64 `protobuf:"fixed64,5,opt,name=sum,proto3" json:"sum,omitempty"`
	// (Optional) list of values at different quantiles of the distribution calculated
	// from the current snapshot. The quantiles must be strictly increasing.
	QuantileValues []*DoubleSummaryDataPoint_ValueAtQuantile `protobuf:"bytes,6,rep,name=quantile_values,json=quantileValues,proto3" json:"quantile_values,omitempty"`
}

func (x *DoubleSummaryDataPoint) Reset() {
	*x = DoubleSummaryDataPoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DoubleSummaryDataPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DoubleSummaryDataPoint) ProtoMessage() {}

func (x *DoubleSummaryDataPoint) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DoubleSummaryDataPoint.ProtoReflect.Descriptor instead.
func (*DoubleSummaryDataPoint) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{14}
}

func (x *DoubleSummaryDataPoint) GetLabels() []*v11.StringKeyValue {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *DoubleSummaryDataPoint) GetStartTimeUnixNano() uint64 {
	if x != nil {
		return x.StartTimeUnixNano
	}
	return 0
}

func (x *DoubleSummaryDataPoint) GetTimeUnixNano() uint64 {
	if x != nil {
		return x.TimeUnixNano
	}
	return 0
}

func (x *DoubleSummaryDataPoint) GetCount() uint64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *DoubleSummaryDataPoint) GetSum() float64 {
	if x != nil {
		return x.Sum
	}
	return 0
}

func (x *DoubleSummaryDataPoint) GetQuantileValues() []*DoubleSummaryDataPoint_ValueAtQuantile {
	if x != nil {
		return x.QuantileValues
	}
	return nil
}

// A representation of an exemplar, which is a sample input int measurement.
// Exemplars also hold information about the environment when the measurement
// was recorded, for example the span and trace ID of the active span when the
// exemplar was recorded.
type IntExemplar struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of labels that were filtered out by the aggregator, but recorded
	// alongside the original measurement. Only labels that were filtered out
	// by the aggregator should be included
	FilteredLabels []*v11.StringKeyValue `protobuf:"bytes,1,rep,name=filtered_labels,json=filteredLabels,proto3" json:"filtered_labels,omitempty"`
	// time_unix_nano is the exact time when this exemplar was recorded
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// Numerical int value of the measurement that was recorded.
	Value int64 `protobuf:"fixed64,3,opt,name=value,proto3" json:"value,omitempty"`
	// (Optional) Span ID of the exemplar trace.
	// span_id may be missing if the measurement is not recorded inside a trace
	// or if the trace is not sampled.
	SpanId []byte `protobuf:"bytes,4,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// (Optional) Trace ID of the exemplar trace.
	// trace_id may be missing if the measurement is not recorded inside a trace
	// or if the trace is not sampled.
	TraceId []byte `protobuf:"bytes,5,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
}

func (x *IntExemplar) Reset() {
	*x = IntExemplar{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntExemplar) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntExemplar) ProtoMessage() {}

func (x *IntExemplar) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntExemplar.ProtoReflect.Descriptor instead.
func (*IntExemplar) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{15}
}

func (x *IntExemplar) GetFilteredLabels() []*v11.StringKeyValue {
	if x != nil {
		return x.FilteredLabels
	}
	return nil
}

func (x *IntExemplar) GetTimeUnixNano() uint64 {
	if x != nil {
		return x.TimeUnixNano
	}
	return 0
}

func (x *IntExemplar) GetValue() int64 {
	if x != nil {
		return x.Value
	}
	return 0
}

func (x *IntExemplar) GetSpanId() []byte {
	if x != nil {
		return x.SpanId
	}
	return nil
}

func (x *IntExemplar) GetTraceId() []byte {
	if x != nil {
		return x.TraceId
	}
	return nil
}

// A representation of an exemplar, which is a sample input double measurement.
// Exemplars also hold information about the environment when the measurement
// was recorded, for example the span and trace ID of the active span when the
// exemplar was recorded.
type DoubleExemplar struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of labels that were filtered out by the aggregator, but recorded
	// alongside the original measurement. Only labels that were filtered out
	// by the aggregator should be included
	FilteredLabels []*v11.StringKeyValue `protobuf:"bytes,1,rep,name=filtered_labels,json=filteredLabels,proto3" json:"filtered_labels,omitempty"`
	// time_unix_nano is the exact time when this exemplar was recorded
	//
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January
	// 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// Numerical double value of the measurement that was recorded.
	Value float64 `protobuf:"fixed64,3,opt,name=value,proto3" json:"value,omitempty"`
	// (Optional) Span ID of the exemplar trace.
	// span_id may be missing if the measurement is not recorded inside a trace
	// or if the trace is not sampled.
	SpanId []byte `protobuf:"bytes,4,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// (Optional) Trace ID of the exemplar trace.
	// trace_id may be missing if the measurement is not recorded inside a trace
	// or if the trace is not sampled.
	TraceId []byte `protobuf:"bytes,5,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
}

func (x *DoubleExemplar) Reset() {
	*x = DoubleExemplar{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DoubleExemplar) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DoubleExemplar) ProtoMessage() {}

func (x *DoubleExemplar) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DoubleExemplar.ProtoReflect.Descriptor instead.
func (*DoubleExemplar) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{16}
}

func (x *DoubleExemplar) GetFilteredLabels() []*v11.StringKeyValue {
	if x != nil {
		return x.FilteredLabels
	}
	return nil
}

func (x *DoubleExemplar) GetTimeUnixNano() uint64 {
	if x != nil {
		return x.TimeUnixNano
	}
	return 0
}

func (x *DoubleExemplar) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

func (x *DoubleExemplar) GetSpanId() []byte {
	if x != nil {
		return x.SpanId
	}
	return nil
}

func (x *DoubleExemplar) GetTraceId() []byte {
	if x != nil {
		return x.TraceId
	}
	return nil
}

// Represents the value at a given quantile of a distribution.
//
// To record Min and Max values following conventions are used:
// - The 1.0 quantile is equivalent to the maximum value observed.
// - The 0.0 quantile is equivalent to the minimum value observed.
//
// See the following issue for more context:
// https://github.com/open-telemetry/opentelemetry-proto/issues/125
type DoubleSummaryDataPoint_ValueAtQuantile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The quantile of a distribution. Must be in the interval
	// [0.0, 1.0].
	Quantile float64 `protobuf:"fixed64,1,opt,name=quantile,proto3" json:"quantile,omitempty"`
	// The value at the given quantile of a distribution.
	Value float64 `protobuf:"fixed64,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *DoubleSummaryDataPoint_ValueAtQuantile) Reset() {
	*x = DoubleSummaryDataPoint_ValueAtQuantile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DoubleSummaryDataPoint_ValueAtQuantile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DoubleSummaryDataPoint_ValueAtQuantile) ProtoMessage() {}

func (x *DoubleSummaryDataPoint_ValueAtQuantile) ProtoReflect() protoreflect.Message {
	mi := &file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DoubleSummaryDataPoint_ValueAtQuantile.ProtoReflect.Descriptor instead.
func (*DoubleSummaryDataPoint_ValueAtQuantile) Descriptor() ([]byte, []int) {
	return file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{14, 0}
}

func (x *DoubleSummaryDataPoint_ValueAtQuantile) GetQuantile() float64 {
	if x != nil {
		return x.Quantile
	}
	return 0
}

func (x *DoubleSummaryDataPoint_ValueAtQuantile) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

var File_opentelemetry_proto_metrics_v1_metrics_proto protoreflect.FileDescriptor

var file_opentelemetry_proto_metrics_v1_metrics_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x76, 0x31,
	0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e,
	0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x2a,
	0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe0, 0x01, 0x0a, 0x0f, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x45,
	0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x85, 0x01, 0x0a, 0x1f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72,
	0x79, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3d, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x1d,
	0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0xd1, 0x01,
	0x0a, 0x1d, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12,
	0x6e, 0x0a, 0x17, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x52, 0x16, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x12,
	0x40, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x22, 0x8f, 0x05, 0x0a, 0x06, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x12, 0x47, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x5f, 0x67, 0x61,
	0x75, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x47, 0x61,
	0x75, 0x67, 0x65, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x47, 0x61, 0x75, 0x67, 0x65, 0x12,
	0x50, 0x0a, 0x0c, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x67, 0x61, 0x75, 0x67, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65,
	0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x47, 0x61, 0x75,
	0x67, 0x65, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x47, 0x61, 0x75, 0x67,
	0x65, 0x12, 0x41, 0x0a, 0x07, 0x69, 0x6e, 0x74, 0x5f, 0x73, 0x75, 0x6d, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74,
	0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x48, 0x00, 0x52, 0x06, 0x69, 0x6e,
	0x74, 0x53, 0x75, 0x6d, 0x12, 0x4a, 0x0a, 0x0a, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x73,
	0x75, 0x6d, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74,
	0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x53, 0x75, 0x6d, 0x48, 0x00, 0x52, 0x09, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x53, 0x75, 0x6d,
	0x12, 0x53, 0x0a, 0x0d, 0x69, 0x6e, 0x74, 0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61,
	0x6d, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65,
	0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x48, 0x69, 0x73, 0x74,
	0x6f, 0x67, 0x72, 0x61, 0x6d, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e, 0x74, 0x48, 0x69, 0x73, 0x74,
	0x6f, 0x67, 0x72, 0x61, 0x6d, 0x12, 0x5c, 0x0a, 0x10, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f,
	0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x48, 0x00, 0x52, 0x0f, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67,
	0x72, 0x61, 0x6d, 0x12, 0x56, 0x0a, 0x0e, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x75,
	0x62, 0x6c, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x48, 0x00, 0x52, 0x0d, 0x64, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x42, 0x06, 0x0a, 0x04, 0x64,
	0x61, 0x74, 0x61, 0x22, 0x59, 0x0a, 0x08, 0x49, 0x6e, 0x74, 0x47, 0x61, 0x75, 0x67, 0x65, 0x12,
	0x4d, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d,
	0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69,
	0x6e, 0x74, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x22, 0x5f,
	0x0a, 0x0b, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x47, 0x61, 0x75, 0x67, 0x65, 0x12, 0x50, 0x0a,
	0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74,
	0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f,
	0x69, 0x6e, 0x74, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x22,
	0xeb, 0x01, 0x0a, 0x06, 0x49, 0x6e, 0x74, 0x53, 0x75, 0x6d, 0x12, 0x4d, 0x0a, 0x0b, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0a, 0x64,
	0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x6f, 0x0a, 0x17, 0x61, 0x67, 0x67,
	0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x67, 0x72,
	0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x52, 0x16, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x73,
	0x5f, 0x6d, 0x6f, 0x6e, 0x6f, 0x74, 0x6f, 0x6e, 0x69, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0b, 0x69, 0x73, 0x4d, 0x6f, 0x6e, 0x6f, 0x74, 0x6f, 0x6e, 0x69, 0x63, 0x22, 0xf1, 0x01,
	0x0a, 0x09, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x53, 0x75, 0x6d, 0x12, 0x50, 0x0a, 0x0b, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e,
	0x74, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x6f, 0x0a,
	0x17, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x65, 0x6d,
	0x70, 0x6f, 0x72, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6f,
	0x72, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x16, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x21,
	0x0a, 0x0c, 0x69, 0x73, 0x5f, 0x6d, 0x6f, 0x6e, 0x6f, 0x74, 0x6f, 0x6e, 0x69, 0x63, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x69, 0x73, 0x4d, 0x6f, 0x6e, 0x6f, 0x74, 0x6f, 0x6e, 0x69,
	0x63, 0x22, 0xd7, 0x01, 0x0a, 0x0c, 0x49, 0x6e, 0x74, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72,
	0x61, 0x6d, 0x12, 0x56, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65,
	0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x48, 0x69, 0x73, 0x74,
	0x6f, 0x67, 0x72, 0x61, 0x6d, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0a,
	0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x6f, 0x0a, 0x17, 0x61, 0x67,
	0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x67,
	0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x52, 0x16, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x22, 0xdd, 0x01, 0x0a, 0x0f,
	0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x12,
	0x59, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d,
	0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x48, 0x69, 0x73, 0x74,
	0x6f, 0x67, 0x72, 0x61, 0x6d, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0a,
	0x64, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x6f, 0x0a, 0x17, 0x61, 0x67,
	0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x6f, 0x70,
	0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x67,
	0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x52, 0x16, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x22, 0x68, 0x0a, 0x0d, 0x44,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x57, 0x0a, 0x0b,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79,
	0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x50,
	0x6f, 0x69, 0x6e, 0x74, 0x73, 0x22, 0x8d, 0x02, 0x0a, 0x0c, 0x49, 0x6e, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c,
	0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4b, 0x65, 0x79,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x2f, 0x0a,
	0x14, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x75, 0x6e, 0x69, 0x78,
	0x5f, 0x6e, 0x61, 0x6e, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x06, 0x52, 0x11, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x55, 0x6e, 0x69, 0x78, 0x4e, 0x61, 0x6e, 0x6f, 0x12, 0x24,
	0x0a, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x75, 0x6e, 0x69, 0x78, 0x5f, 0x6e, 0x61, 0x6e, 0x6f,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x06, 0x52, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x55, 0x6e, 0x69, 0x78,
	0x4e, 0x61, 0x6e, 0x6f, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x10, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x49, 0x0a, 0x09, 0x65, 0x78,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x74, 0x45, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x52, 0x09, 0x65, 0x78, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x72, 0x73, 0x22, 0x93, 0x02, 0x0a, 0x0f, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x2f, 0x0a, 0x14, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x75,
	0x6e, 0x69, 0x78, 0x5f, 0x6e, 0x61, 0x6e, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x06, 0x52, 0x11,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x55, 0x6e, 0x69, 0x78, 0x4e, 0x61, 0x6e,
	0x6f, 0x12, 0x24, 0x0a, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x75, 0x6e, 0x69, 0x78, 0x5f, 0x6e,
	0x61, 0x6e, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x06, 0x52, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x55,
	0x6e, 0x69, 0x78, 0x4e, 0x61, 0x6e, 0x6f, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x4c, 0x0a,
	0x09, 0x65, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x45, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72,
	0x52, 0x09, 0x65, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x73, 0x22, 0xf6, 0x02, 0x0a, 0x15,
	0x49, 0x6e, 0x74, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x44, 0x61, 0x74, 0x61,
	0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65,
	0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4b, 0x65, 0x79, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x2f, 0x0a, 0x14,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x75, 0x6e, 0x69, 0x78, 0x5f,
	0x6e, 0x61, 0x6e, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x06, 0x52, 0x11, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x55, 0x6e, 0x69, 0x78, 0x4e, 0x61, 0x6e, 0x6f, 0x12, 0x24, 0x0a,
	0x0e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x75, 0x6e, 0x69, 0x78, 0x5f, 0x6e, 0x61, 0x6e, 0x6f, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x06, 0x52, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x55, 0x6e, 0x69, 0x78, 0x4e,
	0x61, 0x6e, 0x6f, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x06, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x75, 0x6d,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x10, 0x52, 0x03, 0x73, 0x75, 0x6d, 0x12, 0x23, 0x0a, 0x0d, 0x62,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x06, 0x52, 0x0c, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x12, 0x27, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x5f, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x01, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x6c, 0x69,
	0x63, 0x69, 0x74, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x12, 0x49, 0x0a, 0x09, 0x65, 0x78, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x72, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x74, 0x45, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x52, 0x09, 0x65, 0x78, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x72, 0x73, 0x22, 0xfc, 0x02, 0x0a, 0x18, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x48,
	0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e,
	0x74, 0x12, 0x45, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x2f, 0x0a, 0x14, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x75, 0x6e, 0x69, 0x78, 0x5f, 0x6e, 0x61, 0x6e, 0x6f,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x06, 0x52, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x55, 0x6e, 0x69, 0x78, 0x4e, 0x61, 0x6e, 0x6f, 0x12, 0x24, 0x0a, 0x0e, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x75, 0x6e, 0x69, 0x78, 0x5f, 0x6e, 0x61, 0x6e, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x06, 0x52, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x55, 0x6e, 0x69, 0x78, 0x4e, 0x61, 0x6e, 0x6f, 0x12,
	0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x06, 0x52, 0x05,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x75, 0x6d, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x03, 0x73, 0x75, 0x6d, 0x12, 0x23, 0x0a, 0x0d, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x06, 0x52, 0x0c,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x27, 0x0a, 0x0f,
	0x65, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x01, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x42,
	0x6f, 0x75, 0x6e, 0x64, 0x73, 0x12, 0x4c, 0x0a, 0x09, 0x65, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x72, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74,
	0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x45, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x52, 0x09, 0x65, 0x78, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x72, 0x73, 0x22, 0x94, 0x03, 0x0a, 0x16, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x44, 0x61, 0x74, 0x61, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x45,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x2f, 0x0a, 0x14, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x75, 0x6e, 0x69, 0x78, 0x5f, 0x6e, 0x61, 0x6e, 0x6f, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x06, 0x52, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x55, 0x6e,
	0x69, 0x78, 0x4e, 0x61, 0x6e, 0x6f, 0x12, 0x24, 0x0a, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x75,
	0x6e, 0x69, 0x78, 0x5f, 0x6e, 0x61, 0x6e, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x06, 0x52, 0x0c,
	0x74, 0x69, 0x6d, 0x65, 0x55, 0x6e, 0x69, 0x78, 0x4e, 0x61, 0x6e, 0x6f, 0x12, 0x14, 0x0a, 0x05,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x06, 0x52, 0x05, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x75, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x03, 0x73, 0x75, 0x6d, 0x12, 0x6f, 0x0a, 0x0f, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x6c, 0x65,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x44, 0x61, 0x74, 0x61,
	0x50, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x41, 0x74, 0x51, 0x75, 0x61,
	0x6e, 0x74, 0x69, 0x6c, 0x65, 0x52, 0x0e, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x43, 0x0a, 0x0f, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x41, 0x74,
	0x51, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x71, 0x75, 0x61, 0x6e,
	0x74, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x08, 0x71, 0x75, 0x61, 0x6e,
	0x74, 0x69, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xd5, 0x01, 0x0a, 0x0b, 0x49,
	0x6e, 0x74, 0x45, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x12, 0x56, 0x0a, 0x0f, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65,
	0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x65, 0x64, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x24, 0x0a, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x75, 0x6e, 0x69, 0x78, 0x5f,
	0x6e, 0x61, 0x6e, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x06, 0x52, 0x0c, 0x74, 0x69, 0x6d, 0x65,
	0x55, 0x6e, 0x69, 0x78, 0x4e, 0x61, 0x6e, 0x6f, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x10, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x17,
	0x0a, 0x07, 0x73, 0x70, 0x61, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x06, 0x73, 0x70, 0x61, 0x6e, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x61, 0x63, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x65,
	0x49, 0x64, 0x22, 0xd8, 0x01, 0x0a, 0x0e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x45, 0x78, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x72, 0x12, 0x56, 0x0a, 0x0f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x65,
	0x64, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x4b, 0x65, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x65, 0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x24, 0x0a,
	0x0e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x75, 0x6e, 0x69, 0x78, 0x5f, 0x6e, 0x61, 0x6e, 0x6f, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x06, 0x52, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x55, 0x6e, 0x69, 0x78, 0x4e,
	0x61, 0x6e, 0x6f, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x73, 0x70, 0x61,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x73, 0x70, 0x61, 0x6e,
	0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x65, 0x49, 0x64, 0x2a, 0x8c, 0x01,
	0x0a, 0x16, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d,
	0x70, 0x6f, 0x72, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x27, 0x0a, 0x23, 0x41, 0x47, 0x47, 0x52,
	0x45, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x45, 0x4d, 0x50, 0x4f, 0x52, 0x41, 0x4c,
	0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x21, 0x0a, 0x1d, 0x41, 0x47, 0x47, 0x52, 0x45, 0x47, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x54, 0x45, 0x4d, 0x50, 0x4f, 0x52, 0x41, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x44, 0x45, 0x4c,
	0x54, 0x41, 0x10, 0x01, 0x12, 0x26, 0x0a, 0x22, 0x41, 0x47, 0x47, 0x52, 0x45, 0x47, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x45, 0x4d, 0x50, 0x4f, 0x52, 0x41, 0x4c, 0x49, 0x54, 0x59, 0x5f,
	0x43, 0x55, 0x4d, 0x55, 0x4c, 0x41, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x42, 0x71, 0x0a, 0x21,
	0x69, 0x6f, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76,
	0x31, 0x42, 0x0c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x3c, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x69, 0x6e,
	0x66, 0x6c, 0x75, 0x78, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x69, 0x6e, 0x66, 0x6c, 0x75, 0x78, 0x64,
	0x62, 0x2d, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2f,
	0x6f, 0x74, 0x6c, 0x70, 0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x76, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescOnce sync.Once
	file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescData = file_opentelemetry_proto_metrics_v1_metrics_proto_rawDesc
)

func file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescGZIP() []byte {
	file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescOnce.Do(func() {
		file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescData = protoimpl.X.CompressGZIP(file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescData)
	})
	return file_opentelemetry_proto_metrics_v1_metrics_proto_rawDescData
}

var file_opentelemetry_proto_metrics_v1_metrics_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_opentelemetry_proto_metrics_v1_metrics_proto_goTypes = []interface{}{
	(AggregationTemporality)(0),                    // 0: opentelemetry.proto.metrics.v1.AggregationTemporality
	(*ResourceMetrics)(nil),                        // 1: opentelemetry.proto.metrics.v1.ResourceMetrics
	(*InstrumentationLibraryMetrics)(nil),          // 2: opentelemetry.proto.metrics.v1.InstrumentationLibraryMetrics
	(*Metric)(nil),                                 // 3: opentelemetry.proto.metrics.v1.Metric
	(*IntGauge)(nil),                               // 4: opentelemetry.proto.metrics.v1.IntGauge
	(*DoubleGauge)(nil),                            // 5: opentelemetry.proto.metrics.v1.DoubleGauge
	(*IntSum)(nil),                                 // 6: opentelemetry.proto.metrics.v1.IntSum
	(*DoubleSum)(nil),                              // 7: opentelemetry.proto.metrics.v1.DoubleSum
	(*IntHistogram)(nil),                           // 8: opentelemetry.proto.metrics.v1.IntHistogram
	(*DoubleHistogram)(nil),                        // 9: opentelemetry.proto.metrics.v1.DoubleHistogram
	(*DoubleSummary)(nil),                          // 10: opentelemetry.proto.metrics.v1.DoubleSummary
	(*IntDataPoint)(nil),                           // 11: opentelemetry.proto.metrics.v1.IntDataPoint
	(*DoubleDataPoint)(nil),                        // 12: opentelemetry.proto.metrics.v1.DoubleDataPoint
	(*IntHistogramDataPoint)(nil),                  // 13: opentelemetry.proto.metrics.v1.IntHistogramDataPoint
	(*DoubleHistogramDataPoint)(nil),               // 14: opentelemetry.proto.metrics.v1.DoubleHistogramDataPoint
	(*DoubleSummaryDataPoint)(nil),                 // 15: opentelemetry.proto.metrics.v1.DoubleSummaryDataPoint
	(*IntExemplar)(nil),                            // 16: opentelemetry.proto.metrics.v1.IntExemplar
	(*DoubleExemplar)(nil),                         // 17: opentelemetry.proto.metrics.v1.DoubleExemplar
	(*DoubleSummaryDataPoint_ValueAtQuantile)(nil), // 18: opentelemetry.proto.metrics.v1.DoubleSummaryDataPoint.ValueAtQuantile
	(*v1.Resource)(nil),                            // 19: opentelemetry.proto.resource.v1.Resource
	(*v11.InstrumentationLibrary)(nil),             // 20: opentelemetry.proto.common.v1.InstrumentationLibrary
	(*v11.StringKeyValue)(nil),                     // 21: opentelemetry.proto.common.v1.StringKeyValue
}
var file_opentelemetry_proto_metrics_v1_metrics_proto_depIdxs = []int32{
	19, // 0: opentelemetry.proto.metrics.v1.ResourceMetrics.resource:type_name -> opentelemetry.proto.resource.v1.Resource
	2,  // 1: opentelemetry.proto.metrics.v1.ResourceMetrics.instrumentation_library_metrics:type_name -> opentelemetry.proto.metrics.v1.InstrumentationLibraryMetrics
	20, // 2: opentelemetry.proto.metrics.v1.InstrumentationLibraryMetrics.instrumentation_library:type_name -> opentelemetry.proto.common.v1.InstrumentationLibrary
	3,  // 3: opentelemetry.proto.metrics.v1.InstrumentationLibraryMetrics.metrics:type_name -> opentelemetry.proto.metrics.v1.Metric
	4,  // 4: opentelemetry.proto.metrics.v1.Metric.int_gauge:type_name -> opentelemetry.proto.metrics.v1.IntGauge
	5,  // 5: opentelemetry.proto.metrics.v1.Metric.double_gauge:type_name -> opentelemetry.proto.metrics.v1.DoubleGauge
	6,  // 6: opentelemetry.proto.metrics.v1.Metric.int_sum:type_name -> opentelemetry.proto.metrics.v1.IntSum
	7,  // 7: opentelemetry.proto.metrics.v1.Metric.double_sum:type_name -> opentelemetry.proto.metrics.v1.DoubleSum
	8,  // 8: opentelemetry.proto.metrics.v1.Metric.int_histogram:type_name -> opentelemetry.proto.metrics.v1.IntHistogram
	9,  // 9: opentelemetry.proto.metrics.v1.Metric.double_histogram:type_name -> opentelemetry.proto.metrics.v1.DoubleHistogram
	10, // 10: opentelemetry.proto.metrics.v1.Metric.double_summary:type_name -> opentelemetry.proto.metrics.v1.DoubleSummary
	11, // 11: opentelemetry.proto.metrics.v1.IntGauge.data_points:type_name -> opentelemetry.proto.metrics.v1.IntDataPoint
	12, // 12: opentelemetry.proto.metrics.v1.DoubleGauge.data_points:type_name -> opentelemetry.proto.metrics.v1.DoubleDataPoint
	11, // 13: opentelemetry.proto.metrics.v1.IntSum.data_points:type_name -> opentelemetry.proto.metrics.v1.IntDataPoint
	0,  // 14: opentelemetry.proto.metrics.v1.IntSum.aggregation_temporality:type_name -> opentelemetry.proto.metrics.v1.AggregationTemporality
	12, // 15: opentelemetry.proto.metrics.v1.DoubleSum.data_points:type_name -> opentelemetry.proto.metrics.v1.DoubleDataPoint
	0,  // 16: opentelemetry.proto.metrics.v1.DoubleSum.aggregation_temporality:type_name -> opentelemetry.proto.metrics.v1.AggregationTemporality
	13, // 17: opentelemetry.proto.metrics.v1.IntHistogram.data_points:type_name -> opentelemetry.proto.metrics.v1.IntHistogramDataPoint
	0,  // 18: opentelemetry.proto.metrics.v1.IntHistogram.aggregation_temporality:type_name -> opentelemetry.proto.metrics.v1.AggregationTemporality
	14, // 19: opentelemetry.proto.metrics.v1.DoubleHistogram.data_points:type_name -> opentelemetry.proto.metrics.v1.DoubleHistogramDataPoint
	0,  // 20: opentelemetry.proto.metrics.v1.DoubleHistogram.aggregation_temporality:type_name -> opentelemetry.proto.metrics.v1.AggregationTemporality
	15, // 21: opentelemetry.proto.metrics.v1.DoubleSummary.data_points:type_name -> opentelemetry.proto.metrics.v1.DoubleSummaryDataPoint
	21, // 22: opentelemetry.proto.metrics.v1.IntDataPoint.labels:type_name -> opentelemetry.proto.common.v1.StringKeyValue
	16, // 23: opentelemetry.proto.metrics.v1.IntDataPoint.exemplars:type_name -> opentelemetry.proto.metrics.v1.IntExemplar
	21, // 24: opentelemetry.proto.metrics.v1.DoubleDataPoint.labels:type_name -> opentelemetry.proto.common.v1.StringKeyValue
	17, // 25: opentelemetry.proto.metrics.v1.DoubleDataPoint.exemplars:type_name -> opentelemetry.proto.metrics.v1.DoubleExemplar
	21, // 26: opentelemetry.proto.metrics.v1.IntHistogramDataPoint.labels:type_name -> opentelemetry.proto.common.v1.StringKeyValue
	16, // 27: opentelemetry.proto.metrics.v1.IntHistogramDataPoint.exemplars:type_name -> opentelemetry.proto.metrics.v1.IntExemplar
	21, // 28: opentelemetry.proto.metrics.v1.DoubleHistogramDataPoint.labels:type_name -> opentelemetry.proto.common.v1.StringKeyValue
	17, // 29: opentelemetry.proto.metrics.v1.DoubleHistogramDataPoint.exemplars:type_name -> opentelemetry.proto.metrics.v1.DoubleExemplar
	21, // 30: opentelemetry.proto.metrics.v1.DoubleSummaryDataPoint.labels:type_name -> opentelemetry.proto.common.v1.StringKeyValue
	18, // 31: opentelemetry.proto.metrics.v1.DoubleSummaryDataPoint.quantile_values:type_name -> opentelemetry.proto.metrics.v1.DoubleSummaryDataPoint.ValueAtQuantile
	21, // 32: opentelemetry.proto.metrics.v1.IntExemplar.filtered_labels:type_name -> opentelemetry.proto.common.v1.StringKeyValue
	21, // 33: opentelemetry.proto.metrics.v1.DoubleExemplar.filtered_labels:type_name -> opentelemetry.proto.common.v1.StringKeyValue
	34, // [34:34] is the sub-list for method output_type
	34, // [34:34] is the sub-list for method input_type
	34, // [34:34] is the sub-list for extension type_name
	34, // [34:34] is the sub-list for extension extendee
	0,  // [0:34] is the sub-list for field type_name
}

func init() { file_opentelemetry_proto_metrics_v1_metrics_proto_init() }
func file_opentelemetry_proto_metrics_v1_metrics_proto_init() {
	if File_opentelemetry_proto_metrics_v1_metrics_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstrumentationLibraryMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Metric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntGauge); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DoubleGauge); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntSum); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DoubleSum); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntHistogram); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DoubleHistogram); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DoubleSummary); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntDataPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DoubleDataPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntHistogramDataPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DoubleHistogramDataPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DoubleSummaryDataPoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntExemplar); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DoubleExemplar); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DoubleSummaryDataPoint_ValueAtQuantile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*Metric_IntGauge)(nil),
		(*Metric_DoubleGauge)(nil),
		(*Metric_IntSum)(nil),
		(*Metric_DoubleSum)(nil),
		(*Metric_IntHistogram)(nil),
		(*Metric_DoubleHistogram)(nil),
		(*Metric_DoubleSummary)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_opentelemetry_proto_metrics_v1_metrics_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_opentelemetry_proto_metrics_v1_metrics_proto_goTypes,
		DependencyIndexes: file_opentelemetry_proto_metrics_v1_metrics_proto_depIdxs,
		EnumInfos:         file_opentelemetry_proto_metrics_v1_metrics_proto_enumTypes,
		MessageInfos:      file_opentelemetry_proto_metrics_v1_metrics_proto_msgTypes,
	}.Build()
	File_opentelemetry_proto_metrics_v1_metrics_proto = out.File
	file_opentelemetry_proto_metrics_v1_metrics_proto_rawDesc = nil
	file_opentelemetry_proto_metrics_v1_metrics_proto_goTypes = nil
	file_opentelemetry_proto_metrics_v1_metrics_proto_depIdxs = nil
}
