package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddCommonBandwidthPackageIps invokes the vpc.AddCommonBandwidthPackageIps API synchronously
func (client *Client) AddCommonBandwidthPackageIps(request *AddCommonBandwidthPackageIpsRequest) (response *AddCommonBandwidthPackageIpsResponse, err error) {
	response = CreateAddCommonBandwidthPackageIpsResponse()
	err = client.DoAction(request, response)
	return
}

// AddCommonBandwidthPackageIpsWithChan invokes the vpc.AddCommonBandwidthPackageIps API asynchronously
func (client *Client) AddCommonBandwidthPackageIpsWithChan(request *AddCommonBandwidthPackageIpsRequest) (<-chan *AddCommonBandwidthPackageIpsResponse, <-chan error) {
	responseChan := make(chan *AddCommonBandwidthPackageIpsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddCommonBandwidthPackageIps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddCommonBandwidthPackageIpsWithCallback invokes the vpc.AddCommonBandwidthPackageIps API asynchronously
func (client *Client) AddCommonBandwidthPackageIpsWithCallback(request *AddCommonBandwidthPackageIpsRequest, callback func(response *AddCommonBandwidthPackageIpsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddCommonBandwidthPackageIpsResponse
		var err error
		defer close(result)
		response, err = client.AddCommonBandwidthPackageIps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddCommonBandwidthPackageIpsRequest is the request struct for api AddCommonBandwidthPackageIps
type AddCommonBandwidthPackageIpsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	IpInstanceIds        *[]string        `position:"Query" name:"IpInstanceIds"  type:"Repeated"`
	BandwidthPackageId   string           `position:"Query" name:"BandwidthPackageId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	IpType               string           `position:"Query" name:"IpType"`
}

// AddCommonBandwidthPackageIpsResponse is the response struct for api AddCommonBandwidthPackageIps
type AddCommonBandwidthPackageIpsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddCommonBandwidthPackageIpsRequest creates a request to invoke AddCommonBandwidthPackageIps API
func CreateAddCommonBandwidthPackageIpsRequest() (request *AddCommonBandwidthPackageIpsRequest) {
	request = &AddCommonBandwidthPackageIpsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "AddCommonBandwidthPackageIps", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddCommonBandwidthPackageIpsResponse creates a response to parse from AddCommonBandwidthPackageIps response
func CreateAddCommonBandwidthPackageIpsResponse() (response *AddCommonBandwidthPackageIpsResponse) {
	response = &AddCommonBandwidthPackageIpsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
