package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMonitorGroupDynamicRules invokes the cms.DescribeMonitorGroupDynamicRules API synchronously
func (client *Client) DescribeMonitorGroupDynamicRules(request *DescribeMonitorGroupDynamicRulesRequest) (response *DescribeMonitorGroupDynamicRulesResponse, err error) {
	response = CreateDescribeMonitorGroupDynamicRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMonitorGroupDynamicRulesWithChan invokes the cms.DescribeMonitorGroupDynamicRules API asynchronously
func (client *Client) DescribeMonitorGroupDynamicRulesWithChan(request *DescribeMonitorGroupDynamicRulesRequest) (<-chan *DescribeMonitorGroupDynamicRulesResponse, <-chan error) {
	responseChan := make(chan *DescribeMonitorGroupDynamicRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMonitorGroupDynamicRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMonitorGroupDynamicRulesWithCallback invokes the cms.DescribeMonitorGroupDynamicRules API asynchronously
func (client *Client) DescribeMonitorGroupDynamicRulesWithCallback(request *DescribeMonitorGroupDynamicRulesRequest, callback func(response *DescribeMonitorGroupDynamicRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMonitorGroupDynamicRulesResponse
		var err error
		defer close(result)
		response, err = client.DescribeMonitorGroupDynamicRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMonitorGroupDynamicRulesRequest is the request struct for api DescribeMonitorGroupDynamicRules
type DescribeMonitorGroupDynamicRulesRequest struct {
	*requests.RpcRequest
	GroupId requests.Integer `position:"Query" name:"GroupId"`
}

// DescribeMonitorGroupDynamicRulesResponse is the response struct for api DescribeMonitorGroupDynamicRules
type DescribeMonitorGroupDynamicRulesResponse struct {
	*responses.BaseResponse
	RequestId string                                     `json:"RequestId" xml:"RequestId"`
	Success   bool                                       `json:"Success" xml:"Success"`
	Code      int                                        `json:"Code" xml:"Code"`
	Message   string                                     `json:"Message" xml:"Message"`
	Resource  ResourceInDescribeMonitorGroupDynamicRules `json:"Resource" xml:"Resource"`
}

// CreateDescribeMonitorGroupDynamicRulesRequest creates a request to invoke DescribeMonitorGroupDynamicRules API
func CreateDescribeMonitorGroupDynamicRulesRequest() (request *DescribeMonitorGroupDynamicRulesRequest) {
	request = &DescribeMonitorGroupDynamicRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DescribeMonitorGroupDynamicRules", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeMonitorGroupDynamicRulesResponse creates a response to parse from DescribeMonitorGroupDynamicRules response
func CreateDescribeMonitorGroupDynamicRulesResponse() (response *DescribeMonitorGroupDynamicRulesResponse) {
	response = &DescribeMonitorGroupDynamicRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
