/***************************************************************************
                          tea_gtk_utils.c  -  description
                             -------------------
    begin                : aug. 2004
    copyright            : (C) 2004, 2005 by Peter 'Roxton' Semiletov
    email                : roxton@ua.fm
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#include <glib.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <sys/stat.h>
#include <gdk/gdkkeysyms.h>

#include <stddef.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>

#include "tea_defs.h"
#include "tea_options.h"
#include "tea_gtk_utils.h"
#include "tea_config.h"


static void cb_put_launcher (GtkButton *button,
                             gpointer user_data)
{
   free_desktop_create_shortcut ();
}


static void cb_del_launcher (GtkButton *button,
                             gpointer user_data)
{
   free_desktop_delete_shortcut ();
}


static void cb_on_choose_enc (GtkButton *button,
                              gpointer user_data)
{
  gchar *s = tv_get_selected_single (tv_available_charsets);
  if (! s)
     return;

  gl_enc_choosed = g_list_prepend (gl_enc_choosed, g_strdup (s));
  tv_fill_with_glist (tv_choosed_charsets, gl_enc_choosed);

  glist_save_to_file (gl_enc_choosed, confile.tea_choosed_charsets); 
  get_iconv_sup ();
}


static void cb_on_del_enc (GtkButton *button,
                           gpointer user_data)
{
  gchar *s = tv_get_selected_single (tv_choosed_charsets);
  if (! s)
     return;

  GList *l = str_remove_from_list (gl_enc_choosed, s);

  glist_strings_free (gl_enc_choosed);
  gl_enc_choosed = l;

  glist_save_to_file (gl_enc_choosed, confile.tea_choosed_charsets); 
  get_iconv_sup ();
  tv_fill_with_glist (tv_choosed_charsets, gl_enc_choosed);
}


static void on_kwas_notebook_switch_page (GtkNotebook *notebook,
                                          GtkNotebookPage *page,
                                          guint page_num,
                                          gpointer user_data)
{
  confile.last_prefs_tab = page_num;      
}


static void cb_on_bt_apply (GtkObject *object, GtkWidget *w) 
{
   GList *l = NULL;

   l = add_to_glist_combined_str (l, "fmt_color_function", gtk_entry_get_text (GTK_ENTRY (ent_fmt_color_function)));
   l = add_to_glist_combined_str (l, "default_markup_mode", gtk_entry_get_text (GTK_ENTRY (ent_def_markup_mode)));

   l = add_to_glist_combined_str (l, "def_save_dir", gtk_entry_get_text (GTK_ENTRY (ent_def_save_dir)));
   l = add_to_glist_combined_str (l, "def_open_dir", gtk_entry_get_text (GTK_ENTRY (ent_def_open_dir)));

   l = add_to_glist_combined_str (l, "cm_pdflatex", gtk_entry_get_text (GTK_ENTRY (ent_cm_pdflatex)));
   l = add_to_glist_combined_str (l, "cm_dvi_to_ps", gtk_entry_get_text (GTK_ENTRY (ent_cm_dvi_to_ps)));
   l = add_to_glist_combined_str (l, "cm_dvi_view", gtk_entry_get_text (GTK_ENTRY (ent_cm_dvi_view)));
   l = add_to_glist_combined_str (l, "cm_pdf_view", gtk_entry_get_text (GTK_ENTRY (ent_cm_pdf_view)));
   l = add_to_glist_combined_str (l, "cm_ps_view", gtk_entry_get_text (GTK_ENTRY (ent_cm_ps_view)));
   l = add_to_glist_combined_str (l, "cm_run_latex", gtk_entry_get_text (GTK_ENTRY (ent_cm_run_latex)));
   l = add_to_glist_combined_str (l, "cm_dvi_to_pdf", gtk_entry_get_text (GTK_ENTRY (ent_cm_dvi_to_pdf)));

   l = add_to_glist_combined_str (l, "mplayer", gtk_entry_get_text (GTK_ENTRY (ent_cm_mplayer)));
   l = add_to_glist_combined_str (l, "mozilla", gtk_entry_get_text (GTK_ENTRY (ent_cm_mozilla)));
   l = add_to_glist_combined_str (l, "konqueror", gtk_entry_get_text (GTK_ENTRY (ent_cm_konqueror)));
   l = add_to_glist_combined_str (l, "firefox", gtk_entry_get_text (GTK_ENTRY (ent_cm_firefox)));
   l = add_to_glist_combined_str (l, "opera", gtk_entry_get_text (GTK_ENTRY (ent_cm_opera)));
   l = add_to_glist_combined_str (l, "links", gtk_entry_get_text (GTK_ENTRY (ent_cm_links)));
   l = add_to_glist_combined_str (l, "elinks", gtk_entry_get_text (GTK_ENTRY (ent_cm_elinks)));
   l = add_to_glist_combined_str (l, "dillo", gtk_entry_get_text (GTK_ENTRY (ent_cm_dillo)));
   l = add_to_glist_combined_str (l, "galeon", gtk_entry_get_text (GTK_ENTRY (ent_cm_galeon)));
   l = add_to_glist_combined_str (l, "epiphany", gtk_entry_get_text (GTK_ENTRY (ent_cm_epiphany)));

   l = add_to_glist_combined_str (l, "other", gtk_entry_get_text (GTK_ENTRY (ent_cm_other)));
   l = add_to_glist_combined_str (l, "lynx", gtk_entry_get_text (GTK_ENTRY (ent_cm_lynx)));
   l = add_to_glist_combined_str (l, "def_doc_browser", gtk_entry_get_text (GTK_ENTRY (ent_cm_manual_browser)));

   l = add_to_glist_combined_str (l, "date_time", gtk_entry_get_text (GTK_ENTRY (ent_date_time)));
   l = add_to_glist_combined_str (l, "now_playing", gtk_entry_get_text (GTK_ENTRY (ent_now_playing)));


   l = add_to_glist_combined_str (l, "tag_color_lm_error_fg", gtk_entry_get_text (GTK_ENTRY (ent_tag_color_lm_error_fg)));
   l = add_to_glist_combined_str (l, "tag_color_lm_error_bg", gtk_entry_get_text (GTK_ENTRY (ent_tag_color_lm_error_bg)));
   l = add_to_glist_combined_str (l, "color_cursor", gtk_entry_get_text (GTK_ENTRY (ent_color_cursor)));

   l = add_to_glist_combined_str (l, "tag_comment", gtk_entry_get_text (GTK_ENTRY (ent_tag_comment)));
   l = add_to_glist_combined_str (l, "tag_identifier", gtk_entry_get_text (GTK_ENTRY (ent_tag_identifier)));
   l = add_to_glist_combined_str (l, "tag_digit", gtk_entry_get_text (GTK_ENTRY (ent_tag_digit)));
   l = add_to_glist_combined_str (l, "tag_string", gtk_entry_get_text (GTK_ENTRY (ent_tag_string)));
   l = add_to_glist_combined_str (l, "tag_html_tag", gtk_entry_get_text (GTK_ENTRY (ent_tag_html_tag)));

   l = add_to_glist_combined_str (l, "tag_preprocessor", gtk_entry_get_text (GTK_ENTRY (ent_tag_preprocessor)));
   l = add_to_glist_combined_str (l, "tag_type", gtk_entry_get_text (GTK_ENTRY (ent_tag_type)));
   l = add_to_glist_combined_str (l, "tag_spellcheck", gtk_entry_get_text (GTK_ENTRY (ent_tag_spellcheck)));

   l = add_to_glist_combined_str (l, "text_foreground", gtk_entry_get_text (GTK_ENTRY (ent_text_foreground)));
   l = add_to_glist_combined_str (l, "text_background", gtk_entry_get_text (GTK_ENTRY (ent_text_background)));
 
   l = add_to_glist_combined_str (l, "text_sel_foreground", gtk_entry_get_text (GTK_ENTRY (ent_text_sel_foreground)));
   l = add_to_glist_combined_str (l, "text_sel_background", gtk_entry_get_text (GTK_ENTRY (ent_text_sel_background)));

   l = add_to_glist_combined_str (l, "def_filesave_charset", gtk_entry_get_text (GTK_ENTRY (ent_def_filesave_charset)));
   l = add_to_glist_combined_str (l, "default_charset", gtk_entry_get_text (GTK_ENTRY (ent_default_charset)));
   l = add_to_glist_combined_str (l, "rtf_enc", gtk_entry_get_text (GTK_ENTRY (ent_rtf_enc)));

/*
   l = add_to_glist_combined_str (l, "tag_comment_font", gtk_entry_get_text (GTK_ENTRY (ent_tag_comment_font)));
   l = add_to_glist_combined_str (l, "tag_identifier_font", gtk_entry_get_text (GTK_ENTRY (ent_tag_identifier_font)));
   l = add_to_glist_combined_str (l, "tag_digit_font", gtk_entry_get_text (GTK_ENTRY (ent_tag_digit_font)));
   l = add_to_glist_combined_str (l, "tag_string_font", gtk_entry_get_text (GTK_ENTRY (ent_tag_string_font)));
   l = add_to_glist_combined_str (l, "tag_html_tag_font", gtk_entry_get_text (GTK_ENTRY (ent_tag_html_tag_font)));
   l = add_to_glist_combined_str (l, "tag_preprocessor_font", gtk_entry_get_text (GTK_ENTRY (ent_tag_preprocessor_font)));
   l = add_to_glist_combined_str (l, "tag_type_font", gtk_entry_get_text (GTK_ENTRY (ent_tag_type_font)));
*/
   l = add_to_glist_combined_str (l, "tag_comment_font", gtk_font_button_get_font_name (fb_tag_comment_font));
   l = add_to_glist_combined_str (l, "tag_identifier_font", gtk_font_button_get_font_name (fb_tag_identifier_font));
   l = add_to_glist_combined_str (l, "tag_digit_font", gtk_font_button_get_font_name (fb_tag_digit_font));
   l = add_to_glist_combined_str (l, "tag_string_font", gtk_font_button_get_font_name (fb_tag_string_font));
   l = add_to_glist_combined_str (l, "tag_html_tag_font", gtk_font_button_get_font_name (fb_tag_html_tag_font));
   l = add_to_glist_combined_str (l, "tag_preprocessor_font", gtk_font_button_get_font_name (fb_tag_preprocessor_font));
   l = add_to_glist_combined_str (l, "tag_type_font", gtk_font_button_get_font_name (fb_tag_type_font));
   l = add_to_glist_combined_str (l, "editor_font", gtk_font_button_get_font_name (fb_editor_font));


//   l = add_to_glist_combined_str (l, "editor_font", gtk_entry_get_text (GTK_ENTRY (ent_editor_font)));

   l = add_to_glist_combined_str (l, "ext_pic_editor", gtk_entry_get_text (GTK_ENTRY (ent_ext_pic_editor)));
   l = add_to_glist_combined_str (l, "ext_pic_viewer", gtk_entry_get_text (GTK_ENTRY (ent_ext_pic_viewer)));

   l = add_to_glist_combined_int (l, "autoclose_tags", gtk_toggle_button_get_active (&cb_autoclose_tags->toggle_button));
   

   l = add_to_glist_combined_int (l, "prompt_on_not_saved", gtk_toggle_button_get_active (&cb_prompt_on_not_saved->toggle_button));
   l = add_to_glist_combined_int (l, "prompt_on_file_exists", gtk_toggle_button_get_active (&cb_prompt_on_file_exists->toggle_button));

   l = add_to_glist_combined_int (l, "do_det_scripts_by_content", gtk_toggle_button_get_active (&cb_do_det_scripts_by_content->toggle_button));
   l = add_to_glist_combined_int (l, "do_show_main_toolbar", gtk_toggle_button_get_active (&cb_do_show_main_toolbar->toggle_button));
   l = add_to_glist_combined_int (l, "implane_ins_image", gtk_toggle_button_get_active (&cb_implane_ins_image->toggle_button));
   l = add_to_glist_combined_int (l, "use_cursor_blink", gtk_toggle_button_get_active (&cb_use_cursor_blink->toggle_button));

   l = add_to_glist_combined_int (l, "use_snippets", gtk_toggle_button_get_active (&cb_use_snippets->toggle_button));
   l = add_to_glist_combined_int (l, "use_ext_image_viewer", gtk_toggle_button_get_active (&cb_use_ext_image_viewer->toggle_button));

   l = add_to_glist_combined_int (l, "do_hl_on_fileopen", gtk_toggle_button_get_active (&cb_do_hl_on_fileopen->toggle_button));
   l = add_to_glist_combined_int (l, "do_backup", gtk_toggle_button_get_active (&cb_do_backup->toggle_button));

   l = add_to_glist_combined_int (l, "start_with_blank_file", gtk_toggle_button_get_active (&cb_start_with_blank_file->toggle_button));
   l = add_to_glist_combined_int (l, "start_with_recent_file", gtk_toggle_button_get_active (&cb_start_with_recent_file->toggle_button));

   l = add_to_glist_combined_int (l, "use_def_doc_browser", gtk_toggle_button_get_active (&cb_use_def_doc_browser->toggle_button));

   l = add_to_glist_combined_int (l, "show_line_nums", gtk_toggle_button_get_active (&cb_show_line_nums->toggle_button));
   l = add_to_glist_combined_int (l, "word_wrap", gtk_toggle_button_get_active (&cb_word_wrap->toggle_button));
   l = add_to_glist_combined_int (l, "use_def_save_dir", gtk_toggle_button_get_active (&cb_use_def_save_dir->toggle_button));
   l = add_to_glist_combined_int (l, "use_def_open_dir", gtk_toggle_button_get_active (&cb_use_def_open_dir->toggle_button));
   l = add_to_glist_combined_int (l, "use_auto_indent", gtk_toggle_button_get_active (&cb_use_auto_indent->toggle_button));

   l = add_to_glist_combined_int (l, "ins_spaces_on_tab_press", gtk_toggle_button_get_active (&cb_ins_spaces_on_tab_press->toggle_button));
   l = add_to_glist_combined_int (l, "scan_for_links_on_doc_open", gtk_toggle_button_get_active (&cb_scan_for_links_on_doc_open->toggle_button));
   l = add_to_glist_combined_int (l, "main_wnd_show_full_path", gtk_toggle_button_get_active (&cb_main_wnd_show_full_path->toggle_button));

   l = add_to_glist_combined_int (l, "enc_det_cp1251", gtk_toggle_button_get_active (&cb_enc_det_cp1251->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_koi8r", gtk_toggle_button_get_active (&cb_enc_det_koi8r->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_koi8u", gtk_toggle_button_get_active (&cb_enc_det_koi8u->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_866", gtk_toggle_button_get_active (&cb_enc_det_866->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_czech", gtk_toggle_button_get_active (&cb_enc_czech->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_finnish", gtk_toggle_button_get_active (&cb_enc_det_finnish->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_german", gtk_toggle_button_get_active (&cb_enc_det_german->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_serbian", gtk_toggle_button_get_active (&cb_enc_det_serbian->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_latvian", gtk_toggle_button_get_active (&cb_enc_det_latvian->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_polish", gtk_toggle_button_get_active (&cb_enc_det_polish->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_portuguese", gtk_toggle_button_get_active (&cb_enc_det_portuguese->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_slovak", gtk_toggle_button_get_active (&cb_enc_det_slovak->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_slovenian", gtk_toggle_button_get_active (&cb_enc_det_slovenian->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_spanish", gtk_toggle_button_get_active (&cb_enc_det_spanish->toggle_button));
   l = add_to_glist_combined_int (l, "enc_det_turkish", gtk_toggle_button_get_active (&cb_enc_det_turkish->toggle_button));
   l = add_to_glist_combined_int (l, "show_hidden_files", gtk_toggle_button_get_active (&cb_show_hidden_files->toggle_button));
   l = add_to_glist_combined_int (l, "do_autorep", gtk_toggle_button_get_active (&cb_do_autorep->toggle_button));

   l = add_to_glist_combined_int (l, "logmemo_lines_max", gtk_spin_button_get_value_as_int (sb_logmemo_lines_max));  
   l = add_to_glist_combined_int (l, "famous_history_max", gtk_spin_button_get_value_as_int (sb_famous_history_max));  
   l = add_to_glist_combined_int (l, "max_recent_items", gtk_spin_button_get_value_as_int (sb_max_recent_items));  
   //l = add_to_glist_combined_int (l, "autocomp_wordlen_min", gtk_spin_button_get_value_as_int (sb_autocomp_wordlen_min));  
   //l = add_to_glist_combined_int (l, "autocomp_list_items_max", gtk_spin_button_get_value_as_int (sb_autocomp_list_items_max));  

   l = add_to_glist_combined_int (l, "thumb_width", gtk_spin_button_get_value_as_int (sb_thumb_width));  
   l = add_to_glist_combined_int (l, "thumb_height", gtk_spin_button_get_value_as_int (sb_thumb_height));  

   l = add_to_glist_combined_int (l, "saveopen_w", gtk_spin_button_get_value_as_int (sb_saveopen_w));  
   l = add_to_glist_combined_int (l, "saveopen_h", gtk_spin_button_get_value_as_int (sb_saveopen_h));  
   l = add_to_glist_combined_int (l, "tab_size", gtk_spin_button_get_value_as_int (sb_tab_size));  
 
   glist_save_to_file (l, confile.tea_rc);

   glist_strings_free (l);
   confile_reload ();
   write_gtkrc (); 
   gtk_rc_parse (confile.file_gtkrc);
   gtk_rc_reset_styles (gtk_settings_get_for_screen (gdk_screen_get_default ()));

   doc_update_all();
   update_enc_menu();
}


static GtkWidget* wnd_options_encoding (void)
{
  GtkWidget *enc_tabs = gtk_notebook_new ();    
  gtk_widget_show (enc_tabs);
  
  GtkWidget *wnd = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (wnd);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (wnd), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
 
  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);
  gtk_scrolled_window_add_with_viewport (wnd, page);

  GtkWidget *fr1 = gtk_frame_new (_("Defaults"));   
  gtk_widget_show (fr1);
  gtk_box_pack_start (page, fr1, FALSE, FALSE, UI_PACKFACTOR);

  GtkWidget *box = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (box);
  gtk_container_add (fr1, box); 

  ent_default_charset = tea_combo (box, confile.iconv_encs, _("Default charset for File open"), confile.default_charset);
  ent_def_filesave_charset = tea_combo (box, confile.gl_save_charsets, _("Default charset for File save as"), confile.def_filesave_charset);
 
  fr1 = gtk_frame_new (_("Misc"));   
  gtk_widget_show (fr1);
  gtk_box_pack_start (box, fr1, FALSE, FALSE, UI_PACKFACTOR);
 
  box = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (box);
  gtk_container_add (fr1, box); 

  ent_rtf_enc = tea_text_entry (box, _("Default charset for RTF"), confile.rtf_enc);  
 
  GtkWidget *fr2 = gtk_frame_new (_("Autodetect"));   
  gtk_widget_show (fr2);
 
  gtk_box_pack_start (page, fr2, FALSE, FALSE, UI_PACKFACTOR);
  
  box = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (box);
  gtk_container_add (fr2, box); 

  cb_enc_det_cp1251 = tea_checkbox (box, _("CP 1251"), confile.enc_det_cp1251); 
  cb_enc_det_koi8r = tea_checkbox (box, _("KOI8-R"), confile.enc_det_koi8r);
  cb_enc_det_koi8u = tea_checkbox (box, _("KOI8-U"), confile.enc_det_koi8u);
  cb_enc_det_866 = tea_checkbox (box, _("DOS 866"), confile.enc_det_866);
  cb_enc_czech = tea_checkbox (box, _("Czech"), confile.enc_det_czech);
  cb_enc_det_finnish = tea_checkbox (box, _("Finnish"), confile.enc_det_finnish);
  cb_enc_det_german = tea_checkbox (box, _("German"), confile.enc_det_german);
  cb_enc_det_serbian = tea_checkbox (box, _("Serbian"), confile.enc_det_serbian);
  cb_enc_det_latvian = tea_checkbox (box, _("Latvian"), confile.enc_det_latvian);
  cb_enc_det_polish = tea_checkbox (box, _("Polish"), confile.enc_det_polish);
  cb_enc_det_portuguese = tea_checkbox (box, _("Portuguese"), confile.enc_det_portuguese);
  cb_enc_det_slovak = tea_checkbox (box, _("Slovak"), confile.enc_det_slovak);
  cb_enc_det_slovenian = tea_checkbox (box, _("Slovenian"), confile.enc_det_slovenian);
  cb_enc_det_spanish = tea_checkbox (box, _("Spanish"), confile.enc_det_spanish);  
  cb_enc_det_turkish = tea_checkbox (box, _("Turkish"), confile.enc_det_turkish);  

  //current music: Radiohead - Banana Co.
  gtk_notebook_append_page (enc_tabs, wnd, gtk_label_new (_("Management")));

  GtkWidget *hb = gtk_hbox_new (FALSE, UI_PACKFACTOR);
  
  gtk_widget_show (hb);

  tv_available_charsets = tv_create_framed (hb, _("Available"), GTK_SELECTION_SINGLE);
  tv_fill_with_glist (tv_available_charsets, gl_enc_available);

  GtkVBox *buttons = daisho_add_del (cb_on_choose_enc, cb_on_del_enc);
  gtk_box_pack_start (hb, buttons, FALSE, FALSE, UI_PACKFACTOR);
  
  tv_choosed_charsets = tv_create_framed (hb, _("Selected"), GTK_SELECTION_SINGLE);
  tv_fill_with_glist (tv_choosed_charsets, gl_enc_choosed);
 
  gtk_notebook_append_page (enc_tabs, hb, gtk_label_new (_("Configure charsets")));
  
  return enc_tabs;
}


static GtkWidget* wnd_options_commands (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);

  GtkWidget *fr_misc = gtk_frame_new (_("Misc"));
  gtk_widget_show (fr_misc);
  gtk_container_add (page, fr_misc);

  GtkWidget *b = gtk_vbox_new (FALSE, UI_PACKFACTOR); 
  gtk_widget_show (b);
  gtk_container_add (fr_misc, b);

  ent_ext_pic_editor = tea_text_entry (b, _("External image editor"), confile.ext_pic_editor);
  ent_ext_pic_viewer = tea_text_entry (b, _("External image viewer"), confile.ext_pic_viewer);
  ent_cm_mplayer =  tea_text_entry (b, _("Run Mplayer with subtitles"), confile.cm_mplayer);

  GtkWidget *fr_latex = gtk_frame_new (_("LaTeX"));
  gtk_widget_show (fr_latex);
  gtk_container_add (page, fr_latex);

  b = gtk_vbox_new (FALSE, UI_PACKFACTOR); 
  gtk_widget_show (b);
  gtk_container_add (fr_latex, b);
  
  ent_cm_run_latex = tea_text_entry (b, _("Process with LaTeX"), confile.cm_run_latex); 
  ent_cm_pdflatex = tea_text_entry (b, _("Process with pdflatex"), confile.cm_pdflatex); 
  ent_cm_dvi_to_pdf = tea_text_entry (b, _("dvi to PDF"), confile.cm_dvi_to_pdf); 
  ent_cm_dvi_to_ps = tea_text_entry (b, _("dvi to PS"), confile.cm_dvi_to_ps); 
  ent_cm_dvi_view = tea_text_entry (b, _("View dvi"), confile.cm_dvi_view); 
  ent_cm_pdf_view = tea_text_entry (b, _("View PDF"), confile.cm_pdf_view); 
  ent_cm_ps_view = tea_text_entry (b, _("View PS"), confile.cm_ps_view); 
  
  return page;
}


static GtkWidget* wnd_options_limits (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, 1);
  gtk_widget_show (page);

  sb_logmemo_lines_max = tea_spinbutton (page, _("Logmemo lines limit"), confile.logmemo_lines_max);
  sb_famous_history_max = tea_spinbutton (page, _("Text entry history limit"), confile.famous_history_max);
  sb_max_recent_items = tea_spinbutton (page, _("Max. recent files"), confile.max_recent_items); 

  return page;
}


static GtkWidget* wnd_options_functions (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, 1);
  gtk_widget_show (page);
  ent_now_playing = tea_text_entry (page, _("Now Playing string format"), confile.now_playing);
  ent_date_time = tea_text_entry (page, _("Date and time format"), confile.date_time);
  ent_fmt_color_function = tea_text_entry (page, _("The format of the Color function"), confile.fmt_color_function);

  return page;
}


static GtkWidget* wnd_options_interface (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);
  
  sb_saveopen_w = tea_spinbutton (page, _("Save/Open dialogs width per cents"), confile.saveopen_w);
  sb_saveopen_h = tea_spinbutton (page, _("Save/Open dialogs height per cents"), confile.saveopen_h);
  sb_thumb_width = tea_spinbutton (page, _("Image thumbnail width"), confile.thumb_width);
  sb_thumb_height = tea_spinbutton (page, _("Image thumbnail height"), confile.thumb_height);
  cb_main_wnd_show_full_path = tea_checkbox (page, _("Show the full path in the window caption"), confile.main_wnd_show_full_path); 
  cb_do_show_main_toolbar = tea_checkbox (page, _("Show the main toolbar"), confile.do_show_main_toolbar); 

  return page;
}


static GtkWidget* wnd_options_switches (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);

  cb_start_with_recent_file = tea_checkbox (page, _("Start TEA with a recent file"), confile.start_with_recent_file); 
  cb_start_with_blank_file = tea_checkbox (page, _("Start TEA with a blank file"), confile.start_with_blank_file); 
  cb_do_det_scripts_by_content = tea_checkbox (page, _("Determine a scripts highlighting by the content"), confile.do_det_scripts_by_content); 
  cb_show_hidden_files = tea_checkbox (page, _("Show hidden files in Kwas"), confile.show_hidden_files); 
  cb_use_snippets = tea_checkbox (page, _("Use snippets"), confile.use_snippets); 
  cb_use_ext_image_viewer = tea_checkbox (page, _("Use external image viewer"), confile.use_ext_image_viewer);
  cb_do_hl_on_fileopen = tea_checkbox (page, _("Highlight on file open"), confile.do_hl_on_fileopen);
  cb_do_backup = tea_checkbox (page, _("Do backup"), confile.do_backup);
  cb_show_line_nums = tea_checkbox (page, _("Show line numbers"), confile.show_line_nums);
  cb_word_wrap = tea_checkbox (page, _("Word wrap"), confile.word_wrap);
  cb_scan_for_links_on_doc_open = tea_checkbox (page, _("Scan for links on file open"), confile.scan_for_links_on_doc_open);
  cb_implane_ins_image = tea_checkbox (page, _("Imageplane insert tags by default"), confile.implane_ins_image);

  return page;
}


static GtkWidget* wnd_options_confirmations (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);
  
  cb_prompt_on_not_saved = tea_checkbox (page, _("Warn before closing a modified file"), confile.prompt_on_not_saved); 
  cb_prompt_on_file_exists = tea_checkbox (page, _("Overwrite the existing file"), confile.prompt_on_file_exists); 
 
  return page;
}


static void cb_backup_config (GtkButton *button,
                              gpointer user_data)
{
  gchar *f = g_strconcat (confile.tea_rc, ".bak", NULL);
  copy_file (confile.tea_rc, f);
  g_free (f);
}


static void cb_restore_config (GtkButton *button,
                               gpointer user_data)
{
  gchar *f = g_strconcat (confile.tea_rc, ".bak", NULL);
  copy_file (f, confile.tea_rc);
  g_free (f);
  confile_reload ();
  doc_update_all();
  update_enc_menu();
  dlg_info (wnd_options, _("Configuration restored, please close and reopen the Preferences window."), NULL);  
}


static void cb_config_reset (GtkButton *button,
                             gpointer user_data)
{
   if (unlink (confile.tea_rc) == 0 )
      {
       confile_reload ();
       doc_update_all();
       update_enc_menu();
       dlg_info (wnd_options, _("Configuration reseted to default, please close and reopen the Preferences window."), NULL);  
      }  
}


static GtkWidget* wnd_options_maintenance (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);
  
  GtkWidget *b = tea_button_at_box (page, _("Backup the current config" ), cb_backup_config, NULL);
  b = tea_button_at_box (page, _("Config restore" ), cb_restore_config, NULL);
  b = tea_button_at_box (page, _("Reset config to default" ), cb_config_reset, NULL);
  b = tea_button_at_box (page, _("Put the launcher to the desktop" ), cb_put_launcher, NULL);
  b = tea_button_at_box (page, _("Remove the launcher from the desktop" ), cb_del_launcher, NULL);
  
  return page;
}


static GtkWidget* wnd_options_colors (void)
{
  GtkWidget *notebook = gtk_notebook_new ();         
  gtk_widget_show (notebook);

  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);

  gtk_notebook_append_page (notebook, page, gtk_label_new (_("Editor")));

  ent_text_foreground = tea_color_selector (page, _("Text foreground"), confile.text_foreground);
  ent_text_background = tea_color_selector (page, _("Text background"), confile.text_background);
  ent_text_sel_foreground = tea_color_selector (page, _("Selected foreground"), confile.text_sel_foreground);
  ent_text_sel_background = tea_color_selector (page, _("Selected background"), confile.text_sel_background);
  ent_color_cursor = tea_color_selector (page, _("Cursor color"), confile.color_cursor);

  ent_tag_spellcheck = tea_color_selector (page, _("Spellchecker marks"), confile.tag_spellcheck);
  
  page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);
  gtk_notebook_append_page (notebook, page, gtk_label_new (_("Highlighting")));
 
  ent_tag_comment = tea_color_selector (page, _("Comments"), confile.tag_comment);
  ent_tag_identifier = tea_color_selector (page, _("Identifiers"), confile.tag_identifier);
  ent_tag_digit = tea_color_selector (page, _("Digits"), confile.tag_digit); 
  ent_tag_string = tea_color_selector (page, _("Strings"), confile.tag_string);
  ent_tag_html_tag = tea_color_selector (page, _("HTML tags"), confile.tag_html_tag);
  ent_tag_preprocessor = tea_color_selector (page, _("Preprocessor"), confile.tag_preprocessor);
  ent_tag_type = tea_color_selector (page, _("Types"), confile.tag_type);

  page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);
  gtk_notebook_append_page (notebook, page, gtk_label_new (_("IDE")));
 
  ent_tag_color_lm_error_fg = tea_color_selector (page, _("Errors foreground (logmemo)"), confile.tag_color_lm_error_fg);
  ent_tag_color_lm_error_bg = tea_color_selector (page, _("Errors background (logmemo)"), confile.tag_color_lm_error_bg);

  return notebook ;
}


static GtkWidget* wnd_options_fonts (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);

//  ent_editor_font = tea_font_selector (page, _("Editor font"), confile.editor_font); 
/*
  ent_tag_comment_font = tea_font_selector (page, _("Comments font"), confile.tag_comment_font); 
  ent_tag_identifier_font = tea_font_selector (page, _("Identifiers font"), confile.tag_identifier_font); 
  ent_tag_digit_font = tea_font_selector (page, _("Digits font"), confile.tag_digit_font); 
  ent_tag_string_font = tea_font_selector (page, _("Strings font"), confile.tag_string_font); 
  ent_tag_html_tag_font = tea_font_selector (page, _("HTML tags font"), confile.tag_html_tag_font); 
  ent_tag_preprocessor_font = tea_font_selector (page, _("Preprocessor font"), confile.tag_preprocessor_font); 
  ent_tag_type_font = tea_font_selector (page, _("Types font"), confile.tag_type_font); 
  */
  fb_editor_font = tea_font_button (page, _("Editor font"), confile.editor_font); 
  fb_tag_comment_font = tea_font_button (page, _("Comments font"), confile.tag_comment_font); 
  fb_tag_identifier_font = tea_font_button (page, _("Identifiers font"), confile.tag_identifier_font); 
  fb_tag_digit_font = tea_font_button (page, _("Digits font"), confile.tag_digit_font); 
  fb_tag_string_font = tea_font_button (page, _("Strings font"), confile.tag_string_font); 
  fb_tag_html_tag_font = tea_font_button (page, _("HTML tags font"), confile.tag_html_tag_font); 
  fb_tag_preprocessor_font = tea_font_button (page, _("Preprocessor font"), confile.tag_preprocessor_font); 
  fb_tag_type_font = tea_font_button (page, _("Types font"), confile.tag_type_font); 
 

  return page;
}


static GtkWidget* wnd_options_browsers (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);
  ent_cm_opera = tea_text_entry (page, "Opera", confile.cmd_Opera);
  ent_cm_konqueror = tea_text_entry (page, "Konqueror", confile.cmd_Konqueror);
  ent_cm_firefox = tea_text_entry (page, "Firefox", confile.cmd_Firefox);
  ent_cm_mozilla = tea_text_entry (page, "Mozilla",  confile.cmd_Mozilla);
  ent_cm_links = tea_text_entry (page, "Links", confile.cmd_Links); 
  ent_cm_elinks = tea_text_entry (page, "Elinks", confile.cmd_ELinks);
  ent_cm_dillo = tea_text_entry (page, "Dillo", confile.cmd_Dillo);
  ent_cm_galeon = tea_text_entry (page, "Galeon", confile.cmd_Galeon);
  ent_cm_epiphany = tea_text_entry (page, "Epiphany", confile.cmd_Epiphany); 
  ent_cm_other = tea_text_entry (page, "Other", confile.cmd_Other);
  ent_cm_lynx = tea_text_entry (page, "Lynx", confile.cmd_Lynx);
  ent_cm_manual_browser = tea_text_entry (page, _("Browser for the manual"), confile.cmd_def_doc_browser);
  cb_use_def_doc_browser = tea_checkbox (page, _("Use this browser"), confile.use_def_doc_browser); 

  return page;
}


static GtkWidget* wnd_options_editor (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);
  ent_def_markup_mode = tea_combo (page, gl_supported_markup_modes, _("Default markup mode"), confile.default_markup_mode);
  sb_tab_size = tea_spinbutton (page, _("Tab size in spaces"), confile.tab_size);
  cb_ins_spaces_on_tab_press = tea_checkbox (page, _("Insert spaces on TAB key"), confile.ins_spaces_on_tab_press);
  cb_use_auto_indent = tea_checkbox (page, _("Automatic indent"), confile.use_auto_indent);
  cb_do_autorep = tea_checkbox (page, _("Autoreplace"), confile.do_autorep);
  cb_autoclose_tags = tea_checkbox (page, _("Autoclose tags"), confile.autoclose_tags);  
  cb_use_cursor_blink = tea_checkbox (page, _("Cursor blink"), confile.use_cursor_blink);  

  return page;
}


static GtkWidget* wnd_options_paths (void)
{
  GtkWidget *page = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (page);
  ent_def_save_dir = tea_dir_selector (page, _("Default file saving directory"), confile.def_save_dir);
  cb_use_def_save_dir = tea_checkbox (page, _("Use default saving directory"), confile.use_def_save_dir);
  ent_def_open_dir = tea_dir_selector (page, _("Default file opening directory"), confile.def_open_dir);
  cb_use_def_open_dir = tea_checkbox (page, _("Use default file opening directory"), confile.use_def_open_dir);
  
  return page;
}


GtkWidget* wnd_options_create (void)
{
  wnd_options = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_window_set_title (GTK_WINDOW (wnd_options), _("Options, I presume..."));

  GtkWidget *vbox1 = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (wnd_options), vbox1);

  GtkWidget *notebook = gtk_notebook_new ();         
  gtk_notebook_set_tab_pos (notebook, GTK_POS_LEFT);

  gtk_widget_show (notebook);

  gtk_container_add (GTK_CONTAINER (vbox1), notebook);

  gtk_notebook_append_page (notebook, wnd_options_switches (), gtk_label_new (_("Switches")));
  gtk_notebook_append_page (notebook, wnd_options_encoding (), gtk_label_new (_("Encoding")));
  gtk_notebook_append_page (notebook, wnd_options_functions (), gtk_label_new (_("Functions")));
  gtk_notebook_append_page (notebook, wnd_options_interface (), gtk_label_new (_("Interface")));
  gtk_notebook_append_page (notebook, wnd_options_limits (), gtk_label_new (_("Limits")));
  gtk_notebook_append_page (notebook, wnd_options_fonts (), gtk_label_new (_("Fonts")));
  gtk_notebook_append_page (notebook, wnd_options_editor (), gtk_label_new (_("Editor")));
  gtk_notebook_append_page (notebook, wnd_options_browsers (), gtk_label_new (_("Browsers")));
  gtk_notebook_append_page (notebook, wnd_options_colors (), gtk_label_new (_("Colors")));
  gtk_notebook_append_page (notebook, wnd_options_commands (), gtk_label_new (_("Commands")));
  gtk_notebook_append_page (notebook, wnd_options_paths (), gtk_label_new (_("Paths")));
  gtk_notebook_append_page (notebook, wnd_options_confirmations (), gtk_label_new (_("Confirmations")));
  gtk_notebook_append_page (notebook, wnd_options_maintenance (), gtk_label_new (_("Maintenance")));

  gtk_notebook_set_current_page (notebook, confile.last_prefs_tab);

  g_signal_connect ((gpointer) notebook, "switch_page",
                    G_CALLBACK (on_kwas_notebook_switch_page),
                    NULL);

  GtkWidget *hbox1 = gtk_hbutton_box_new ();     
  gtk_button_box_set_layout (hbox1, GTK_BUTTONBOX_SPREAD);

  gtk_widget_show (hbox1);
  gtk_container_add (GTK_CONTAINER (vbox1), hbox1);

  GtkWidget *bt_close = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
  gtk_widget_show (bt_close);
  gtk_container_add (GTK_CONTAINER (hbox1), bt_close);

  g_signal_connect (bt_close, "clicked", G_CALLBACK (cb_on_bt_close), wnd_options);

  GtkWidget *im_save = gtk_image_new_from_stock (GTK_STOCK_SAVE, GTK_ICON_SIZE_BUTTON);
  GtkWidget *im_apply = gtk_image_new_from_stock (GTK_STOCK_APPLY, GTK_ICON_SIZE_BUTTON);
  GtkWidget *hb_apply = gtk_hbox_new (FALSE, UI_PACKFACTOR);
  GtkWidget *l_apply = gtk_label_new (_("Save and apply"));
  gtk_container_add (GTK_CONTAINER (hb_apply), im_save);
  gtk_container_add (GTK_CONTAINER (hb_apply), im_apply);
  gtk_container_add (GTK_CONTAINER (hb_apply), l_apply);
  gtk_widget_show_all (hb_apply);

  GtkWidget *bt_apply = gtk_button_new ();
  gtk_container_add (GTK_CONTAINER (bt_apply), hb_apply);
  
  gtk_widget_show (bt_apply);
  gtk_container_add (GTK_CONTAINER (hbox1), bt_apply);

  g_signal_connect (bt_apply, "clicked", G_CALLBACK (cb_on_bt_apply), wnd_options);

  gtk_window_set_position (wnd_options, GTK_WIN_POS_CENTER);   
  gtk_window_set_modal (wnd_options, TRUE);

  g_signal_connect (G_OBJECT (wnd_options), "key_press_event", G_CALLBACK (win_key_handler), wnd_options);

  gtk_widget_show (wnd_options);
  return wnd_options;
}
