/***************************************************************************
                          latex_support.c  -  description
                             -------------------
    begin                : 17.02.2005
    copyright            : (C)2005 by Peter 'Roxton' Semiletov
    email                : roxton@ua.fm
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "interface.h"
#include "tea_config.h"
#include "tea_funx.h"
#include "tea_defs.h"

/*
FIXME:
add 
if (!g_file_test (file_name, G_FILE_TEST_EXISTS))
for all generated filenames
*/


//Now playing: Guano Apes - Living In A Lie
void latex_dvi_to_ps (gchar *filename)
{
  gchar *dir = g_path_get_dirname (filename);
  if (dir)
      chdir (dir);
  g_free (dir);
 
  gchar *f = change_file_ext (filename, "dvi");
  gchar *cm = str_replace_all (confile.cm_dvi_to_ps, "%s", f); 

  gchar *r = run_process_and_wait (cm); 

  log_to_memo (_("Done"), NULL, LM_NORMAL);
  log_to_memo ("-------", NULL, LM_NORMAL);
   
  log_to_memo (r, NULL, LM_NORMAL);

  log_to_memo ("-------", NULL, LM_NORMAL);
  log_to_memo (_("dvi to PS results for %s:"), f, LM_NORMAL);
   
  g_free (r);
  g_free (cm);
  g_free (f);
}


void latex_process (gchar *filename)
{
  gchar *dir = g_path_get_dirname (filename);
  if (dir)
      chdir (dir);
  g_free (dir);

  gchar *cm = str_replace_all (confile.cm_run_latex, "%s", filename); 
  gchar *r = run_process_and_wait (cm); 

  log_to_memo (_("Done"), NULL, LM_NORMAL);
  log_to_memo ("-------", NULL, LM_NORMAL);
  log_to_memo (r, NULL, LM_NORMAL);
  log_to_memo ("-------", NULL, LM_NORMAL);
  log_to_memo (_("LaTeX processing results for %s:"), filename, LM_NORMAL);
   
  g_free (r);
  g_free (cm);
}


void pdflatex_process (gchar *filename)
{
  gchar *dir = g_path_get_dirname (filename);
  if (dir)
      chdir (dir);
  g_free (dir);

  gchar *cm = str_replace_all (confile.cm_pdflatex, "%s", filename); 
  gchar *r = run_process_and_wait (cm); 

  log_to_memo (_("Done"), NULL, LM_NORMAL);
  log_to_memo ("-------", NULL, LM_NORMAL);
  log_to_memo (r, NULL, LM_NORMAL);
  log_to_memo ("-------", NULL, LM_NORMAL);
  log_to_memo (_("pdflatex processing results for %s:"), filename, LM_NORMAL);
   
  g_free (r);
  g_free (cm);
}


void latex_dvi_to_pdf (gchar *filename)
{
  gchar *dir = g_path_get_dirname (filename);
  if (dir)
      chdir (dir);
  g_free (dir);
 
  gchar *f = change_file_ext (filename, "dvi");
  gchar *cm = str_replace_all (confile.cm_dvi_to_pdf, "%s", f); 

  gchar *r = run_process_and_wait (cm); 

  log_to_memo (_("Done"), NULL, LM_NORMAL);
  log_to_memo ("-------", NULL, LM_NORMAL);
  log_to_memo (r, NULL, LM_NORMAL);
  log_to_memo ("-------", NULL, LM_NORMAL);
  log_to_memo (_("dvi to PDF results for %s:"), f, LM_NORMAL);
   
  g_free (r);
  g_free (cm);
  g_free (f);
}

//Now playing Guano Apes - Proud Like A God
void view_dvi (gchar *filename)
{
  gchar *f = change_file_ext (filename, "dvi");
  gchar *cm = str_replace_all (confile.cm_dvi_view, "%s", f);
  g_spawn_command_line_async (cm, NULL);  
  g_free (cm);
  g_free (f);
}


void view_ps (gchar *filename)
{
  gchar *f = change_file_ext (filename, "dvi.ps");
  gchar *cm = str_replace_all (confile.cm_pdf_view, "%s", f);
  g_spawn_command_line_async (cm, NULL);  
  g_free (cm);
  g_free (f);
}


void view_pdf (gchar *filename)
{
  gchar *f = change_file_ext (filename, "pdf");
  gchar *cm = str_replace_all (confile.cm_pdf_view, "%s", f);
  g_spawn_command_line_async (cm, NULL);  
  g_free (cm);
  g_free (f);
}
