/***************************************************************************
                          callbacks.c  -  description
                             -------------------
    begin                : Mon Dec 1 2003
    copyright            : (C) 2003, 2004, 2005 by Peter 'Roxton' Semiletov
    email                : roxton@ua.fm
 **************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 **************************************************************************/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>

#include <errno.h>
#include <sys/stat.h>
#include <glib.h>
#include <time.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
                 
#include "tea_text_document.h"
#include "tea_funx.h"
#include "callbacks.h"
#include "interface.h"
#include "tea_config.h"
#include "tea_defs.h"
#include "tea_hl.h"
#include "tea_fr.h"
#include "tea_about.h"
#include "tea_proj.h"
#include "undo.h"
#include "tea_gtk_utils.h"
#include "tea_calendar.h"
#include "image_browser.h"
#include "latex_support.h"


static gboolean on_fnentr_key_press_event (GtkWidget *widget,
                                           GdkEventKey *event,
                                           gpointer user_data)
{
  if (event->keyval == GDK_Return)
     {
      gtk_dialog_response (GTK_DIALOG (user_data), GTK_RESPONSE_ACCEPT);   
      return TRUE;      
     }
      
  return FALSE;
}



//n.p. Depeche Mode - Enjoy The Silence 
void set_fam_text (gchar *def)
{
  if (strlen (gtk_entry_get_text (ent_search)) == 0)
     {
      gtk_entry_set_text (ent_search, def);  
      log_to_memo (_("Read the manual!"), NULL, LM_ERROR);
     } 
}


void on_mni_file_open_at_cursor (GtkMenuItem *menuitem,
                                 gpointer user_data)
{
  if (! get_page_text()) return;

  gchar *w = get_c_url (cur_text_doc);
  handle_file (w, 0, FALSE);
  g_free (w);
}


static void tea_handle_param_pair (gchar *key, gchar *val)
{
  if (g_utf8_collate (key, "charset") == 0)
     cur_settings.selected_enc = ch_str (cur_settings.selected_enc, val);
}


static void tea_handle_param (gchar *p)
{
  gchar *t =  g_utf8_offset_to_pointer (p, 2);

  if (! t)  
     return;

  if (strstr (t, "="))
     {
      gchar **a = g_strsplit (t, "=", -1);

      if (a && a[0] && a[1])
         tea_handle_param_pair (a[0], a[1]);

      g_strfreev (a);
     }
  else
      {
       if (g_utf8_collate (t, "crapbook") == 0)
          {
           on_mni_file_crapbook (NULL, NULL); 
           return;
          }
      }  
}


gboolean tea_init (gpointer data)
{
  gint i; 
  gchar *fn;
  t_note_page *p = NULL; 

  if (g_argc > 1)
  for (i = 1; i < g_argc; ++i)
      {
       if (! g_argv[i]) 
          break;

      cur_settings.selected_enc = ch_str (cur_settings.selected_enc, confile.default_charset);  

      if (g_str_has_prefix (g_argv[i], "--"))
         tea_handle_param (g_argv[i]); 
       else
           {
            fn = g_malloc (2048); 
            if (realpath (g_argv[i], fn))
                p = open_file_std (fn); 
            g_free (fn);
           }
      }

  if (g_argc <= 1)
    {
     if (confile.start_with_blank_file)
       on_mni_new_file_activate (NULL, NULL);

     if (confile.start_with_recent_file)
       on_mni_load_last_file (NULL, NULL);
    }
}  

//current music: Guano Apes - Quietly
void file_new (void)
{
  cur_text_doc = doc_clear_new ();
  gtk_window_set_title (GTK_WINDOW (tea_main_window), cur_text_doc->file_name_utf8);
  gtk_widget_grab_focus (cur_text_doc->text_view);
  tabs_reload ();
}


void on_mni_new_file_activate (GtkMenuItem *menuitem,
                               gpointer user_data)
{
  file_new ();
}


static void on_mni_dialog_control_box_bookmarks_goto (GtkMenuItem *menuitem,
                                                      gpointer user_data)
{
  gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (user_data), gtk_widget_get_name (menuitem));
}


static void combo_bookmark_change (GtkComboBox *combobox,
                                   gpointer user_data)
{
  gint i = gtk_combo_box_get_active (combobox);
  if (i == -1)
     return;
  gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (user_data), g_list_nth_data (gl_tea_kwas_bookmarks, i));
 
}


static GtkWidget* create_dialog_control_box_bookmarks_combo (gpointer parent)
{
  GtkComboBox *cb = gtk_combo_box_new_text ();
  fill_combo_with_glist (cb, gl_tea_kwas_bookmarks);

  g_signal_connect ((gpointer) cb, "changed",
                   G_CALLBACK (combo_bookmark_change),
                    parent);
 
  gtk_widget_show (cb);
  return cb;
}


static void on_dialog_control_box_add_bookmark (GtkButton *button,
                                                gpointer user_data)
{
  gl_tea_kwas_bookmarks = g_list_prepend (gl_tea_kwas_bookmarks, gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (user_data)));
}

static GtkWidget *ent_dlg_filename;


static GtkWidget* create_dialog_control_box (t_ppair *p, gint mode)
{
  GtkWidget *label; 
  GtkWidget *vb = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (vb);

  gtk_file_chooser_set_extra_widget (GTK_FILE_CHOOSER (p->a), vb);
 
  GtkWidget *hb1 = gtk_hbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (hb1);

  GtkWidget *hb2 = gtk_hbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (hb2);

  GtkWidget *bookmarks = create_dialog_control_box_bookmarks_combo (p->a);

  gtk_box_pack_start (GTK_BOX (vb), hb1, FALSE, FALSE, UI_PACKFACTOR);
  gtk_box_pack_start (GTK_BOX (vb), hb2, FALSE, FALSE, UI_PACKFACTOR);

  label = gtk_label_new (_("Bookmarks"));
  gtk_widget_show (label);

  gtk_box_pack_start (GTK_BOX (hb1), label, FALSE, FALSE, UI_PACKFACTOR);
  gtk_box_pack_start (GTK_BOX (hb1), bookmarks, FALSE, FALSE, UI_PACKFACTOR);

  GtkWidget *bt_add_bookmark = tea_stock_button (GTK_STOCK_ADD);
  gtk_widget_show (bt_add_bookmark);

  g_signal_connect ((gpointer) bt_add_bookmark, "clicked",
                    G_CALLBACK (on_dialog_control_box_add_bookmark),
                    p->a);

  gtk_box_pack_start (GTK_BOX (hb1), bt_add_bookmark, FALSE, FALSE, UI_PACKFACTOR);

  GtkComboBox *cb_charset;
  gint i; 

  if (mode == 0 )
     {
      cur_settings.selected_enc = ch_str (cur_settings.selected_enc, confile.default_charset); 
      cb_charset = gtk_combo_box_new_text ();
      fill_combo_with_glist (cb_charset, confile.iconv_encs);
      i = find_str_index (confile.iconv_encs, confile.default_charset);

      if (i == -1)
          i = 0;

      gtk_combo_box_set_active (cb_charset, i); 
      gtk_widget_show (cb_charset);

      g_signal_connect ((gpointer) cb_charset, "changed",
                       G_CALLBACK (select_charset_fileopen),
                        NULL);

      ent_dlg_filename = gtk_entry_new (); 
      gtk_widget_show (ent_dlg_filename);

       
      g_signal_connect ((gpointer) ent_dlg_filename, "key_press_event",
                    G_CALLBACK (on_fnentr_key_press_event),
                    p->a);


     } 

  if (mode == 1)
     {
      cur_settings.selected_enc = ch_str (cur_settings.selected_enc, confile.def_filesave_charset); 
      cb_charset = gtk_combo_box_new_text ();
      fill_combo_with_glist (cb_charset, confile.gl_save_charsets);

      g_signal_connect ((gpointer) cb_charset, "changed",
                       G_CALLBACK (select_charset_filesave),
                        NULL);
 
      i = find_str_index (confile.gl_save_charsets, confile.def_filesave_charset);

      if (i == -1)
         i = 0;

      gtk_combo_box_set_active (cb_charset, i); 
      gtk_widget_show (cb_charset);
    } 

  label = gtk_label_new (_("Encoding: "));
  gtk_widget_show (label);

  gtk_box_pack_start (GTK_BOX (hb2), label, FALSE, FALSE, UI_PACKFACTOR);
  gtk_box_pack_start (GTK_BOX (hb2), cb_charset, FALSE, FALSE, UI_PACKFACTOR);

  if (mode == 0)
     gtk_box_pack_start (GTK_BOX (vb), ent_dlg_filename, FALSE, FALSE, UI_PACKFACTOR);

  return vb;
}


void select_charset_fileopen (GtkComboBox *combobox,
                              gpointer user_data)
{
   g_free (cur_settings.selected_enc);
   cur_settings.selected_enc = g_strdup (g_list_nth_data (confile.iconv_encs, gtk_combo_box_get_active (combobox)));
}


void select_charset_filesave (GtkComboBox *combobox,
                              gpointer user_data)
{
  g_free (cur_settings.selected_enc);
  cur_settings.selected_enc = g_strdup (g_list_nth_data (confile.gl_save_charsets, gtk_combo_box_get_active (combobox)));
}


void cb_change_filename (GtkFileChooser *chooser,
                         gpointer user_data)
{
  gchar *f = gtk_file_chooser_get_filename (chooser);
  gchar *utf8n;
  if (f)
     {
      utf8n = get_8_filename (f); 
      gtk_entry_set_text (ent_dlg_filename, utf8n);
      g_free (f);
      g_free (utf8n);  
      }
}


void file_open (void)
{
  gchar *filename = NULL;
  GSList *lt = NULL;
  gchar *t;
  GtkWidget *file_dialog = gtk_file_chooser_dialog_new (_("File open"),
                                                        tea_main_window,
                                                        GTK_FILE_CHOOSER_ACTION_OPEN,
                                                        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                                        GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
                                                        NULL);
  
  GtkFileFilter *f = tea_file_filter_with_patterns (_("All files"), "*", NULL);
  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (file_dialog), f); 

  f = tea_file_filter_with_patterns (_("Plain text files"), "*.txt", "*.TXT", NULL);
  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (file_dialog), f); 

  f = tea_file_filter_with_patterns (_("[X]HTML/XML and CSS files"),
                                       "*.html", "*.htm",
                                       "*.xhtml", "*.shtml",
                                       "*.css", "*.CSS",
                                       "*.xml", "*.sgml", "*.sgm", 
                                        "*.docbook", NULL);

  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (file_dialog), f); 

  f = tea_file_filter_with_patterns (_("C/C++ sources and headers"),
                                       "*.cpp", "*.c",
                                       "*.cxx", "*.h",
                                       "*.cpp", NULL);

  f = tea_file_filter_with_patterns (_("Office text format files"),
                                       "*.kwd", "*.sxw",
                                       "*.abw", "*.rtf",
                                       NULL);

  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (file_dialog), f); 

  gtk_file_chooser_set_local_only (GTK_FILE_CHOOSER (file_dialog), TRUE);
  gtk_window_resize (GTK_WINDOW (file_dialog), get_value (confile.screen_w, confile.saveopen_w), get_value (confile.screen_h, confile.saveopen_h));

  if (confile.use_def_open_dir)
     gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (file_dialog), confile.def_open_dir);
  else
      {
       if (get_page_text ())
          if (g_file_test (cur_text_doc->file_name_local, G_FILE_TEST_EXISTS))
            {
             t = g_path_get_dirname (cur_text_doc->file_name_local);
             gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (file_dialog), t);
             g_free (t);
            }
          else
              if (last_dir)  
                gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (file_dialog), last_dir);
      } 
  
  t_ppair *p = g_malloc (sizeof (t_ppair));
  p->a = file_dialog;
  p->b = GTK_DIALOG (file_dialog)->vbox;
  GtkWidget *w = create_dialog_control_box (p, 0);
  g_free (p);

  g_signal_connect (GTK_FILE_CHOOSER (file_dialog), "selection-changed",
                    G_CALLBACK (cb_change_filename),
                    NULL);
 
  
  gtk_file_chooser_set_select_multiple (GTK_FILE_CHOOSER (file_dialog), TRUE);

  if (gtk_dialog_run (GTK_DIALOG (file_dialog)) == GTK_RESPONSE_ACCEPT)
    {
     GSList *l = gtk_file_chooser_get_filenames (GTK_FILE_CHOOSER (file_dialog));
     if (! l)
        {
         gtk_widget_destroy (file_dialog);
         return; 
        }

 
     if (g_slist_length (l) == 1)
        {
         gchar *lf = get_l_filename (gtk_entry_get_text (ent_dlg_filename));
         gchar *cf = gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (file_dialog));
         g_strstrip (lf);

         gchar *clf = correct_relative_filename (cf, lf);

         open_file_std (clf);
                 
         g_free (lf);
         g_free (cf);
         g_free (clf);
        }
     else
        {
         lt = l;

         while (lt)
              {
               filename = lt->data; 
               open_file_std (filename);
               g_free (filename);
               lt = g_slist_next (lt);
              }

         g_slist_free (l);
        }
    }

  gtk_widget_destroy (file_dialog);
}


//n.p. The Rolling Stones - Mother's Little Helper
void on_mni_file_open_activate (GtkMenuItem *menuitem,
                                gpointer user_data)
{
  file_open ();
}


void file_save (void)
{
  if (! get_page_text ()) return;
  
  if (! cur_text_doc->b_saved)
     on_mni_file_save_as_activate (NULL, NULL);
  else
      if (text_doc_save (cur_text_doc, cur_text_doc->file_name_local))
         log_to_memo (_("%s saved OK"), cur_text_doc->file_name_utf8, LM_NORMAL);
}


void on_mni_file_save_activate (GtkMenuItem *menuitem,
                                gpointer user_data)
{
  file_save ();
}


void file_save_as (void)
{
  if (get_page_text ())
     show_save_as_dlg (0);
}


void on_mni_file_save_as_activate (GtkMenuItem *menuitem,
                                   gpointer user_data)
{
  file_save_as ();
}


void on_mni_out_activate (GtkMenuItem *menuitem,
                          gpointer user_data)
{
  ui_done ();
  gtk_main_quit ();
}


void on_mni_case_upcase_activate (GtkMenuItem *menuitem,
                                  gpointer user_data)
{
  if (! get_page_text ()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);
  gchar *t;

  if (buf)
     {
      t = g_utf8_strup (buf, -1);
      doc_rep_sel (cur_text_doc, t);
      g_free (buf);
      g_free (t);
     }
  else
      { 
       GtkTextIter itstart;
       GtkTextIter itend; 
       buf = doc_get_current_word (cur_text_doc, &itstart, &itend);

       if (! buf)
          return;
  
       t = g_utf8_strup (buf, -1);
      
       doc_set_new_text (cur_text_doc, &itstart, &itend, t);        
                                                    
       g_free (buf);
       g_free (t);
      }
}


void on_mni_case_locase_activate (GtkMenuItem *menuitem,
                                  gpointer user_data) 
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);
  gchar *t;

  if (buf)
     {
      t = g_utf8_strdown (buf, -1);
      doc_rep_sel (cur_text_doc, t);
      g_free (buf);
      g_free (t);
     }
  else
      {
       GtkTextIter itstart;
       GtkTextIter itend; 
       buf = doc_get_current_word (cur_text_doc, &itstart, &itend);

       if (! buf)
          return;

       t = g_utf8_strdown (buf, -1);
      
       doc_set_new_text (cur_text_doc, &itstart, &itend, t);        
                                                    
       g_free (buf);
       g_free (t);
      }
}


void on_mni_reverse (GtkMenuItem *menuitem,
                     gpointer user_data) 
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);
  if (! buf) return;

  gchar *t = g_utf8_strreverse (buf, -1);
  doc_rep_sel (cur_text_doc, t);

  g_free (buf);
  g_free (t);
}


void on_mni_file_save_version (GtkMenuItem *menuitem,
                               gpointer user_data) 
{
  if (! get_page_text()) return;
  
  gchar *s = get_file_ver_name (cur_text_doc->file_name_local);
  if (! s)
     {
      log_to_memo(_("Save the file first..."), NULL, LM_ADVICE);
      return;
     }

  text_doc_save (cur_text_doc, s);
  log_to_memo (_("%s saved good, don't worry..."), s, LM_NORMAL);
  g_free (s);
}


void on_mni_Markup_bold_activate (GtkMenuItem *menuitem,
                                  gpointer user_data)
{
  if (! get_page_text ()) return;
  
  gchar *t = NULL;
  gchar *buf = doc_get_sel (cur_text_doc);
   
  if (! buf)
     {
      if (def_mm == MM_HTML || def_mm == MM_XHTML)   
         doc_insert_at_cursor (cur_text_doc, "<b></b>");
      else
          if (def_mm == MM_DOCBOOK)   
             doc_insert_at_cursor (cur_text_doc, "<emphasis role=\"bold\"></emphasis>");

      doc_move_cursor_backw_middle_tags (cur_text_doc);
     }
  else
      {
       if (def_mm == MM_HTML || def_mm == MM_XHTML)      
          t = g_strconcat ("<b>", buf, "</b>", NULL);
       else 
           if (def_mm == MM_WIKI)      
              t = g_strconcat ("\'\'\'", buf, "\'\'\'", NULL);
           else        
               if (def_mm == MM_TEX)      
                  t = g_strconcat ("\\textbf{", buf, "} ", NULL);
               else               
                   if (def_mm == MM_DOCBOOK)      
                      t = g_strconcat ("<emphasis role=\"bold\">",
                                       buf, "</emphasis>", 
                                       NULL);
      
       doc_rep_sel (cur_text_doc, t);
      }

  g_free (buf);
  g_free (t);
}


void on_mni_Markup_link_activate (GtkMenuItem *menuitem,
                                  gpointer user_data) 
{
  if (! get_page_text ()) return;
  
  gchar *t = NULL;
  gchar *buf = doc_get_sel (cur_text_doc);

  if (! buf)
     {
      if (def_mm == MM_HTML || def_mm == MM_XHTML)
         doc_insert_at_cursor (cur_text_doc, "<a href=\"\"></a>");
      else 
          if (def_mm == MM_DOCBOOK)
            doc_insert_at_cursor (cur_text_doc, "<ulink url=\"\"></ulink>"); 

      doc_move_cursor_backw_middle_tags (cur_text_doc);
     }
  else
      {
       if (def_mm == MM_HTML || def_mm == MM_XHTML)       
          t = g_strconcat ("<a href=\"\">", buf, "</a>", NULL);
       else
           if (def_mm == MM_WIKI) 
              t = g_strconcat ("[", buf, "]", NULL);
           else   
               if (def_mm == MM_DOCBOOK) 
                  t = g_strconcat ("<ulink url=\"\">", buf, "</ulink>", NULL);

       doc_rep_sel (cur_text_doc, t);

       if (def_mm == MM_HTML || def_mm == MM_XHTML || def_mm == MM_DOCBOOK)       
          doc_move_to_pos_bw_quote (cur_text_doc);
      }

  g_free (buf);
  g_free (t);
}


void on_mni_markup_wiki_internal_link (GtkMenuItem *menuitem,
                                       gpointer user_data) 
{
  if (! get_page_text()) return;
  
  gint mm = get_markup_mode ();
  gchar *t = NULL;
  gchar *buf = doc_get_sel (cur_text_doc);

  if (! buf)
     return;  

  t = g_strconcat ("[[", buf, "]]", NULL);
  doc_rep_sel (cur_text_doc, t);

  g_free (buf);
  g_free (t);
}


void on_mni_Markup_italic_activate (GtkMenuItem *menuitem,
                                    gpointer user_data) 
{
  if (! get_page_text()) return;
  
  gchar *t = NULL;
  gchar *buf = doc_get_sel (cur_text_doc);

  if (! buf)
     {
      if (def_mm == MM_HTML || def_mm == MM_XHTML)
         {
          doc_insert_at_cursor (cur_text_doc, "<i></i>");
          doc_move_cursor_backw_middle_tags (cur_text_doc);
         }
      else 
          if (def_mm == MM_DOCBOOK)
             doc_insert_at_cursor (cur_text_doc, "<emphasis></emphasis>");
     }
  else
      {
       if (def_mm == MM_HTML || def_mm == MM_XHTML)
          t = g_strconcat ("<i>", buf, "</i>", NULL);
       else
           if (def_mm == MM_WIKI)
              t = g_strconcat ("\'\'", buf, "\'\'", NULL);
           else 
               if (def_mm == MM_TEX)
                  t = g_strconcat ("\\textit{", buf, "}", NULL);
               else
                   if (def_mm == MM_DOCBOOK)
                      t = g_strconcat ("<emphasis>", buf, "</emphasis>", NULL);

       doc_rep_sel (cur_text_doc, t);
       g_free (t);
      }

  g_free (buf);
}


void on_mni_Markup_underline_activate (GtkMenuItem *menuitem,
                                       gpointer user_data) 
{
  if (! get_page_text()) return;

  gchar *buf = doc_get_sel (cur_text_doc);
  if (! buf)
     {
      doc_insert_at_cursor (cur_text_doc, "<u></u>");
      doc_move_cursor_backw_middle_tags (cur_text_doc);
     }

  gchar *t;
  if (def_mm == MM_HTML || def_mm == MM_XHTML || def_mm == MM_WIKI)
     t = g_strconcat ("<u>", buf, "</u>", NULL);
  else 
      if (def_mm == MM_TEX)
         t = g_strconcat ("\\underline{", buf, "} ", NULL);

  doc_rep_sel (cur_text_doc, t);

  g_free (buf);
  g_free (t);
}


void on_mni_Markup_para_activate (GtkMenuItem *menuitem,
                                  gpointer user_data) 
{
  if (! get_page_text()) return;

  gchar *t = NULL;
  gchar *buf = doc_get_sel (cur_text_doc);
  
  if (! buf)
     {
      if (def_mm == MM_HTML || def_mm == MM_XHTML)
          doc_insert_at_cursor (cur_text_doc, "<p></p>");
      else
          if (def_mm == MM_DOCBOOK)
             doc_insert_at_cursor (cur_text_doc, "<para></para>");
     
      doc_move_cursor_backw_middle_tags (cur_text_doc);
     }
  else
      {
       if (def_mm == MM_HTML || def_mm == MM_XHTML)
          t = g_strconcat ("<p>", buf, "</p>", NULL);
       else
           if (def_mm == MM_DOCBOOK)      
              t = g_strconcat ("<para>", buf, "</para>", NULL);

        doc_rep_sel (cur_text_doc, t);
        g_free (t);
      }

  g_free (buf);
}


void on_mni_markup_common (GtkMenuItem *menuitem,
                           gpointer user_data)
{
  if (! get_page_text ()) return;
  
  gchar *t = NULL;
  gchar *buf = doc_get_sel (cur_text_doc);

  if (! buf)
     {
      t = g_strconcat ("<", gtk_widget_get_name (menuitem), ">",
                       "</", gtk_widget_get_name (menuitem), ">",
                       NULL);
      doc_insert_at_cursor (cur_text_doc, t);
      doc_move_cursor_backw_middle_tags (cur_text_doc);
     }
  else
      {
       t = g_strconcat ("<", gtk_widget_get_name (menuitem), ">",
                        buf,
                        "</", gtk_widget_get_name (menuitem), ">",
                        NULL);
       doc_rep_sel (cur_text_doc, t);
      }

  g_free (buf);
  g_free (t);
}


static gint last_page = -1;

void on_notebook1_switch_page (GtkNotebook *notebook,
                               GtkNotebookPage *page,
                               guint page_num,
                               gpointer user_data)
{
  t_note_page *dc = get_page_by_index (page_num);
  
  if (dc)
     {
      set_title (dc);
      gtk_widget_grab_focus (dc->text_view);
      last_page = gtk_notebook_get_current_page (notebook);
     }
}


void on_mni_file_close_current (GtkMenuItem *menuitem,
                                gpointer user_data)
{
  page_del_by_index (gtk_notebook_get_current_page ((GtkNotebook *) notebook1));
}


void on_mni_view_wrap (GtkMenuItem *menuitem,
                       gpointer user_data)
{
  if (! get_page_text ()) return;
  
  if (gtk_text_view_get_wrap_mode (cur_text_doc->text_view) != GTK_WRAP_WORD)
      gtk_text_view_set_wrap_mode (cur_text_doc->text_view, GTK_WRAP_WORD);
  else
      gtk_text_view_set_wrap_mode (cur_text_doc->text_view, GTK_WRAP_NONE);
}


void on_mni_Markup_br (GtkMenuItem *menuitem,
                       gpointer user_data)
{
  if (! get_page_text ()) return;

  if (def_mm == MM_HTML)
     doc_insert_at_cursor (cur_text_doc, "<br>");
  else
      if (def_mm == MM_XHTML)
         doc_insert_at_cursor (cur_text_doc, "<br />"); 
         else
             if (def_mm == MM_TEX)
                doc_insert_at_cursor (cur_text_doc, "\\newline"); 
}
                       

void on_mni_Functions_number_arabian2roman (GtkMenuItem *menuitem,
                                            gpointer user_data)
{
  if (! get_page_text ()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);
  if (! buf) return;

  gchar *t = g_malloc (1024);

  tNumber2Roman (strtol (buf, NULL, 10), TRUE, t);

  if (t)
     doc_rep_sel (cur_text_doc, t);

  g_free (t);
  g_free (buf);
}


void on_mni_view_show_line_numbers (GtkMenuItem *menuitem,
                                    gpointer user_data)
{
  if (! get_page_text()) return;
  
  if (! cur_text_doc->linenums)
      document_set_line_numbers (cur_text_doc, TRUE);
   else
       document_set_line_numbers (cur_text_doc, FALSE);
}


void on_button_close (GtkWidget *wid, gpointer data)
{
  page_del_by_index (find_index_by_page (data));
}


void on_mni_html_default_template (GtkMenuItem *menuitem,
                                   gpointer user_data)
{
  if (! get_page_text ()) return;
  
  gchar *t = g_strconcat (
                          "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd\">\n", 
                          "<html>\n",
                          "<head>\n",
                          "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n",
                          "<title></title>\n",
                          "</head>\n",
                          "<body>\n",
                          "</body>\n",
                          "</html>",
                          NULL);
                                       
  doc_insert_at_cursor (cur_text_doc, t);
  g_free (t);
}


void on_mni_file_save_session (GtkMenuItem *menuitem,
                               gpointer user_data)
{
  gchar *filename; 
  GtkWidget *dialog = gtk_file_chooser_dialog_new (_("Save the session as:"),
                                                   tea_main_window,
                                                   GTK_FILE_CHOOSER_ACTION_SAVE,
                                                   GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                                   GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT,
                                                   NULL);

  gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), confile.sessions_dir);
  gtk_window_resize (GTK_WINDOW (dialog), get_value (confile.screen_w, confile.saveopen_w), get_value (confile.screen_h, confile.saveopen_h));
 
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
    {
     filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));

     GList *p = g_list_first (dox);
     GList *t = NULL;

     while (p)
          {
           t = add_session_item_composed (t, (t_note_page*) p->data);
           p = g_list_next (p);
          }

     glist_save_to_file (t, filename);
     g_list_free (t);                      
     reload_sessions ();
     g_free (filename);
    }

  gtk_widget_destroy (dialog);
}


void on_mni_session_file_open_activate (GtkMenuItem *menuitem,
                                        gpointer user_data)
{
  GtkWidget *dialog = gtk_file_chooser_dialog_new (_("Open a session file:"),
                                                   tea_main_window,
                                                   GTK_FILE_CHOOSER_ACTION_OPEN,
                                                   GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                                   GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
                                                   NULL);

  gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), confile.sessions_dir);
  gtk_window_resize (GTK_WINDOW (dialog), get_value (confile.screen_w, confile.saveopen_w), get_value (confile.screen_h, confile.saveopen_h));
  
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
     {
      gchar *filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
      cur_settings.selected_enc = ch_str (cur_settings.selected_enc, "UTF-8");
      open_file_std (filename);
      g_free (filename);
     }

   gtk_widget_destroy (dialog);
}


void on_mni_antispam (GtkMenuItem *menuitem, gpointer user_data)
{
  if (! get_page_text()) return;
 
  gchar *buf = doc_get_sel (cur_text_doc);
  if (! buf) return;

  gint c = g_utf8_strlen (buf, STRMAXLEN);
  GString *result = g_string_sized_new (16 * c);

  gint i;

  for (i = 0; i <= c; i++) 
       g_string_append_printf (result, "&#%d;", buf[i]);

  doc_rep_sel (cur_text_doc, result->str);

  g_free (buf);
  g_string_free (result, TRUE);
}


void on_mni_Functions_number_hex2dec (GtkMenuItem *menuitem,
                                      gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);
  if (! buf) return;

  gchar *t = g_strdup_printf ("%d", strtol (buf, NULL, 16));  

  doc_rep_sel (cur_text_doc, t);

  g_free (t);
  g_free (buf);
}


void on_mni_config_open (GtkMenuItem *menuitem,
                         gpointer user_data)
{
  cur_settings.selected_enc = ch_str (cur_settings.selected_enc, "UTF-8");
  open_file_std (confile.tea_rc);
}


void on_mni_open_in_browser (GtkMenuItem *menuitem,
                             gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *file_name;

  if (! cur_text_doc->b_saved)
     {
      doc_save_buffer_to_file (cur_text_doc->text_buffer, confile.tmp_file);
      file_name = g_strdup (confile.tmp_file);
     }  
  else 
      file_name = g_strdup (cur_text_doc->file_name_local);

  gchar *cmd;
  gchar *wn = gtk_widget_get_name (menuitem);

  if (g_ascii_strncasecmp (wn, "opera", 33) == 0)
     cmd = rep_all_s (confile.cmd_Opera, file_name);
  else     
  if (g_ascii_strncasecmp (wn, "firefox", 33) == 0)
     cmd = rep_all_s (confile.cmd_Firefox, file_name);
     //firefox -a firefox -remote openURL(<url>,new-tab)
  else
  if (g_ascii_strncasecmp (wn, "mozilla", 33) == 0)
     cmd = rep_all_s (confile.cmd_Mozilla, file_name);
  else
  if (g_ascii_strncasecmp (wn, "konqueror", 33) == 0)
     cmd = rep_all_s (confile.cmd_Konqueror, file_name);
  else
  if (g_ascii_strncasecmp (wn, "galeon", 33) == 0)
     cmd = rep_all_s (confile.cmd_Galeon, file_name);
  else
  if (g_ascii_strncasecmp (wn, "dillo",33) == 0)
     cmd = rep_all_s (confile.cmd_Dillo, file_name);
  else
  if (g_ascii_strncasecmp (wn, "elinks",33) == 0)
     cmd = rep_all_s (confile.cmd_ELinks, file_name);
  else
  if (g_ascii_strncasecmp (wn, "links",33) == 0)
     cmd = rep_all_s (confile.cmd_Links, file_name);
  else
  if (g_ascii_strncasecmp (wn, "lynx", 33) == 0)
     cmd = rep_all_s (confile.cmd_Lynx, file_name);
  else
  if (g_ascii_strncasecmp (wn, "epiphany", 33) == 0)
     cmd = rep_all_s (confile.cmd_Epiphany, file_name);
  else
  if (g_ascii_strncasecmp (wn, "Other browser", 33) == 0)
     cmd = rep_all_s (confile.cmd_Other, file_name);

  system (cmd);
  g_free (cmd);
  g_free (file_name);
}


void on_mni_utils_stats (GtkMenuItem *menuitem,
                         gpointer user_data)
{
  if (! get_page_text()) return;
  make_stats (cur_text_doc);
}


void on_mni_Functions_number_bin2dec (GtkMenuItem *menuitem, gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);
  if (! buf) return;
  
  gchar *t = g_strdup_printf ("%d", strtol (buf, NULL, 2)); 

  doc_rep_sel (cur_text_doc, t);

  g_free (t);
  g_free (buf);
}

                                       
void on_mni_Markup_nbsp (GtkMenuItem *menuitem,
                         gpointer user_data)
{
  if (! get_page_text()) return;

  if (def_mm == MM_HTML || def_mm == MM_XHTML || def_mm == MM_WIKI || def_mm == MM_DOCBOOK)
     doc_insert_at_cursor (cur_text_doc, "&nbsp;");
  else 
     if (def_mm == MM_TEX)
       doc_insert_at_cursor (cur_text_doc, "\\space");
}


void on_mni_undo (GtkMenuItem *menuitem,
                  gpointer user_data)
{
  if (! get_page_text()) return;
  if (undomgr_can_undo (cur_text_doc->um))
      undomgr_undo (cur_text_doc->um);
}


void on_mni_redo (GtkMenuItem *menuitem,
                  gpointer user_data)
{
  if (! get_page_text()) return;
  if (undomgr_can_redo (cur_text_doc->um))
     undomgr_redo (cur_text_doc->um);
}


static void update_preview_cb (GtkFileChooser *file_chooser, gpointer data)
{
  GtkWidget *preview = GTK_WIDGET (data);
  gchar *filename = gtk_file_chooser_get_preview_filename (file_chooser);
  if (! filename)
     return;

  GdkPixbuf *pixbuf = gdk_pixbuf_new_from_file_at_size (filename, confile.thumb_width, confile.thumb_height, NULL);
  gboolean have_preview = (pixbuf != NULL);
  g_free (filename);

  gtk_image_set_from_pixbuf (GTK_IMAGE (preview), pixbuf);

  if (pixbuf)
     gdk_pixbuf_unref (pixbuf);

  gtk_file_chooser_set_preview_widget_active (file_chooser, have_preview);
}


void on_mni_image_activate (GtkMenuItem *menuitem,
                            gpointer user_data)
{
  if (! get_page_text()) return;
  
  GtkImage *img = gtk_image_new ();
 
  GtkWidget *file_dialog = gtk_file_chooser_dialog_new (_("File open"),
                                                        tea_main_window,
                                                        GTK_FILE_CHOOSER_ACTION_OPEN,
                                                        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                                        GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
                                                        NULL);
  
  GtkFileFilter *f = tea_file_filter_with_patterns (_("Image files"), 
                                                    "*.JPG", "*.jpg", 
                                                    "*.png", "*.PNG",
                                                    "*.jpeg", "*.JPEG",
                                                    "*.GIF", "*.gif",
                                                    "*.bmp", "*.BMP",
                                                    "*.wbmp", "*.WBMP",
                                                    "*.eps", "*.EPS",
                                                    "*.ps", "*.PS", 
                                                     NULL);

  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (file_dialog), f); 

  f = tea_file_filter_with_patterns (_("All files"), "*", NULL);
  gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (file_dialog), f); 

  gtk_file_chooser_set_preview_widget (file_dialog, img);
  g_signal_connect (file_dialog, "update-preview", G_CALLBACK (update_preview_cb), img);

  if (g_file_test (cur_text_doc->file_name_local, G_FILE_TEST_EXISTS))
     {
      gchar *dir = g_path_get_dirname (cur_text_doc->file_name_local);
      gtk_file_chooser_set_current_folder (file_dialog, dir);
      g_free (dir);
     }

  gtk_file_chooser_set_local_only (GTK_FILE_CHOOSER (file_dialog), TRUE);
  gtk_window_resize (GTK_WINDOW (file_dialog), get_value (confile.screen_w, confile.saveopen_w), get_value (confile.screen_h, confile.saveopen_h));

//for GTK 2.6
//   gtk_file_chooser_set_show_hidden (GTK_FILE_CHOOSER (file_dialog), confile.show_hidden_files);

  gtk_file_chooser_set_select_multiple (GTK_FILE_CHOOSER (file_dialog), TRUE);

  if (gtk_dialog_run (GTK_DIALOG (file_dialog)) == GTK_RESPONSE_ACCEPT)
     {
      gchar *filename;

      GSList *l = gtk_file_chooser_get_filenames (GTK_FILE_CHOOSER (file_dialog));
      if (l)  
         {
          GSList *t = l;
          while (t)
               {
                filename = t->data; 
                if (! g_file_test (filename, G_FILE_TEST_IS_DIR))
                   if (is_image (filename))
                     insert_image (filename);  
   
                g_free (filename);
                t = g_slist_next (t);
               }
           g_slist_free (l);
         }
     }
  gtk_widget_destroy (file_dialog);
}


void on_mni_html_enclose_link (GtkMenuItem* menuitem,
                              gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);
  if (! buf) return;

  gchar *t = linkify_text (buf);
  doc_rep_sel (cur_text_doc, t);

  g_free (buf);
  free (t);
}


gboolean on_ent_search_key_press_event (GtkWidget *widget,
                                        GdkEventKey *event,
                                        gpointer user_data)
{
  if (event->keyval != GDK_Return)
     return FALSE;      

  if (get_page_text())
     {
      set_fam_text ("text to find");
      doc_search_f (cur_text_doc, gtk_entry_get_text (ent_search));
     }

  return FALSE;
}


void on_mni_func_strings_removeblanks (GtkMenuItem* menuitem,
                                       gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);

  if (! buf) return;

  GList *temp = glist_from_string (buf);
  GList *temp2 = remove_blank_lines (temp);
  gchar *t = string_from_glist (temp2);

  doc_rep_sel (cur_text_doc, t);

  g_free (buf);
  g_free (t);
  glist_strings_free (temp);
  glist_strings_free (temp2);
}


void on_mni_func_strings_enclose (GtkMenuItem* menuitem,
                                  gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);

  if (! buf) return;

  set_fam_text ("<li>%s</li>");

  if (! strstr (gtk_entry_get_text (ent_search), "%s"))
     {
      g_free (buf);
      return;
     }

  GList *temp = glist_from_string (buf);

  temp = glist_repl (temp, gtk_entry_get_text (ent_search));
  gchar *t = string_from_glist (temp);

  doc_rep_sel (cur_text_doc, t);

  g_free (buf);
  g_free (t);
  glist_strings_free (temp);
}


void on_mni_func_strings_rev (GtkMenuItem* menuitem,
                              gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);

  if (! buf) return;

  GList *temp = glist_from_string (buf);
  temp = g_list_reverse (temp);
  gchar *t = string_from_glist (temp);
  doc_rep_sel (cur_text_doc, t);

  g_free (buf);
  g_free (t);
  glist_strings_free (temp);
}


void on_mni_search_repall (GtkMenuItem* menuitem,
                           gpointer user_data)
{
  if (! get_page_text()) return;
  
  set_fam_text ("text to find~text to replace");
  gchar *s = gtk_entry_get_text (ent_search);

  if (! strstr (s, "~"))
     return; 
 
  gchar **a = g_strsplit (s, "~", -1);

  if (! a) return;

  gchar *x; 
  gchar *y;

  x = a[0];
  if (! x)
     {
      g_strfreev (a);
      return;
     } 

  if (! a[1])
     {
      g_strfreev (a);
      return;
     } 

  y = a[1];

  gchar *buf = doc_get_buf (cur_text_doc->text_buffer);
  gchar *z = str_replace_all (buf, x, y);
 
  gtk_text_buffer_set_text (cur_text_doc->text_buffer, z, -1);

  g_free (z);
  g_free (buf); 
  g_strfreev (a);
}


void on_mni_recent_activate (GtkMenuItem *menuitem,
                             gpointer user_data)
{
  execute_recent_item (gtk_widget_get_name (menuitem));
}


void on_mni_about_activate (GtkMenuItem *menuitem,
                            gpointer user_data)
{
  create_wnd_about ();
}


void show_save_as_dlg (int mode)
{
  GtkWidget *file_dialog = gtk_file_chooser_dialog_new (_("Save as..."),
                                                        tea_main_window,
                                                        GTK_FILE_CHOOSER_ACTION_SAVE,
                                                        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                                        GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT,
                                                        NULL);

  gtk_window_resize (GTK_WINDOW (file_dialog), get_value (confile.screen_w, confile.saveopen_w), get_value (confile.screen_h, confile.saveopen_h));
  gtk_file_chooser_set_local_only (GTK_FILE_CHOOSER (file_dialog), TRUE);

  t_ppair *p = g_malloc (sizeof (t_ppair));
  p->a = file_dialog;
  p->b = GTK_DIALOG (file_dialog)->vbox;
  GtkWidget *w = create_dialog_control_box (p, 1);
  g_free (p);

  if (mode == 0)
     {
      if (cur_text_doc)
         {
          if (confile.use_def_save_dir)     
             gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (file_dialog),
                                                  confile.def_save_dir);
          else
              {
               if (g_file_test (cur_text_doc->file_name_local, G_FILE_TEST_EXISTS))
                  gtk_file_chooser_set_filename (GTK_FILE_CHOOSER (file_dialog), 
                                                  cur_text_doc->file_name_local);
               else
                   if (last_dir) 
                      gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (file_dialog),
                                                         last_dir); 
               }
         }
     }

  if (mode == 2)
     gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (file_dialog),
                                          confile.snippets_dir);
  
  if (gtk_dialog_run (GTK_DIALOG (file_dialog)) == GTK_RESPONSE_ACCEPT)
    {
     gchar *filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (file_dialog));
     gchar *utf8n = get_8_filename (filename); 

     if (confile.prompt_on_file_exists && g_file_test (filename, G_FILE_TEST_EXISTS))
     if (! dlg_question (_("Question"), _("%s is exists. Do you want to overwrite it?"), utf8n))
        {
         g_free (utf8n);
         gtk_widget_destroy (file_dialog);  
         return;
        }

     g_free (cur_text_doc->file_name_local);
     g_free (cur_text_doc->file_name_utf8);
     
     cur_text_doc->file_name_utf8 = utf8n;
     cur_text_doc->file_name_local = g_strdup (filename);

     cur_text_doc->encoding = ch_str (cur_text_doc->encoding, cur_settings.selected_enc); 

     if (! text_doc_save (cur_text_doc, filename))
        {
         log_to_memo (_("error by saving %s!!!"), cur_text_doc->file_name_utf8, LM_ERROR);
         gtk_widget_destroy (file_dialog);
         return;
        }
      
      cur_text_doc->b_saved = TRUE;
      gchar *bsname = g_path_get_basename (cur_text_doc->file_name_utf8);
      gtk_label_set_label (cur_text_doc->tab_label, bsname);
      g_free (bsname);
      set_title (cur_text_doc);

     if (strstr (cur_text_doc->file_name_local, confile.snippets_dir))
        reload_snippets ();

     if (strstr (cur_text_doc->file_name_local, confile.templates_dir))
        reload_templates ();

     tabs_reload ();
     g_free (filename);
    }

   gtk_widget_destroy (file_dialog);
}


void on_mni_file_save_as_template_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  show_save_as_dlg (1);
}


void on_mni_file_edit_at_cursor (GtkMenuItem* menuitem,
                                 gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *w = get_c_url (cur_text_doc);
  handle_file (w, 1, FALSE);
  g_free (w);
}


void on_mni_new_link_select (GtkMenuItem *menuitem,
                             gpointer user_data)
{
  handle_file (gtk_widget_get_name (menuitem), 0, FALSE);
}


void add_link_item (const gchar *fname, const gchar *linkname)
{
  gchar *dir = g_path_get_dirname (fname);
  gchar *filename = create_full_path (linkname, dir);

  if (g_file_test (filename, G_FILE_TEST_EXISTS))
      mni_temp = new_menu_item (filename, mni_links_menu, on_mni_new_link_select);

  g_free (dir);
  g_free (filename);
}

//n.p. Defecation - Intention Superpassed - 2/3 Pure 
void scan_links (void)
{
  if (! get_page_text()) return;
  
  gchar *f;
  GtkTextIter match_start;
  GtkTextIter match_end;

  gtk_widget_destroy(mni_links_menu);
  mni_links_menu = new_menu_submenu (mni_links);
  mni_temp = new_menu_item (cur_text_doc->file_name_utf8, mni_links_menu, on_mni_new_link_select);
  gtk_text_buffer_get_start_iter (cur_text_doc->text_buffer, &match_start); 
  gtk_text_buffer_get_end_iter (cur_text_doc->text_buffer, &match_end); 

  while (gtk_text_iter_forward_search (&match_start, "ref=\"", GTK_TEXT_SEARCH_TEXT_ONLY, &match_start, &match_end, NULL))
       {
        match_start = match_end;
        if (gtk_text_iter_forward_find_char (&match_end, find_quote, NULL, NULL))   
           { 
            f = gtk_text_buffer_get_text (cur_text_doc->text_buffer, &match_start, &match_end, FALSE);
            add_link_item (cur_text_doc->file_name_utf8, f);
            g_free (f);
           }
        match_start = match_end;
       }

  gtk_text_buffer_get_start_iter (cur_text_doc->text_buffer, &match_start); 
  gtk_text_buffer_get_end_iter (cur_text_doc->text_buffer, &match_end); 

  while (gtk_text_iter_forward_search (&match_start, "REF=\"", GTK_TEXT_SEARCH_TEXT_ONLY, &match_start, &match_end, NULL))
       {
        match_start = match_end;
        if (gtk_text_iter_forward_find_char (&match_end, find_quote, NULL, NULL))   
           {
            f = gtk_text_buffer_get_text (cur_text_doc->text_buffer, &match_start, &match_end, FALSE);
            add_link_item (cur_text_doc->file_name_utf8, f);
            g_free (f);
           }
        match_start = match_end;
       }
}


void on_mni_get_links (GtkMenuItem* menuitem,
                       gpointer user_data)
{
  scan_links ();
  log_to_memo (_("Now look into Links menu ;)"), NULL, LM_ADVICE);
}


//n.p. Massive Attack - Karmacoma [album version]
void on_mni_co_select (GtkMenuItem *menuitem, gpointer user_data)
{
  if (! get_page_text()) return;
  
  if (! g_file_test (cur_text_doc->file_name_local, G_FILE_TEST_EXISTS))
     return;

  cur_settings.selected_enc = ch_str (cur_settings.selected_enc, gtk_widget_get_name (menuitem));

  if (! doc_reload_text (cur_text_doc, cur_text_doc->file_name_local, cur_settings.selected_enc))
     log_to_memo (_("No, I can't!"), NULL, LM_ERROR);
  else
      cur_text_doc->encoding = ch_str (cur_text_doc->encoding, cur_settings.selected_enc);
}


void on_mni_html_strip_tags (GtkMenuItem* menuitem,
                              gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);
  if (! buf) return;

  gchar *t = strip_html (buf);
  doc_rep_sel (cur_text_doc, t);

  g_free (buf);
  g_free (t);
}


void on_mni_markup_align (GtkMenuItem *menuitem,
                                      gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *t = NULL;
  gchar *buf = doc_get_sel (cur_text_doc);
 
  if (! buf)
     {
      if (def_mm == MM_HTML || def_mm == MM_XHTML)
         { 
          if (strcmp (gtk_widget_get_name (menuitem), "Center") == 0)
             doc_insert_at_cursor (cur_text_doc, "<div align=\"center\"></div>");
          else
          if (strcmp (gtk_widget_get_name (menuitem), "Left") == 0)
             doc_insert_at_cursor (cur_text_doc, "<div align=\"left\"></div>");
          else
          if (strcmp (gtk_widget_get_name (menuitem), "Right") == 0)
             doc_insert_at_cursor (cur_text_doc, "<div align=\"right\"></div>");
          else
          if (strcmp (gtk_widget_get_name (menuitem), "Justify") == 0)
             doc_insert_at_cursor (cur_text_doc, "<div align=\"justify\"></div>");

            doc_move_cursor_backw_middle_tags (cur_text_doc);  
         }
       else 
       if (def_mm == MM_TEX)
         { 
          if (strcmp (gtk_widget_get_name (menuitem), "Center") == 0)
             doc_insert_at_cursor (cur_text_doc, "\\begin{center}\n\\end{center}");
          else
          if (strcmp (gtk_widget_get_name (menuitem), "Left") == 0)
             doc_insert_at_cursor (cur_text_doc, "\\begin{left}\n\\end{left}");
          else
          if (strcmp (gtk_widget_get_name (menuitem), "Right") == 0)
             doc_insert_at_cursor (cur_text_doc, "\\begin{right}\n\\end{right}");
          }
      
      g_free (buf);
    
      return;
     }
  else
     {  
      if (def_mm == MM_HTML || def_mm == MM_XHTML)
         {
          if (strcmp (gtk_widget_get_name (menuitem), "Center") == 0)
             t = g_strconcat ("<div align=\"center\">", buf, "</div>", NULL);
          else
          if (strcmp (gtk_widget_get_name (menuitem), "Left") == 0)
              t = g_strconcat ("<div align=\"left\">", buf, "</div>", NULL);
          else
          if (strcmp (gtk_widget_get_name (menuitem), "Right") == 0)
             t = g_strconcat ("<div align=\"right\">", buf, "</div>", NULL);
          else
          if (strcmp (gtk_widget_get_name (menuitem), "Justify") == 0)
             t =  g_strconcat ("<div align=\"justify\">", buf, "</div>", NULL);
         }
      else
      if (def_mm == MM_TEX)
         {
          if (strcmp (gtk_widget_get_name (menuitem), "Center") == 0)
             t = g_strconcat ("\\begin{center}\n", buf, "\\end{center}", NULL);
          else
          if (strcmp (gtk_widget_get_name (menuitem), "Left") == 0)
              t = g_strconcat ("\\begin{left}\n", buf, "\\end{left}", NULL);
          else
          if (strcmp (gtk_widget_get_name (menuitem), "Right") == 0)
             t = g_strconcat ("\\begin{right}\n", buf, "\\end{right}", NULL);
         } 

      }
  
  doc_rep_sel (cur_text_doc, t);

  g_free (buf);
  g_free (t);
}


void on_mni_html_make_table (GtkMenuItem* menuitem,
                              gpointer user_data)
{
  if (! get_page_text()) return;
  
  set_fam_text ("2~2"); 

  gchar *table = gtk_entry_get_text (ent_search);
  gchar **a = g_strsplit (table, "~", 3);

  if (! a)
     {
      g_free (table);
      return;
     }

  gint cols = 1;
  gint rows = 1;
  gint c;
  gint r;

  GList *l = NULL;
 
  if (a[0])
     rows = strtol (a[0], NULL, 10);
  if (a[1])
     cols = strtol (a[1], NULL, 10);

  if (def_mm == MM_HTML || def_mm == MM_XHTML)  
     l = g_list_prepend (l, strdup ("<table>"));  
  else
      if (def_mm == MM_WIKI)  
         l = g_list_prepend (l, strdup ("{|"));  
      else
      if (def_mm ==  MM_DOCBOOK)  
         l = g_list_prepend (l, g_strdup_printf ("<informaltable frame=\"none\">\n<tgroup cols=\"%d\">\n<tbody>", cols));  
      else
          if (def_mm == MM_DOCBOOK)  
             l = g_list_prepend (l, strdup ("\\begin{table}\n\\end{table}"));  
      

  for (r = 1; r <= rows; r++)
      {
       if (def_mm == MM_HTML || def_mm == MM_XHTML)  
          l = g_list_prepend (l, strdup ("<tr>")); 
       else
       if (def_mm == MM_DOCBOOK)  
          l = g_list_prepend (l, strdup ("<row>")); 
           
       if (def_mm == MM_HTML || def_mm == MM_XHTML)   
          {
           for (c = 1; c <= cols; c++)
               l = g_list_prepend (l, strdup ("<td></td>")); 
          }
       else
           if (def_mm == MM_WIKI)  
              {
               for (c = 1; c <= cols; c++)
                  l = g_list_prepend (l, strdup ("|")); 
              }
       else
       if (def_mm == MM_DOCBOOK)   
          {
           for (c = 1; c <= cols; c++)
               l = g_list_prepend (l, strdup ("<entry></entry>")); 
          }
 

       if (def_mm == MM_HTML || def_mm == MM_XHTML)  
          l = g_list_prepend (l, strdup ("</tr>")); 
       else
       if (def_mm == MM_DOCBOOK)  
          l = g_list_prepend (l, strdup ("</row>")); 
       else
           if (def_mm == MM_WIKI)  
              if (r != rows)
                 l = g_list_prepend (l, strdup ("|-")); 
       
      }

  if (def_mm == MM_HTML || def_mm == MM_XHTML)  
     l = g_list_prepend (l, strdup ("</table>"));  
  else
      if (def_mm == MM_WIKI)  
         l = g_list_prepend (l, strdup ("|}"));  
      else
          if (def_mm ==  MM_DOCBOOK)  
             l = g_list_prepend (l, strdup ("</tbody>\n</tgroup>\n</informaltable>"));  

  gchar *buf = string_from_glist (g_list_reverse (l));

  doc_insert_at_cursor (cur_text_doc, buf);

  glist_strings_free (l);
  g_strfreev (a);
  g_free (buf);
}


void on_mni_file_revert_to_saved (GtkMenuItem* menuitem,
                                  gpointer user_data)
{
  if (! get_page_text()) return;
  
  if (! g_file_test (cur_text_doc->file_name_local, G_FILE_TEST_EXISTS))
     return;

  if (! doc_reload_text (cur_text_doc, cur_text_doc->file_name_local, cur_text_doc->encoding))
    log_to_memo (_("I can't reload %s :("), cur_text_doc->file_name_utf8, LM_ERROR);
  else
      log_to_memo (_("%s is reloaded :)"), cur_text_doc->file_name_utf8, LM_NORMAL);
}


void on_mni_funx_ins_time (GtkMenuItem *menuitem, gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = get_time (confile.date_time);
  doc_insert_at_cursor (cur_text_doc, buf);
  g_free (buf);
}


void on_mni_goto_line (GtkMenuItem* menuitem,
                       gpointer user_data)
{
  if (! get_page_text()) return;
  set_fam_text ("0");
  doc_select_line (cur_text_doc, strtol (gtk_entry_get_text (ent_search), NULL, 10));
}


void on_mni_convert_ascii_2_html (GtkMenuItem *menuitem,
                                  gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);
  if (! buf) return;

  gchar *t = g_markup_escape_text (buf, -1);
  doc_rep_sel (cur_text_doc, t);

  g_free (buf);
  g_free (t);
}


void on_mni_func_filter_exclude_from_list (GtkMenuItem* menuitem,
                                           gpointer user_data)
{
  if (! get_page_text()) return;
  
  set_fam_text ("Chirurgus mente prius et oculis agat, quam armata manu");
  gchar *buf = doc_get_sel (cur_text_doc);

  if (! buf) return;

  GList *temp = glist_from_string (buf);
//  GList *temp2 = filter_exclude_from_list (temp, gtk_entry_get_text (ent_search));
//
  GList *temp2 = filter_list (temp, gtk_entry_get_text (ent_search), FALSE);

  gchar *t = string_from_glist (temp2);

  doc_rep_sel (cur_text_doc, t);

  g_free (buf);
  g_free (t);
  glist_strings_free (temp);
  glist_strings_free (temp2);
}


void on_mni_func_filter_antiexclude_from_list (GtkMenuItem* menuitem,
                                           gpointer user_data)
{
  if (! get_page_text()) return;
  
  set_fam_text ("Tantum possumus, quantum scimus.");  
  gchar *s = gtk_entry_get_text (ent_search);
  gchar *buf = doc_get_sel (cur_text_doc);

  if (! buf) return;

  GList *temp = glist_from_string (buf);
  //GList *temp2 = filter_antiexclude_from_list (temp, s);
  GList *temp2 = filter_list (temp, gtk_entry_get_text (ent_search), TRUE);

  gchar *t = string_from_glist (temp2);

  doc_rep_sel (cur_text_doc, t);

  g_free (buf);
  g_free (t);
  glist_strings_free (temp);
  glist_strings_free (temp2);
}


GList *common_temp_list;

void on_mni_html_calc_weight (GtkMenuItem *menuitem,
                              gpointer user_data)
{
  if (! get_page_text()) return;
  
  if (! g_file_test (cur_text_doc->file_name_local, G_FILE_TEST_EXISTS))
     return;

  common_temp_list = NULL;
  
  gchar *f;
  GtkTextIter match_start;
  GtkTextIter match_end;

  gtk_widget_destroy (mni_links_menu);
  mni_links_menu = new_menu_submenu (mni_links);
  mni_temp = new_menu_item (cur_text_doc->file_name_utf8, mni_links_menu, on_mni_new_link_select);
  gtk_text_buffer_get_start_iter (cur_text_doc->text_buffer, &match_start); 
  gtk_text_buffer_get_end_iter (cur_text_doc->text_buffer, &match_end); 

  while (gtk_text_iter_forward_search (&match_start, "src=\"", GTK_TEXT_SEARCH_TEXT_ONLY, &match_start, &match_end, NULL))
       {
        match_start = match_end;
        if (gtk_text_iter_forward_find_char (&match_end, find_quote, NULL, NULL))   
           {
            f = gtk_text_buffer_get_text (cur_text_doc->text_buffer, &match_start, &match_end, FALSE);
            if (g_file_test (f, G_FILE_TEST_EXISTS)) 
                common_temp_list = g_list_append (common_temp_list, f);   
           } 
        match_start = match_end;
       }

  while (gtk_text_iter_forward_search (&match_start, "SRC=\"", GTK_TEXT_SEARCH_TEXT_ONLY, &match_start, &match_end, NULL))
       {
        match_start = match_end;
        if (gtk_text_iter_forward_find_char (&match_end, find_quote, NULL, NULL))   
           {
            f = gtk_text_buffer_get_text (cur_text_doc->text_buffer, &match_start, &match_end, FALSE);
            if ( g_file_test (f, G_FILE_TEST_EXISTS)) 
               common_temp_list = g_list_append (common_temp_list, f);
           } 
        match_start = match_end;
       }

  gint bytes_total = 0;
  gchar *t = NULL;
  gint x;

  GList *p = g_list_first (common_temp_list);

  while (p)
        {
         x = get_file_size ((gchar *) p->data);
         bytes_total = bytes_total + x;
         t = g_strdup_printf (_("%s = %d Kb"), (gchar *) p->data, (gint) x/1024);
         log_to_memo (t, NULL, LM_NORMAL);
         g_free (t);
         p = g_list_next (p);
        }

  x = get_file_size (cur_text_doc->file_name_local);
  bytes_total = bytes_total + x;
  t = g_strdup_printf (_("%s = %d Kb"), cur_text_doc->file_name_utf8, (gint) x/1024);
  log_to_memo (t, NULL, LM_NORMAL);
  g_free (t);     

  glist_strings_free (common_temp_list);

  t = g_strdup_printf (_("Total weight for %s is %d Kb"), cur_text_doc->file_name_utf8, bytes_total/1024);
  log_to_memo (t, NULL, LM_NORMAL);
  g_free (t);
}


void on_mni_get_src (GtkMenuItem* menuitem,
                     gpointer user_data)
{
  if (! get_page_text()) return;
  
  if (! g_file_test (cur_text_doc->file_name_local, G_FILE_TEST_EXISTS))
     return;

  gchar *f;
  GtkTextIter match_start;
  GtkTextIter match_end;

  gtk_widget_destroy(mni_links_menu);
  mni_links_menu = new_menu_submenu (mni_links);
  mni_temp = new_menu_item (cur_text_doc->file_name_utf8, mni_links_menu, on_mni_new_link_select);
  gtk_text_buffer_get_start_iter (cur_text_doc->text_buffer, &match_start); 
  gtk_text_buffer_get_end_iter (cur_text_doc->text_buffer, &match_end); 

  while (gtk_text_iter_forward_search (&match_start, "src=\"", GTK_TEXT_SEARCH_TEXT_ONLY, &match_start, &match_end, NULL))
       {
        match_start = match_end;
        if (gtk_text_iter_forward_find_char (&match_end, find_quote, NULL, NULL))   
           {
            f = gtk_text_buffer_get_text (cur_text_doc->text_buffer, &match_start, &match_end, FALSE);
            add_link_item (cur_text_doc->file_name_utf8, f);
            g_free (f);
           }
        match_start = match_end;
       }

  while (gtk_text_iter_forward_search (&match_start, "SRC=\"", GTK_TEXT_SEARCH_TEXT_ONLY, &match_start, &match_end, NULL))
       {
        match_start = match_end;
        if (gtk_text_iter_forward_find_char (&match_end, find_quote, NULL, NULL))   
           {
            f = gtk_text_buffer_get_text (cur_text_doc->text_buffer, &match_start, &match_end, FALSE);
            add_link_item (cur_text_doc->file_name_utf8, f);
            g_free (f); 
           }
        match_start = match_end;
       }

  log_to_memo (_("Now look into Links menu ;)"), NULL, LM_ADVICE);
}


void select_color_cb (GtkWidget *widget,
                      gpointer user_data)
{
  GdkColor color;
  GtkColorSelection *colorsel;
  colorsel = GTK_COLOR_SELECTION (GTK_COLOR_SELECTION_DIALOG (dlg_colorsel)->colorsel);

  gtk_color_selection_get_current_color (colorsel, &color);
  gchar *s = g_strdup_printf("#%02x%02x%02x", color.red / 256, color.green / 256, color.blue / 256);

  gchar *cm;
  gchar *t;
  gchar *buf = doc_get_sel (cur_text_doc);

  if (! buf)
     doc_insert_at_cursor (cur_text_doc, s);
  else
      {
       gchar *cm = g_strdup (confile.fmt_color_function);

       if (strstr (cm, "@color"))
          {
           t = g_str_replace (cm, "@color", s);
           g_free (cm);
           cm = t;
          }

       if (strstr (cm, "@text"))
          {
           t = g_str_replace (cm, "@text", buf);
           g_free (cm);
           cm = t;
          }

       doc_rep_sel (cur_text_doc, cm);
       g_free (cm);
       g_free (buf);
      }

  g_free (s);
}


void on_mni_markup_select_color_activate (GtkMenuItem *menuitem,
                                         gpointer user_data)
{
  if (! get_page_text()) return;
  
  dlg_colorsel = gtk_color_selection_dialog_new (_("Select a color"));

  GtkColorSelection *colorsel;
  colorsel = GTK_COLOR_SELECTION (GTK_COLOR_SELECTION_DIALOG (dlg_colorsel)->colorsel);
  
  gtk_color_selection_set_has_palette (colorsel, TRUE);  

  g_signal_connect (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (dlg_colorsel)->ok_button),
                    "clicked",
                    G_CALLBACK (select_color_cb),
                    (gpointer) dlg_colorsel);
  
  g_signal_connect_swapped (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (dlg_colorsel)->ok_button),
                            "clicked",
                            G_CALLBACK (gtk_widget_destroy),
                            (gpointer) dlg_colorsel);

  g_signal_connect_swapped (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (dlg_colorsel)->cancel_button),
                            "clicked",
                            G_CALLBACK (gtk_widget_destroy),
                            (gpointer) dlg_colorsel);

  gtk_widget_show (dlg_colorsel);
}


void on_mni_file_backup (GtkMenuItem* menuitem,
                       gpointer user_data)
{
  if (! get_page_text()) return;
  do_backup (cur_text_doc->file_name_local, FALSE);
}


void on_mni_file_add_bookmark (GtkMenuItem* menuitem,
                               gpointer user_data)
{
  if (! get_page_text()) return;

  bookmarks = add_recent_item_composed (bookmarks, cur_text_doc);
  glist_save_to_file (bookmarks, confile.bmx_file);
  bmx_reload ();
}


void on_mni_file_open_bookmark (GtkMenuItem* menuitem,
                               gpointer user_data)
{
  cur_settings.selected_enc = ch_str (cur_settings.selected_enc, "UTF-8");
  open_file_std (confile.bmx_file);
}


void on_mni_real_recent_activate (GtkMenuItem *menuitem,
                                  gpointer user_data)
{
  execute_recent_item (gtk_widget_get_name (menuitem));

  GList *p = str_in_glist (recent_list, gtk_widget_get_name (menuitem));
  if (p)
     {
      g_free (p->data);
      recent_list = g_list_delete_link (recent_list, p);
      update_recent_list_menu (FALSE);
     }
}


void on_mni_refresh_hl (GtkMenuItem *menuitem,
                        gpointer user_data)
{
  if (! get_page_text()) return;
  apply_hl (cur_text_doc);
}


void on_mni_make_numbering (GtkMenuItem *menuitem,
                            gpointer user_data)
{
  if (! get_page_text()) return;
  set_fam_text ("1~5~10");
  gchar *s = gtk_entry_get_text (ent_search);
  
  gchar *buf = doc_get_sel (cur_text_doc);
  if (buf) //exit if selected
     {
      g_free (buf);
      return;
     }

  gchar **a = g_strsplit (s, "~", 4);

  if (! a) return;

  gint c;
  gint x = 0;
  gint y = 0;
  gint step = 1;

  if (a[0])
     {
      x = strtol (a[0], NULL, 10);
      if (a[1])
         {
          y = strtol (a[1], NULL, 10);
          if (a[2])
              step = strtol (a[2], NULL, 10);
         }  
     }

  gchar *counter = NULL;
  GList *list = NULL;

  for (c = x; c <= y; c++)
      {
       counter = g_strdup_printf ("%d", (c * step));
       list = g_list_append (list, counter);
      }

  gchar *t = string_from_glist (list);
  doc_insert_at_cursor (cur_text_doc, t);

  g_free (t);
  glist_strings_free (list);
}


void on_mni_nav_block_start (GtkMenuItem *menuitem,
                             gpointer user_data)
{
  if (! get_page_text()) return;

  GtkTextIter iter;
  gint r = 0;
  gint l = 0;

  GtkTextMark *m = gtk_text_buffer_get_insert (cur_text_doc->text_buffer); 
  gtk_text_buffer_get_iter_at_mark (cur_text_doc->text_buffer, &iter, m);

  while (gtk_text_iter_backward_char (&iter))
        {
         if (gtk_text_iter_get_char (&iter) == '}')
            r++;
         else
             if (gtk_text_iter_get_char (&iter) == '{')
                {
                 l++;
                 if (l > r)
                 if (gtk_text_iter_forward_char (&iter))
                    {
                     gtk_text_buffer_place_cursor (cur_text_doc->text_buffer, &iter );
                     gtk_text_view_scroll_to_iter (cur_text_doc->text_view, &iter, 0.0, FALSE, 0.0, 0.0 );
                     break;
                    }
                }
        }
}


void on_mni_nav_block_end (GtkMenuItem *menuitem,
                             gpointer user_data)
{
  if (! get_page_text()) return;

  GtkTextIter iter;
  gint r = 0;
  gint l = 0;

  GtkTextMark *m = gtk_text_buffer_get_insert (cur_text_doc->text_buffer); 
  gtk_text_buffer_get_iter_at_mark (cur_text_doc->text_buffer, &iter, m);

  while (gtk_text_iter_forward_char (&iter))
        {
         if (gtk_text_iter_get_char (&iter) == '{')
            l++;
         else
             if (gtk_text_iter_get_char (&iter) == '}')
                {
                 r++;
                 if (l < r)
                    {
                     gtk_text_buffer_place_cursor (cur_text_doc->text_buffer, &iter );
                     gtk_text_view_scroll_to_iter (cur_text_doc->text_view, &iter, 0.0, FALSE, 0.0, 0.0 );
                     break;
                    }
                }
        }
}


void on_mni_open_hotkeys (GtkMenuItem *menuitem,
                          gpointer user_data)
{
  cur_settings.selected_enc = ch_str (cur_settings.selected_enc, "UTF-8");
  open_file_std (confile.tea_hotkeys);
}


enum
{
  TARGET_URILIST
};


static const GtkTargetEntry drag_types[] = {
                                            {"text/uri-list", 0, TARGET_URILIST}
                                           };

static gint inner_dnd_switch = 0;

void open_files_list (const gchar *s)
{
  GList *l = glist_from_string (s);
  if (! l)
     return;

  gchar *f;
  gchar *z;  

  GList *t = g_list_first (l);
  while (t && t->data)
        {
         if (strlen (t->data) < 1)
            break;
         
         cur_settings.selected_enc = ch_str (cur_settings.selected_enc, confile.default_charset);

         gchar *x = strchr ((gchar *) t->data, '/'); 
         if (x)
            f = g_strdup (x);
          else 
              f = g_strdup ((gchar *) t->data);
       
         if (f)
            {
             g_strchomp (f);
             if (strstr (f, "%20"))
                {
                 z = str_replace_all (f, "%20", " "); 
                 g_free (f);
                 f = z; 
                }

             if (is_image (f))
                {
                 if (get_page_text ())   
                    insert_image (f); 
                }
             else
                 open_file_std (f);

             g_free (f);
            }

         t = g_list_next (t);
        }

   glist_strings_free (l);
}


void tea_win_on_drag_data_cb (GtkWidget *widget,
                              GdkDragContext *context,
                              gint x, gint y, GtkSelectionData *data, 
                              guint info, guint time) 
{
  if (inner_dnd_switch == 1)
     {
      inner_dnd_switch = 0;
      return;
     } 

  gchar *filename;
  inner_dnd_switch++;   
 
  if ((data->length == 0) || (data->format != 8) || (info != TARGET_URILIST)) 
     {
      gtk_drag_finish (context, FALSE, TRUE, time);
      return;
     }

  filename = g_strndup (data->data, data->length);
  //if (info == TARGET_URILIST)
  open_files_list (filename);  

  gtk_drag_finish (context, TRUE, TRUE, time);
  g_free (filename);
}


void set_dnd_accept (GtkWidget *widget)
{
  gtk_drag_dest_set (widget, (GTK_DEST_DEFAULT_ALL),
                     drag_types, 1,
                    (GDK_ACTION_DEFAULT | GDK_ACTION_COPY | GDK_ACTION_MOVE));

  g_signal_connect (G_OBJECT (widget), "drag_data_received", G_CALLBACK (tea_win_on_drag_data_cb), widget);
}


gboolean on_tea_window_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
  ui_done ();
  return FALSE;
}


void on_mni_snippet_click (GtkMenuItem *menuitem,
                           gpointer user_data)
{
  if (! get_page_text()) return;

  gchar *f = g_strconcat (confile.snippets_dir, gtk_widget_get_name (menuitem), NULL);

  gsize length;
  GError *error;
  gchar *buf;
  gchar *t;
 
  if (! g_file_get_contents (f, &buf, &length, &error))
     {
      g_free (f); 
      return;
     }
  else
      if (! g_utf8_validate (buf, -1, NULL))
         {
          g_free (buf);
          g_free (f);
          return;
         }
 
  gchar *sel = doc_get_sel (cur_text_doc);

  if (! sel)
     doc_insert_at_cursor (cur_text_doc, buf);
  else      
  if (sel)
     {
      if (strstr (buf, "%s"))
        {
         t = rep_all_s (buf, sel);
         doc_rep_sel (cur_text_doc, t); 
         g_free (t);
         g_free (sel);
        }
     }
     else
         doc_insert_at_cursor (cur_text_doc, buf);
  
  g_free (f);
  g_free (buf);
}


void on_mni_snippet_file_open_activate (GtkMenuItem *menuitem,
                                        gpointer user_data)
{
  GtkWidget *dialog = gtk_file_chooser_dialog_new (_("Open file:"),
                                                   tea_main_window,
                                                   GTK_FILE_CHOOSER_ACTION_OPEN,
                                                   GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                                   GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
                                                   NULL);

  gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), confile.snippets_dir);
  gtk_window_resize (GTK_WINDOW (dialog), get_value (confile.screen_w, confile.saveopen_w), get_value (confile.screen_h, confile.saveopen_h));

  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
     {
      gchar *filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
      cur_settings.selected_enc = ch_str (cur_settings.selected_enc, "UTF-8");
      open_file_std (filename);
      g_free (filename);
     }

  gtk_widget_destroy (dialog);
}


void on_mni_file_save_as_snippet_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  show_save_as_dlg (2);
}


static GList *gl_menu_item_names;

void lookup_widget_cb_2 (GtkWidget *widget, gpointer data)
{
  if (! widget) return;
   
  gchar *s = gtk_widget_get_name (widget);
  if (strcmp (MENUITEMUTIL, s) != 0)
     {
      gl_menu_item_names = g_list_append (gl_menu_item_names, s);

      if (GTK_IS_MENU_ITEM (widget))
         lookup_widget2 (gtk_menu_item_get_submenu (widget), data);      
     }   
}


GtkWidget* lookup_widget2 (GtkContainer *widget, const gchar *widget_name)
{
  if (widget)
     gtk_container_foreach (widget, lookup_widget_cb_2, NULL);
  return NULL;
}


void on_mni_dump_menu (GtkMenuItem *menuitem, gpointer user_data)
{
  gl_menu_item_names = NULL;

  lookup_widget2 (GTK_CONTAINER (menubar1), NULL);
   
  gchar *t = string_from_glist (gl_menu_item_names); 

  doc_ins_to_new (t);
  g_free (t);
  g_list_free (gl_menu_item_names);
}


void on_mni_nav_focus_to_famous (GtkMenuItem* menuitem,
                                 gpointer user_data)
{
  gtk_widget_grab_focus (ent_search);    
}


void on_mni_nav_focus_to_text (GtkMenuItem* menuitem,
                               gpointer user_data)
{
  if (! get_page_text()) return;
  gtk_widget_grab_focus (cur_text_doc->text_view);    
}


void on_mni_tools_unitaz_sort (GtkMenuItem* menuitem,
                               gpointer user_data)
{
  if (! get_page_text()) return;
  mpb_start ();
  run_unitaz (cur_text_doc, 0, FALSE);
  mpb_stop ();
}


void on_mni_tools_unitaz_sort_by_count (GtkMenuItem *menuitem,
                                        gpointer user_data)
{
  if (! get_page_text()) return;
  mpb_start ();
  run_unitaz (cur_text_doc, 1, FALSE);
  mpb_stop ();
}


void on_mni_tools_unitaz_plain (GtkMenuItem* menuitem,
                                gpointer user_data)
{
  if (! get_page_text()) return;
  mpb_start ();
  run_unitaz (cur_text_doc, -1);
  mpb_stop ();
}


void on_mni_str_kill_dups (GtkMenuItem *menuitem,
                           gpointer user_data)
{
  if (! get_page_text()) return;

  gchar *buf = doc_get_sel (cur_text_doc);
  if (! buf) return;

  gchar *t = str_kill_dups (buf);
  doc_rep_sel (cur_text_doc, t);

  g_free (buf);
  g_free (t);
}


void on_mni_func_strings_sort (GtkMenuItem* menuitem,
                              gpointer user_data)
{
  if (! get_page_text()) return;

  gchar *buf = doc_get_sel (cur_text_doc);

  if (! buf) return;

  GList *temp = glist_from_string (buf);
  temp = glist_strings_sort (temp);
  gchar *t = string_from_glist (temp);

  doc_rep_sel (cur_text_doc, t);

  g_free (buf);
  g_free (t);
  glist_strings_free (temp);
}


void on_mni_extract_words (GtkMenuItem* menuitem,
                           gpointer user_data)
{
  if (! get_page_text()) return;
  run_extract_words (cur_text_doc);
}


void on_mni_edit_copy_all (GtkMenuItem *menuitem,
                           gpointer user_data)
{
  if (! get_page_text()) return;
  gchar *buf = doc_get_buf (cur_text_doc->text_buffer);
  clipboard_put_text (buf);
  g_free (buf);
}


void on_mni_edit_copy_current_url (GtkMenuItem *menuitem,
                                   gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = get_c_url_pure (cur_text_doc);
  clipboard_put_text (buf);
  g_free (buf);
}


void on_mni_edit_replace_with_clipboard (GtkMenuItem *menuitem,
                                         gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);
  if (! buf) return;
  gchar *t = get_clipboard_text (); 
 
  doc_rep_sel (cur_text_doc, t);
  clipboard_put_text (buf);  

  g_free (buf);
  g_free (t);
}


void on_mni_count_string_list (GtkMenuItem *menuitem,
                               gpointer user_data)
{
  if (! get_page_text()) return;

  gchar *buf = doc_get_sel (cur_text_doc);
  if (! buf) return;

  set_fam_text ("%d.)%s");  
  
  gchar *t = glist_enum (buf, gtk_entry_get_text (ent_search));

  if (t)
     doc_rep_sel (cur_text_doc, t);

  g_free (buf);
  g_free (t);
}


void on_mni_paste_to_new (GtkMenuItem *menuitem,
                          gpointer user_data)
{
  cur_text_doc = doc_clear_new ();
  gtk_window_set_title (GTK_WINDOW (tea_main_window), cur_text_doc->file_name_utf8);
  gtk_widget_grab_focus (cur_text_doc->text_view);

  gchar *t = get_clipboard_text (); 
  doc_insert_at_cursor (cur_text_doc, t);
  g_free (t); 
}


void on_mni_copy_to_new (GtkMenuItem *menuitem,
                         gpointer user_data)
{
  if (! get_page_text()) return;

  gchar *t = doc_get_sel (cur_text_doc);
  if (! t)
     return;  
 
  cur_text_doc = doc_clear_new ();
  gtk_window_set_title (GTK_WINDOW (tea_main_window), cur_text_doc->file_name_utf8);
  gtk_widget_grab_focus (cur_text_doc->text_view);

  doc_insert_at_cursor (cur_text_doc, t);
  g_free (t); 
}


void on_mni_cut_to_new (GtkMenuItem *menuitem,
                        gpointer user_data)
{
  if (! get_page_text()) return;

  gchar *t = doc_get_sel (cur_text_doc);
  if (! t)
     return;  
 
  doc_rep_sel (cur_text_doc, "");
  doc_ins_to_new (t);
  g_free (t); 
}


void on_mni_shuffle_strings (GtkMenuItem *menuitem,
                             gpointer user_data)
{
  if (! get_page_text()) return;

  gchar *buf = doc_get_sel (cur_text_doc);

  if (! buf) return;

  GList *temp = glist_from_string (buf);
  temp = glist_shuffle (temp);
  gchar *t = string_from_glist (temp);
  doc_rep_sel (cur_text_doc, t);

  g_free (buf);
  g_free (t);
  glist_strings_free (temp);
}


void on_mni_tools_unitaz_sort_caseinsens (GtkMenuItem *menuitem,
                                          gpointer user_data)
{
  if (! get_page_text()) return;
  run_unitaz (cur_text_doc, 0, TRUE);
}


void on_mni_tools_unitaz_sort_by_count_caseinsens (GtkMenuItem *menuitem,
                                                   gpointer user_data)
{
  if (! get_page_text()) return;
  run_unitaz (cur_text_doc, 1, TRUE);
}


void on_mni_tabs_to_spaces (GtkMenuItem *menuitem,
                            gpointer user_data)
{
  if (! get_page_text()) return;
  set_fam_text ("1");
  doc_tabs_to_spaces (cur_text_doc, strtol (gtk_entry_get_text (ent_search), NULL, 10));  
}


void on_mni_spaces_to_tabs (GtkMenuItem *menuitem,
                            gpointer user_data)
{
  if (! get_page_text()) return;
  set_fam_text ("2");
  doc_spaces_to_tabs (cur_text_doc, strtol (gtk_entry_get_text (ent_search), NULL, 10));  
}


void on_mni_edit_delete_current_line (GtkMenuItem *menuitem,
                                      gpointer user_data)
{
  if (! get_page_text()) return;
  
  GtkTextIter ittemp;
  GtkTextIter itend;

  GtkTextMark *mark = gtk_text_buffer_get_insert (cur_text_doc->text_buffer);
 
  gtk_text_buffer_get_iter_at_mark (cur_text_doc->text_buffer, &ittemp, mark);

  itend = ittemp;

  if (gtk_text_iter_forward_to_line_end (&itend))
     while (! gtk_text_iter_starts_line (&ittemp))
           gtk_text_iter_backward_char (&ittemp); 

  if (gtk_text_iter_forward_char (&itend));
     gtk_text_buffer_delete (cur_text_doc->text_buffer, &ittemp, &itend);
}


void on_mni_Markup_comment (GtkMenuItem *menuitem,
                           gpointer user_data)
{
  if (! get_page_text()) return;

  gchar *temp = NULL;
  gchar *buf = doc_get_sel (cur_text_doc);
  GList *x; 

  if (is_markup (cur_text_doc->file_name_local))
    {
     if (! buf)
        doc_insert_at_cursor (cur_text_doc, "<!-- -->");
     else
         {
          temp = g_strconcat ("<!-- ", buf, " -->", NULL);
          doc_rep_sel (cur_text_doc, temp);
          g_free (temp);
         }
  
     g_free (buf);
     return;
    }

  if (is_c (cur_text_doc->file_name_local) || is_css (cur_text_doc->file_name_local))
     {
      if (! buf)
        doc_insert_at_cursor (cur_text_doc, "/* */");
      else
          {
           temp = g_strconcat ("/*", buf, "*/", NULL);
           doc_rep_sel (cur_text_doc, temp);
           g_free (temp);
          }

      g_free (buf);
      return; 
     } 
  
  if (is_pascal (cur_text_doc->file_name_local))
     {
      if (! buf)
         doc_insert_at_cursor (cur_text_doc, "{ }");
      else
          {
           temp = g_strconcat ("{", buf, "}", NULL);
           doc_rep_sel (cur_text_doc, temp);
           g_free (temp);
          }

      g_free (buf);
      return; 
     }

  if (is_tex (cur_text_doc->file_name_local))
     {
      if (buf)
         {
          x = glist_from_string (buf);
          x = glist_repl (x, "% %s");
          gchar *t = string_from_glist (x);
          doc_rep_sel (cur_text_doc, t);
          glist_strings_free (x);
          g_free (t);  
         }

      g_free (buf);
      return; 
     }
}


void edit_paste (void)
{
  if (! get_page_text()) return;
  gchar *t = get_clipboard_text (); 
  doc_insert_at_cursor (cur_text_doc, t);
  g_free (t); 
}

//current music is Free Kitten - Sentimental Education - Teenie Weenie Boppie
void on_mni_paste (GtkMenuItem *menuitem,
                   gpointer user_data)
{
  edit_paste ();
}


void edit_copy (void)
{
  if (! get_page_text()) return;
  gchar *buf = doc_get_sel  (cur_text_doc);
  clipboard_put_text (buf);
  g_free (buf);
}


void on_mni_edit_copy (GtkMenuItem *menuitem,
                       gpointer user_data)
{
  edit_copy ();
}


void edit_cut (void)
{
  if (! get_page_text()) return;

  gchar *buf = doc_get_sel (cur_text_doc);

  if (buf)
     {
      clipboard_put_text (buf);
      doc_rep_sel (cur_text_doc, "");
     }
      
  g_free (buf);
}


void on_mni_edit_cut (GtkMenuItem *menuitem,
                       gpointer user_data)
{
  edit_cut ();
}


void on_mni_edit_delete (GtkMenuItem *menuitem,
                         gpointer user_data)
{
  if (! get_page_text()) return;
  doc_rep_sel (cur_text_doc, "");
}


void on_mni_edit_select_all (GtkMenuItem *menuitem,
                             gpointer user_data)
{
  if (! get_page_text()) return;

  GtkTextIter start_iter;
  GtkTextIter end_iter;

  gtk_text_buffer_get_start_iter (cur_text_doc->text_buffer, &start_iter);
  gtk_text_buffer_get_end_iter (cur_text_doc->text_buffer, &end_iter);

  gtk_text_buffer_move_mark_by_name (cur_text_doc->text_buffer,
                                     "insert",
                                     &start_iter);

  gtk_text_buffer_move_mark_by_name (cur_text_doc->text_buffer,
                                     "selection_bound",
                                     &end_iter);
}


void on_mni_sort_case_insensetive (GtkMenuItem *menuitem,
                                   gpointer user_data)
{
  if (! get_page_text()) return;

  gchar *buf = doc_get_sel (cur_text_doc);

  if (! buf) return;
  
  GList *temp = glist_from_string (buf);
  temp = sort_list_case_insensetive (temp);
  gchar *t = string_from_glist (temp);

  doc_rep_sel (cur_text_doc, t);

  g_free (buf);
  g_free (t);
  glist_strings_free (temp);
}


void on_mni_kill_formatting (GtkMenuItem *menuitem,
                             gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);

  if (buf)
     {
      gchar *temp = kill_formatting (buf, -1);
      doc_rep_sel (cur_text_doc, temp);
      g_free (buf);
      g_free (temp);
     }
}


void on_mni_wrap_raw (GtkMenuItem *menuitem,
                      gpointer user_data)
{
  if (! get_page_text()) return;

  set_fam_text ("72");
  
  gchar *buf = doc_get_sel (cur_text_doc);
  if (buf)
     {
      gchar *temp = wrap_raw (buf, strtol (gtk_entry_get_text (ent_search), NULL, 10));
      doc_rep_sel (cur_text_doc, temp);
      g_free (buf);
      g_free (temp);
     }
}


void on_mni_wrap_on_spaces (GtkMenuItem *menuitem,
                            gpointer user_data)
{
  if (! get_page_text()) return;

  set_fam_text ("72");
  
  gchar *buf = doc_get_sel (cur_text_doc);
  if (buf)
     {
      wrap_on_spaces (buf, strtol (gtk_entry_get_text (ent_search), NULL, 10));
      doc_rep_sel (cur_text_doc, buf);
      g_free (buf);
     }
}


void on_doit_button (GtkButton *button,
                     gpointer user_data)
{
  if (! get_page_text())
     return;
  set_fam_text ("text to find");
  doc_search_f (cur_text_doc, gtk_entry_get_text (ent_search));
}


void on_mni_kill_formatting_on_each_line (GtkMenuItem *menuitem,
                                          gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);

  if (buf)
     {
      gchar *temp = kill_formatting_on_each_line (buf, -1);
      doc_rep_sel (cur_text_doc, temp);
      g_free (buf);
      g_free (temp);
     }
}


void on_mni_file_crapbook (GtkMenuItem *menuitem,
                           gpointer user_data)
{
  if (! g_file_test (confile.crapbook_file, G_FILE_TEST_EXISTS))
     create_empty_file (confile.crapbook_file, _("you can put some crap here..."));

  handle_file_enc (confile.crapbook_file, "UTF-8");
}


void on_mni_spellcheck (GtkMenuItem *menuitem,
                        gpointer user_data)
{
  if (! get_page_text()) return;
  do_hl_spell_check2 (cur_text_doc, gtk_widget_get_name (menuitem));
}


void on_mni_filter_kill_lesser (GtkMenuItem *menuitem,
                                gpointer user_data)
{
  if (! get_page_text()) return;
  
  set_fam_text ("2");
   
  gchar *buf = doc_get_sel (cur_text_doc);

  if (buf)
     {
      gchar *t = kill_str_by_size (buf, strtol (gtk_entry_get_text (ent_search), NULL, 10), TRUE);
      doc_rep_sel (cur_text_doc, t);
      g_free (buf);
      g_free (t);
     }
}


void on_mni_filter_kill_more_than (GtkMenuItem *menuitem,
                                   gpointer user_data)
{
  if (! get_page_text()) return;
  
  set_fam_text ("2");
   
  gchar *buf = doc_get_sel (cur_text_doc);

  if (buf)
     {
      gchar *t = kill_str_by_size (buf, strtol (gtk_entry_get_text (ent_search), NULL, 10), FALSE);
      doc_rep_sel (cur_text_doc, t);
      g_free (buf);
      g_free (t);
     }
}


void on_mni_func_strings_sort_by_q (GtkMenuItem* menuitem,
                                    gpointer user_data)
{
  if (! get_page_text()) return;

  gchar *buf = doc_get_sel (cur_text_doc);

  if (! buf) return;

  GList *temp = glist_from_string (buf);
  temp = glist_word_sort_mode (temp, 2);
  gchar *t = string_from_glist (temp);

  doc_rep_sel (cur_text_doc, t);

  g_free (buf);
  g_free (t);
  glist_strings_free (temp);
}


void on_mni_tabs_menuitem_click (GtkMenuItem *menuitem,
                                 gpointer user_data)
{
  t_note_page *doc = user_data;
  if (doc) 
     handle_file (doc->file_name_utf8, 0, FALSE);
}


void on_mni_show_images_in_text (GtkMenuItem *menuitem,
                                 gpointer user_data)
{
  if (! get_page_text()) return;
  
  if (! g_file_test (cur_text_doc->file_name_local, G_FILE_TEST_EXISTS))
     return;

  doc_toggle_images_visibility (cur_text_doc);
}


void on_mni_nav_goto_recent_tab (GtkMenuItem* menuitem,
                                 gpointer user_data)
{
  gint t = gtk_notebook_get_current_page (notebook1);

  if (last_page != -1)
      gtk_notebook_set_current_page (notebook1, last_page);

  last_page = t;
}


void on_mni_nav_goto_selection (GtkMenuItem* menuitem,
                                gpointer user_data)
{
  last_page = gtk_notebook_get_current_page (notebook1);
  gtk_notebook_prev_page (notebook1);
}


void on_mni_nav_goto_prev_tab (GtkMenuItem* menuitem,
                               gpointer user_data)
{
  last_page = gtk_notebook_get_current_page (notebook1);
  gtk_notebook_prev_page (notebook1);
}


void on_mni_nav_goto_next_tab (GtkMenuItem* menuitem,
                               gpointer user_data)
{
  last_page = gtk_notebook_get_current_page (notebook1);
  gtk_notebook_next_page (notebook1);
}


void on_mni_view_hide_highlighting (GtkMenuItem* menuitem,
                                    gpointer user_data)
{
  if (! get_page_text()) return;
  remove_tags (cur_text_doc);
}


void on_mni_nav_goto_first_tab (GtkMenuItem* menuitem,
                                gpointer user_data)
{
  last_page = gtk_notebook_get_current_page (notebook1);
  gtk_notebook_set_current_page (notebook1, 0);
}


void on_mni_nav_goto_last_tab (GtkMenuItem* menuitem,
                               gpointer user_data)
{
  last_page = gtk_notebook_get_current_page (notebook1);
  gtk_notebook_set_current_page (notebook1, -1);
}


void on_mni_quest_find (GtkMenuItem* menuitem,
                        gpointer user_data)
{
  if (! get_page_text()) return;
  set_fam_text (_("text to find"));
  doc_search_f (cur_text_doc, gtk_entry_get_text (ent_search));
}


void on_mni_quest_find_next (GtkMenuItem* menuitem,
                             gpointer user_data)
{
  if (! get_page_text()) return;
  doc_search_f_next (cur_text_doc);
}


void on_mni_quest_find_ncase (GtkMenuItem* menuitem,
                              gpointer user_data)
{
  if (! get_page_text()) return;
  set_fam_text (_("text to find"));
  doc_search_f_ncase (cur_text_doc, gtk_entry_get_text (ent_search));
}


void on_mni_quest_find_next_ncase (GtkMenuItem* menuitem,
                                   gpointer user_data)
{
  if (! get_page_text()) return;
  doc_search_f_next_ncase (cur_text_doc);
}


void on_mni_user_menu_item (GtkMenuItem *menuitem,
                            gpointer user_data)
{
  gchar *t = g_hash_table_lookup (ht_user_menu, gtk_widget_get_name (menuitem));
  if (! t) 
     return;

  gchar *s = g_strdup (t);
  gchar *cmd = NULL;

  if (get_page_text()) 
     {
      cmd = str_replace_all (s, "%s", cur_text_doc->file_name_utf8);       
      system (cmd);
      g_free (cmd);
     }

  g_free (s);
}


void on_mni_user_menu_open (GtkMenuItem *menuitem,
                            gpointer user_data)
{
  if (! g_file_test (confile.user_menu_file, G_FILE_TEST_EXISTS))
     create_empty_file (confile.user_menu_file, "kwrite=kwrite %s &");

  cur_settings.selected_enc = ch_str (cur_settings.selected_enc, "UTF-8");
  open_file_std (confile.user_menu_file);
}

//n.p. Cypress Hill - Insane In The Brain
void on_mni_find_and_replace_wnd (GtkMenuItem *menuitem,
                                  gpointer user_data)
{
  if (! get_page_text()) return;
  create_fr ();
}


void on_mni_rtfm (GtkMenuItem *menuitem,
                  gpointer user_data)
{
  run_doc_in_browser ();
}


void on_mni_crackerize (GtkMenuItem *menuitem,
                        gpointer user_data)
{
  if (! get_page_text()) return;

  gchar *t = doc_get_sel (cur_text_doc);

  if (! t)
     return;

  gchar *x = str_crackerize (t);
  doc_rep_sel (cur_text_doc, x);

  g_free (t);
  g_free (x);
}


void show_options (void)
{
  wnd_options_create ();
}


void on_mni_show_options (GtkMenuItem *menuitem,
                          gpointer user_data)
{
  wnd_options_create ();
}


void on_mni_new_kwas (GtkMenuItem *menuitem,
                      gpointer user_data)
{
  create_kwas_window ();
}

//n.p. Orbital - The Box
void on_mni_open_kwas_bookmarks_file (GtkMenuItem *menuitem,
                                      gpointer user_data)
{
  cur_settings.selected_enc = ch_str (cur_settings.selected_enc, "UTF-8");
  open_file_std (confile.tea_kwas_bookmarks);
}


void on_mni_eol_to_crlf (GtkMenuItem* menuitem,
                          gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_buf (cur_text_doc->text_buffer);
  gchar *z = str_eol_to_crlf (buf);

  gtk_text_buffer_set_text (cur_text_doc->text_buffer, z, -1);

  g_free (z);
  g_free (buf); 
}


void on_mni_eol_to_lf (GtkMenuItem* menuitem,
                       gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_buf (cur_text_doc->text_buffer);
  gchar *z = str_replace_all (buf, "\r\n", "\n");
  
  gtk_text_buffer_set_text (cur_text_doc->text_buffer, z, -1);

  g_free (z);
  g_free (buf); 
}


void on_mni_templ_file_open_activate (GtkMenuItem *menuitem,
                                      gpointer user_data)
{
  GtkWidget *dialog = gtk_file_chooser_dialog_new (_("Open file:"),
                                                   tea_main_window,
                                                   GTK_FILE_CHOOSER_ACTION_OPEN,
                                                   GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                                   GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
                                                   NULL);

  gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), confile.templates_dir);
  gtk_window_resize (GTK_WINDOW (dialog), get_value (confile.screen_w, confile.saveopen_w), get_value (confile.screen_h, confile.saveopen_h));

  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
     {
      gchar *filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
      cur_settings.selected_enc = ch_str (cur_settings.selected_enc, "UTF-8");
      open_file_std (filename);
      g_free (filename);
     }

  gtk_widget_destroy (dialog);
}


void on_mni_upcase_each_first_letter_ofw (GtkMenuItem *menuitem,
                                          gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *z = upcase_each_first_letter_ofw (cur_text_doc);
  if (z)
     doc_rep_sel (cur_text_doc, z);

  g_free (z);
}


void on_mni_nav_mplayer_jump (GtkMenuItem *menuitem,
                              gpointer user_data)
{
  if (! confile.cm_mplayer)
     return;    

  if (! get_page_text()) 
     return;

  if (! confile.current_movie)
     {
      log_to_memo (_("Before using that, go to File > Open different > Open movie."), NULL, LM_ERROR);
      return;
     }   

  GtkTextIter iter;
  GtkTextMark *m = gtk_text_buffer_get_insert (cur_text_doc->text_buffer);
  gtk_text_buffer_get_iter_at_mark (cur_text_doc->text_buffer, &iter, m);

  GtkTextIter end;
  GtkTextIter start;

  if (! gtk_text_iter_forward_search (&iter, "\n\n", GTK_TEXT_SEARCH_TEXT_ONLY, &end,
                                      NULL,
                                      NULL))
     return; 

  if (! gtk_text_iter_backward_search (&end, "-->", GTK_TEXT_SEARCH_TEXT_ONLY, &iter,
                                       NULL,
                                       NULL))
     return;


  if (! gtk_text_iter_backward_search (&iter, "\n", GTK_TEXT_SEARCH_TEXT_ONLY, &start,
                                       NULL,
                                       NULL))
     return;

  gchar *t = gtk_text_iter_get_text (&start, &iter);
  if (! t)
     return;

  t = g_strstrip (t);

  gchar *s;
  gchar *m1;
  gchar *m2;

  gchar *cm = g_strdup (confile.cm_mplayer);

  if (strstr (cm, "@encoding"))
     {
      s = g_str_replace (cm, "@encoding", cur_text_doc->encoding);
      g_free (cm);
      cm = s; 
     }

  if (strstr (cm, "@time"))
     {
      s = g_str_replace (cm, "@time", t);
      g_free (cm);
      cm = s; 
     }

  if (strstr (cm, "@sub_file"))
     {
      s = g_str_replace (cm, "@sub_file", cur_text_doc->file_name_utf8);
      g_free (cm);
      cm = s; 
     }

  if (strstr (cm, "@movie_file"))
     {
      s = g_str_replace (cm, "@movie_file", confile.current_movie);
      g_free (cm);
      cm = s; 
     }
  
  system (cm);

  g_free (t);
  g_free (cm);
}


void on_mni_open_open_movie (GtkMenuItem *menuitem,
                             gpointer user_data)
{
  GtkWidget *dialog = gtk_file_chooser_dialog_new (_("Open a movie:"),
                                                   tea_main_window,
                                                   GTK_FILE_CHOOSER_ACTION_OPEN,
                                                   GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                                   GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
                                                   NULL);

  gtk_window_resize (GTK_WINDOW (dialog), get_value (confile.screen_w, confile.saveopen_w), get_value (confile.screen_h, confile.saveopen_h));

  gchar *t;
  gchar *dir;

  if (get_page_text())
  if (g_file_test (cur_text_doc->file_name_local, G_FILE_TEST_EXISTS))
     {
      t = g_path_get_dirname (cur_text_doc->file_name_local);
      gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), t);
      g_free (t);
     }

  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
    {
     gchar *filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
     confile.current_movie = ch_str (confile.current_movie, filename);
     g_free (filename);
    }

  gtk_widget_destroy (dialog);
}

#ifdef FOR_DEBIAN
void on_mni_help_item (GtkMenuItem *menuitem,
                       gpointer user_data)
{
  cur_settings.selected_enc = ch_str (cur_settings.selected_enc, "UTF-8");

  gchar *n = gtk_widget_get_name (menuitem);
  gchar *f;

  if (g_utf8_collate (n, "ChangeLog") == 0)
     f = g_strconcat (TEA_DOC_DIR, "changelog.gz", NULL);        
  else
  if (g_utf8_collate (n, "COPYING") == 0)
     f = g_strdup ("/usr/share/common-licenses/GPL-2");
  else
  if (g_utf8_collate (n, "NEWS") == 0)
     f = g_strconcat (TEA_DOC_DIR, "NEWS.gz", NULL);        
  else
      f = get_tea_doc_compose_name (gtk_widget_get_name (menuitem));

  cur_text_doc = open_file_std (f);
  if (cur_text_doc)
     cur_text_doc->readonly = TRUE;
  g_free (f);
}
#else

void on_mni_help_item (GtkMenuItem *menuitem,
                       gpointer user_data)
{
  cur_settings.selected_enc = ch_str (cur_settings.selected_enc, "UTF-8");
  gchar *f = get_tea_doc_compose_name (gtk_widget_get_name (menuitem));
  cur_text_doc = open_file_std (f);
  if (cur_text_doc)
     cur_text_doc->readonly = TRUE;
  g_free (f);
}

#endif


void on_mni_insert_doctype (GtkMenuItem *menuitem,
                            gpointer user_data)
{
  if (! get_page_text()) return;

  gchar *n = gtk_widget_get_name (menuitem);
  gchar *t;

  if (g_utf8_collate (n, "HTML 4.1 Transitional") == 0)
     t = g_strdup ("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd\">");
  else 
  if (g_utf8_collate (n, "HTML 4.1 Strict") == 0)
     t = g_strdup ("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">");
  else
  if (g_utf8_collate (n, "HTML 4.1 Frameset") == 0)
     t = g_strdup ("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/1999/REC-html401-19991224/frameset.dtd\">");
  else
  if (g_utf8_collate (n, "XHTML 1.0 Strict") == 0)
     t = g_strdup ("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
  else
  if (g_utf8_collate (n, "XHTML 1.0 Transitional") == 0)
     t = g_strdup ("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
  else
  if (g_utf8_collate (n, "XHTML 1.0 Frameset") == 0)
     t = g_strdup ("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\">");
  else
  if (g_utf8_collate (n, "WML 1.1") == 0)
     t = g_strdup ("<xml version='1.0'> \n<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">");
  
  doc_insert_at_cursor (cur_text_doc, t); 

  g_free (t);
}


void on_mni_entity (GtkMenuItem *menuitem,
                    gpointer user_data)
{
  if (! get_page_text()) return;

  gchar *t = NULL;
  gchar *n = gtk_widget_get_name (menuitem);
  gchar *x = g_hash_table_lookup (ht_entities, n);
  if (x)
     t = g_strdup_printf ("&#%s;", x);

  doc_insert_at_cursor (cur_text_doc, t); 

  g_free (t);    
}


void on_mni_sessions_click (GtkMenuItem *menuitem,
                            gpointer user_data)
{
  gchar *f = g_strconcat (confile.sessions_dir, gtk_widget_get_name (menuitem), NULL);

  GList *list = load_file_to_glist (f);
  GList *t = g_list_first (list);

  while (t) 
       {
        execute_recent_item (t->data);
        t = g_list_next (t);
       }

  glist_strings_free (list);
  g_free (f);
}


void on_mni_templates_click (GtkMenuItem *menuitem,
                             gpointer user_data)
{
  gchar *f = g_strconcat (confile.templates_dir, gtk_widget_get_name (menuitem), NULL);
  gchar *t = str_file_read (f);
  doc_ins_to_new (t);
  g_free (f);
  g_free (t);
}


void on_mni_morse_encode (GtkMenuItem *menuitem,
                          gpointer user_data)
{
  if (! get_page_text()) return;

  gchar *t = doc_get_sel (cur_text_doc);

  if (! t)
     return;

  gchar *x = morse_encode (t);
 
  doc_rep_sel (cur_text_doc, x);
  g_free (t);
  g_free (x);
}


void on_mni_morse_decode (GtkMenuItem *menuitem,
                          gpointer user_data)
{
  if (! get_page_text()) return;

  gchar *t = doc_get_sel (cur_text_doc);

  if (! t)
     return;

  gchar *x = morse_decode (t);
 
  doc_rep_sel (cur_text_doc, x);
  g_free (t);
  g_free (x);
}


void on_mni_set_hl_mode (GtkMenuItem *menuitem,
                         gpointer user_data)
{
  //n.p. Method Man - Tical - Biscuits
  if (! get_page_text()) return;
  cur_text_doc->hl_mode = ch_str (cur_text_doc->hl_mode, gtk_widget_get_name (menuitem));
  apply_hl (cur_text_doc);
}


gboolean on_editor_keypress (GtkWidget *widget, GdkEventKey *event, gpointer data)
{
  t_note_page *page = data;
  gchar *t;
  gchar *s;
  GtkTextIter itstart;
  GtkTextIter itend;  
  
  GList *l;

  guint32 k = gdk_keyval_to_unicode (event->keyval);

  if (confile.autoclose_tags)
     {
      if (k == '>')
         {
          current_tag_close (page, 0);
          return TRUE;
         }
       return FALSE;
     }

  if (confile.do_autorep && ht_autoreplace)
     {
      t = NULL;  
      if (g_unichar_ispunct (k) || g_unichar_isspace (k))
      t = doc_get_word_at_left (cur_text_doc, &itstart, &itend);
      if (! t)
         return FALSE;
     
      s = g_hash_table_lookup (ht_autoreplace, t);  
      if (s)
        {  
         gtk_text_buffer_delete (page->text_buffer,
                                 &itstart,
                                 &itend);

         gtk_text_buffer_insert (page->text_buffer,
                                 &itstart,
                                 s,
                                 -1);
        } 
    
     if (t)
        g_free (t);
 
     return FALSE;
    }

  if (event->keyval == GDK_Return)
     if (confile.use_auto_indent) 
        {
         indent_real(page->text_view);
         return TRUE;
        }

  //if (event->keyval == GDK_ISO_Left_Tab)
  if (event->keyval == GDK_Tab)
     {
      doc_indent_selection (page, FALSE);
      return TRUE; 
     }

 return FALSE;
}


void on_mni_save_pos (GtkMenuItem *menuitem,
                      gpointer user_data)
{
  if (! get_page_text()) return;
  cur_text_doc->position = editor_get_pos (cur_text_doc);
}


void on_mni_jump_to_saved_pos (GtkMenuItem *menuitem,
                               gpointer user_data)
{
  if (! get_page_text()) return;
  editor_set_pos (cur_text_doc, cur_text_doc->position);
}


void on_mni_unindent (GtkMenuItem *menuitem,
                      gpointer user_data)
{
  if (! get_page_text()) return;
  doc_indent_selection (cur_text_doc, TRUE);
}


void on_mni_indent (GtkMenuItem *menuitem,
                    gpointer user_data)
{
  if (! get_page_text()) return;
  doc_indent_selection (cur_text_doc, FALSE);
}


void on_mni_autorep_file_open (GtkMenuItem *menuitem,
                               gpointer user_data)
{
  cur_settings.selected_enc = ch_str (cur_settings.selected_enc, "UTF-8");
  open_file_std (confile.tea_autoreplace);
}


void on_mni_strings_remove_leading_whitespaces (GtkMenuItem *menuitem,
                                                gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);

  if (! buf) return;

  GList *temp = glist_from_string (buf);
  GList *temp2 = each_line_remove_lt_spaces (temp, 0);
  gchar *t = string_from_glist (temp2);

  doc_rep_sel (cur_text_doc, t);

  g_free (buf);
  g_free (t);
  glist_strings_free (temp);
  glist_strings_free (temp2);
}


void on_mni_strings_remove_trailing_whitespaces (GtkMenuItem *menuitem,
                                                 gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);

  if (! buf) return;

  GList *temp = glist_from_string (buf);
  GList *temp2 = each_line_remove_lt_spaces (temp, 1);
  gchar *t = string_from_glist (temp2);

  doc_rep_sel (cur_text_doc, t);

  g_free (buf);
  g_free (t);
  glist_strings_free (temp);
  glist_strings_free (temp2);
}


void on_mni_edit_append_to_crapbook (GtkMenuItem *menuitem,
                                     gpointer user_data)
{
  if (! get_page_text()) return;
  
  t_note_page *p;
  GtkTextIter iter;

  gchar *buf = doc_get_sel (cur_text_doc);

  if (! buf) return;

  gchar *t = g_strconcat (buf, "\n", NULL);  

  gint i = get_n_page_by_filename (confile.crapbook_file);

  if (i != -1)
     {
      p = get_page_by_index (i);
      gtk_text_buffer_get_iter_at_offset (p->text_buffer, &iter, 0);
      gtk_text_buffer_insert (p->text_buffer, &iter, t, -1);
      g_free (buf);
      g_free (t);
      return;
     } 

  GList *l = load_file_to_glist (confile.crapbook_file);

  l = g_list_prepend (l, t);

  glist_save_to_file (l, confile.crapbook_file);
  glist_strings_free (l);
  g_free (buf);
}


void on_mni_load_last_file (GtkMenuItem *menuitem,
                            gpointer user_data)
{
  if (! recent_list)
    return;

  execute_recent_item (recent_list->data); 
}


void on_source_header_switch (GtkMenuItem *menuitem,
                              gpointer user_data)
{
  if (! get_page_text()) return;
  doc_header_source_switch (cur_text_doc);
}


gboolean cb_logmemo_button_press_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
  gchar *r = NULL;
  GtkTextView *text_view = user_data;
  GtkTextBuffer *text_buffer = gtk_text_view_get_buffer (text_view); 

  if (event->button == 1) 
     if (event->type == GDK_2BUTTON_PRESS)
        {
         gchar *r = NULL;

         GtkTextIter target_iter;
         GtkTextIter end_line_iter;
         gint line_top;

         GtkTextMark *mark = gtk_text_buffer_get_insert (text_buffer);
         gtk_text_buffer_get_iter_at_mark (text_buffer, &target_iter, mark);
         gtk_text_iter_set_line (&target_iter, gtk_text_iter_get_line (&target_iter)) ;
         end_line_iter = target_iter;

         if (gtk_text_iter_forward_to_line_end (&end_line_iter))
             r = gtk_text_buffer_get_text (text_buffer, &target_iter, &end_line_iter, FALSE);

         if (! r)
            return FALSE; 
             
         gchar *filename = NULL;
         gint lineno;

         if (parse_error_line (r, &filename, &lineno))
            handle_file_ide (filename, (lineno - 1));
          
         g_free (filename);
         g_free (r);

         return TRUE;
        }
         
  return FALSE; 
}


void on_mni_show_project_props (GtkMenuItem *menuitem,
                                gpointer user_data)
{
  if (cur_tea_project)
     create_proj_props_window (cur_tea_project);  
}


void on_mni_project_new (GtkMenuItem *menuitem,
                        gpointer user_data)
{
  cur_tea_project = tea_proj_clear_new (cur_tea_project);
  if (cur_tea_project)
     create_proj_props_window (cur_tea_project);
}


void on_mni_project_save_as (GtkMenuItem *menuitem,
                             gpointer user_data)
{
  if (! cur_tea_project)
     return;

  gchar *filename;

  GtkWidget *dialog = gtk_file_chooser_dialog_new (_("Save a project"),
                                                   tea_main_window,
                                                   GTK_FILE_CHOOSER_ACTION_SAVE,
                                                   GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                                   GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT,
                                                   NULL);

  gtk_window_resize (GTK_WINDOW (dialog), get_value (confile.screen_w, confile.saveopen_w), get_value (confile.screen_h, confile.saveopen_h));
  
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
     {
      filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
      tea_proj_save_as (cur_tea_project, filename);
      g_free (filename);
     }

  gtk_widget_destroy (dialog);
}


void on_mni_show_project_save (GtkMenuItem *menuitem,
                               gpointer user_data)
{
  if (! cur_tea_project)
     return;

  if (! g_file_test (cur_tea_project->project_file_name, G_FILE_TEST_EXISTS))
     {
      on_mni_project_save_as (NULL, NULL);
      return;
     } 

  tea_proj_save (cur_tea_project);
}


void on_mni_project_open (GtkMenuItem *menuitem,
                          gpointer user_data)
{
  gchar *filename;

  GtkWidget *dialog = gtk_file_chooser_dialog_new (_("Open a project"),
                                                   tea_main_window,
                                                   GTK_FILE_CHOOSER_ACTION_OPEN,
                                                   GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                                   GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
                                                   NULL);

  gtk_window_resize (GTK_WINDOW (dialog), get_value (confile.screen_w, confile.saveopen_w), get_value (confile.screen_h, confile.saveopen_h));
  
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
     {
      filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
      tea_proj_free (cur_tea_project);
      cur_tea_project = tea_proj_open (filename);
      g_free (filename);
     }

   gtk_widget_destroy (dialog);
}


void on_mni_project_make (GtkMenuItem *menuitem,
                          gpointer user_data)
{
  if (! cur_tea_project)
      return;

   if (! cur_tea_project->dir_makefile)
      return;

  if (! g_file_test (cur_tea_project->dir_makefile, G_FILE_TEST_EXISTS))
     return;
 
  chdir (cur_tea_project->dir_makefile);

  gchar *standard_output = NULL;
  gchar *standard_error = NULL;
                                                   
  gint exit_status;
  GError *err = NULL;

  gchar *cmd = g_strconcat ("make", NULL); 
  
  gsize bytes_read;
  gsize bytes_written;
  gchar *x = NULL;

  if (! g_spawn_command_line_sync  (cmd, &standard_output, &standard_error, NULL, &err))
    {
     fprintf (stderr, "Error: %s\n", err->message);
     g_error_free (err);
     return;
    }
  else
     {
      x = g_locale_to_utf8 (standard_output, -1, &bytes_read, &bytes_written, NULL);
      log_to_memo (x, NULL, LM_NORMAL);
      g_free (x);

      x = g_locale_to_utf8 (standard_error, -1, &bytes_read, &bytes_written, NULL);
      log_to_memo (x, NULL, LM_NORMAL);
      g_free (x);
  
      do_errors_hl (tv_logmemo);
     }   

  g_free (cmd);
  g_free (standard_output);
  g_free (standard_error);
}


void on_mni_show_project_run (GtkMenuItem *menuitem,
                              gpointer user_data)
{
  tea_proj_run (cur_tea_project);  
}


void on_mni_add_to_autosave_list (GtkMenuItem *menuitem,
                                  gpointer user_data)
{
  if (! get_page_text()) return;
  if (! cur_text_doc->b_saved)
     return; 

  gl_autosave = g_list_prepend (gl_autosave, g_strdup (cur_text_doc->file_name_utf8));
  glist_save_to_file (gl_autosave, confile.autosave_file);
}


void on_mni_autosave_list_open (GtkMenuItem *menuitem,
                               gpointer user_data)
{
  cur_settings.selected_enc = ch_str (cur_settings.selected_enc, "UTF-8");
  open_file_std (confile.autosave_file);
}


void on_mni_string_unquote (GtkMenuItem *menuitem,
                            gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);

  if (! buf)
     return;
 
  gchar *t = g_shell_unquote (buf, NULL);
  doc_rep_sel (cur_text_doc, t);
  g_free (buf);
  g_free (t);
}


void on_mni_copy_filename (GtkMenuItem *menuitem,
                           gpointer user_data)
{
  if (! get_page_text()) return;
  
  if (! cur_text_doc->b_saved)  
     return;

  clipboard_put_text (cur_text_doc->file_name_utf8);
}


void on_mni_quote_string (GtkMenuItem *menuitem,
                          gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);
  gchar *t;

  if (buf)
     {
      t = g_shell_quote (buf);
      doc_rep_sel (cur_text_doc, t);
      g_free (buf);
      g_free (t);
     }
}


void on_mni_file_close_all (GtkMenuItem *menuitem,
                            gpointer user_data)
{
  doc_close_all ();
}


void on_mni_text_to_html_fmt (GtkMenuItem *menuitem,
                              gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);
  gchar *t;
  gboolean xhtml_mode = FALSE;  
  if (def_mm == MM_XHTML)
     xhtml_mode = TRUE; 

  if (buf)
     {
      t = str_to_html (buf, xhtml_mode);
      doc_ins_to_new (t);
      g_free (buf);
      g_free (t);
     }
}


void on_mni_mm_change (GtkMenuItem *menuitem,
                       gpointer user_data)
{
  confile.default_markup_mode = ch_str (confile.default_markup_mode, gtk_widget_get_name (menuitem));
  def_mm = get_markup_mode ();  
}


void on_mni_ins_np (GtkMenuItem *menuitem,
                    gpointer user_data)
{
  if (! get_page_text()) return;
  gchar *s = get_amarok_now_playing ();

  gchar *t = str_replace_all (confile.now_playing, "%s", s);
  doc_insert_at_cursor (cur_text_doc, t);
      
  g_free (s);
  g_free (t);
}


void on_mni_imageplane (GtkMenuItem *menuitem,
                        gpointer user_data)
{
  if (! get_page_text()) return;

  if (! cur_text_doc->b_saved)
     {
      log_to_memo (_("Open the file first"), NULL, LM_ERROR);
      return; 
     }

  gchar *dir = g_path_get_dirname (cur_text_doc->file_name_local);

  if (! wnd_imageplane)
     wnd_imageplane = create_image_browser (dir);
  else 
     {
      gtk_widget_destroy (wnd_imageplane); 
      wnd_imageplane = create_image_browser (dir);
     }

  g_free (dir);
}


void on_mni_quotes_to_tex (GtkMenuItem *menuitem,
                            gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);
  gchar *t;

  if (buf)
     {
      t = quotes_to_tex (buf);
      doc_rep_sel (cur_text_doc, t);
      g_free (buf);
      g_free (t);
     }
}


void on_mni_doc_close_all (GtkMenuItem *menuitem,
                           gpointer user_data)
{
   doc_close_all ();
}


void on_mni_latex_process (GtkMenuItem *menuitem,
                           gpointer user_data)
{
  if (! get_page_text()) return;
  latex_process (cur_text_doc->file_name_local);
}


void on_mni_dvi_to_ps (GtkMenuItem *menuitem,
                       gpointer user_data)
{
  if (! get_page_text()) return;
  latex_dvi_to_ps (cur_text_doc->file_name_local);
}


void on_mni_dvi_to_pdf (GtkMenuItem *menuitem,
                       gpointer user_data)
{
  if (! get_page_text()) return;
  latex_dvi_to_pdf (cur_text_doc->file_name_local);
}


void on_mni_view_dvi (GtkMenuItem *menuitem,
                      gpointer user_data)
{
  if (! get_page_text()) return;
  view_dvi (cur_text_doc->file_name_local);
}


void on_mni_view_pdf (GtkMenuItem *menuitem,
                      gpointer user_data)
{
  if (! get_page_text()) return;
  view_pdf  (cur_text_doc->file_name_local);
}


void on_mni_view_ps (GtkMenuItem *menuitem,
                     gpointer user_data)
{
  if (! get_page_text()) return;
  view_ps (cur_text_doc->file_name_local);
}


void on_mni_split_to_tex_paragraphs (GtkMenuItem *menuitem,
                                     gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *buf = doc_get_sel (cur_text_doc);

  if (! buf)
     return;
 
  gchar *t = tex_paras (buf, NULL);
  doc_rep_sel (cur_text_doc, t);
  g_free (buf);
  g_free (t);
}


void on_mni_markup_list_item (GtkMenuItem *menuitem,
                              gpointer user_data) 
{
  if (! get_page_text()) return;

  gchar *t = NULL;
  gchar *buf = doc_get_sel (cur_text_doc);
  
  if (! buf)
      {
       if (def_mm == MM_HTML || def_mm == MM_XHTML)
          {
           doc_insert_at_cursor (cur_text_doc, "<li></li>");
           doc_move_cursor_backw_middle_tags (cur_text_doc);
           }
       else 
           if (def_mm == MM_TEX)
              doc_insert_at_cursor (cur_text_doc, "\\item");
       else 
           if (def_mm == MM_DOCBOOK)
              doc_insert_at_cursor (cur_text_doc, "<listitem><para></para></listitem>");
      }
  else
      {
       if (def_mm == MM_HTML || def_mm == MM_XHTML)
          { 
           t = g_strconcat ("<li>", buf, "</li>", NULL);
           doc_rep_sel (cur_text_doc, t);
           g_free (t);
          }
       else
          if (def_mm == MM_TEX)      
            { 
             t = g_strconcat ("\\item", buf, NULL);
             doc_rep_sel (cur_text_doc, t);
             g_free (t);
            }
       else
           if (def_mm == MM_DOCBOOK)      
            { 
             t = g_strconcat ("<listitem><para>", buf, "</para></listitem>", NULL);
             doc_rep_sel (cur_text_doc, t);
             g_free (t);
            }
      }

  g_free (buf);
}


void on_mni_markup_tex_begend (GtkMenuItem *menuitem,
                               gpointer user_data) 
{
  if (! get_page_text()) return;

  gchar *t = NULL;
  gchar *buf = doc_get_sel (cur_text_doc);
  
  if (! buf)
      {
       doc_insert_at_cursor (cur_text_doc, "\\begin{}\n\\end{}");
       doc_move_cursor_backw_middle_tags (cur_text_doc);
      }
  else
      if (def_mm == MM_TEX)      
        { 
         t = g_strconcat ("\\begin{}\n", buf, "\\end{}", NULL);
         doc_rep_sel (cur_text_doc, t);
         g_free (t);
        }
     
  g_free (buf);
}


void on_mni_markup_col (GtkMenuItem *menuitem,
                        gpointer user_data) 
{
  if (! get_page_text()) return;

  gchar *t = NULL;
  gchar *buf = doc_get_sel (cur_text_doc);
  
  if (! buf)
     {
      if (def_mm == MM_HTML || def_mm == MM_XHTML)
          doc_insert_at_cursor (cur_text_doc, "<td></td>");
      else
          if (def_mm == MM_DOCBOOK)
             doc_insert_at_cursor (cur_text_doc, "<entry></entry>");
     
      doc_move_cursor_backw_middle_tags (cur_text_doc);
     }
  else
      {
       if (def_mm == MM_HTML || def_mm == MM_XHTML)
          { 
           t = g_strconcat ("<td>", buf, "</td>", NULL);
           doc_rep_sel (cur_text_doc, t);
           g_free (t);
          }
       else
           if (def_mm == MM_DOCBOOK)      
            { 
             t = g_strconcat ("<entry>", buf, "</entry>", NULL);
             doc_rep_sel (cur_text_doc, t);
             g_free (t);
            }
      }
 
  g_free (buf);
}


void on_mni_markup_row (GtkMenuItem *menuitem,
                        gpointer user_data) 
{
  if (! get_page_text()) return;

  gchar *t = NULL;
  gchar *buf = doc_get_sel (cur_text_doc);
  
  if (! buf)
     {
      if (def_mm == MM_HTML || def_mm == MM_XHTML)
          doc_insert_at_cursor (cur_text_doc, "<tr></tr>");
      else
          if (def_mm == MM_DOCBOOK)
             doc_insert_at_cursor (cur_text_doc, "<row></row>");
     
      doc_move_cursor_backw_middle_tags (cur_text_doc);
     }
  else
      {
       if (def_mm == MM_HTML || def_mm == MM_XHTML)
          { 
           t = g_strconcat ("<tr>", buf, "</tr>", NULL);
           doc_rep_sel (cur_text_doc, t);
           g_free (t);
          }
       else
          if (def_mm == MM_WIKI)      
            { 
             t = g_strconcat (buf, "\\par", NULL);
             doc_rep_sel (cur_text_doc, t);
             g_free (t);
            }
       else
           if (def_mm == MM_DOCBOOK)      
             { 
              t = g_strconcat ("<row>", buf, "</row>", NULL);
              doc_rep_sel (cur_text_doc, t);
              g_free (t);
             }
      }

  g_free (buf);
}


void on_mni_markup_table (GtkMenuItem *menuitem,
                          gpointer user_data) 
{
  if (! get_page_text()) return;

  gchar *t = NULL;
  gchar *buf = doc_get_sel (cur_text_doc);
  
  if (! buf)
     {
      if (def_mm == MM_HTML || def_mm == MM_XHTML)
          doc_insert_at_cursor (cur_text_doc, "<table></table>");
      else
          if (def_mm == MM_DOCBOOK)
             doc_insert_at_cursor (cur_text_doc,
                                   "<informaltable frame=\"none\">\n<tgroup cols=\"7\">\n<tbody>\n</tbody>\n</tgroup>\n</informaltable>");
     
      doc_move_cursor_backw_middle_tags (cur_text_doc);
     }
  else
      {
       if (def_mm == MM_HTML || def_mm == MM_XHTML)
          { 
           t = g_strconcat ("<table>\n", buf, "</table>", NULL);
           doc_rep_sel (cur_text_doc, t);
           g_free (t);
          }
       else
          if (def_mm == MM_WIKI)      
            { 
             t = g_strconcat (buf, "{|\n|}", NULL);
             doc_rep_sel (cur_text_doc, t);
             g_free (t);
            }
       else
           if (def_mm == MM_DOCBOOK)      
             { 
              t = g_strconcat ("<informaltable frame=\"none\">\n<tgroup cols=\"777\">\n<tbody>", 
                               buf, "</tbody>\n</tgroup>\n</informaltable>", NULL);
              doc_rep_sel (cur_text_doc, t);
              g_free (t);
             }
      }
  g_free (buf);
}


void on_mni_markup_itemizedlist (GtkMenuItem *menuitem,
                                 gpointer user_data) 
{
  if (! get_page_text()) return;

  gchar *t = NULL;
  gchar *buf = doc_get_sel (cur_text_doc);
  
  if (! buf)
     {
      if (def_mm == MM_TEX)
          doc_insert_at_cursor (cur_text_doc, "\\begin{itemize}\n\\end{itemize}");
      else
          if (def_mm == MM_DOCBOOK)
             {
              doc_insert_at_cursor (cur_text_doc, "<itemizedlist></itemizedlist>");
              doc_move_cursor_backw_middle_tags (cur_text_doc);
             }
     }
  else
      {
       if (def_mm == MM_TEX)      
         { 
          t = g_strconcat ("\\begin{itemize}\n", buf, "\\end{itemize}", NULL);
          doc_rep_sel (cur_text_doc, t);
          g_free (t);
         }
       else
           if (def_mm == MM_DOCBOOK)      
            { 
             t = g_strconcat ("<itemizedlist>", buf, "</itemizedlist>", NULL);
             doc_rep_sel (cur_text_doc, t);
             g_free (t);
            }
      }

  g_free (buf);
}


void on_mni_markup_enumeratedlist (GtkMenuItem *menuitem,
                                   gpointer user_data) 
{
  if (! get_page_text()) return;

  gchar *t = NULL;
  gchar *buf = doc_get_sel (cur_text_doc);
  
  if (! buf)
     {
      if (def_mm == MM_HTML || def_mm == MM_XHTML)
          doc_insert_at_cursor (cur_text_doc, "\\begin{enumerate}\n\\end{enumerate}");
      else
          if (def_mm == MM_DOCBOOK)
             {
              doc_insert_at_cursor (cur_text_doc, "<orderedlist></orderedlist>");
              doc_move_cursor_backw_middle_tags (cur_text_doc);
             }
     }
  else
      {
       if (def_mm == MM_WIKI)      
         { 
          t = g_strconcat ("\\begin{enumerate}\n", buf, "\\end{enumerate}", NULL);
          doc_rep_sel (cur_text_doc, t);
          g_free (t);
         }
       else
           if (def_mm == MM_DOCBOOK)      
             { 
              t = g_strconcat ("<orderedlist>", buf, "</orderedlist>", NULL);
              doc_rep_sel (cur_text_doc, t);
              g_free (t);
             }
      }

  g_free (buf);
}


void on_mni_markup_em (GtkMenuItem *menuitem,
                       gpointer user_data) 
{
  if (! get_page_text()) return;

  gchar *t = NULL;
  gchar *buf = doc_get_sel (cur_text_doc);
  
  if (! buf)
     {
      if (def_mm == MM_HTML || def_mm == MM_XHTML)
          doc_insert_at_cursor (cur_text_doc, "<em></em>");
      else
          if (def_mm == MM_DOCBOOK)
             doc_insert_at_cursor (cur_text_doc, "<emphasis></emphasis>");
      else
          if (def_mm == MM_TEX)
             doc_insert_at_cursor (cur_text_doc, "\\emph{}");
          
      //doc_move_cursor_backw_middle_tags (cur_text_doc);
      //CHECKME: but how doc_move_cursor_backw_middle_tags works if MM_TEX?
     }
  else
      {
       if (def_mm == MM_HTML || def_mm == MM_XHTML)
          { 
           t = g_strconcat ("<em>", buf, "</em", NULL);
           doc_rep_sel (cur_text_doc, t);
           g_free (t);
          }
       else
           if (def_mm == MM_DOCBOOK)      
             { 
              t = g_strconcat ("<emphasis>", buf, "</emphasis>", NULL);
              doc_rep_sel (cur_text_doc, t);
              g_free (t);
             }
        else
           if (def_mm == MM_TEX)      
             { 
              t = g_strconcat ("\\emph{", buf, "}", NULL);
              doc_rep_sel (cur_text_doc, t);
              g_free (t);
             }
      }

  g_free (buf);
}


void on_mni_calendar (GtkMenuItem *menuitem,
                      gpointer user_data)
{
  if (! wnd_calendar)
      wnd_calendar = make_calendar_window ();
  else 
     {
      gtk_widget_destroy (wnd_calendar); 
      wnd_calendar = make_calendar_window ();
     }
}


void on_mni_markup_section (GtkMenuItem *menuitem,
                            gpointer user_data) 
{
  if (! get_page_text()) return;

  gchar *t = NULL;
  gchar *buf = doc_get_sel (cur_text_doc);
  
  if (! buf)
     {
      if (def_mm == MM_DOCBOOK)
         {
          doc_insert_at_cursor (cur_text_doc, "<section>\n<title></title>\n</section>");
          doc_move_cursor_backw_middle_tags (cur_text_doc);
         }
      else 
      if (def_mm == MM_TEX)
         doc_insert_at_cursor (cur_text_doc, "\\section{}");  
     }
  else
      {
       if (def_mm == MM_DOCBOOK)      
          { 
           t = g_strconcat ("<section>", buf, "</section>", NULL);
           doc_rep_sel (cur_text_doc, t);
           g_free (t);
           }
      }
 
  g_free (buf);
}


void on_mni_markup_chap (GtkMenuItem *menuitem,
                         gpointer user_data) 
{
  if (! get_page_text()) return;

  gchar *t = NULL;
  gchar *buf = doc_get_sel (cur_text_doc);
  
  if (! buf)
     {
      if (def_mm == MM_DOCBOOK)
         {
          doc_insert_at_cursor (cur_text_doc, "chapter>\n<title></title>\n</chapter>");
          doc_move_cursor_backw_middle_tags (cur_text_doc);
         }
      else 
      if (def_mm = MM_TEX)
         doc_insert_at_cursor (cur_text_doc, "\\chapter[]{}");  
     }
  else
      {
       if (def_mm == MM_DOCBOOK)      
            { 
             t = g_strconcat ("<chapter>", buf, "</chapter>", NULL);
             doc_rep_sel (cur_text_doc, t);
             g_free (t);
            }
      }
 
  g_free (buf);
}


void on_mni_markup_tex_common (GtkMenuItem *menuitem,
                               gpointer user_data)
{
  if (! get_page_text()) return;
  
  gchar *t = NULL;
  
  t = g_strconcat ("\\", gtk_widget_get_name (menuitem), NULL);
  doc_insert_at_cursor (cur_text_doc, t);
  g_free (t);
}


void on_mni_pdflatex_process (GtkMenuItem *menuitem,
                              gpointer user_data)
{
  if (! get_page_text()) return;
  pdflatex_process (cur_text_doc->file_name_local);
}


void on_mni_close_current_tag (GtkMenuItem *menuitem,
                               gpointer user_data)
{
  if (! get_page_text()) return;
  current_tag_close (cur_text_doc, 1);
}


void on_mni_csv_to_latex_table (GtkMenuItem* menuitem,
                                gpointer user_data)
{
  if (! get_page_text()) return;
  set_fam_text (",");
  
  gchar *buf = doc_get_sel (cur_text_doc);
  gchar *t = separated_table_to_latex_tabular (buf, gtk_entry_get_text (ent_search));

  doc_ins_to_new (t);
   
  g_free (buf);
}


void on_mni_test (GtkMenuItem *menuitem,
                  gpointer user_data)
{
/*
  mni_temp = NULL;
  GtkMenuItem *m = find_menuitem (GTK_CONTAINER (menubar1), "BR");
  if (m)
     //dbm (gtk_widget_get_name (m));
      gtk_menu_item_activate (GTK_MENU_ITEM (m));
*/


  gchar *x = filename_from_xuri ("file:/mnt/user/rox/devel/ltea/test");
  dbm (x);
  g_free (x);
  
}


void on_mni_ins_ast (GtkMenuItem *menuitem,
                     gpointer user_data)
{
  if (! get_page_text ()) return;
  doc_insert_at_cursor (cur_text_doc, "\\begin{center}\n***\\\\\n\\end{center}\n");
} 


static void fam_open (void)
{
  set_fam_text ("noname");

  gchar *lf = get_l_filename (gtk_entry_get_text (ent_search));
  g_strstrip (lf);

  gchar *x = filename_from_xuri (lf); 
  
  cur_settings.selected_enc = ch_str (cur_settings.selected_enc, confile.default_charset); 
  open_file_std (x);
                 
  g_free (x);
  g_free (lf);
}


void on_bt_open (GtkButton *button,
                 gpointer user_data)
{
  fam_open ();
}


void on_mni_fam_open (GtkMenuItem *menuitem,
                      gpointer user_data)
{
  fam_open ();
} 
