/***************************************************************************
 *   Copyright (C) 2007-2010 by Peter Semiletov                            *
 *   peter.semiletov@gmail.com                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef UTILS_H
#define UTILS_H

#include <QtGui>


typedef struct {
                char chunk_id[4];
                quint32 chunk_size;
               } t_wav_chunk_hdr;


typedef struct {
                quint16 format;      // = 1 (PCM/uncompressed)
                quint16 num_channels; // mono = 1, stereo = 2, etc
                quint32 sample_rate;  // 8000, 44100, 48000 etc
                quint32 byte_rate;    // SampleRate * NumChannels * BitsPerSample/8
                quint16 block_align;  // NumChannels * BitsPerSample / 8
                quint16 bits_per_sample; //8, 16 etc
               } t_wav_chunk_fmt;



class CFilesList: public QObject
{
public:

  QStringList list;

  void get (const QString &path);
  void iterate (QFileInfo &fi);
};


class CFTypeChecker: public QObject
{
public:

  QStringList lexts;
  QStringList lnames;

  CFTypeChecker (const QString &fnames, const QString &exts);
  bool check (const QString &fname);
};


class CWavReader: public QObject
{
public:

  t_wav_chunk_fmt wav_chunk_fmt;
  double rms;
  bool get_info (const QString fname);
};

QString hash_keyval_to_string (const QHash<QString, QString> &h);
QString hash_get_val (QHash<QString, QString> &h, const QString &key, const QString &def_val);

QString file_get_ext (const QString &file_name);

bool file_exists (const QString &fileName);
void qstring_list_print (const QStringList &l);

bool qstring_save (const QString &fileName, const QString &data, const char *enc = "UTF-8");
QString qstring_load (const QString &fileName, const char *enc = "UTF-8");

QString toggle_fname_header_source (const QString &fileName);


void create_menu_from_list (QObject *handler,
                            QMenu *menu,
                            const QStringList &list,
                            const char *method
                           );

QString mod_to_string (Qt::KeyboardModifiers k);
QStringList read_dir_entries (const QString &path);
QStringList html_get_by_patt (const QString &s, const QString &spatt);
QHash<QString, QString> hash_load (const QString &fname);
QHash<QString, QString> hash_load_keyval (const QString &fname);
QHash<QString, QString> stringlist_to_hash (const QStringList &l);
QString hash_keyval_to_string (QHash<QString, QString> *h);
bool is_image (const QString &filename);
QString keycode_to_string (int k);
QString string_between (const QString &source, const QString &sep1, const QString &sep2);
QByteArray file_load (const QString &fileName);

bool char_is_shit (const QChar &c);

void create_menu_from_dir (QObject *handler,
                           QMenu *menu,
                           const QString &dir,
                           const char *method
                           );

QImage image_scale_by (const QImage &source,
                       bool by_side,
                       int value,
                       Qt::TransformationMode mode);

QString change_file_ext (const QString &s, const QString &ext);
QStringList bytearray_to_stringlist (QList <QByteArray> a);
QString qstring_get_last_after (const QString &s, const QString &sep);
QString int_to_binary (int n);
QString string_reverse (const QString &s);
unsigned int bin_to_decimal (const QString &s);
QString get_insert_image (const QString &file_name, const QString &full_path, const QString &markup_mode);


inline int get_value (int total, int perc)
{
  return static_cast <int> (total * perc / 100);

}


inline double get_percent (double total, double value)
{
  return (value / total) * 100;
}


inline bool is_dir (const QString &path)
{
  return QFileInfo(path).isDir();
}


inline QString get_file_path (const QString &fileName)
{
  return QFileInfo (fileName).absolutePath();
}

#endif
