 /**************************************************************************
 *   Copyright (C) 2007-2009 by Peter Semiletov                            *
 *   peter.semiletov@gmail.com                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef RVLN_H
#define RVLN_H


#include <QtGui>
#include <QtScript>


#include "document.h"
#include "fman.h"
#include "shortcuts.h"
#include "img_viewer.h"


#ifdef SPELLCHECK_ENABLE

#include "spellchecker.h"

#endif




class CMarkupPair: public QObject
{
  Q_OBJECT

public:

  QHash <QString, QString> tags_a;
  QHash <QString, QString> tags_b;

};


class CStrIntPair: public QObject
{
  Q_OBJECT

public:

  QString string_value;
  int int_value;
   
  CStrIntPair (const QString &s, int i);
};  


class CAboutWindow: public QWidget
{
  Q_OBJECT

  QLabel *logo;
  
public:

  CAboutWindow();

protected:

  void closeEvent (QCloseEvent *event);
  
public slots:

  void update_image();
  
};


class CReloadWindow: public QWidget
{
  Q_OBJECT

public:

  QListWidget *list;
  
  CReloadWindow (const QStringList &all, const QStringList &used);

protected:

  void closeEvent (QCloseEvent *event);
};


class rvln: public QMainWindow
{
  Q_OBJECT

public:

  rvln();
  ~rvln();

  int fm_entry_mode; 
    
  CLogMemo *log;
  CShortcuts *shortcuts;
  CFMan *fman;
  CImgViewer *img_viewer;

  document_holder *documents;


#ifdef SPELLCHECK_ENABLE

  ASpellchecker *spellchecker;
  QStringList spellcheckers;
  QString cur_spellchecker;

#endif
  

  
  bool b_preview;
  
  int idx_tab_edit;
  int idx_tab_tune;
  int idx_tab_fman;
  int idx_tab_learn;
  int idx_prev;
  
  int fman_find_idx;
  QList<QStandardItem *> l_fman_find;
  
  int pbar_step;
  bool ui_update;

  QScriptEngine script_engine;
  QHash <QString, CMarkupPair*> hs_markup;

  QToolBar *tb_fman_dir;
  QLabel *l_fman_preview;
  QTimer timer;

  QStringList sl_places_bmx;
  QStringList sl_urls;
  QStringList sl_charsets;
  QStringList sl_last_used_charsets;

  QHash <QString, QString> programs;
  QHash <QString, QString> places_bookmarks;

  QTranslator myappTranslator;
  QTranslator qtTranslator;

  QDir dir_lv;

  QCompleter *cmpl_fif;
  QStandardItemModel *cmpl_fif_model;

  QLineEdit *ed_man_search;
  QString man_search_value;

  QString markup_mode;
  QPrinter printer;

  QSettings *settings;

  QString opt_shortcuts_string_to_find;
  QString fman_fname_to_find;

  QString dir_user_dict;
  
  QString dir_last;
  QString dir_config;
  QString dir_templates;
  QString dir_sessions;
  QString dir_hls;

  QString dir_snippets;
  QString dir_scripts;
  QString dir_palettes;
  QString dir_tables;
  
  QString fname_def_palette;
  QString fname_hls_cache;

  QString fname_fif;

  QString fname_bookmarks;
  QString fname_programs;
  QString fname_places_bookmarks;

  QString bookmarks;
  QString fname_crapbook;
  QString fname_tempfile;
  QString fname_tempparamfile;

  QLabel *l_status;
  QProgressBar *pb_status;
  QLineEdit *ed_spellcheck_path;

protected:

  void closeEvent (QCloseEvent *event);
  bool fman_tv_eventFilter (QObject *obj, QEvent *event);

private slots:

/*************************
main window callbacks
*************************/

  void fm_full_info();

  void fm_hashsum_md5();
  void fm_hashsum_md4();
  void fm_hashsum_sha1();

  void fman_refresh();
  void fman_rename();
  void fman_delete();
  void fman_drives_changed (const QString & path);
  void fman_current_file_changed (const QString &full_path, const QString &just_name);
  void fman_file_activated (const QString &full_path);
  void fman_dir_changed (const QString &full_path);
  void fman_fname_entry_confirm();
  void fman_create_dir();
  void fman_add_bmk();
  void fman_del_bmk();
  void fman_open();
  void fman_home();
  void fman_places_itemActivated (QListWidgetItem *item);

  void cb_button_saves_as();

  void pageChanged (int index);

  void iterate_pbar();
  void file_print();

  void newFile();
  void open();
  void open_at_cursor();

  void file_reload();
  void file_reload_enc_itemDoubleClicked ( QListWidgetItem *item); 
  void file_reload_enc();
  void file_open_bookmarks_file();
  void file_open_programs_file();
  void file_find_obsolete_paths();


  void file_last_opened();
  void file_open_bookmark();
  void file_open_program();
  void file_add_to_bookmarks();
  void file_crapbook();
  void file_use_template();
  void file_use_snippet();
  void file_use_palette();
  void file_use_hl();
  void file_open_session();
  void file_save_version();
  void file_save_bak();
  void test();

  bool save();
  bool saveAs();

  void toggle_wrap();

  void about();
  void close_current();

  void ed_copy();
  void ed_paste();
  void ed_cut();

  void ed_undo();
  void ed_redo();
  void ed_clear();

  void ed_indent();
  void ed_unindent();
  
  void upCase();
  void dnCase();

  void edit_copy_current_fname();

  void fn_count();
  void fn_count_rx();

  void fn_enum();
  void fn_filter_with_regexp();
  void fn_text_stat();
  void fn_antispam_email();
  void fn_apply_to_each_line();
  void fn_reverse();
  void fn_escape();

  void fn_evaluate();
  void fn_sort_casecare();
  void fn_sort_casecareless();

  void fn_flip_a_list();
  void fn_insert_loremipsum();
  void fn_insert_template_html();
  void fn_run_script();
  void cb_script_finished (int exitCode, QProcess::ExitStatus exitStatus);
  void fn_number_arabic_to_roman();
  void fn_number_roman_to_arabic();
  void fn_filter_rm_less_than();
  void fn_filter_rm_greater_than();
  void fn_filter_rm_duplicates();
  void fn_filter_rm_empty();
  void fn_rm_formatting();
  void fn_convert_quotes();
  void fn_get_words_count();
  void fn_unitaz_abc();
  void fn_extract_words();
  void fn_morse_from_en();
  void fn_morse_to_en();
  void fn_morse_from_ru();
  void fn_morse_to_ru();
  void fn_insert_date();
  void fn_insert_time();
  void fn_rm_formatting_at_each_line();
  void fn_rm_trailing_spaces();

  void fn_strip_html_tags();
  void fn_number_decimal_to_binary();
  void fn_number_flip_bits();
  void fn_binary_to_decimal();
  
  void remove_formatting();

#ifdef SPELLCHECK_ENABLE

  void fn_change_spell_lang();
  void fn_spell_check();
  void fn_spell_suggest_callback();
  void fn_spell_add_to_dict();
  void fn_remove_from_dict();

  void fn_spell_suggest();

  void cmb_spellchecker_currentIndexChanged (const QString &text);

#ifdef HUNSPELL_ENABLE
  void pb_choose_hunspell_path_clicked();
#endif

#endif

  void mrkup_bold();
  void mrkup_italic();
  void mrkup_underline();
  void mrkup_link();
  void mrkup_para();
  void mrkup_preview_color();
  void mrkup_br();
  void mrkup_nbsp();
  void mrkup_tags_to_entities();
  void mrkup_mode_choosed();
  void mrkup_header();
  void mrkup_align();
  void mrkup_document_weight();
  void markup_ins_image();
  void mrkup_color();
  void mrkup_text_to_html();

  void search_find();
  void search_find_next();
  void search_find_prev();
  void search_replace_with();
  void search_replace_all();
  void search_replace_all_at_ofiles();

  void view_preview_in_bro();
  void view_hide_error_marks();
  void view_toggle_fs();
  void view_stay_on_top();

  void nav_goto_line();
  void nav_goto_right_tab();
  void nav_goto_left_tab();
  void nav_toggle_hs();
  void nav_save_pos();
  void nav_goto_pos();
  void nav_focus_to_fif();
  void nav_focus_to_editor();

  void help_show_gpl();
  void help_show_news();
  void help_show_changelog();
  void help_show_todo();

  void session_save_as();

  void main_tab_page_changed (int index);

  void fn_use_table();

/*************************
prefs window callbacks
*************************/

  void man_find_find();
  void man_find_next();
  void man_find_prev();

  void cmb_output_image_fmt_currentIndexChanged (const QString &text);

  void cb_locale_override (int state);
  void ed_locale_override_editingFinished ();
  void cb_session_restore (int state);
  void cb_wordwrap_changed (int state);
  void cb_hl_brackets_changed (int state);
  void cb_use_trad_dialogs_changed (int state);
  void cb_spaces_instead_of_tabs_changed (int state);
  void slot_tab_sp_width_changed (int i); 

  void cb_auto_img_preview_changed (int state);

  void pb_assign_hotkey_clicked();
  void pb_remove_hotkey_clicked();
  void slot_lv_menuitems_currentItemChanged (QListWidgetItem *current, QListWidgetItem *previous);
  void slot_app_fontname_changed (const QString &text);
  void slot_editor_fontname_changed (const QString &text);
  void slot_font_size_changed (int i);
  void cb_auto_indent_changed (int state);
  void cb_use_hl_wrap_changed (int state);

  void slot_app_font_size_changed (int i);
  void slot_style_currentIndexChanged (const QString &text);
  void slot_sl_icons_size_sliderMoved (int value);
  void ed_date_format_editingFinished();
  void ed_time_format_editingFinished();

  void cb_hl_current_line_changed (int state);
  void cb_cursor_xy_visible_changed (int state);
  void cb_img_filter (int state);
  void cb_img_post_proc (int state);
  void slot_img_quality_changed (int i);

  void cb_show_margin_changed (int state);
  void margin_pos_changed (int i);
  void cb_cursor_center_on_scroll (int state);

  
////////////////////////////  
  
  
  
  
  void fman_naventry_confirm();
  void fman_img_conv_by_side();
  void fman_img_conv_by_percent();
  void fman_create_zip();
  void fman_add_to_zip();
  void fman_save_zip();
  void fman_preview_image();

private:

/*************************
main window widgets
*************************/

  QSplitter *mainSplitter;
  QTextBrowser *man;
  QPlainTextEdit *log_memo;
  QString charset;

  QTabWidget *main_tab_widget;
  QTabWidget *tab_options;
  QTabWidget *tab_browser;
  QTabWidget *tab_widget;
  QLineEdit *fif;

  QMenu *fileMenu;
  QMenu *editMenu;

  QMenu *menu_file_edit_bookmarks;

  QMenu *menu_file_configs;
  QMenu *menu_file_sessions;
  QMenu *menu_file_actions;
  QMenu *menu_file_bookmarks;
  QMenu *menu_file_templates;
  QMenu *menu_programs;
  QMenu *menu_fn_snippets;
  QMenu *menu_fn_tables;
  QMenu *menu_view_palettes;
  QMenu *menu_view_hl;
  QMenu *menu_fn_sessions;
  QMenu *menu_fn_scripts;
  QMenu *menu_markup;
  QMenu *menu_functions;
  QMenu *menu_functions_case;
  QMenu *menu_file_recent;
  QMenu *menu_search;
  QMenu *menu_nav;
  QMenu *menu_fm;
  QMenu *menu_fm_file_ops;
  QMenu *menu_fm_file_infos;
  QMenu *menu_fm_img_conv;
  QMenu *menu_fm_zip;
  QMenu *menu_view;
  QMenu *menu_spell_langs;
  QMenu *helpMenu;

  QToolBar *fileToolBar;
  QToolBar *editToolBar;

  QAction *act_test;
  QAction *newAct;
  QAction *openAct;
  QAction *saveAct;
  QAction *saveAsAct;
  QAction *exitAct;
  QAction *cutAct;
  QAction *copyAct;
  QAction *closeAct;
  QAction *undoAct;
  QAction *redoAct;
  QAction *pasteAct;
  QAction *aboutAct;
  QAction *aboutQtAct;
  QAction *menu_find_whole_words;
  QAction *menu_find_case;
  QAction *menu_find_regexp;

  QWidget *w_right;
  QLineEdit *ed_fman_fname;
  QComboBox *cb_fman_codecs;
  QComboBox *cb_fman_drives;

/*************************
prefs window widgets
*************************/

  QLineEdit *ed_img_post_proc;

  QLineEdit *ed_date_format;
  QLineEdit *ed_time_format;
  QLineEdit *ed_locale_override;

  CShortcutEntry *ent_shtcut;
  QListWidget *lv_menuitems;

  QFontComboBox *cmb_font_name;
  QSpinBox *spb_font_size;

  QFontComboBox *cmb_app_font_name;
  QSpinBox *spb_app_font_size;

  QLineEdit *ed_fman_path;
  QListWidget *lv_places;
  QSplitter *spl_fman;

//main window functions

  QAction* add_to_menu (QMenu *menu,
                        const QString &caption,
                        const char *method,
                        const QString &shortkt = QString(),
                        const QString &iconpath = QString()
                        );


  void update_dyn_menus();
  void create_paths();
  

#ifdef SPELLCHECK_ENABLE

  void setup_spellcheckers();
  void create_spellcheck_menu();

#endif

  void init_jengine();
  void handle_args();

  void create_main_widget();
  void createActions();
  void createMenus();
  void createOptions();
  void createManual();
  void updateFonts();
  void update_bookmarks();
  void update_templates();
  void update_snippets();
  void update_sessions();
  void update_palettes();
  void update_view_hls();

  void update_hls (bool force = false);

  void update_tables();
  void update_scripts();
  void update_places_bookmarks();
  void update_programs();
  void update_logmemo_palette();

  void update_charsets();
  void createToolBars();
  void createStatusBar();
  void readSettings();
  void writeSettings();

  void completer_init();

  void read_search_options();
  void write_search_options();

  void dragEnterEvent (QDragEnterEvent *event);
  void dropEvent (QDropEvent *event);
  void add_to_last_used_charsets (const QString &s);

  void createFman();
  void create_markup_hash();

  void count_substring (bool use_regexp);
  void fn_filter_less_greater (bool less);

  void run_unitaz (int mode);
  void run_js_script (const QString &fname);

  void cmpl_fif_model_add (const QString &value);

  void fif_model_read();
  void fif_model_write();

  QTextDocument::FindFlags get_search_options();
  void fman_convert_images (bool by_side, int value);

  QString fif_get_text();

  void fman_find();
  void fman_find_next();
  void fman_find_prev();

  
  void opt_update_keyb();
  
  void opt_shortcuts_find();
  void opt_shortcuts_find_next();
  void opt_shortcuts_find_prev();
};


class CApplication: public QApplication
{
  Q_OBJECT

public:

  CApplication (int &argc, char **argv): QApplication (argc, argv)
               {}

  void saveState (QSessionManager &manager);
};

#endif
