/***************************************************************************
                          image_browser.c  -  description
                             -------------------
    begin                : 11.02.2005
    copyright            : (C)2005-2006 by Peter 'Roxton' Semiletov
    email                : peter.semiletov@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <string.h>
#include <sys/stat.h>
#include <gdk/gdkkeysyms.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include <stddef.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <glib/gi18n.h>

#include "tea_defs.h"
#include "rox_strings.h"
#include "tea_config.h"
#include "image_browser.h"
#include "tea_gtk_utils.h"
#include "interface.h"
#include "md5-util.h"
#include "tea_tree_view.h"
#include "tea_funx.h" //Needed for insert_image


//static gchar *dir_name;

void image_plane_free (t_image_plane *instance)
{
  dbm ("image_plane_free");
  glist_strings_free (instance->gl_thumbs);
  g_free (instance->directory);
  g_free (instance);
}


static gboolean on_viewer_key_press_event (GtkWidget *widget,
                                           GdkEventKey *event,
                                           gpointer user_data)
{
  t_image_viewer *instance = user_data;

  if (event->keyval == GDK_Escape)
    {
     image_viewer_free (user_data); //new
     gtk_widget_destroy (widget);
     return TRUE;
    }


  if (event->keyval == GDK_KP_Add)
    {
     GdkPixbuf *x = gtk_image_get_pixbuf (instance->image);
     gint w = gdk_pixbuf_get_width (x);

   //  GdkPixbuf *p = gdk_pixbuf_new_from_file_at_scale (instance->filename, w + 50,
     //                                                  -1, TRUE, NULL);
     GdkPixbuf *p = gdk_pixbuf_new_from_file_at_size (instance->filename, w + 50,
                                                       -1, NULL);

     gtk_image_set_from_pixbuf (instance->image, p);
    }

  if (event->keyval == GDK_KP_Subtract)
    {
     GdkPixbuf *x = gtk_image_get_pixbuf (instance->image);
     gint w = gdk_pixbuf_get_width (x);

     //GdkPixbuf *p = gdk_pixbuf_new_from_file_at_scale (instance->filename, w - 50,
      //                                                 -1, TRUE, NULL);
   GdkPixbuf *p = gdk_pixbuf_new_from_file_at_size (instance->filename, w - 50,
                                                       -1, NULL);


     gtk_image_set_from_pixbuf (instance->image, p);

     gtk_window_resize (instance->wnd_image, gdk_pixbuf_get_width (p), gdk_pixbuf_get_height (p));
    }

  return FALSE;
}


static gint button_press_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
  t_image_plane *instance = user_data;

  if (event->button == 1)
     if (event->type == GDK_2BUTTON_PRESS)
        {
         GtkTreeSelection *sl = gtk_tree_view_get_selection (GTK_TREE_VIEW (widget));
         GtkTreeModel *model;
         GtkTreeIter iter;

         if (gtk_tree_selection_get_selected (sl, &model, &iter))
            {
             gchar *name;
             gtk_tree_model_get (model, &iter, COL_TEXT_CELL, &name, -1);

             if (! name)
                return FALSE;

             gchar *f = g_strconcat (instance->directory, G_DIR_SEPARATOR_S, name, NULL);

             if (gtk_toggle_button_get_active (&cb_imgplane_mode_sw->toggle_button))
                insert_image (f);
             else
                 {
                  t_image_viewer *v = image_viewer_create (f);
                 }

             g_free (f);
             g_free (name);
             return TRUE;
            }
        }

  return FALSE;
}




static gboolean on_image_viewer_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
  image_viewer_free (user_data); //new

  dbm ("on_image_viewer_delete_event");
  return FALSE;
}


t_image_viewer* image_viewer_create (const gchar *filename)
{
  if (! filename)
     return NULL;

  t_image_viewer *instance =  g_malloc (sizeof (t_image_viewer));
  instance->filename = g_strdup (filename);
  instance->wnd_image = create_wnd_imgviewer (instance);

  g_signal_connect (instance->wnd_image, "key_press_event",
                    G_CALLBACK (on_viewer_key_press_event),
                    instance);

  g_signal_connect (instance->wnd_image, "delete_event",
                    G_CALLBACK (on_image_viewer_delete_event),
                    instance);
}


void image_viewer_free (t_image_viewer *instance)
{
  dbm ("image_viewer_free");
  g_free (instance->filename);
  g_free (instance);
}


GtkWidget* create_wnd_imgviewer (t_image_viewer *instance)
{
  if (! instance)
     return NULL;

  if (! g_file_test (instance->filename, G_FILE_TEST_EXISTS))
     return NULL;

  GtkWidget *wnd_imgviewer = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  GtkWidget *image = gtk_image_new_from_file (instance->filename);
  gtk_container_add (GTK_CONTAINER (wnd_imgviewer), image);
  gtk_widget_show (image);
  instance->image = image;

  gtk_widget_show (wnd_imgviewer);
  gchar *t = g_path_get_basename (instance->filename);
  gtk_window_set_title (wnd_imgviewer, t);
  g_free (t);

  return wnd_imgviewer;
}

static gboolean on_imageplane_key_press_event (GtkWidget *widget,
                                           GdkEventKey *event,
                                           gpointer user_data)
{
  if (event->keyval == GDK_Escape)
    {
     image_plane_free (user_data);
     gtk_widget_destroy (widget);
     return TRUE;
    }
}


static gboolean on_imageplane_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
  image_plane_free (user_data);

  dbm ("on_imageplane_delete_event");
  return FALSE;
}


t_image_plane* create_image_plane (const gchar *dir)
{
  t_image_plane *instance = g_malloc (sizeof (t_image_plane));
  instance->gl_thumbs = NULL;

  instance->directory = g_strdup (dir);
  instance->wnd_imageplane = create_image_browser (instance);

  g_signal_connect (instance->wnd_imageplane, "key_press_event",
                    G_CALLBACK (on_imageplane_key_press_event),
                    instance);

  g_signal_connect (instance->wnd_imageplane, "delete_event",
                    G_CALLBACK (on_imageplane_delete_event),
                    instance);


}


GtkWidget* create_image_browser (t_image_plane *instance)
{
  if (! instance)
     return NULL;

  GtkWidget *tvb;
  gchar *filename;
  gchar *utf;

  GdkPixbuf *pixbuf;
  guchar digest[16];
  gchar *thumb_filename;
  gchar *md5sum = NULL;
  gchar *uri = NULL;
  gdouble val;

  GtkWidget *wnd = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_window_set_title (wnd, "Imageplane");

  g_signal_connect (G_OBJECT (wnd), "key_press_event", G_CALLBACK (win_key_handler), wnd);

  gtk_window_set_transient_for (wnd, tea_main_window);
  gtk_window_set_default_size (wnd, -1, gdk_screen_height ());
  gtk_window_move (wnd, 1, 1);
  gtk_widget_show (wnd);

  GtkWidget *vbox1 = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (wnd), vbox1);

  cb_imgplane_mode_sw = tea_checkbox (vbox1, _("Insert tags"), confile.implane_ins_image);
  gtk_tooltips_set_tip (tooltips,
                        cb_imgplane_mode_sw,
                        _("Insert the tag rather than view image"),
                        NULL);

  instance->tree_view = tv_create_tree (vbox1, GTK_SELECTION_SINGLE);

  instance->pb = gtk_progress_bar_new ();
  gtk_widget_show (instance->pb);
  gtk_box_pack_start (vbox1, instance->pb, FALSE, FALSE, UI_PACKFACTOR);
  image_browser_update (instance);

  g_signal_connect (GTK_OBJECT (instance->tree_view), "button_press_event",
                   (GtkSignalFunc) button_press_event, instance);

  return wnd;
}


void image_browser_update (t_image_plane *instance)
{
  if (! instance)
     return NULL;

  gchar *filename;
  gchar *utf;

  GdkPixbuf *pixbuf;
  guchar digest[16];
  gchar *thumb_filename;
  gchar *md5sum = NULL;
  gchar *uri = NULL;
  gdouble val;

  glist_strings_free (instance->gl_thumbs);
  instance->gl_thumbs = read_dir_to_glist (instance->directory);
  gint len;
  gint c = 0;
  if (instance->gl_thumbs)
     {
      GtkListStore *liststore = gtk_tree_view_get_model (GTK_TREE_VIEW (instance->tree_view));

      if (liststore)
        gtk_list_store_clear (liststore);

      len = g_list_length (instance->gl_thumbs) - 1;

      GList *t = g_list_first (instance->gl_thumbs);
      while (t)
           {
            if (is_image (t->data))
               {
                while (gtk_events_pending ())
                    gtk_main_iteration ();

                val = ((gdouble)++c / (gdouble)(len - 0.999));
                if (val > 1.0)
                   val = 0.0;
                gtk_progress_bar_set_fraction (instance->pb, val);

                uri = g_strconcat ("file://", t->data, NULL);
                md5_get_digest (uri, strlen (uri), digest);

                md5sum = md5_digest_to_text (digest);

                if (md5sum)
                  {
                   thumb_filename = g_strconcat (confile.dir_thumbs, G_DIR_SEPARATOR_S, md5sum, ".png", NULL);
                   if (g_file_test (thumb_filename, G_FILE_TEST_EXISTS))
                       pixbuf = gdk_pixbuf_new_from_file (thumb_filename, NULL);
                   else
                       pixbuf = gdk_pixbuf_new_from_file_at_size (t->data, confile.thumb_width, confile.thumb_height, NULL);
                  }
                else
                    pixbuf = gdk_pixbuf_new_from_file_at_size (t->data, confile.thumb_width, confile.thumb_height, NULL);

                g_free (uri);
                g_free (md5sum);
                g_free (thumb_filename);

                filename = g_path_get_basename (t->data);
                utf = get_8_filename (filename);

                tv_add_new_item_img (instance->tree_view, utf, pixbuf);

                g_free (filename);
                g_free (utf);
               }

             t = g_list_next (t);
            }
     }

  gtk_progress_bar_set_fraction (instance->pb, 0);
}
