/***************************************************************************
                          tea_findfiles.c  -  description
                             -------------------
    begin                : 
    copyright            : (C) 2006 by Peter 'Roxton' Semiletov
    email                : peter.semiletov@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <glib/gi18n.h>

#include "tea_findfiles.h"
#include "tea_defs.h"
#include "tea_text_document.h"
#include "interface.h"
#include "tea_gtk_utils.h"
#include "tea_config.h"
#include "tea_funx.h"
#include "rox_strings.h"


static gboolean pb_bounce (gpointer data)
{
  gtk_progress_bar_pulse (pb_progress_bar);
  return TRUE;
}


static void pb_start (void)
{
  id_pb = g_timeout_add (100, pb_progress_bar, NULL);
  gtk_widget_show (pb_status);
  gtk_progress_bar_pulse (pb_status);
}


static void pb_stop (void)
{
  gtk_progress_bar_set_fraction (pb_progress_bar, 0.0);
  g_source_remove (id_pb);
  gtk_widget_hide (pb_progress_bar);
}



static gint button_press_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
  if (event->button == 1) 
     if (event->type == GDK_2BUTTON_PRESS)
        {
         gchar *s = tv_get_selected_single (tv_found_files);
         if (s) 
            {
             gchar *l = get_l_filename (s);
             execute_recent_item (l);
             g_free (l);
             return TRUE;
            }
         }
  return FALSE;
}


gchar* strinfile (gchar *filename, gchar *text_to_find)
{
  gchar *buf = str_file_read (filename);
  if (! buf)
     return NULL;

  gchar *converted_text;
  gchar *pos = NULL;

  GList *l = g_list_first (confile.iconv_encs);
  while (l)
        {
         //if (strstr (l->data, "autodetect"))
           //continue;

        //dbm (l->data); 

        converted_text = tea_convert_charset (text_to_find, "UTF-8", l->data);

        if (converted_text)
           {
            pos = strstr (buf, converted_text);
            if (pos)
              {
               pos = recent_item_compose (filename /* UTF-8!*/, l->data, 0);
               g_free (converted_text);
               break;
              }
           }

        g_free (converted_text);
        l = g_list_next (l);
        }


  g_free (buf);
  return pos;
}


gchar* strinfile_office (gchar *filename, gchar *text_to_find)
{
  gchar *buf = NULL;
  if (check_ext (filename, ".sxw") || check_ext (filename, ".odt"))
     buf = read_xml_text (filename, "content.xml", "text:p");
  else
      if (check_ext (filename, ".abw"))
         buf = read_abw_text (filename, filename, "p");
      else
          if (check_ext (filename, ".kwd"))
             buf = read_xml_text (filename, "maindoc.xml", "TEXT");

  if (! buf)
     return NULL;

  gchar *pos = NULL;

  pos = strstr (buf, text_to_find);
  if (pos)
      pos = recent_item_compose (filename, "UTF-8", 0);

  g_free (buf);

  return pos;
}


GList* find_in_files (GList *files, gchar *text_to_find)
{
  mpb_start ();

  GList *result = NULL;
  GList *l = g_list_first (files);
  gchar *t = NULL;
  while (l)
       {
        gtk_progress_bar_set_text (pb_progress_bar, l->data);
        gtk_progress_bar_pulse (pb_status);

        if (! is_office(l->data))
           t = strinfile (l->data, text_to_find);
        else
            t = strinfile_office (l->data, text_to_find);

        if (t)
            result = g_list_prepend (result, t);

        l = g_list_next (l);
       }

  mpb_stop ();

  return result;
}


static void on_button_find (GtkWidget *wid, gpointer data)
{
  gchar *text = gtk_entry_get_text (ent_text_to_find);
  if (! text)
      return;

  gchar *dir = gtk_entry_get_text (ent_dir_where_to_find);
  if (! dir)
      return;

  GError *error = NULL;
  gl_found_files = NULL;

  pb_start ();

dbm ("11");


  read_dir_files_recurse (dir, gtk_entry_get_text (ent_pattern));

dbm ("22");


  pb_stop ();

  gtk_widget_show (ffstatusbar);

  dbm ("read_dir_files_recurse - done");

  GList *lx = find_in_files (gl_found_files, gtk_entry_get_text (ent_text_to_find));

  dbm ("find_in_files - done");

  //glist_print (lx); 

  tv_fill_with_glist (tv_found_files, lx);

  glist_strings_free (lx);
}


static void on_button_savelist (GtkWidget *wid, gpointer data)
{
  GtkWidget *dialog = gtk_file_chooser_dialog_new (_("File save"), NULL, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                                  GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL);

  gchar *filename = NULL;

  if (gtk_dialog_run (dialog) == GTK_RESPONSE_ACCEPT)
     filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
  else
      {
       gtk_widget_destroy (dialog);
       return;
      }

  gtk_widget_destroy (dialog);

  GList *l = tv_get_list_data (tv_found_files);
  GList *save = NULL;
  while (l)
        {
         save = g_list_prepend (save, get_l_filename (l->data));
         l = g_list_next (l);
        }

  glist_save_to_file (save, filename);
  glist_strings_free (save);
}


static void on_button_loadlist (GtkWidget *wid, gpointer data)
{

  GtkWidget *dialog = gtk_file_chooser_dialog_new (_("File open"), NULL, GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                                  GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);

  gchar *filename = NULL;

  if (gtk_dialog_run (dialog) == GTK_RESPONSE_ACCEPT)
     filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
  else
      {
       gtk_widget_destroy (dialog);
       return;
      }

  gtk_widget_destroy (dialog);

  GList *l = load_file_to_glist (filename);
  tv_fill_with_glist (tv_found_files, l); 

  glist_strings_free (l);
}



static void on_button_savesession (GtkWidget *wid, gpointer data)
{
  GtkWidget *dialog = gtk_file_chooser_dialog_new (_("File save"), NULL, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                                  GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL);

   gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), confile.sessions_dir);

   gchar *filename = NULL;

  if (gtk_dialog_run (dialog) == GTK_RESPONSE_ACCEPT)
     filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
  else
      return;

  gtk_widget_destroy (dialog);

  GList *l = tv_get_list_data (tv_found_files);
  GList *save = NULL;
  while (l)
        {
         save = g_list_prepend (save, get_l_filename (l->data));
         l = g_list_next (l);
        }

  glist_save_to_file (save, filename);
  glist_strings_free (save);
  reload_sessions ();
}


GtkWidget* create_findfiles (void)
{
  GtkWidget *window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window1), _("Find in files"));

  vbox1 = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (window1), vbox1);

  hbox1 = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, UI_PACKFACTOR);

  ent_text_to_find = tea_text_entry (hbox1, _("Text to find"), NULL);

  gchar *ft = get_clipboard_text ();

  if (ft)
      gtk_entry_set_text (ent_text_to_find, g_strstrip (ft));

  g_free (ft);

  ent_dir_where_to_find = tea_dir_selector2 (hbox1, "And where to find?", g_get_home_dir ());

  ent_pattern = tea_text_entry (hbox1, _("File pattern"), "*.txt");

  //ent_text_to_replace = tea_text_entry (hbox1, _("Replace with"), NULL);

  GtkWidget *hbox4 = gtk_hbox_new (TRUE, UI_PACKFACTOR);
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox4, FALSE, FALSE, UI_PACKFACTOR);

  GtkWidget *bt_find = gtk_button_new_with_label (_("Find")); 
  gtk_widget_show (bt_find);
  gtk_box_pack_start (GTK_BOX (hbox4), bt_find, FALSE, FALSE, UI_PACKFACTOR);

  g_signal_connect ((gpointer) bt_find, "clicked",
                    G_CALLBACK (on_button_find),
                    NULL);

  GtkWidget *bt_savelist = gtk_button_new_with_label (_("Save a list")); 
  gtk_widget_show (bt_savelist);
  gtk_box_pack_start (GTK_BOX (hbox4), bt_savelist, FALSE, FALSE, UI_PACKFACTOR);

  g_signal_connect ((gpointer) bt_savelist, "clicked",
                    G_CALLBACK (on_button_savelist),
                    NULL);

  GtkWidget *bt_loadlist = gtk_button_new_with_label (_("Load a list")); 
  gtk_widget_show (bt_loadlist);
  gtk_box_pack_start (GTK_BOX (hbox4), bt_loadlist, FALSE, FALSE, UI_PACKFACTOR);

  g_signal_connect ((gpointer) bt_loadlist, "clicked",
                    G_CALLBACK (on_button_loadlist),
                    NULL);

  GtkWidget *bt_savesession = gtk_button_new_with_label (_("Save as a session")); 
  gtk_widget_show (bt_savesession);
  gtk_box_pack_start (GTK_BOX (hbox4), bt_savesession, FALSE, FALSE, UI_PACKFACTOR);

  g_signal_connect ((gpointer) bt_savesession, "clicked",
                    G_CALLBACK (on_button_savesession),
                    NULL);


  GtkWidget *hbox3 = gtk_hbox_new (TRUE, UI_PACKFACTOR);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox3, FALSE, TRUE, UI_PACKFACTOR);


  tv_found_files = tv_create_framed (hbox1, _("Found files"), GTK_SELECTION_SINGLE);


  g_signal_connect (GTK_OBJECT (tv_found_files), "button_press_event",
                     (GtkSignalFunc) button_press_event, NULL);


  ffstatusbar = gtk_statusbar_new ();
  gtk_widget_show (ffstatusbar);
  gtk_box_pack_start (GTK_BOX (vbox1), ffstatusbar, FALSE, FALSE, UI_PACKFACTOR);

  //b.p. Scorn - Whine - Strand

  pb_progress_bar = gtk_progress_bar_new ();
  gtk_box_pack_start (GTK_BOX (ffstatusbar), pb_progress_bar, FALSE, FALSE, UI_PACKFACTOR);
  gtk_progress_bar_set_pulse_step (pb_progress_bar, 0.05);
  gtk_widget_show (ffstatusbar);


 // g_signal_connect (G_OBJECT (window1), "key_press_event", G_CALLBACK (win_key_handler), window1);


/*
  g_signal_connect (GTK_OBJECT(window1),
                    "destroy",
                     GTK_SIGNAL_FUNC (gtk_widget_destroyed),
                     &window1); 

  //n.p. Radiohead - Heil To The Thief - 2+2=5
  g_signal_connect (G_OBJECT (window1), "delete_event",
                    G_CALLBACK (gtk_false), NULL);
*/


  gtk_window_set_focus (window1, ent_text_to_find);

  gtk_window_resize (window1, get_value (confile.screen_w, 80), get_value (confile.screen_h, 80));

//  gtk_window_set_modal (window1, TRUE);

  g_signal_connect (G_OBJECT (window1), "key_press_event", G_CALLBACK (win_key_handler), window1);

 g_signal_connect ((gpointer) window1, "delete_event",
                    G_CALLBACK (gtk_false),
                    NULL);

 // gtk_window_set_transient_for (window1, tea_main_window);
  gtk_window_set_position (window1, GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_widget_show (window1);

  return window1;
}
