/***************************************************************************
                          image_browser.c  -  description
                             -------------------
    begin                : 11.02.2005
    copyright            : (C)2005 by Peter 'Roxton' Semiletov
    email                : peter.semiletov@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <sys/stat.h>
#include <gdk/gdkkeysyms.h>

#include <stddef.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <glib/gi18n.h>

#include "tea_defs.h"
#include "rox_strings.h"
#include "tea_config.h"
#include "image_browser.h"
#include "tea_gtk_utils.h"
#include "interface.h"
#include "md5-util.h"


GtkWidget* create_wnd_imgviewer (gchar *f)
{
  if (! f)
     return NULL;

  if (! g_file_test (f, G_FILE_TEST_EXISTS))
     return NULL;

  GtkWidget *wnd_imgviewer = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  g_signal_connect (G_OBJECT (wnd_imgviewer), "key_press_event", G_CALLBACK (win_key_handler), wnd_imgviewer);

  g_signal_connect ((gpointer) wnd_imgviewer, "destroy_event",
                    G_CALLBACK (gtk_false),
                    NULL);

  GtkWidget *image = gtk_image_new_from_file (f);
  gtk_container_add (GTK_CONTAINER (wnd_imgviewer), image);
  gtk_widget_show (image);
  gtk_widget_show (wnd_imgviewer);
  gchar *t = g_path_get_basename (f);
  gtk_window_set_title (wnd_imgviewer, t);
  g_free (t);

  return wnd_imgviewer;
}


static void cb_on_pic_button_click (GtkButton *button,
                                    gpointer user_data)
{
  if (gtk_toggle_button_get_active (&cb_imgplane_mode_sw->toggle_button)) 
     insert_image (user_data);
  else
      create_wnd_imgviewer (user_data);
}


static GList *gl_thumbs;


void image_browser_init (void)
{
  gl_thumbs = NULL;
  wnd_imageplane = NULL;
}


void image_browser_done (void)
{
  glist_strings_free (gl_thumbs);  
}


static gint destroy_event (GtkWidget *widget, GdkEventAny *event, gpointer data)
{
  gtk_widget_destroy (wnd_imageplane);
  wnd_imageplane = NULL;
  return TRUE;
}


GtkWidget* create_image_browser (gchar *dir)
{
  GtkWidget *tvb;
  gchar *filename;     
  gchar *utf;

  GtkWidget *label;
  GtkWidget *button;
  GtkWidget *image;  
  GdkPixbuf *pixbuf;
  guchar digest[16];
  gchar *thumb_filename;
  gchar *md5sum = NULL;
  gchar *uri = NULL;
  gdouble val;

  GtkWidget *wnd = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  g_signal_connect (GTK_OBJECT (wnd), "destroy",
                    GTK_SIGNAL_FUNC (destroy_event), wnd); 

  gtk_window_set_title (wnd, "Imageplane");
  
  g_signal_connect (G_OBJECT (wnd), "key_press_event", G_CALLBACK (win_key_handler), wnd);

  gtk_window_set_transient_for (wnd, tea_main_window);
  gtk_window_set_default_size  (wnd, -1, gdk_screen_height ());
  gtk_window_move (wnd, 1, 1);
  gtk_widget_show (wnd);
 
  GtkWidget *vbox1 = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (wnd), vbox1);

  cb_imgplane_mode_sw = tea_checkbox (vbox1, _("Insert tags"), confile.implane_ins_image);                                            
  gtk_tooltips_set_tip (tooltips,
                        cb_imgplane_mode_sw,
                        _("Insert the tag rather than view image"),
                        NULL);

  GtkWidget *sw = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (sw);
  gtk_container_add (GTK_CONTAINER (vbox1), sw);

  gtk_scrolled_window_set_policy  (sw, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

  GtkWidget *vbox2 = gtk_vbox_new (FALSE, UI_PACKFACTOR);
  gtk_widget_show (vbox2);
  
  gtk_scrolled_window_add_with_viewport (sw, vbox2);

  GtkWidget *pb = gtk_progress_bar_new ();    
  gtk_widget_show (pb);
  gtk_box_pack_start (vbox1, pb, FALSE, FALSE, UI_PACKFACTOR);

  glist_strings_free (gl_thumbs); 
  gl_thumbs = read_dir_to_glist (dir);
  gint len; 
  gint c = 0;
  if (gl_thumbs)
     {
      len = g_list_length (gl_thumbs) - 1;
            
      GList *t = g_list_first (gl_thumbs);
      while (t)
           {
            if (is_image (t->data))
               { 
                while (gtk_events_pending ())
                    gtk_main_iteration ();
                      
                val = ((gdouble)++c / (gdouble)(len - 0.999));
                if (val > 1.0)
                   val = 0.0;  
                gtk_progress_bar_set_fraction (pb, val) ;
                 
                button = gtk_button_new ();
                g_signal_connect (button, "clicked", G_CALLBACK (cb_on_pic_button_click), t->data);

                tvb = gtk_vbox_new (FALSE, UI_PACKFACTOR);
                gtk_widget_show (tvb);
                gtk_container_add (GTK_CONTAINER (button), tvb);
              
                uri = g_strconcat ("file://", t->data, NULL); 
                md5_get_digest (uri, strlen (uri), digest);     
                
                md5sum = md5_digest_to_text (digest);

                if (md5sum)
                  {
                   thumb_filename = g_strconcat (confile.dir_thumbs, G_DIR_SEPARATOR_S, md5sum, ".png", NULL);
                   if (g_file_test (thumb_filename, G_FILE_TEST_EXISTS))
                       pixbuf = gdk_pixbuf_new_from_file (thumb_filename, NULL); 
                   else  
                       pixbuf = gdk_pixbuf_new_from_file_at_size (t->data, confile.thumb_width, confile.thumb_height, NULL); 
                  }
                else   
                    pixbuf = gdk_pixbuf_new_from_file_at_size (t->data, confile.thumb_width, confile.thumb_height, NULL); 
                 
                g_free (uri); 
                g_free (md5sum);
                g_free (thumb_filename);
                
                image = gtk_image_new_from_pixbuf (pixbuf);
                gtk_widget_show (image);
                
                gtk_box_pack_start (tvb, image, FALSE, FALSE, UI_PACKFACTOR);        

                filename = g_path_get_basename (t->data); 
                utf = get_8_filename (filename);
                label = gtk_label_new (utf);

                g_free (filename);
                g_free (utf);

                gtk_widget_show (label);
                gtk_box_pack_start (tvb, label, FALSE, FALSE, UI_PACKFACTOR);         
       
                gtk_widget_show (button);
                gtk_box_pack_start (vbox2, button, FALSE, FALSE, UI_PACKFACTOR);        
               }

             t = g_list_next (t);
            }
     }

   gtk_progress_bar_set_fraction (pb, 0);

  return wnd;
}