[manpage_begin tcllib_ip n 1.0.0]
[copyright {2004, Pat Thoyts}]
[moddesc   {dns}]
[titledesc {IPv4 and IPv6 address manipulation}]
[require Tcl 8.2]
[require ip [opt 1.0.0]]
[description]
[para]

This package provides a set of commands to help in parsing, displaying
and comparing internet addresses. The package can handle both IPv4 (1)
and IPv6 (2) address types.

[section COMMANDS]

[list_begin definitions]

[call [cmd ::ip::version] [arg address]]

Returns the protocol version of the address (4 or 6) or 0 if the
address is neither IPv4 or IPv6.

[call [cmd ::ip::is] [arg class] [arg address]]

Returns true if the address is a member of the given protocol
class. The class parameter may be either [arg ipv4] or [arg ipv6]
This is effectively a boolean equivalent of the [cmd version]
command. The [arg class] argument may be shortened to [arg 4] or
[arg 6].

[call [cmd ::ip::equal] [arg address] [arg address]]

Compare two address specifications for equivalence. The arguments are
normalized and the address prefix determined (if a mask is
supplied). The normalized addresses are then compared bit-by-bit and
the procedure returns true if they match.

[call [cmd ::ip::normalize] [arg address]]

Convert an IPv4 or IPv6 address into a fully expanded version. There
are various shorthand ways to write internet addresses, missing out
redundant parts or digts.. This procedure is the opposite of 
[cmd contract].  

[call [cmd ::ip::contract] [arg address]]

Convert a [cmd normalize]d internet address into a more compact form
suitable for displaying to users.

[call [cmd ::ip::prefix] [arg address]]

Returns the address prefix generated by masking the address part with
the mask if provided. If there is no mask then it is equivalent to
calling [cmd normalize]

[call [cmd ::ip::type] [arg address]]

[call [cmd ::ip::mask] [arg address]]

If the address supplied includes a mask then this is returned
otherwise returns an empty string.

[list_end]

[comment { -----------------------------------------------------------  }]

[section EXAMPLES]
[para]

[example {
% ip::version ::1
6
% ip::version 127.0.0.1
4
}]

[example {
% ip::normalize 127/8
127.0.0.0/8
% ip::contract 192.168.0.0
192.168
%
% ip::normalize fec0::1
fec0:0000:0000:0000:0000:0000:0000:0001
% ip::contract fec0:0000:0000:0000:0000:0000:0000:0001
fec0::1
}]

[example {
% ip::equal 192.168.0.4/16 192.168.0.0/16
1
% ip::equal fec0::1/10 fec0::fe01/10
1
}]

[comment { -----------------------------------------------------------  }]

[section {REFERENCES}]

[list_begin enum]

[enum]
    Postel, J. "Internet Protocol." RFC 791,  September 1981,
    ([uri http://www.ietf.org/rfc/rfc791.txt])

[enum]
    Hinden, R. and Deering, S.,
    "Internet Protocol Version 6 (IPv6) Addressing Architecture",
    RFC 3513, April 2003
    ([uri http://www.ietf.org/rfc/rfc3513.txt])

[list_end]

[see_also inet(3) ip(7) ipv6(7)]
[section AUTHORS]
Pat Thoyts

[keywords {internet address} ip ipv4 ipv6 {rfc 3513}]
[manpage_end]
