[comment {-*- tcl -*- doctools manpage}]
[manpage_begin tcl::transform::spacer n 1]
[keywords {channel transformation}]
[keywords {reflected channel}]
[keywords spacing]
[keywords {tip 230}]
[keywords transformation]
[keywords {virtual channel}]
[copyright {2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Reflected/virtual channel support}]
[category  Channels]
[titledesc {Space insertation and removal}]
[require Tcl 8.6]
[require tcl::transform::core [opt 1]]
[require tcl::transform::spacer [opt 1]]
[description]
[para]

The [package tcl::transform::spacer] package provides a command
creating a channel transformation which adds spacing to the data
written to it, and removes such spacing from the data read from it.

[para] The internal [package TclOO] class implementing the transform
handler is a sub-class of the [package tcl::transform::core]
framework.

[section API]

[list_begin definitions]

[call [cmd ::tcl::transform::spacer] [arg chan] [arg n] [opt [arg space]]]

This command creates a spacer transformation on top of the channel
[arg chan] and returns its handle.

[para] The [arg space] character sequence will be added every [arg n]
bytes of data written, and on the read side the same is done in
reverse, removing the spacing. If [arg space] is not specified it
defaults to a single space character (ASCII 32).

[list_end]

[vset CATEGORY virtchannel]
[include ../doctools2base/include/feedback.inc]
[manpage_end]
