package edu.uoregon.tau.taucdt.popup.actions;

//import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import edu.uoregon.tau.taucdt.popup.actions.CTauApplicationLaunchShortcut;

public class Run_TAUCdt implements IObjectActionDelegate {

	/**
	 * Constructor for Action1.
	 */
	public Run_TAUCdt() {
		super();
	}
	IStructuredSelection selection;
	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		
		if(selection==null)return;
		//Produce the associated compilation unit and send it to launcher
		IBinary bin = (IBinary) selection.getFirstElement();
		if (bin == null){
			System.out.println("No project!");
			return;
		}
		String mode = ILaunchManager.RUN_MODE;
		//System.out.println("Making");
		CTauApplicationLaunchShortcut cut = new CTauApplicationLaunchShortcut();
		//System.out.println("Running");
		cut.launch(bin,mode);
		//System.out.println("Ran");
		//cut.

	}

	
	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection)
			this.selection = (IStructuredSelection) selection;
		else
		{	//if the selection is invalid, stop
			this.selection = null;
			System.out.println("Invalid Selection");
		}
	}
}
