/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.analysis;

public class ScalabilityResult {
    public String functionName = null;
    public int trialCount = 0;
    public int[] threadCount = null;
    public double[] minimum = null;
    public double[] average = null;
    public double[] maximum = null;
    public double[] stddev = null;

    public ScalabilityResult(String string, int n) {
        this.trialCount = n;
        this.functionName = new String(string);
        this.threadCount = new int[n];
        this.minimum = new double[n];
        this.average = new double[n];
        this.maximum = new double[n];
        this.stddev = new double[n];
    }

    public String toString(boolean bl) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.functionName.replace(',', ' ') + " minimum");
        for (n = 0; n < this.trialCount; ++n) {
            if (bl) {
                stringBuffer.append("," + this.minimum[0] / this.minimum[n]);
                continue;
            }
            stringBuffer.append("," + this.minimum[n]);
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.functionName.replace(',', ' ') + " average");
        for (n = 0; n < this.trialCount; ++n) {
            if (bl) {
                stringBuffer.append("," + this.average[0] / this.average[n]);
                continue;
            }
            stringBuffer.append("," + this.average[n]);
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.functionName.replace(',', ' ') + " maximum");
        for (n = 0; n < this.trialCount; ++n) {
            if (bl) {
                stringBuffer.append("," + this.maximum[0] / this.maximum[n]);
                continue;
            }
            stringBuffer.append("," + this.maximum[n]);
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.functionName.replace(',', ' ') + " stddev");
        for (n = 0; n < this.trialCount; ++n) {
            if (bl) {
                stringBuffer.append("," + this.stddev[n]);
                continue;
            }
            stringBuffer.append("," + this.stddev[n]);
        }
        return stringBuffer.toString();
    }

    public double[] getMinimumSpeedup() {
        double[] dArray = new double[this.trialCount];
        for (int i = 0; i < this.trialCount; ++i) {
            dArray[i] = this.minimum[0] / this.minimum[i];
        }
        return dArray;
    }

    public double[] getAverageSpeedup() {
        double[] dArray = new double[this.trialCount];
        for (int i = 0; i < this.trialCount; ++i) {
            dArray[i] = this.average[0] / this.average[i];
        }
        return dArray;
    }

    public double[] getMaximumSpeedup() {
        double[] dArray = new double[this.trialCount];
        for (int i = 0; i < this.trialCount; ++i) {
            dArray[i] = this.maximum[0] / this.maximum[i];
        }
        return dArray;
    }
}

