/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public class PhaseConvertedDataSource
extends DataSource {
    public PhaseConvertedDataSource(DataSource dataSource, List list) {
        if (!dataSource.getCallPathDataPresent()) {
            throw new IllegalArgumentException("Can't make phase profile without callpath data");
        }
        int n = dataSource.getNumberOfMetrics();
        for (int i = 0; i < n; ++i) {
            this.addMetric(dataSource.getMetricName(i));
        }
        Iterator iterator = dataSource.getAllThreads().iterator();
        while (iterator.hasNext()) {
            Thread thread = (Thread)iterator.next();
            Node node = this.addNode(thread.getNodeID());
            Context context = node.addContext(thread.getContextID());
            Thread thread2 = context.addThread(thread.getThreadID(), n);
            Iterator iterator2 = thread.getFunctionProfileIterator();
            while (iterator2.hasNext()) {
                Object object;
                Object object2;
                Object object3;
                FunctionProfile functionProfile = (FunctionProfile)iterator2.next();
                if (functionProfile == null) continue;
                if (!functionProfile.isCallPathFunction()) {
                    object3 = this.addFunction(functionProfile.getName(), n);
                    object2 = functionProfile.getFunction().getGroups().iterator();
                    while (object2.hasNext()) {
                        Group group = (Group)object2.next();
                        object = this.addGroup(group.getName());
                        ((Function)object3).addGroup((Group)object);
                    }
                    object2 = new FunctionProfile((Function)object3, n);
                    for (int i = 0; i < dataSource.getNumberOfMetrics(); ++i) {
                        ((FunctionProfile)object2).setExclusive(i, functionProfile.getExclusive(i));
                        ((FunctionProfile)object2).setInclusive(i, functionProfile.getInclusive(i));
                    }
                    ((FunctionProfile)object2).setNumCalls(functionProfile.getNumCalls());
                    ((FunctionProfile)object2).setNumSubr(functionProfile.getNumSubr());
                    thread2.addFunctionProfile((FunctionProfile)object2);
                    continue;
                }
                object3 = functionProfile.getName();
                object2 = UtilFncs.getAllButRightMost((String)object3);
                String string = UtilFncs.getRightMost((String)object3);
                while (!this.match(UtilFncs.getRightMost((String)object2), list) && ((String)object2).indexOf("=>") >= 0) {
                    object2 = UtilFncs.getAllButRightMost((String)object2);
                }
                object = UtilFncs.getRightMost((String)object2);
                Function function = this.addFunction((String)object);
                function.addGroup(this.addGroup("TAU_PHASE"));
                String string2 = (String)object + " => " + string;
                Function function2 = this.addFunction(string2);
                Object object4 = functionProfile.getFunction().getGroups().iterator();
                while (object4.hasNext()) {
                    Group group = (Group)object4.next();
                    Group group2 = this.addGroup(group.getName());
                    function2.addGroup(group2);
                }
                object4 = thread2.getFunctionProfile(function2);
                if (object4 == null) {
                    object4 = new FunctionProfile(function2, n);
                    thread2.addFunctionProfile((FunctionProfile)object4);
                }
                for (int i = 0; i < dataSource.getNumberOfMetrics(); ++i) {
                    ((FunctionProfile)object4).setExclusive(i, ((FunctionProfile)object4).getExclusive(i) + functionProfile.getExclusive(i));
                    ((FunctionProfile)object4).setInclusive(i, ((FunctionProfile)object4).getInclusive(i) + functionProfile.getInclusive(i));
                }
                ((FunctionProfile)object4).setNumCalls(((FunctionProfile)object4).getNumCalls() + functionProfile.getNumCalls());
                ((FunctionProfile)object4).setNumSubr(((FunctionProfile)object4).getNumSubr() + functionProfile.getNumSubr());
            }
        }
        this.generateDerivedData();
    }

    public void load() throws FileNotFoundException, IOException, DataSourceException, SQLException {
    }

    public int getProgress() {
        return 0;
    }

    public void cancelLoad() {
    }

    private boolean match(String string, List list) {
        return list.contains(string);
    }
}

