/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.RMIView;
import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.IntervalEvent;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import java.io.Serializable;
import java.util.List;

public class RMIPerfExplorerModel
implements Serializable {
    public static final String K_MEANS = "K Means";
    public static final String K_HARMONIC_MEANS = "K Harmonic Means";
    public static final String GEM = "Gaussian Expectation-Maximization";
    public static final String FUZZY_K_MEANS = "Fuzzy K Means";
    public static final String CORRELATION_ANALYSIS = "Correlation Analysis";
    public static final String LINEAR_PROJECTION = "Random Linear Projection (disabled)";
    public static final String OVER_X_PERCENT = "Over X Percent";
    public static final String REGRESSION = "PCA (disabled)";
    public static final String NONE = "none";
    public static final String PERCENTAGE_OF_TOTAL = "Percentage of Total";
    public static final String RANGE_OF_TOTAL = "Range of Total";
    public static final int MAX_CLUSTERS = 10;
    public static final double X_PERCENT = 1.0;
    public static final int NO_MULTI = 0;
    public static final int APPLICATION = 1;
    public static final int EXPERIMENT = 2;
    public static final int TRIAL = 3;
    public static final int METRIC = 4;
    public static final int VIEW = 5;
    public static final int EVENT = 6;
    protected List multiSelections = null;
    protected int multiSelectionType = 0;
    protected String groupName = null;
    protected String metricName = null;
    protected String eventName = null;
    protected String totalTimesteps = null;
    protected Boolean constantProblem = null;
    protected String clusterMethod = null;
    protected String dimensionReduction = null;
    protected String normalization = null;
    protected int numberOfClusters = 10;
    protected double xPercent = 1.0;
    protected Object currentSelection = null;
    protected Application application = null;
    protected Experiment experiment = null;
    protected Trial trial = null;
    protected RMIView view = null;
    protected Metric metric = null;
    protected IntervalEvent event = null;
    protected int analysisID = 0;
    protected Object[] fullPath = null;

    public RMIPerfExplorerModel() {
    }

    public RMIPerfExplorerModel(RMIPerfExplorerModel rMIPerfExplorerModel) {
        this.multiSelectionType = rMIPerfExplorerModel.multiSelectionType;
        this.groupName = rMIPerfExplorerModel.groupName;
        this.metricName = rMIPerfExplorerModel.metricName;
        this.eventName = rMIPerfExplorerModel.eventName;
        this.totalTimesteps = rMIPerfExplorerModel.totalTimesteps;
        this.clusterMethod = rMIPerfExplorerModel.clusterMethod;
        this.dimensionReduction = rMIPerfExplorerModel.dimensionReduction;
        this.normalization = rMIPerfExplorerModel.normalization;
        this.numberOfClusters = rMIPerfExplorerModel.numberOfClusters;
        this.xPercent = rMIPerfExplorerModel.xPercent;
        this.currentSelection = rMIPerfExplorerModel.currentSelection;
        this.application = rMIPerfExplorerModel.application;
        this.experiment = rMIPerfExplorerModel.experiment;
        this.trial = rMIPerfExplorerModel.trial;
        this.view = rMIPerfExplorerModel.view;
        this.metric = rMIPerfExplorerModel.metric;
        this.event = rMIPerfExplorerModel.event;
        this.analysisID = rMIPerfExplorerModel.analysisID;
        this.fullPath = rMIPerfExplorerModel.fullPath;
    }

    public static Object[] getClusterMethods() {
        Object[] objectArray = new Object[]{K_MEANS, K_HARMONIC_MEANS, GEM, FUZZY_K_MEANS};
        return objectArray;
    }

    public static Object[] getDimensionReductions() {
        Object[] objectArray = new Object[]{OVER_X_PERCENT, NONE};
        return objectArray;
    }

    public static Object[] getNormalizations() {
        Object[] objectArray = new Object[]{PERCENTAGE_OF_TOTAL, RANGE_OF_TOTAL, NONE};
        return objectArray;
    }

    public Object getCurrentSelection() {
        return this.currentSelection;
    }

    public Application getApplication() {
        return this.application;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public Trial getTrial() {
        return this.trial;
    }

    public Metric getMetric() {
        return this.metric;
    }

    public IntervalEvent getEvent() {
        return this.event;
    }

    public String getClusterMethod() {
        return this.clusterMethod == null ? K_MEANS : this.clusterMethod;
    }

    public String getDimensionReduction() {
        return this.dimensionReduction == null ? NONE : this.dimensionReduction;
    }

    public String getNormalization() {
        return this.normalization == null ? NONE : this.normalization;
    }

    public int getNumberOfClusters() {
        return this.numberOfClusters;
    }

    public double getXPercent() {
        return this.xPercent;
    }

    public void setCurrentSelection(Object object) {
        this.groupName = null;
        this.metricName = null;
        this.eventName = null;
        this.totalTimesteps = null;
        this.multiSelections = null;
        this.constantProblem = null;
        this.multiSelectionType = 0;
        if (object instanceof Application) {
            this.application = (Application)object;
        } else if (object instanceof Experiment) {
            this.experiment = (Experiment)object;
        } else if (object instanceof Trial) {
            this.trial = (Trial)object;
        } else if (object instanceof RMIView) {
            this.view = (RMIView)object;
        } else if (object instanceof Metric) {
            this.metric = (Metric)object;
        } else if (object instanceof IntervalEvent) {
            this.event = (IntervalEvent)object;
        }
        this.currentSelection = object;
    }

    public void setCurrentSelection(Object[] objectArray) {
        this.groupName = null;
        this.metricName = null;
        this.eventName = null;
        this.totalTimesteps = null;
        this.multiSelections = null;
        this.constantProblem = null;
        this.multiSelectionType = 0;
        this.fullPath = objectArray;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Application) {
                this.application = (Application)objectArray[i];
            } else if (objectArray[i] instanceof Experiment) {
                this.experiment = (Experiment)objectArray[i];
            } else if (objectArray[i] instanceof Trial) {
                this.trial = (Trial)objectArray[i];
            } else if (objectArray[i] instanceof RMIView) {
                this.view = (RMIView)objectArray[i];
            } else if (objectArray[i] instanceof Metric) {
                this.metric = (Metric)objectArray[i];
            } else if (objectArray[i] instanceof IntervalEvent) {
                this.event = (IntervalEvent)objectArray[i];
            }
            this.currentSelection = objectArray[i];
        }
    }

    public void setClusterMethod(String string) {
        this.clusterMethod = string;
    }

    public void setDimensionReduction(String string) {
        this.dimensionReduction = string;
    }

    public void setNormalization(String string) {
        this.normalization = string;
    }

    public void setNumberOfClusters(String string) {
        this.numberOfClusters = Integer.parseInt(string);
    }

    public void setXPercent(String string) {
        this.xPercent = Double.parseDouble(string);
    }

    public String toString() {
        if (this.multiSelectionType == 1) {
            return "Applications";
        }
        if (this.multiSelectionType == 2) {
            String string = this.application == null ? "" : this.application.getName();
            return string;
        }
        if (this.multiSelectionType == 3) {
            String string = this.application == null ? "" : this.application.getName();
            String string2 = this.experiment.getName();
            String string3 = string + ":" + string2;
            return string3;
        }
        if (this.multiSelectionType == 4) {
            String string = this.application == null ? "" : this.application.getName();
            String string4 = this.experiment == null ? "" : this.experiment.getName();
            String string5 = this.trial.getName();
            String string6 = string + ":" + string4 + ":" + string5;
            return string6;
        }
        if (this.multiSelectionType == 6) {
            String string = this.application == null ? "" : this.application.getName();
            String string7 = this.experiment == null ? "" : this.experiment.getName();
            String string8 = this.trial.getName();
            String string9 = string + ":" + string7 + ":" + string8;
            return string9;
        }
        if (this.multiSelectionType == 5) {
            return "Custom View";
        }
        if (this.currentSelection instanceof IntervalEvent) {
            IntervalEvent intervalEvent = (IntervalEvent)this.currentSelection;
            String string = this.application == null ? "" : this.application.getName();
            String string10 = this.experiment == null ? "" : this.experiment.getName();
            String string11 = this.trial == null ? "" : this.trial.getName();
            String string12 = this.metric == null ? "" : this.metric.getName();
            String string13 = intervalEvent.getName();
            String string14 = string + ":" + string10 + ":" + string11 + ":" + string12 + ":" + string13;
            return string14;
        }
        if (this.currentSelection instanceof Metric) {
            Metric metric = (Metric)this.currentSelection;
            String string = this.application == null ? "" : this.application.getName();
            String string15 = this.experiment == null ? "" : this.experiment.getName();
            String string16 = this.trial == null ? "" : this.trial.getName();
            String string17 = metric.getName();
            String string18 = string + ":" + string15 + ":" + string16 + ":" + string17;
            return string18;
        }
        if (this.currentSelection instanceof Trial) {
            Trial trial = (Trial)this.currentSelection;
            String string = this.application == null ? "" : this.application.getName();
            String string19 = this.experiment == null ? "" : this.experiment.getName();
            String string20 = trial.getName();
            String string21 = string + ":" + string19 + ":" + string20;
            return string21;
        }
        if (this.currentSelection instanceof Experiment) {
            Experiment experiment = (Experiment)this.currentSelection;
            String string = this.application == null ? "" : this.application.getName();
            String string22 = experiment.getName();
            String string23 = string + ":" + string22;
            return string23;
        }
        if (this.currentSelection instanceof Application) {
            Application application = (Application)this.currentSelection;
            String string = application.getName();
            return string;
        }
        if (this.currentSelection instanceof RMIView) {
            RMIView rMIView = (RMIView)this.currentSelection;
            String string = rMIView.getField("NAME");
            return string;
        }
        return new String("");
    }

    public String toShortString() {
        if (this.currentSelection instanceof IntervalEvent) {
            IntervalEvent intervalEvent = (IntervalEvent)this.currentSelection;
            String string = this.application == null ? "" : "" + this.application.getID();
            String string2 = this.experiment == null ? "" : "" + this.experiment.getID();
            String string3 = this.trial == null ? "" : "" + this.trial.getID();
            String string4 = this.metric == null ? "" : "" + this.metric.getID();
            String string5 = "" + intervalEvent.getID();
            String string6 = string + ":" + string2 + ":" + string3 + ":" + string4 + ":" + string5;
            return string6;
        }
        if (this.currentSelection instanceof Metric) {
            Metric metric = (Metric)this.currentSelection;
            String string = this.application == null ? "" : "" + this.application.getID();
            String string7 = this.experiment == null ? "" : "" + this.experiment.getID();
            String string8 = this.trial == null ? "" : "" + this.trial.getID();
            String string9 = "" + metric.getID();
            String string10 = string + "." + string7 + "." + string8 + "." + string9;
            return string10;
        }
        if (this.currentSelection instanceof Trial) {
            Trial trial = (Trial)this.currentSelection;
            String string = this.application == null ? "" : "" + this.application.getID();
            String string11 = this.experiment == null ? "" : "" + this.experiment.getID();
            String string12 = "" + trial.getID();
            String string13 = string + "." + string11 + "." + string12;
            return string13;
        }
        if (this.currentSelection instanceof Experiment) {
            Experiment experiment = (Experiment)this.currentSelection;
            String string = this.application == null ? "" : "" + this.application.getID();
            String string14 = "" + experiment.getID();
            String string15 = string + "." + string14;
            return string15;
        }
        if (this.currentSelection instanceof Application) {
            Application application = (Application)this.currentSelection;
            String string = "" + application.getID();
            return string;
        }
        if (this.currentSelection instanceof RMIView) {
            RMIView rMIView = (RMIView)this.currentSelection;
            String string = rMIView.getField("NAME");
            return string;
        }
        return new String("");
    }

    public int getAnalysisID() {
        return this.analysisID;
    }

    public void setAnalysisID(int n) {
        this.analysisID = n;
    }

    public boolean setMultiSelection(List list) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof Application) {
                if (this.multiSelectionType != 1 && this.multiSelectionType != 0) {
                    return false;
                }
                this.multiSelectionType = 1;
                continue;
            }
            if (list.get(i) instanceof Experiment) {
                if (this.multiSelectionType != 2 && this.multiSelectionType != 0) {
                    return false;
                }
                this.multiSelectionType = 2;
                continue;
            }
            if (list.get(i) instanceof Trial) {
                if (this.multiSelectionType != 3 && this.multiSelectionType != 0) {
                    return false;
                }
                this.multiSelectionType = 3;
                continue;
            }
            if (list.get(i) instanceof Metric) {
                if (this.multiSelectionType != 4 && this.multiSelectionType != 0) {
                    return false;
                }
                this.multiSelectionType = 4;
                continue;
            }
            if (list.get(i) instanceof RMIView) {
                if (this.multiSelectionType != 5 && this.multiSelectionType != 0) {
                    return false;
                }
                this.multiSelectionType = 5;
                continue;
            }
            if (!(list.get(i) instanceof IntervalEvent)) continue;
            if (this.multiSelectionType != 6 && this.multiSelectionType != 0) {
                return false;
            }
            this.multiSelectionType = 6;
        }
        this.groupName = null;
        this.metricName = null;
        this.eventName = null;
        this.totalTimesteps = null;
        this.constantProblem = null;
        this.multiSelections = list;
        return true;
    }

    public List getMultiSelection() {
        return this.multiSelections;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public String getMetricName() {
        if (this.metricName != null) {
            return this.metricName;
        }
        if (this.currentSelection instanceof Metric) {
            Metric metric = (Metric)this.currentSelection;
            return metric.getName();
        }
        if (this.currentSelection instanceof IntervalEvent && this.metric != null) {
            return this.metric.getName();
        }
        return this.metricName;
    }

    public String getMetricNameUnits() {
        String string = this.getMetricName();
        if (string != null && string.equalsIgnoreCase("time")) {
            return string + " (seconds)";
        }
        return string;
    }

    public void setMetricName(String string) {
        this.metricName = string;
    }

    public String getTotalTimesteps() {
        return this.totalTimesteps;
    }

    public void setTotalTimesteps(String string) {
        this.totalTimesteps = string;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String string) {
        this.eventName = string;
    }

    public String getViewSelectionPath(boolean bl, boolean bl2, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl2) {
            stringBuffer.append(" inner join experiment e on t.experiment = e.id ");
        }
        if (bl) {
            stringBuffer.append(" inner join application a on e.application = a.id ");
        }
        stringBuffer.append(" WHERE ");
        boolean bl3 = false;
        for (int i = 0; i < this.fullPath.length; ++i) {
            if (i > 0 && bl3) {
                stringBuffer.append(" AND ");
            }
            if (!(this.fullPath[i] instanceof RMIView)) continue;
            RMIView rMIView = (RMIView)this.fullPath[i];
            if (string.equalsIgnoreCase("db2")) {
                stringBuffer.append(" cast (");
            }
            if (rMIView.getField("table_name").equalsIgnoreCase("Application")) {
                stringBuffer.append(" a.");
            } else if (rMIView.getField("table_name").equalsIgnoreCase("Experiment")) {
                stringBuffer.append(" e.");
            } else {
                stringBuffer.append(" t.");
            }
            stringBuffer.append(rMIView.getField("column_name"));
            if (string.equalsIgnoreCase("db2")) {
                stringBuffer.append(" as varchar(256)) ");
            }
            stringBuffer.append(" " + rMIView.getField("operator") + " '");
            stringBuffer.append(rMIView.getField("value"));
            stringBuffer.append("' ");
            bl3 = true;
        }
        return stringBuffer.toString();
    }

    public String getViewSelectionString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.fullPath.length - 1;
        RMIView rMIView = (RMIView)this.fullPath[n];
        if (rMIView.getField("operator").equalsIgnoreCase("like") || rMIView.getField("operator").equals("=")) {
            if (string.equalsIgnoreCase("db2")) {
                stringBuffer.append(" cast ( ");
            }
            if (rMIView.getField("table_name").equalsIgnoreCase("Application")) {
                stringBuffer.append(" a.");
            } else if (rMIView.getField("table_name").equalsIgnoreCase("Experiment")) {
                stringBuffer.append(" e.");
            } else {
                stringBuffer.append(" t.");
            }
            stringBuffer.append(rMIView.getField("column_name"));
            if (string.equalsIgnoreCase("db2")) {
                stringBuffer.append(" as varchar(256)) ");
            }
        } else {
            stringBuffer.append(" '" + rMIView.getField("name") + "'");
        }
        return stringBuffer.toString();
    }

    public String getViewID() {
        int n = this.fullPath.length - 1;
        RMIView rMIView = (RMIView)this.fullPath[n];
        return rMIView.getField("id");
    }

    public void setConstantProblem(boolean bl) {
        this.constantProblem = new Boolean(bl);
    }

    public Boolean getConstantProblem() {
        return this.constantProblem;
    }
}

