/*
 * Decompiled with CFR 0.152.
 */
package clustering.weka;

import clustering.DendrogramTree;
import clustering.DistanceMatrix;
import clustering.HierarchicalCluster;
import clustering.weka.WekaRawData;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public class JavaHierarchicalCluster
implements HierarchicalCluster {
    private DistanceMatrix distances = null;
    private LinkedHashSet remainingIndices = null;
    private DendrogramTree[] trees = null;

    public JavaHierarchicalCluster(DistanceMatrix distanceMatrix) {
        this.distances = new DistanceMatrix(distanceMatrix);
    }

    public DendrogramTree buildDendrogramTree() {
        int n = this.distances.getDimension();
        this.remainingIndices = new LinkedHashSet(n);
        this.trees = new DendrogramTree[n];
        for (int i = 0; i < n; ++i) {
            this.remainingIndices.add(new Integer(i));
            this.trees[i] = new DendrogramTree(-1 - i, 0.0);
        }
        DendrogramTree dendrogramTree = null;
        int n2 = 0;
        while (this.remainingIndices.size() > 1) {
            boolean bl = true;
            double d = 0.0;
            int[] nArray = new int[]{0, 0};
            for (int i = 0; i < n; ++i) {
                if (!this.remainingIndices.contains(new Integer(i))) continue;
                for (int j = 0; j < i; ++j) {
                    if (!this.remainingIndices.contains(new Integer(j))) continue;
                    if (bl) {
                        bl = false;
                        d = this.distances.elementAt(i, j);
                        nArray[0] = i;
                        nArray[1] = j;
                        continue;
                    }
                    if (!(d > this.distances.elementAt(i, j))) continue;
                    d = this.distances.elementAt(i, j);
                    nArray[0] = i;
                    nArray[1] = j;
                }
            }
            this.remainingIndices.remove(new Integer(nArray[0]));
            System.out.print(" " + nArray[0]);
            if (++n2 % 20 == 0) {
                System.out.println(" : " + n2 / 20);
            }
            dendrogramTree = new DendrogramTree(nArray[1], d);
            dendrogramTree.setLeftAndRight(this.trees[nArray[1]], this.trees[nArray[0]]);
            this.trees[nArray[1]] = dendrogramTree;
            this.distances.mergeDistances(nArray[1], nArray[0]);
        }
        return dendrogramTree;
    }

    public static void main(String[] stringArray) {
        int n = 10;
        int n2 = 3;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        arrayList.add("x");
        arrayList.add("y");
        arrayList.add("z");
        WekaRawData wekaRawData = new WekaRawData("test", arrayList, n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                wekaRawData.addValue(i, j, Math.random());
            }
        }
        DistanceMatrix distanceMatrix = new DistanceMatrix(n);
        distanceMatrix.solveManhattanDistances(wekaRawData);
        System.out.println("Got Distances...");
        JavaHierarchicalCluster javaHierarchicalCluster = new JavaHierarchicalCluster(distanceMatrix);
        DendrogramTree dendrogramTree = javaHierarchicalCluster.buildDendrogramTree();
        System.out.println("\n\n" + dendrogramTree.toString());
    }
}

