/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ImagePanel;
import client.PerfExplorerClient;
import client.PerfExplorerConnection;
import client.PerfExplorerImageButton;
import client.PerfExplorerModel;
import common.RMIPerformanceResults;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class PerformanceExplorerPane
extends JScrollPane
implements ActionListener {
    private static PerformanceExplorerPane thePane = null;
    private JPanel imagePanel = null;
    private Hashtable resultsHash = null;
    private RMIPerformanceResults results = null;
    private static final int imagesPerRow = 6;

    public static PerformanceExplorerPane getPane() {
        if (thePane == null) {
            JPanel jPanel = new JPanel(new BorderLayout());
            thePane = new PerformanceExplorerPane(jPanel);
        }
        thePane.repaint();
        return thePane;
    }

    private PerformanceExplorerPane(JPanel jPanel) {
        super(jPanel);
        this.imagePanel = jPanel;
        this.resultsHash = new Hashtable();
        JScrollBar jScrollBar = this.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(35);
    }

    public JPanel getImagePanel() {
        return this.imagePanel;
    }

    public void updateImagePanel() {
        this.imagePanel.removeAll();
        PerfExplorerModel perfExplorerModel = PerfExplorerModel.getModel();
        if (perfExplorerModel.getCurrentSelection() instanceof Metric || perfExplorerModel.getCurrentSelection() instanceof Trial) {
            Object object;
            Object object2;
            PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
            this.results = perfExplorerConnection.getPerformanceResults(perfExplorerModel);
            if (this.results.getResultCount() == 0) {
                return;
            }
            int n = 0;
            List list = this.results.getDescriptions();
            List list2 = this.results.getThumbnails();
            int n2 = list.size();
            this.resultsHash.put(perfExplorerModel.toString(), this.results);
            JPanel jPanel = null;
            if (this.results.getResultCount() % 6 == 1) {
                n = 1;
                ImageIcon imageIcon = new ImageIcon((byte[])list2.get(0));
                object2 = (String)list.get(0);
                object = new PerfExplorerImageButton(imageIcon, 0, (String)object2);
                ((AbstractButton)object).addActionListener(this);
                this.imagePanel.add((Component)object, "Center");
                jPanel = new JPanel(new GridLayout((this.results.getResultCount() - 1) / 6, 6));
            } else {
                jPanel = new JPanel(new GridLayout(this.results.getResultCount() / 6, 6));
            }
            for (int i = n; i < n2; ++i) {
                object2 = new ImageIcon((byte[])list2.get(i));
                object = (String)list.get(i);
                PerfExplorerImageButton perfExplorerImageButton = new PerfExplorerImageButton((Icon)object2, i, (String)object);
                perfExplorerImageButton.addActionListener(this);
                jPanel.add(perfExplorerImageButton);
            }
            this.imagePanel.add((Component)jPanel, "South");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = Integer.parseInt(actionEvent.getActionCommand());
        String string = (String)this.results.getDescriptions().get(n);
        ImageIcon imageIcon = new ImageIcon((byte[])this.results.getImages().get(n));
        JFrame jFrame = new JFrame(string);
        int n2 = 500;
        int n3 = 500;
        Point point = PerfExplorerClient.getMainFrame().getLocationOnScreen();
        Dimension dimension = PerfExplorerClient.getMainFrame().getSize();
        int n4 = dimension.width;
        int n5 = dimension.height;
        int n6 = (n4 - n2) / 2;
        int n7 = (n5 - n3) / 2;
        n6 = (int)point.getX() + n6;
        n7 = (int)point.getY() + n7;
        jFrame.setLocation(n6, n7);
        jFrame.setSize(new Dimension(n2, n3));
        ImagePanel imagePanel = new ImagePanel(imageIcon.getImage());
        imagePanel.setPreferredSize(new Dimension(n2, n3));
        imagePanel.setSize(n2, n3);
        jFrame.getContentPane().add(imagePanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

