/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Stack;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyInstance;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySystemState;

public class ThreadState {
    public PySystemState systemState;
    public PyFrame frame;
    public PyException exception;
    public Thread thread;
    public boolean tracing;
    public PyList reprStack = null;
    private Stack initializingProxies = null;
    public int compareStateNesting = 0;
    private PyDictionary compareStateDict;

    public PyInstance getInitializingProxy() {
        if (this.initializingProxies == null || this.initializingProxies.empty()) {
            return null;
        }
        return (PyInstance)this.initializingProxies.peek();
    }

    public void pushInitializingProxy(PyInstance proxy) {
        if (this.initializingProxies == null) {
            this.initializingProxies = new Stack();
        }
        this.initializingProxies.push(proxy);
    }

    public void popInitializingProxy() {
        if (this.initializingProxies == null || this.initializingProxies.empty()) {
            throw Py.RuntimeError("invalid initializing proxies state");
        }
        this.initializingProxies.pop();
    }

    public boolean enterRepr(PyObject obj) {
        if (this.reprStack == null) {
            this.reprStack = new PyList(new PyObject[]{obj});
            return true;
        }
        int i = this.reprStack.length - 1;
        while (i >= 0) {
            if (obj == this.reprStack.get(i)) {
                return false;
            }
            --i;
        }
        this.reprStack.append(obj);
        return true;
    }

    public void exitRepr(PyObject obj) {
        if (this.reprStack == null) {
            return;
        }
        int i = this.reprStack.length - 1;
        while (i >= 0) {
            if (this.reprStack.get(i) == obj) {
                this.reprStack.delRange(i, this.reprStack.length, 1);
            }
            --i;
        }
    }

    public PyDictionary getCompareStateDict() {
        if (this.compareStateDict == null) {
            this.compareStateDict = new PyDictionary();
        }
        return this.compareStateDict;
    }

    public ThreadState(Thread t, PySystemState systemState) {
        this.thread = t;
        this.systemState = systemState;
        this.tracing = false;
    }
}

