/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLException;
import net.java.games.jogl.impl.Debug;
import net.java.games.jogl.impl.GLContext;
import net.java.games.jogl.impl.StaticGLInfo;

public final class FunctionAvailabilityCache {
    private static final boolean DEBUG = Debug.debug("FunctionAvailabilityCache");
    private HashMap availabilityCache = new HashMap(50);
    private HashSet availableExtensionCache = new HashSet(50);
    private GLContext context;

    FunctionAvailabilityCache(GLContext gLContext) {
        this.context = gLContext;
    }

    public void flush() {
        this.availabilityCache.clear();
        this.availableExtensionCache.clear();
    }

    public boolean isFunctionAvailable(String string) {
        Boolean bl;
        if (DEBUG) {
            System.err.println("!!! CHECKING FOR AVAILABILITY OF: " + string);
        }
        if ((bl = (Boolean)this.availabilityCache.get(string)) == null) {
            bl = this.isPartOfAvailableExtensions(string) || FunctionAvailabilityCache.isPartOfGLCore(this.context.getGL().glGetString(7938), string) ? Boolean.TRUE : Boolean.FALSE;
            this.availabilityCache.put(string, bl);
        }
        if (DEBUG) {
            System.err.println("!!! AVAILABILITY OF " + string + ": " + bl);
        }
        return bl;
    }

    public boolean isExtensionAvailable(String string) {
        this.initAvailableExtensions();
        return this.availableExtensionCache.contains(string);
    }

    protected void initAvailableExtensions() {
        if (this.availableExtensionCache.isEmpty()) {
            GL gL = this.context.getGL();
            if (DEBUG) {
                System.err.println("!!! Pre-caching extension availability");
            }
            String string = gL.glGetString(7939) + " " + this.context.getPlatformExtensionsString();
            if (DEBUG) {
                System.err.println("!!! Available extensions: " + string);
                System.err.println("!!! GL vendor: " + gL.glGetString(7936));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                string2 = string2.intern();
                this.availableExtensionCache.add(string2);
                if (!DEBUG) continue;
                System.err.println("!!!   Available: " + string2);
            }
            this.availableExtensionCache.add("<INTERNAL_DUMMY_PLACEHOLDER>");
        }
    }

    protected boolean isPartOfAvailableExtensions(String string) {
        this.initAvailableExtensions();
        String string2 = FunctionAvailabilityCache.getExtensionCorrespondingToFunction(string);
        boolean bl = this.availableExtensionCache.contains(string2);
        return bl;
    }

    public static boolean isPartOfGLCore(String string, String string2) {
        Version version;
        Version version2;
        String string3 = StaticGLInfo.getFunctionAssociation(string2);
        if (string3 == null) {
            throw new GLException("Function \"" + string2 + "\" does not " + "correspond to any known OpenGL extension or core version.");
        }
        try {
            version2 = new Version(string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        try {
            version = new Version(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Illegally formatted OpenGL version identifier: \"" + string + "\"");
        }
        if (version2.compareTo(version) <= 0) {
            if (DEBUG) {
                System.err.println(string2 + " is in core OpenGL " + string + " because it is in OpenGL " + string3);
            }
            return true;
        }
        if (DEBUG) {
            System.err.println(string2 + " is NOT a part of the OpenGL " + string + " core" + "; it is part of OpenGL " + string3);
        }
        return false;
    }

    protected static String getExtensionCorrespondingToFunction(String string) {
        return StaticGLInfo.getFunctionAssociation(string);
    }

    private static class Version
    implements Comparable {
        private int major;
        private int minor;
        private int sub;

        public Version(int n, int n2, int n3) {
            this.major = n;
            this.minor = n2;
            this.sub = n3;
        }

        public Version(String string) {
            try {
                if (string.startsWith("GL_VERSION_")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    if (!stringTokenizer.hasMoreTokens()) {
                        this.major = 0;
                        return;
                    }
                    this.major = Integer.valueOf(stringTokenizer.nextToken());
                    if (!stringTokenizer.hasMoreTokens()) {
                        this.minor = 0;
                        return;
                    }
                    this.minor = Integer.valueOf(stringTokenizer.nextToken());
                    if (!stringTokenizer.hasMoreTokens()) {
                        this.sub = 0;
                        return;
                    }
                    this.sub = Integer.valueOf(stringTokenizer.nextToken());
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ". ");
                    this.major = Integer.valueOf(stringTokenizer.nextToken());
                    this.minor = Integer.valueOf(stringTokenizer.nextToken());
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Illegally formatted version identifier: \"" + string + "\"");
            }
        }

        public int compareTo(Object object) {
            Version version = (Version)object;
            if (this.major > version.major) {
                return 1;
            }
            if (this.major < version.major) {
                return -1;
            }
            if (this.minor > version.minor) {
                return 1;
            }
            if (this.minor < version.minor) {
                return -1;
            }
            if (this.sub > version.sub) {
                return 1;
            }
            if (this.sub < version.sub) {
                return -1;
            }
            return 0;
        }
    }
}

