/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.paraprof.ColorBar;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.perfdmf.Function;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;

public class MiniHistogram
extends JComponent {
    private ParaProfTrial ppTrial;
    private Function function;
    private int[] bins;
    private int maxInAnyBin;
    private double maxValue;
    private double minValue;
    private double binWidth;
    private List list;

    public MiniHistogram(ParaProfTrial paraProfTrial, Function function) {
        this.ppTrial = paraProfTrial;
        this.function = function;
        DataSorter dataSorter = new DataSorter(paraProfTrial);
        this.list = dataSorter.getFunctionData(function, false, false);
        this.processData();
    }

    private void processData() {
        int n;
        double d;
        this.maxValue = 0.0;
        this.minValue = 0.0;
        PPFunctionProfile pPFunctionProfile = null;
        int n2 = 0;
        boolean bl = true;
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            pPFunctionProfile = (PPFunctionProfile)iterator.next();
            ++n2;
            d = pPFunctionProfile.getValue();
            if (bl) {
                this.minValue = d;
                bl = false;
            }
            this.maxValue = Math.max(this.maxValue, d);
            this.minValue = Math.min(this.minValue, d);
        }
        int n3 = 10;
        d = this.maxValue / (double)n3;
        this.binWidth = (this.maxValue - this.minValue) / (double)n3;
        this.bins = new int[n3];
        for (n = 0; n < n3; ++n) {
            this.bins[n] = 0;
        }
        n = 0;
        Iterator iterator2 = this.list.iterator();
        block2: while (iterator2.hasNext()) {
            pPFunctionProfile = (PPFunctionProfile)iterator2.next();
            double d2 = pPFunctionProfile.getValue();
            for (int i = 0; i < n3; ++i) {
                if (!(d2 <= this.minValue + this.binWidth * (double)(i + 1))) continue;
                int n4 = i;
                this.bins[n4] = this.bins[n4] + 1;
                ++n;
                continue block2;
            }
        }
        this.maxInAnyBin = 0;
        for (int i = 0; i < n3; ++i) {
            this.maxInAnyBin = Math.max(this.maxInAnyBin, this.bins[i]);
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Rectangle rectangle = this.getBounds();
        int n = rectangle.width / 10;
        int n2 = (int)rectangle.getHeight() - 1;
        graphics.setColor(Color.red);
        for (int i = 0; i < this.bins.length; ++i) {
            if (this.bins[i] == 0) continue;
            double d = (double)this.bins[i] / (double)this.maxInAnyBin;
            int n3 = (int)(d * (double)n2);
            n3 = Math.max(1, n3);
            Color color = ColorBar.getColor((float)d);
            graphics.fillRect(n * i, (int)rectangle.getHeight() - n3, n, n3);
        }
    }
}

