/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.ColorMapWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.perfdmf.Function;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Vector;
import javax.swing.JColorChooser;

public class ColorMap
extends Observable
implements Serializable {
    private Map colors = new HashMap();

    public Map getMap() {
        return this.colors;
    }

    public void setMap(Map map) {
        if (map == null) {
            this.colors.clear();
        } else {
            this.colors = map;
            if (ParaProf.paraProfManagerWindow != null) {
                Vector vector = ParaProf.paraProfManagerWindow.getLoadedTrials();
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    ParaProfTrial paraProfTrial = (ParaProfTrial)iterator.next();
                    ParaProf.colorChooser.setColors(paraProfTrial, -1);
                    paraProfTrial.updateRegisteredObjects("colorEvent");
                }
                this.setChanged();
                this.notifyObservers("colorMap");
            }
        }
    }

    public Color getColor(Function function) {
        return (Color)this.colors.get(function.getName());
    }

    public Color getColor(String string) {
        return (Color)this.colors.get(string);
    }

    void putColor(Function function, Color color) {
        this.colors.put(function.getName(), color);
        this.reassignColors();
        this.setChanged();
        this.notifyObservers("colorMap");
    }

    void removeColor(Function function) {
        this.removeColor(function.getName());
    }

    void removeColor(String string) {
        this.colors.remove(string);
        this.reassignColors();
        this.setChanged();
        this.notifyObservers("colorMap");
    }

    void assignColor(Component component, Function function) {
        Color color = function.getColor();
        if ((color = JColorChooser.showDialog(component, "Please select a new color", color)) != null) {
            this.putColor(function, color);
        }
    }

    public Iterator getFunctions() {
        return this.colors.keySet().iterator();
    }

    public void removeAll() {
        this.colors.clear();
        this.reassignColors();
        this.setChanged();
        this.notifyObservers("colorMap");
    }

    public void reassignColors() {
        Vector vector = ParaProf.paraProfManagerWindow.getLoadedTrials();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ParaProfTrial paraProfTrial = (ParaProfTrial)iterator.next();
            ParaProf.colorChooser.setColors(paraProfTrial, -1);
            paraProfTrial.updateRegisteredObjects("colorEvent");
        }
    }

    public void assignColorsFromTrial(ParaProfTrial paraProfTrial) {
        Iterator iterator = paraProfTrial.getDataSource().getFunctions();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            this.colors.put(function.getName(), function.getColor());
        }
        this.reassignColors();
        this.setChanged();
        this.notifyObservers("colorMap");
    }

    public void showColorMap(Component component) {
        ColorMapWindow colorMapWindow = new ColorMapWindow(component);
        colorMapWindow.show();
        this.addObserver(colorMapWindow);
    }
}

