/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import java.util.Hashtable;
import org.apache.xerces.utils.QName;
import org.apache.xerces.validators.common.CMAny;
import org.apache.xerces.validators.common.CMBinOp;
import org.apache.xerces.validators.common.CMException;
import org.apache.xerces.validators.common.CMLeaf;
import org.apache.xerces.validators.common.CMNode;
import org.apache.xerces.validators.common.CMStateSet;
import org.apache.xerces.validators.common.CMUniOp;
import org.apache.xerces.validators.common.ContentLeafNameTypeVector;
import org.apache.xerces.validators.common.InsertableElementsInfo;
import org.apache.xerces.validators.common.XMLContentModel;
import org.apache.xerces.validators.schema.SubstitutionGroupComparator;

public class DFAContentModel
implements XMLContentModel {
    private static final int EPSILON = -2;
    private static final int EOC = -3;
    private static final boolean DEBUG_VALIDATE_CONTENT = false;
    private SubstitutionGroupComparator comparator = null;
    private QName[] fElemMap = null;
    private int[] fElemMapType = null;
    private int fElemMapSize = 0;
    private boolean fDTD;
    private int fEOCIndex = 0;
    private int fEOCPos = 0;
    private int fEpsilonIndex = 0;
    private boolean[] fFinalStateFlags = null;
    private CMStateSet[] fFollowList = null;
    private CMNode fHeadNode = null;
    private int fLeafCount = 0;
    private CMLeaf[] fLeafList = null;
    private int[] fLeafListType = null;
    private ContentLeafNameTypeVector fLeafNameTypeVector = null;
    private int[][] fTransTable = null;
    private int fTransTableSize = 0;
    private boolean fEmptyContentIsValid = false;
    private QName fQName = new QName();
    private static long time = 0L;

    public DFAContentModel(CMNode cMNode, int n) throws CMException {
        this(cMNode, n, false);
    }

    public DFAContentModel(CMNode cMNode, int n, boolean bl) throws CMException {
        this.fLeafCount = n;
        this.fEpsilonIndex = -2;
        this.fEOCIndex = -3;
        this.fDTD = bl;
        time -= System.currentTimeMillis();
        this.buildDFA(cMNode);
        time += System.currentTimeMillis();
    }

    public int validateContent(QName[] qNameArray, int n, int n2) throws CMException {
        if (n2 == 0) {
            return this.fEmptyContentIsValid ? -1 : 0;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            QName qName = qNameArray[n + n5];
            int n6 = 0;
            while (n6 < this.fElemMapSize) {
                int n7;
                int n8;
                if (this.fDTD ? this.fElemMap[n6].rawname == qName.rawname && (n4 = this.fTransTable[n3][n6]) != -1 : ((n8 = this.fElemMapType[n6] & 0xF) == 0 ? this.fElemMap[n6].uri == qName.uri && this.fElemMap[n6].localpart == qName.localpart && (n4 = this.fTransTable[n3][n6]) != -1 : (n8 == 6 ? ((n7 = this.fElemMap[n6].uri) == 0 || n7 == qName.uri) && (n4 = this.fTransTable[n3][n6]) != -1 : (n8 == 8 ? qName.uri == 0 && (n4 = this.fTransTable[n3][n6]) != -1 : n8 == 7 && this.fElemMap[n6].uri != qName.uri && (n4 = this.fTransTable[n3][n6]) != -1)))) break;
                ++n6;
            }
            if (n4 == -1) {
                return n5;
            }
            if (n6 == this.fElemMapSize) {
                return n5;
            }
            n3 = n4;
            n4 = 0;
            ++n5;
        }
        if (!this.fFinalStateFlags[n3]) {
            return n2;
        }
        return -1;
    }

    private boolean isEqual(QName qName, QName qName2) {
        return qName.localpart == qName2.localpart && qName.uri == qName2.uri;
    }

    public int validateContentSpecial(QName[] qNameArray, int n, int n2) throws Exception {
        if (this.comparator == null) {
            return this.validateContent(qNameArray, n, n2);
        }
        if (n2 == 0) {
            return this.fEmptyContentIsValid ? -1 : 0;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            QName qName = qNameArray[n + n5];
            int n6 = 0;
            while (n6 < this.fElemMapSize) {
                int n7;
                int n8 = this.fElemMapType[n6] & 0xF;
                if (n8 == 0 ? this.comparator.isEquivalentTo(qName, this.fElemMap[n6]) && (n4 = this.fTransTable[n3][n6]) != -1 : (n8 == 6 ? ((n7 = this.fElemMap[n6].uri) == 0 || n7 == qName.uri) && (n4 = this.fTransTable[n3][n6]) != -1 : (n8 == 8 ? qName.uri == 0 && (n4 = this.fTransTable[n3][n6]) != -1 : n8 == 7 && this.fElemMap[n6].uri != qName.uri && (n4 = this.fTransTable[n3][n6]) != -1))) break;
                ++n6;
            }
            if (n4 == -1) {
                return n5;
            }
            if (n6 == this.fElemMapSize) {
                return n5;
            }
            n3 = n4;
            n4 = 0;
            ++n5;
        }
        if (!this.fFinalStateFlags[n3]) {
            return n2;
        }
        return -1;
    }

    public void setSubstitutionGroupComparator(SubstitutionGroupComparator substitutionGroupComparator) {
        this.comparator = substitutionGroupComparator;
    }

    public int whatCanGoHere(boolean bl, InsertableElementsInfo insertableElementsInfo) throws CMException {
        int n;
        int n2 = 0;
        int n3 = 0;
        while (n3 < insertableElementsInfo.insertAt) {
            QName qName = insertableElementsInfo.curChildren[n3];
            n = 0;
            while (n < this.fElemMapSize) {
                if (this.fElemMap[n].uri == qName.uri && this.fElemMap[n].localpart == qName.localpart) break;
                ++n;
            }
            if (n == this.fElemMapSize) {
                return n3;
            }
            if ((n2 = this.fTransTable[n2][n]) == -1) {
                return n3;
            }
            ++n3;
        }
        int n4 = n2;
        insertableElementsInfo.canHoldPCData = false;
        insertableElementsInfo.isValidEOC = this.fFinalStateFlags[n4];
        insertableElementsInfo.resultsCount = this.fElemMapSize;
        if (insertableElementsInfo.results == null || insertableElementsInfo.results.length < insertableElementsInfo.resultsCount) {
            insertableElementsInfo.results = new boolean[insertableElementsInfo.resultsCount];
        }
        if (insertableElementsInfo.possibleChildren == null || insertableElementsInfo.possibleChildren.length < insertableElementsInfo.resultsCount) {
            insertableElementsInfo.possibleChildren = new QName[insertableElementsInfo.resultsCount];
            n = 0;
            while (n < insertableElementsInfo.possibleChildren.length) {
                insertableElementsInfo.possibleChildren[n] = new QName();
                ++n;
            }
        }
        n = 0;
        while (n < this.fElemMapSize) {
            insertableElementsInfo.possibleChildren[n].setValues(this.fElemMap[n]);
            insertableElementsInfo.results[n] = this.fTransTable[n4][n] != -1;
            ++n;
        }
        if (bl) {
            int n5 = 0;
            while (n5 < insertableElementsInfo.resultsCount) {
                if (insertableElementsInfo.results[n5]) {
                    insertableElementsInfo.curChildren[insertableElementsInfo.insertAt] = insertableElementsInfo.possibleChildren[n5];
                    if (this.validateContent(insertableElementsInfo.curChildren, 0, insertableElementsInfo.childCount) != -1) {
                        insertableElementsInfo.results[n5] = false;
                    }
                }
                ++n5;
            }
        }
        return -1;
    }

    public ContentLeafNameTypeVector getContentLeafNameTypeVector() {
        return this.fLeafNameTypeVector;
    }

    private void buildDFA(CMNode cMNode) throws CMException {
        Object object;
        int n;
        int n2;
        Object object2;
        this.fQName.setValues(-1, this.fEOCIndex, this.fEOCIndex);
        CMLeaf cMLeaf = new CMLeaf(this.fQName);
        this.fHeadNode = new CMBinOp(5, cMNode, cMLeaf);
        this.fEOCPos = this.fLeafCount;
        cMLeaf.setPosition(this.fLeafCount++);
        this.fLeafList = new CMLeaf[this.fLeafCount];
        this.fLeafListType = new int[this.fLeafCount];
        this.postTreeBuildInit(this.fHeadNode, 0);
        this.fFollowList = new CMStateSet[this.fLeafCount];
        int n3 = 0;
        while (n3 < this.fLeafCount) {
            this.fFollowList[n3] = new CMStateSet(this.fLeafCount);
            ++n3;
        }
        this.calcFollowList(this.fHeadNode);
        this.fElemMap = new QName[this.fLeafCount];
        this.fElemMapType = new int[this.fLeafCount];
        this.fElemMapSize = 0;
        int n4 = 0;
        while (n4 < this.fLeafCount) {
            this.fElemMap[n4] = new QName();
            if ((this.fLeafListType[n4] & 0xF) != 0 && this.fLeafNameTypeVector == null) {
                this.fLeafNameTypeVector = new ContentLeafNameTypeVector();
            }
            object2 = this.fLeafList[n4].getElement();
            n2 = 0;
            while (n2 < this.fElemMapSize) {
                if (this.fDTD ? this.fElemMap[n2].rawname == object2.rawname : this.fElemMap[n2].uri == object2.uri && this.fElemMap[n2].localpart == object2.localpart) break;
                ++n2;
            }
            if (n2 == this.fElemMapSize) {
                this.fElemMap[this.fElemMapSize].setValues((QName)object2);
                this.fElemMapType[this.fElemMapSize] = this.fLeafListType[n4];
                ++this.fElemMapSize;
            }
            ++n4;
        }
        if (this.fLeafNameTypeVector != null) {
            this.fLeafNameTypeVector.setValues(this.fElemMap, this.fElemMapType, this.fElemMapSize);
        }
        object2 = new int[this.fLeafCount + this.fElemMapSize];
        n2 = 0;
        int n5 = 0;
        while (n5 < this.fElemMapSize) {
            n = 0;
            while (n < this.fLeafCount) {
                object = this.fLeafList[n].getElement();
                int n6 = this.fLeafListType[n];
                QName qName = this.fElemMap[n5];
                if (this.fDTD) {
                    if (object.rawname == qName.rawname) {
                        object2[n2++] = n;
                    }
                } else if (object.uri == qName.uri && object.localpart == qName.localpart) {
                    object2[n2++] = n;
                }
                ++n;
            }
            object2[n2++] = -1;
            ++n5;
        }
        n = this.fLeafCount * 4;
        object = new CMStateSet[n];
        this.fFinalStateFlags = new boolean[n];
        this.fTransTable = new int[n][];
        CMStateSet cMStateSet = this.fHeadNode.firstPos();
        int n7 = 0;
        int n8 = 0;
        this.fTransTable[n8] = this.makeDefStateList();
        object[n8] = cMStateSet;
        ++n8;
        Hashtable<CMStateSet, Integer> hashtable = new Hashtable<CMStateSet, Integer>();
        while (n7 < n8) {
            cMStateSet = object[n7];
            int[] nArray = this.fTransTable[n7];
            this.fFinalStateFlags[n7] = cMStateSet.getBit(this.fEOCPos);
            ++n7;
            CMStateSet cMStateSet2 = null;
            int n9 = 0;
            int n10 = 0;
            while (n10 < this.fElemMapSize) {
                if (cMStateSet2 == null) {
                    cMStateSet2 = new CMStateSet(this.fLeafCount);
                } else {
                    cMStateSet2.zeroBits();
                }
                int n11 = object2[n9++];
                while (n11 != -1) {
                    if (cMStateSet.getBit(n11)) {
                        cMStateSet2.union(this.fFollowList[n11]);
                    }
                    n11 = object2[n9++];
                }
                if (!cMStateSet2.isEmpty()) {
                    int n12;
                    Integer n13 = (Integer)hashtable.get(cMStateSet2);
                    int n14 = n12 = n13 == null ? n8 : n13;
                    if (n12 == n8) {
                        object[n8] = cMStateSet2;
                        this.fTransTable[n8] = this.makeDefStateList();
                        hashtable.put(cMStateSet2, new Integer(n8));
                        ++n8;
                        cMStateSet2 = null;
                    }
                    nArray[n10] = n12;
                    if (n8 == n) {
                        int n15 = (int)((double)n * 1.5);
                        CMStateSet[] cMStateSetArray = new CMStateSet[n15];
                        boolean[] blArray = new boolean[n15];
                        int[][] nArrayArray = new int[n15][];
                        int n16 = 0;
                        while (n16 < n) {
                            cMStateSetArray[n16] = object[n16];
                            blArray[n16] = this.fFinalStateFlags[n16];
                            nArrayArray[n16] = this.fTransTable[n16];
                            ++n16;
                        }
                        n = n15;
                        object = cMStateSetArray;
                        this.fFinalStateFlags = blArray;
                        this.fTransTable = nArrayArray;
                    }
                }
                ++n10;
            }
        }
        this.fEmptyContentIsValid = ((CMBinOp)this.fHeadNode).getLeft().isNullable();
        this.fHeadNode = null;
        this.fLeafList = null;
        this.fFollowList = null;
    }

    private void calcFollowList(CMNode cMNode) throws CMException {
        if (cMNode.type() == 4) {
            this.calcFollowList(((CMBinOp)cMNode).getLeft());
            this.calcFollowList(((CMBinOp)cMNode).getRight());
        } else if (cMNode.type() == 5) {
            this.calcFollowList(((CMBinOp)cMNode).getLeft());
            this.calcFollowList(((CMBinOp)cMNode).getRight());
            CMStateSet cMStateSet = ((CMBinOp)cMNode).getLeft().lastPos();
            CMStateSet cMStateSet2 = ((CMBinOp)cMNode).getRight().firstPos();
            int n = 0;
            while (n < this.fLeafCount) {
                if (cMStateSet.getBit(n)) {
                    this.fFollowList[n].union(cMStateSet2);
                }
                ++n;
            }
        } else if (cMNode.type() == 2 || cMNode.type() == 3) {
            this.calcFollowList(((CMUniOp)cMNode).getChild());
            CMStateSet cMStateSet = cMNode.firstPos();
            CMStateSet cMStateSet3 = cMNode.lastPos();
            int n = 0;
            while (n < this.fLeafCount) {
                if (cMStateSet3.getBit(n)) {
                    this.fFollowList[n].union(cMStateSet);
                }
                ++n;
            }
        } else if (cMNode.type() == 1) {
            this.calcFollowList(((CMUniOp)cMNode).getChild());
        }
    }

    private void dumpTree(CMNode cMNode, int n) throws CMException {
        int n2 = 0;
        while (n2 < n) {
            System.out.print("   ");
            ++n2;
        }
        int n3 = cMNode.type();
        switch (n3 & 0xF) {
            case 4: 
            case 5: {
                if (n3 == 4) {
                    System.out.print("Choice Node ");
                } else {
                    System.out.print("Seq Node ");
                }
                if (cMNode.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                this.dumpTree(((CMBinOp)cMNode).getLeft(), n + 1);
                this.dumpTree(((CMBinOp)cMNode).getRight(), n + 1);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                System.out.print("Rep Node ");
                if (cMNode.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                this.dumpTree(((CMUniOp)cMNode).getChild(), n + 1);
                break;
            }
            case 0: {
                System.out.print("Leaf: (pos=" + ((CMLeaf)cMNode).getPosition() + "), " + ((CMLeaf)cMNode).getElement() + "(elemIndex=" + ((CMLeaf)cMNode).getElement() + ") ");
                if (cMNode.isNullable()) {
                    System.out.print(" Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                if (n3 == 6) {
                    System.out.print("Any Node: ");
                } else if (n3 == 22) {
                    System.out.print("Any lax Node: ");
                } else if (n3 == 38) {
                    System.out.print("Any skip Node: ");
                } else if (n3 == 7) {
                    System.out.print("Any other Node: ");
                } else if (n3 == 23) {
                    System.out.print("Any other lax Node: ");
                } else if (n3 == 39) {
                    System.out.print("Any other skip Node: ");
                } else if (n3 == 8) {
                    System.out.print("Any local Node: ");
                } else if (n3 == 24) {
                    System.out.print("Any local lax Node: ");
                } else if (n3 == 40) {
                    System.out.print("Any local skip Node: ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                break;
            }
            default: {
                throw new CMException(10);
            }
        }
    }

    private int[] makeDefStateList() {
        int[] nArray = new int[this.fElemMapSize];
        int n = 0;
        while (n < this.fElemMapSize) {
            nArray[n] = -1;
            ++n;
        }
        return nArray;
    }

    private int postTreeBuildInit(CMNode cMNode, int n) throws CMException {
        cMNode.setMaxStates(this.fLeafCount);
        if ((cMNode.type() & 0xF) == 6 || (cMNode.type() & 0xF) == 8 || (cMNode.type() & 0xF) == 7) {
            QName qName = new QName(-1, -1, -1, ((CMAny)cMNode).getURI());
            this.fLeafList[n] = new CMLeaf(qName, ((CMAny)cMNode).getPosition());
            this.fLeafListType[n] = cMNode.type();
            ++n;
        } else if (cMNode.type() == 4 || cMNode.type() == 5) {
            n = this.postTreeBuildInit(((CMBinOp)cMNode).getLeft(), n);
            n = this.postTreeBuildInit(((CMBinOp)cMNode).getRight(), n);
        } else if (cMNode.type() == 2 || cMNode.type() == 3 || cMNode.type() == 1) {
            n = this.postTreeBuildInit(((CMUniOp)cMNode).getChild(), n);
        } else if (cMNode.type() == 0) {
            QName qName = ((CMLeaf)cMNode).getElement();
            if (qName.localpart != this.fEpsilonIndex) {
                this.fLeafList[n] = (CMLeaf)cMNode;
                this.fLeafListType[n] = 0;
                ++n;
            }
        } else {
            throw new CMException(10);
        }
        return n;
    }
}

