/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.DataSession;
import edu.uoregon.tau.dms.dss.DataSessionThreadControl;
import edu.uoregon.tau.dms.dss.Debug;
import edu.uoregon.tau.dms.dss.DynaprofOutputSession;
import edu.uoregon.tau.dms.dss.FileList;
import edu.uoregon.tau.dms.dss.GprofOutputSession;
import edu.uoregon.tau.dms.dss.HPMToolkitDataSession;
import edu.uoregon.tau.dms.dss.MpiPOutputSession;
import edu.uoregon.tau.dms.dss.PSRunDataSession;
import edu.uoregon.tau.dms.dss.ParaProfObserver;
import edu.uoregon.tau.dms.dss.TauOutputSession;
import edu.uoregon.tau.dms.dss.TauPprofOutputSession;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.ApplicationManager;
import edu.uoregon.tau.paraprof.HelpWindow;
import edu.uoregon.tau.paraprof.Interpreter;
import edu.uoregon.tau.paraprof.Metric;
import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfLisp;
import edu.uoregon.tau.paraprof.ParaProfManager;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.SavedPreferences;
import jargs.gnu.CmdLineParser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.Vector;
import javax.swing.Timer;

public class ParaProf
implements ParaProfObserver,
ActionListener {
    static String homeDirectory = null;
    static File paraProfHomeDirectory = null;
    static String profilePathName = null;
    static int defaultNumberPrecision = 4;
    static boolean dbSupport = false;
    static ParaProfLisp paraProfLisp = null;
    static SavedPreferences savedPreferences = null;
    static ParaProfManager paraProfManager = null;
    static ApplicationManager applicationManager = null;
    static HelpWindow helpWindow = null;
    static Runtime runtime = null;
    static boolean runHasBeenOpened = false;
    public static String USAGE = "USAGE: paraprof [{-f, --filetype} file_type] [{-s,--sourcefile} sourcefilename] [{-r,--filenameprefix} filenameprefix] [{-i --fixnames}] [{-d,--debug}]\n\tWhere:\n\t\tfile_type = profiles (TAU), pprof (TAU), dynaprof, mpip, hpm, gprof, psrun, sddf (svpablo)\n";
    private static int fileType = -1;
    private static boolean dump = false;
    private static int dumptype = -1;
    private static String sourceFile = null;
    private static String filePrefix = null;
    private static boolean fixNames = false;
    private ParaProfTrial trial = null;

    public void startSystem() {
        try {
            Object object;
            Object object2;
            savedPreferences = new SavedPreferences();
            paraProfHomeDirectory = new File(homeDirectory + "/.ParaProf");
            if (paraProfHomeDirectory.exists()) {
                System.out.println("Found ParaProf home directory!");
                System.out.println("Looking for preferences ...");
                try {
                    object2 = new FileInputStream(paraProfHomeDirectory.getPath() + "/ParaProf.dat");
                    object = new ObjectInputStream((InputStream)object2);
                    savedPreferences = (SavedPreferences)((ObjectInputStream)object).readObject();
                }
                catch (Exception exception) {
                    if (exception instanceof FileNotFoundException) {
                        System.out.println("No preference file present, using defaults!");
                    }
                    System.out.println("There was an internal error whilst trying to read the ParaProf preference");
                    System.out.println("file.  Please delete this file, or replace it with a valid one!");
                    System.out.println("Note: Deleting the file will cause ParaProf to restore the default preferences");
                }
                object2 = new File(paraProfHomeDirectory.getPath() + "/perfdmf.cfg");
                if (((File)object2).exists()) {
                    System.out.println("Found db configuration file: " + paraProfHomeDirectory.getPath() + "/perfdmf.cfg");
                    savedPreferences.setDatabaseConfigurationFile(paraProfHomeDirectory.getPath() + "/perfdmf.cfg");
                } else {
                    System.out.println("Did not find db configuration file ... load manually");
                }
            } else {
                System.out.println("Did not find ParaProf home directory ... creating ...");
                paraProfHomeDirectory.mkdir();
                System.out.println("Done creating ParaProf home directory!");
            }
            paraProfLisp = new ParaProfLisp(UtilFncs.debug);
            paraProfLisp.registerParaProfPrimitives();
            applicationManager = new ApplicationManager();
            object2 = applicationManager.addApplication();
            object2.setName("Default App");
            object = ((ParaProfApplication)object2).addExperiment();
            object.setName("Default Exp");
            TauPprofOutputSession tauPprofOutputSession = null;
            FileList fileList = new FileList();
            Vector vector = null;
            helpWindow = new HelpWindow(UtilFncs.debug);
            paraProfManager = new ParaProfManager();
            if (fileType != -1) {
                File file;
                switch (fileType) {
                    case 0: {
                        tauPprofOutputSession = new TauPprofOutputSession();
                        if (sourceFile == null) {
                            if (filePrefix == null) {
                                vector = fileList.getFileList(new File(System.getProperty("user.dir")), null, fileType, "pprof", UtilFncs.debug);
                                break;
                            }
                            vector = fileList.getFileList(new File(System.getProperty("user.dir")), null, fileType, filePrefix, UtilFncs.debug);
                            break;
                        }
                        vector = new Vector();
                        file = new File(sourceFile);
                        if (!file.exists()) break;
                        File[] fileArray = new File[]{file};
                        vector.add(fileArray);
                        fileList.setFileList(vector);
                        fileList.setPath(file.getPath());
                        break;
                    }
                    case 1: {
                        tauPprofOutputSession = new TauOutputSession();
                        if (sourceFile == null) {
                            if (filePrefix == null) {
                                vector = fileList.getFileList(new File(System.getProperty("user.dir")), null, fileType, "profile", UtilFncs.debug);
                                break;
                            }
                            vector = fileList.getFileList(new File(System.getProperty("user.dir")), null, fileType, filePrefix, UtilFncs.debug);
                            break;
                        }
                        vector = new Vector();
                        file = new File(sourceFile);
                        if (!file.exists()) break;
                        File[] fileArray = new File[]{file};
                        vector.add(fileArray);
                        fileList.setFileList(vector);
                        fileList.setPath(file.getPath());
                        break;
                    }
                    case 2: {
                        tauPprofOutputSession = new DynaprofOutputSession();
                        vector = fileList.getFileList(new File(System.getProperty("user.dir")), null, fileType, filePrefix, UtilFncs.debug);
                        break;
                    }
                    case 3: {
                        tauPprofOutputSession = new MpiPOutputSession();
                        vector = new Vector();
                        if (sourceFile == null || !(file = new File(sourceFile)).exists()) break;
                        File[] fileArray = new File[]{file};
                        vector.add(fileArray);
                        fileList.setFileList(vector);
                        fileList.setPath(file.getPath());
                        break;
                    }
                    case 4: {
                        tauPprofOutputSession = new HPMToolkitDataSession();
                        vector = new Vector();
                        if (sourceFile == null) {
                            if (filePrefix == null) break;
                            vector = fileList.getFileList(new File(System.getProperty("user.dir")), null, fileType, filePrefix, UtilFncs.debug);
                            break;
                        }
                        file = new File(sourceFile);
                        if (!file.exists()) break;
                        File[] fileArray = new File[]{file};
                        vector.add(fileArray);
                        fileList.setFileList(vector);
                        fileList.setPath(file.getPath());
                        break;
                    }
                    case 5: {
                        tauPprofOutputSession = new GprofOutputSession(fixNames);
                        vector = new Vector();
                        if (sourceFile == null) {
                            if (filePrefix == null) break;
                            vector = fileList.getFileList(new File(System.getProperty("user.dir")), null, fileType, filePrefix, UtilFncs.debug);
                            break;
                        }
                        file = new File(sourceFile);
                        if (!file.exists()) break;
                        File[] fileArray = new File[]{file};
                        vector.add(fileArray);
                        fileList.setFileList(vector);
                        fileList.setPath(file.getPath());
                        break;
                    }
                    case 6: {
                        tauPprofOutputSession = new PSRunDataSession();
                        vector = new Vector();
                        if (sourceFile == null) {
                            if (filePrefix == null) break;
                            vector = fileList.getFileList(new File(System.getProperty("user.dir")), null, fileType, filePrefix, UtilFncs.debug);
                            break;
                        }
                        file = new File(sourceFile);
                        if (!file.exists()) break;
                        File[] fileArray = new File[]{file};
                        vector.add(fileArray);
                        fileList.setFileList(vector);
                        fileList.setPath(file.getPath());
                        break;
                    }
                    default: {
                        vector = new Vector();
                        System.out.println("Unrecognized file type.");
                        System.out.println("Use ParaProf's manager window to load them manually.");
                    }
                }
                if (vector.size() > 0) {
                    this.trial = new ParaProfTrial(fileType);
                    this.trial.setApplicationID(0);
                    this.trial.setExperimentID(0);
                    this.trial.setID(0);
                    this.trial.setName("Default Trial");
                    this.trial.setDefaultTrial(true);
                    this.trial.setPaths(fileList.getPath());
                    ((ParaProfExperiment)object).addTrial(this.trial);
                    this.trial.setLoading(true);
                    tauPprofOutputSession.setDebug(UtilFncs.debug);
                    file = new DataSessionThreadControl();
                    file.setDebug(UtilFncs.debug);
                    file.addObserver(this);
                    file.initialize((DataSession)tauPprofOutputSession, vector, true);
                } else {
                    System.out.println("No profile files found in the current directory.");
                    System.out.println("Use ParaProf's manager window to load them manually.");
                }
            } else {
                File[] fileArray;
                File file;
                if (sourceFile == null) {
                    vector = filePrefix == null ? fileList.getFileList(new File(System.getProperty("user.dir")), null, 0, "pprof", UtilFncs.debug) : fileList.getFileList(new File(System.getProperty("user.dir")), null, 0, filePrefix, UtilFncs.debug);
                } else {
                    vector = new Vector();
                    file = new File(sourceFile);
                    if (file.exists()) {
                        fileArray = new File[]{file};
                        vector.add(fileArray);
                        fileList.setFileList(vector);
                        fileList.setPath(file.getPath());
                    }
                }
                if (vector.size() > 0) {
                    tauPprofOutputSession = new TauPprofOutputSession();
                    this.trial = new ParaProfTrial(0);
                    this.trial.setApplicationID(0);
                    this.trial.setExperimentID(0);
                    this.trial.setID(0);
                    this.trial.setName("Default Trial");
                    this.trial.setDefaultTrial(true);
                    this.trial.setPaths(fileList.getPath());
                    ((ParaProfExperiment)object).addTrial(this.trial);
                    this.trial.setLoading(true);
                    tauPprofOutputSession.setDebug(UtilFncs.debug);
                    file = new DataSessionThreadControl();
                    file.setDebug(UtilFncs.debug);
                    file.addObserver(this);
                    file.initialize((DataSession)tauPprofOutputSession, vector, true);
                } else {
                    if (sourceFile == null) {
                        vector = filePrefix == null ? fileList.getFileList(new File(System.getProperty("user.dir")), null, 1, "profile", UtilFncs.debug) : fileList.getFileList(new File(System.getProperty("user.dir")), null, 1, filePrefix, UtilFncs.debug);
                    } else {
                        vector = new Vector();
                        file = new File(sourceFile);
                        if (file.exists()) {
                            fileArray = new File[]{file};
                            vector.add(fileArray);
                            fileList.setFileList(vector);
                            fileList.setPath(file.getPath());
                        }
                    }
                    if (vector.size() > 0) {
                        tauPprofOutputSession = new TauOutputSession();
                        this.trial = new ParaProfTrial(1);
                        this.trial.setApplicationID(0);
                        this.trial.setExperimentID(0);
                        this.trial.setID(0);
                        this.trial.setName("Default Trial");
                        this.trial.setDefaultTrial(true);
                        this.trial.setPaths(fileList.getPath());
                        ((ParaProfExperiment)object).addTrial(this.trial);
                        this.trial.setLoading(true);
                        tauPprofOutputSession.setDebug(UtilFncs.debug);
                        file = new DataSessionThreadControl();
                        file.setDebug(UtilFncs.debug);
                        file.addObserver(this);
                        file.initialize((DataSession)tauPprofOutputSession, vector, true);
                    } else {
                        System.out.println("No profile files found in the current directory.");
                        System.out.println("Use ParaProf's manager window to load them manually.");
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("An un-caught exception has occurred within the program!");
            System.out.println("The details of this exception have been stored in a file named: exception.err");
            System.out.println("Please email this file to Robert Bell at bertie@cs.uoregon.edu ");
            exception.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Timer) {
            System.out.println("------------------------");
            System.out.println("The amount of memory used by the system is: " + runtime.totalMemory());
            System.out.println("The amount of memory free to the system is: " + runtime.freeMemory());
        }
    }

    public void update(Object object) {
        Object object2;
        DataSession dataSession = (DataSession)object;
        dataSession.terminate();
        this.trial.getColorChooser().setColors(dataSession.getGlobalMapping(), -1);
        int n = dataSession.getNumberOfMetrics();
        Vector<Metric> vector = new Vector<Metric>();
        int n2 = 0;
        while (n2 < n) {
            object2 = new Metric();
            object2.setName(dataSession.getMetricName(n2));
            object2.setID(n2);
            ((Metric)object2).setTrial(this.trial);
            vector.add((Metric)object2);
            ++n2;
        }
        dataSession.setMetrics(vector);
        this.trial.setDataSession(dataSession);
        this.trial.setLoading(false);
        paraProfManager.populateTrialMetrics(this.trial);
        this.trial.showMainWindow();
        try {
            object2 = new FileInputStream("ParaProfLisp.lp");
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object2);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = null;
            Vector<String> vector2 = new Vector<String>();
            while ((string = bufferedReader.readLine()) != null) {
                if (UtilFncs.debug) {
                    System.out.println("Expression: " + string);
                }
                vector2.add(string);
            }
            Interpreter interpreter = new Interpreter(vector2, true);
            Thread thread = new Thread(interpreter);
            thread.setName("interpreter");
            if (UtilFncs.debug) {
                System.out.println("Starting the interpreter ...");
            }
            thread.start();
            if (UtilFncs.debug) {
                System.out.println("Done starting the interpreter!");
            }
        }
        catch (Exception exception) {
            if (exception instanceof FileNotFoundException) {
                System.out.println("No ParaProfLisp.lp file present!");
            }
            System.out.println("There was an internal error whilst trying to read the ParaProfLisp.pl");
            System.out.println("Please delete this file, or replace it with a valid one!");
            exception.printStackTrace();
        }
    }

    public void update() {
    }

    public static String getInfoString() {
        return new String("ParaProf Version 2.0 ... The Tau Group!");
    }

    public static void exitParaProf(int n) {
        if (UtilFncs.objectDebug != null) {
            UtilFncs.objectDebug.outputToFile("ParaProf exiting!!");
            UtilFncs.objectDebug.flushDebugFileBuffer();
            UtilFncs.objectDebug.closeDebugFile();
        }
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        System.out.println("");
        homeDirectory = System.getProperty("user.home");
        ParaProf paraProf = new ParaProf();
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addBooleanOption('h', "help");
        CmdLineParser.Option option2 = cmdLineParser.addBooleanOption('d', "debug");
        CmdLineParser.Option option3 = cmdLineParser.addStringOption('g', "configfile");
        CmdLineParser.Option option4 = cmdLineParser.addStringOption('s', "sourcefile");
        CmdLineParser.Option option5 = cmdLineParser.addStringOption('r', "--filenameprefix");
        CmdLineParser.Option option6 = cmdLineParser.addStringOption('f', "filetype");
        CmdLineParser.Option option7 = cmdLineParser.addBooleanOption('i', "fixnames");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println(optionException.getMessage());
            System.err.println(USAGE);
            ParaProf.exitParaProf(-1);
        }
        Boolean bl = (Boolean)cmdLineParser.getOptionValue(option);
        Boolean bl2 = (Boolean)cmdLineParser.getOptionValue(option2);
        sourceFile = (String)cmdLineParser.getOptionValue(option4);
        String string = (String)cmdLineParser.getOptionValue(option6);
        filePrefix = (String)cmdLineParser.getOptionValue(option5);
        Boolean bl3 = (Boolean)cmdLineParser.getOptionValue(option7);
        if (bl != null && bl.booleanValue()) {
            System.err.println(USAGE);
            ParaProf.exitParaProf(-1);
        }
        if (bl3 != null) {
            fixNames = bl3;
        }
        if (bl2 != null) {
            UtilFncs.objectDebug = new Debug();
            UtilFncs.debug = bl2;
            Debug.debug = bl2;
        }
        if (string != null) {
            if (string.equals("pprof")) {
                fileType = 0;
            } else if (string.equals("profiles")) {
                fileType = 1;
            } else if (string.equals("dynaprof")) {
                fileType = 2;
            } else if (string.equals("mpip")) {
                fileType = 3;
            } else if (string.equals("hpm")) {
                fileType = 4;
            } else if (string.equals("gprof")) {
                fileType = 5;
            } else if (string.equals("psrun")) {
                fileType = 6;
            } else {
                System.err.println("Please enter a valid file type.");
                System.err.println(USAGE);
                ParaProf.exitParaProf(-1);
            }
        }
        if ((sourceFile != null || filePrefix != null) && fileType == -1) {
            System.out.println("Error: If you specify either a source file or a prefix, you must specify a file type as well!");
            System.err.println(USAGE);
            ParaProf.exitParaProf(-1);
        }
        if ((fileType == 2 || fileType == 3) && sourceFile == null) {
            System.out.println("Error: If you specify either dynaprof or mpip, you must specify a source file as well!");
            System.err.println(USAGE);
            ParaProf.exitParaProf(-1);
        }
        if (dump) {
            System.out.println("ParaProf will dump to the standard out with dump type: " + dumptype);
            ParaProf.exitParaProf(0);
        }
        runtime = Runtime.getRuntime();
        if (UtilFncs.debug) {
            Timer timer = new Timer(8000, paraProf);
            timer.start();
        }
        paraProf.startSystem();
    }
}

