/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.InterpreterThread;
import java.util.Enumeration;
import java.util.Vector;

public class Interpreter
implements Runnable {
    private Vector expressions = null;
    private boolean graphicsEnvironment = false;
    private int threadCount = 0;
    private Thread lock = null;
    private boolean debug = false;

    public Interpreter() {
    }

    public Interpreter(Vector vector, boolean bl) {
        this.expressions = vector;
    }

    public synchronized void evalExpression(String string, boolean bl) {
        InterpreterThread interpreterThread = new InterpreterThread(this, string, this.threadCount);
        Thread thread = new Thread(interpreterThread);
        thread.setName(this.threadCount + " - " + string);
        ++this.threadCount;
        thread.start();
    }

    public void evalExpressions(Vector vector, boolean bl) {
        this.expressions = vector;
        this.graphicsEnvironment = bl;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            if (UtilFncs.debug) {
                System.out.println("Thread(" + this.threadCount + "). --- Trying to get the lock .... ");
            }
            this.getLock();
            if (UtilFncs.debug) {
                System.out.println("Thread(" + this.threadCount + "). --- Lock obtained!");
            }
            String string = (String)enumeration.nextElement();
            InterpreterThread interpreterThread = new InterpreterThread(this, string, this.threadCount);
            Thread thread = new Thread(interpreterThread);
            thread.setName(this.threadCount + " - " + string);
            ++this.threadCount;
            thread.start();
        }
    }

    public void run() {
        this.evalExpressions(this.expressions, this.graphicsEnvironment);
    }

    public synchronized void getLock() {
        while (!this.lock()) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized boolean lock() {
        boolean bl = false;
        if (this.lock == null) {
            this.lock = Thread.currentThread();
            bl = true;
        }
        return bl;
    }

    public synchronized void unlock() {
        try {
            if (UtilFncs.debug) {
                System.out.println("Setting the lock to null and calling notify!");
            }
            this.lock = null;
            this.notify();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean debug() {
        return this.debug;
    }
}

