/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class DBConfiguration
extends JFrame
implements ActionListener {
    ParaProfManager paraProfManager = null;
    JPasswordField passwordField = null;
    JTextField configFileField = null;

    public DBConfiguration(ParaProfManager paraProfManager) {
        this.paraProfManager = paraProfManager;
        String string = ParaProf.savedPreferences.getDatabasePassword();
        this.passwordField = string == null ? new JPasswordField(string, 20) : new JPasswordField(20);
        String string2 = ParaProf.savedPreferences.getDatabaseConfigurationFile();
        this.configFileField = string2 == null ? (ParaProf.paraProfHomeDirectory.exists() ? new JTextField(ParaProf.paraProfHomeDirectory.getPath() + "/perfdmf.cfg", 30) : new JTextField(System.getProperty("user.dir"), 30)) : new JTextField(string2, 30);
        int n = 400;
        int n2 = 200;
        Point point = paraProfManager.getLocationOnScreen();
        Dimension dimension = paraProfManager.getSize();
        int n3 = dimension.width;
        int n4 = dimension.height;
        int n5 = (n3 - n) / 2;
        int n6 = (n4 - n2) / 2;
        n5 = (int)point.getX() + n5;
        n6 = (int)point.getY() + n6;
        ((Component)this).setLocation(n5, n6);
        ((Component)this).setSize(new Dimension(n, n2));
        this.setTitle("Database Configuration");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DBConfiguration.this.thisWindowClosing(windowEvent);
            }
        });
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(new JLabel("Password:"), gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(this.passwordField, gridBagConstraints, 1, 0, 1, 1);
        JButton jButton = new JButton("Config File");
        jButton.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton, gridBagConstraints, 0, 1, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(this.configFileField, gridBagConstraints, 1, 1, 2, 1);
        jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton, gridBagConstraints, 0, 2, 1, 1);
        jButton = new JButton("Ok");
        jButton.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton, gridBagConstraints, 2, 2, 1, 1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("Config File")) {
                JFileChooser jFileChooser = null;
                jFileChooser = ParaProf.paraProfHomeDirectory.exists() ? new JFileChooser(ParaProf.paraProfHomeDirectory.getPath()) : new JFileChooser(System.getProperty("user.dir"));
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setDialogTitle("Select");
                jFileChooser.setApproveButtonText("Select");
                if (jFileChooser.showOpenDialog(this) != 0) {
                    System.out.println("File selection cancelled by user!");
                    return;
                }
                this.configFileField.setText(jFileChooser.getSelectedFile().getCanonicalPath());
            } else if (string.equals("Cancel")) {
                this.closeThisWindow();
            } else if (string.equals("Ok")) {
                String string2 = new String(this.passwordField.getPassword()).trim();
                if (string2.equals("")) {
                    ParaProf.savedPreferences.setDatabasePassword(null);
                } else {
                    ParaProf.savedPreferences.setDatabasePassword(string2);
                }
                ParaProf.savedPreferences.setDatabaseConfigurationFile(this.configFileField.getText().trim());
                this.closeThisWindow();
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"DBC02");
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.getContentPane().add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"DBC03");
        }
    }

    private void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        ((Component)this).setVisible(false);
        this.dispose();
    }
}

