/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.CallPathUtilFuncs;
import edu.uoregon.tau.dms.dss.DataSessionIterator;
import edu.uoregon.tau.dms.dss.GlobalMapping;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.CallPathTextWindow;
import edu.uoregon.tau.paraprof.MappingDataWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfImageInterface;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.SMWThread;
import edu.uoregon.tau.paraprof.SMWThreadDataElement;
import edu.uoregon.tau.paraprof.StatWindow;
import edu.uoregon.tau.paraprof.StaticMainWindow;
import edu.uoregon.tau.paraprof.ThreadDataWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class StaticMainWindowPanel
extends JPanel
implements ActionListener,
MouseListener,
PopupMenuListener,
Printable,
ParaProfImageInterface {
    private ParaProfTrial trial = null;
    StaticMainWindow sMWindow = null;
    private Vector[] list = new Vector[]{new Vector(), new Vector()};
    private int barHeight = -1;
    private int barSpacing = -1;
    private int baseBarLength = 500;
    private int barLength = 0;
    private int textOffset = 60;
    private int barXCoord = 100;
    private int lastHeaderEndPosition = 0;
    int xPanelSize = 0;
    int yPanelSize = 0;
    private JPopupMenu popup1 = new JPopupMenu();
    private JPopupMenu popup2 = new JPopupMenu();
    private JPopupMenu popup3 = new JPopupMenu();
    private JMenuItem tUESWItem = null;
    private JMenuItem threadCallpathItem = null;
    private Object clickedOnObject = null;
    private boolean debug = false;

    public StaticMainWindowPanel() {
        try {
            this.setToolTipText("Incorrect Constructor!!!");
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"SMWP01");
        }
    }

    public StaticMainWindowPanel(ParaProfTrial paraProfTrial, StaticMainWindow staticMainWindow, boolean bl) {
        try {
            this.setToolTipText("ParaProf bar graph draw window!");
            this.setBackground(Color.white);
            this.addMouseListener(this);
            this.trial = paraProfTrial;
            this.sMWindow = staticMainWindow;
            this.debug = bl;
            this.barLength = this.baseBarLength;
            JMenuItem jMenuItem = new JMenuItem("Show Mean Statistics Window");
            jMenuItem.addActionListener(this);
            this.popup1.add(jMenuItem);
            jMenuItem = new JMenuItem("Show Mean Call Path Thread Relations");
            jMenuItem.addActionListener(this);
            this.popup1.add(jMenuItem);
            jMenuItem = new JMenuItem("Show Statistics Window");
            jMenuItem.addActionListener(this);
            this.popup2.add(jMenuItem);
            if (paraProfTrial.userEventsPresent()) {
                jMenuItem = new JMenuItem("Show User Event Statistics Window");
                jMenuItem.addActionListener(this);
                this.popup2.add(jMenuItem);
            }
            jMenuItem = new JMenuItem("Show Call Path Thread Relations");
            jMenuItem.addActionListener(this);
            this.popup2.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Show Function Details");
            jMenuItem2.addActionListener(this);
            this.popup3.add(jMenuItem2);
            jMenuItem = new JMenuItem("Change Function Color");
            jMenuItem.addActionListener(this);
            this.popup3.add(jMenuItem);
            jMenuItem = new JMenuItem("Reset to Generic Color");
            jMenuItem.addActionListener(this);
            this.popup3.add(jMenuItem);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"SMWP02");
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            SMWThread sMWThread = null;
            int n3 = 0;
            if (this.trial.getPreferences().getBarSpacing() != 0) {
                n3 = n2 / this.trial.getPreferences().getBarSpacing() - 1;
            }
            if (n3 == -1) {
                if (n < this.barXCoord) {
                    if (ParaProf.helpWindow.isShowing()) {
                        ParaProf.helpWindow.clearText();
                        ParaProf.helpWindow.writeText("You are to the left of the mean bar.");
                        ParaProf.helpWindow.writeText("");
                        ParaProf.helpWindow.writeText("Using either the right or left mouse buttons, click once to display more options about the mean values for the functions in the system.");
                    }
                    return new String("Left or right click for more options");
                }
                DataSessionIterator dataSessionIterator = new DataSessionIterator(this.list[1]);
                while (dataSessionIterator.hasNext()) {
                    SMWThreadDataElement sMWThreadDataElement = (SMWThreadDataElement)dataSessionIterator.next();
                    if (n >= sMWThreadDataElement.getXEnd()) continue;
                    if (ParaProf.helpWindow.isShowing()) {
                        ParaProf.helpWindow.clearText();
                        ParaProf.helpWindow.writeText("Your mouse is over the mean draw bar!");
                        ParaProf.helpWindow.writeText("");
                        ParaProf.helpWindow.writeText("Current function name is: " + sMWThreadDataElement.getMappingName());
                        ParaProf.helpWindow.writeText("");
                        ParaProf.helpWindow.writeText("The mean draw bars give a visual representation of the mean values for the functions which have run in the system.  The funtions are assigned a color from the current ParaProf color set.  The colors are cycled through when the number of funtions exceeds the number of available colors. In the preferences section, you can add more colors.  Use the right and left mouse buttons to give additional information.");
                    }
                    return sMWThreadDataElement.getMappingName();
                }
                if (n <= this.barXCoord + this.barLength) {
                    if (ParaProf.helpWindow.isShowing()) {
                        ParaProf.helpWindow.clearText();
                        ParaProf.helpWindow.writeText("Your mouse is over the misc. function section!");
                        ParaProf.helpWindow.writeText("");
                        ParaProf.helpWindow.writeText("These are functions which have a non zero value, but whose screen representation is less than a pixel.");
                        ParaProf.helpWindow.writeText("");
                        ParaProf.helpWindow.writeText("To view these functions, right or left click to the left of this bar to bring up windows which will show more detailed information.");
                    }
                    return "Misc function section ... see help window for details";
                }
            } else if (n3 < this.list[0].size()) {
                sMWThread = (SMWThread)this.list[0].elementAt(n3);
                if (n < this.barXCoord) {
                    if (ParaProf.helpWindow.isShowing()) {
                        ParaProf.helpWindow.clearText();
                        ParaProf.helpWindow.writeText("n,c,t stands for: Node, Context and Thread.");
                        ParaProf.helpWindow.writeText("");
                        ParaProf.helpWindow.writeText("Using either the right or left mouse buttons, click once to display more options for this thread.");
                    }
                    return new String("Left or right click for more options");
                }
                DataSessionIterator dataSessionIterator = (DataSessionIterator)sMWThread.getFunctionListIterator();
                while (dataSessionIterator.hasNext()) {
                    SMWThreadDataElement sMWThreadDataElement = (SMWThreadDataElement)dataSessionIterator.next();
                    if (n >= sMWThreadDataElement.getXEnd()) continue;
                    if (ParaProf.helpWindow.isShowing()) {
                        ParaProf.helpWindow.clearText();
                        ParaProf.helpWindow.writeText("Your mouse is over one of the thread draw bars!");
                        ParaProf.helpWindow.writeText("");
                        ParaProf.helpWindow.writeText("Current function name is: " + sMWThreadDataElement.getMappingName());
                        ParaProf.helpWindow.writeText("");
                        ParaProf.helpWindow.writeText("The thread draw bars give a visual representation functions which have run on this thread.  The funtions are assigned a color from the current Racy color set.  The colors are cycled through when the number of funtions exceeds the number of available colors.  Use the right and left mouse buttons to give additional information.");
                    }
                    return sMWThreadDataElement.getMappingName();
                }
                if (n <= this.barXCoord + this.barLength) {
                    if (ParaProf.helpWindow.isShowing()) {
                        ParaProf.helpWindow.clearText();
                        ParaProf.helpWindow.writeText("Your mouse is over the misc. function section!");
                        ParaProf.helpWindow.writeText("");
                        ParaProf.helpWindow.writeText("These are functions which have a non zero value, but whose screen representation is less than a pixel.");
                        ParaProf.helpWindow.writeText("");
                        ParaProf.helpWindow.writeText("To view these functions, right or left click to the left of this bar to bring up windows which will show more detailed information.");
                    }
                    return "Misc function section ... see help window for details";
                }
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"SMWP03");
        }
        return string;
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.renderIt((Graphics2D)graphics, 0, false);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"SMWP06");
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (pageFormat.getOrientation() == 1) {
            System.out.println("PORTRAIT");
        } else if (pageFormat.getOrientation() == 0) {
            System.out.println("LANDSCAPE");
        }
        if (n >= 3) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.draw(new Rectangle2D.Double(0.0, 0.0, pageFormat.getImageableWidth(), pageFormat.getImageableHeight()));
        this.renderIt(graphics2D, 2, false);
        return 0;
    }

    public void renderIt(Graphics2D graphics2D, int n, boolean bl) {
        try {
            if (this.debug()) {
                System.out.println("####################################");
                System.out.println("StaticMainWindowPanel.renderIt(...)");
                System.out.println("####################################");
            }
            this.list = this.sMWindow.getData();
            int n2 = 0;
            SMWThread sMWThread = null;
            this.trial.getPreferences().setBarDetails(graphics2D);
            this.barSpacing = this.trial.getPreferences().getBarSpacing();
            this.barHeight = this.trial.getPreferences().getBarHeight();
            Font font = new Font(this.trial.getPreferences().getParaProfFont(), this.trial.getPreferences().getFontStyle(), this.barHeight);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            int[] nArray = this.trial.getMaxNCTNumbers();
            this.barXCoord = fontMetrics.stringWidth("n,c,t " + nArray[0] + "," + nArray[1] + "," + nArray[2]) + 15;
            if (this.resizePanel(fontMetrics, this.barXCoord) && n == 0) {
                this.revalidate();
                return;
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            Rectangle rectangle = null;
            Rectangle rectangle2 = null;
            if (n == 0 || n == 1) {
                if (n == 0) {
                    rectangle = graphics2D.getClipBounds();
                    n3 = (int)rectangle.getY();
                    n4 = (int)((double)n3 + rectangle.getHeight());
                } else {
                    rectangle2 = this.sMWindow.getViewRect();
                    n3 = (int)rectangle2.getY();
                    n4 = (int)((double)n3 + rectangle2.getHeight());
                }
                n5 = (n3 - n2) / this.barSpacing - 2;
                n6 = (n4 - n2) / this.barSpacing + 2;
                if (n5 < 0) {
                    n5 = 0;
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n5 > this.list[0].size() - 1) {
                    n5 = this.list[0].size() - 1;
                }
                if (n6 > this.list[0].size() - 1) {
                    n6 = this.list[0].size() - 1;
                }
                if (n == 0) {
                    n2 += n5 * this.barSpacing;
                }
            } else if (n == 2 || n == 3) {
                n5 = 0;
                n6 = this.list[0].size() - 1;
            }
            if (bl) {
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                Insets insets = this.getInsets();
                n2 += this.barSpacing;
                String string = this.sMWindow.getHeaderString();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "'\n'");
                while (stringTokenizer.hasMoreTokens()) {
                    AttributedString attributedString = new AttributedString(stringTokenizer.nextToken());
                    attributedString.addAttribute(TextAttribute.FONT, font);
                    AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                    LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                    float f = this.getSize().width - insets.left - insets.right;
                    float f2 = insets.left;
                    float f3 = insets.right;
                    while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                        TextLayout textLayout = lineBreakMeasurer.nextLayout(f);
                        textLayout.draw(graphics2D, f2, n2 += this.barSpacing);
                        f2 = insets.left;
                    }
                }
                this.lastHeaderEndPosition = n2;
            }
            n2 += this.barSpacing;
            if (n5 == 0) {
                this.drawBar(graphics2D, fontMetrics, "mean", null, this.barXCoord, n2, this.barHeight, n, true);
            }
            if (this.list != null) {
                for (int i = n5; i <= n6; ++i) {
                    sMWThread = (SMWThread)this.list[0].elementAt(i);
                    this.drawBar(graphics2D, fontMetrics, "n,c,t " + sMWThread.getNodeID() + "," + sMWThread.getContextID() + "," + sMWThread.getThreadID(), sMWThread, this.barXCoord, n2 += this.barSpacing, this.barHeight, n, false);
                }
            }
            if (this.debug()) {
                System.out.println("####################################");
                System.out.println("End - StaticMainWindowPanel.renderIt(...)");
                System.out.println("####################################");
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"SMWP");
        }
    }

    private void drawBar(Graphics2D graphics2D, FontMetrics fontMetrics, String string, SMWThread sMWThread, int n, int n2, int n3, int n4, boolean bl) {
        SMWThreadDataElement sMWThreadDataElement;
        DataSessionIterator dataSessionIterator = null;
        int n5 = this.trial.getColorChooser().getGroupHighlightColorID();
        boolean bl2 = false;
        int n6 = n + this.barLength;
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, n - fontMetrics.stringWidth(string) - 5, n2);
        double d = 0.0;
        dataSessionIterator = bl ? new DataSessionIterator(this.list[1]) : (DataSessionIterator)sMWThread.getFunctionListIterator();
        while (dataSessionIterator.hasNext()) {
            sMWThreadDataElement = (SMWThreadDataElement)dataSessionIterator.next();
            if (bl) {
                d += sMWThreadDataElement.getMeanExclusiveValue();
                continue;
            }
            d += sMWThreadDataElement.getExclusiveValue();
        }
        dataSessionIterator.reset();
        while (dataSessionIterator.hasNext()) {
            sMWThreadDataElement = (SMWThreadDataElement)dataSessionIterator.next();
            double d2 = 0.0;
            d2 = bl ? sMWThreadDataElement.getMeanExclusiveValue() : sMWThreadDataElement.getExclusiveValue();
            if (d2 > 0.0) {
                int n7 = (int)(d2 / d * (double)this.barLength);
                if (n7 > 2) {
                    if (n3 > 2) {
                        graphics2D.setColor(sMWThreadDataElement.getColor());
                        graphics2D.fillRect(n + 1, n2 - n3 + 1, n7 - 1, n3 - 1);
                        if (sMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorID()) {
                            bl2 = true;
                            graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                            graphics2D.drawRect(n, n2 - n3, n7, n3);
                            graphics2D.drawRect(n + 1, n2 - n3 + 1, n7 - 2, n3 - 2);
                        } else if (sMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGroupHighlightColorID())) {
                            bl2 = true;
                            graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                            graphics2D.drawRect(n, n2 - n3, n7, n3);
                            graphics2D.drawRect(n + 1, n2 - n3 + 1, n7 - 2, n3 - 2);
                        } else {
                            graphics2D.setColor(Color.black);
                            if (bl2) {
                                graphics2D.drawLine(n + 1, n2 - n3, n + 1 + n7, n2 - n3);
                                graphics2D.drawLine(n + 1, n2, n + 1 + n7, n2);
                                graphics2D.drawLine(n + 1 + n7, n2 - n3, n + 1 + n7, n2);
                                bl2 = false;
                            } else {
                                graphics2D.drawRect(n, n2 - n3, n7, n3);
                            }
                        }
                        if (n4 == 0) {
                            sMWThreadDataElement.setDrawCoords(n, n + n7, n2 - n3, n2);
                        }
                        n += n7;
                    } else {
                        if (sMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorID()) {
                            graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                        } else if (sMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGroupHighlightColorID())) {
                            graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                        } else {
                            graphics2D.setColor(sMWThreadDataElement.getColor());
                        }
                        graphics2D.fillRect(n, n2 - n3, n7, n3);
                        graphics2D.setColor(Color.black);
                        graphics2D.drawRect(n, n2 - n3, n7, n3);
                        if (n4 == 0) {
                            sMWThreadDataElement.setDrawCoords(n, n + n7, n2 - n3, n2);
                        }
                        n += n7;
                    }
                }
                if (n4 != 0) continue;
                sMWThreadDataElement.setDrawCoords(n, n, n2 - n3, n2);
                continue;
            }
            if (n4 != 0) continue;
            sMWThreadDataElement.setDrawCoords(n, n, n2 - n3, n2);
        }
        if (n < n6) {
            graphics2D.setColor(this.trial.getColorChooser().getMiscMappingsColor());
            graphics2D.fillRect(n, n2 - n3, n6 - n, n3);
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(n, n2 - n3, n6 - n, n3);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Mean Statistics Window")) {
                    StatWindow statWindow = new StatWindow(this.trial, -1, -1, -1, this.sMWindow.getSMWData(), 0, this.debug());
                    this.trial.getSystemEvents().addObserver(statWindow);
                    statWindow.show();
                } else if (string.equals("Show Mean User Event Statistics Window")) {
                    if (this.clickedOnObject instanceof SMWThread) {
                        SMWThread sMWThread = (SMWThread)this.clickedOnObject;
                        StatWindow statWindow = new StatWindow(this.trial, sMWThread.getNodeID(), sMWThread.getContextID(), sMWThread.getThreadID(), this.sMWindow.getSMWData(), 2, this.debug());
                        this.trial.getSystemEvents().addObserver(statWindow);
                        statWindow.show();
                    }
                } else if (string.equals("Show Mean Call Path Thread Relations")) {
                    SMWThread sMWThread = (SMWThread)this.clickedOnObject;
                    CallPathTextWindow callPathTextWindow = new CallPathTextWindow(this.trial, -1, -1, -1, this.sMWindow.getSMWData(), 0, this.debug());
                    this.trial.getSystemEvents().addObserver(callPathTextWindow);
                    callPathTextWindow.show();
                } else if (string.equals("Show Call Path Thread Relations")) {
                    if (this.clickedOnObject instanceof SMWThread) {
                        SMWThread sMWThread = (SMWThread)this.clickedOnObject;
                        CallPathUtilFuncs.trimCallPathData((GlobalMapping)this.trial.getGlobalMapping(), (Thread)this.trial.getNCT().getThread(sMWThread.getNodeID(), sMWThread.getContextID(), sMWThread.getThreadID()));
                        CallPathTextWindow callPathTextWindow = new CallPathTextWindow(this.trial, sMWThread.getNodeID(), sMWThread.getContextID(), sMWThread.getThreadID(), this.sMWindow.getSMWData(), 1, this.debug());
                        this.trial.getSystemEvents().addObserver(callPathTextWindow);
                        callPathTextWindow.show();
                    }
                } else if (string.equals("Show Statistics Window")) {
                    if (this.clickedOnObject instanceof SMWThread) {
                        SMWThread sMWThread = (SMWThread)this.clickedOnObject;
                        StatWindow statWindow = new StatWindow(this.trial, sMWThread.getNodeID(), sMWThread.getContextID(), sMWThread.getThreadID(), this.sMWindow.getSMWData(), 1, this.debug());
                        this.trial.getSystemEvents().addObserver(statWindow);
                        statWindow.show();
                    }
                } else if (string.equals("Show User Event Statistics Window")) {
                    if (this.clickedOnObject instanceof SMWThread) {
                        SMWThread sMWThread = (SMWThread)this.clickedOnObject;
                        StatWindow statWindow = new StatWindow(this.trial, sMWThread.getNodeID(), sMWThread.getContextID(), sMWThread.getThreadID(), this.sMWindow.getSMWData(), 2, this.debug());
                        this.trial.getSystemEvents().addObserver(statWindow);
                        statWindow.show();
                    }
                } else if (string.equals("Show Function Details")) {
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        SMWThreadDataElement sMWThreadDataElement = (SMWThreadDataElement)this.clickedOnObject;
                        this.trial.getColorChooser().setHighlightColorID(sMWThreadDataElement.getMappingID());
                        MappingDataWindow mappingDataWindow = new MappingDataWindow(this.trial, sMWThreadDataElement.getMappingID(), this.sMWindow.getSMWData(), this.debug());
                        this.trial.getSystemEvents().addObserver(mappingDataWindow);
                        mappingDataWindow.show();
                    }
                } else if (string.equals("Change Function Color")) {
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        int n = ((SMWThreadDataElement)this.clickedOnObject).getMappingID();
                        GlobalMapping globalMapping = this.trial.getGlobalMapping();
                        GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n, 0);
                        Color color = globalMappingElement.getColor();
                        new JColorChooser();
                        color = JColorChooser.showDialog(this, "Please select a new color", color);
                        if (color != null) {
                            globalMappingElement.setSpecificColor(color);
                            globalMappingElement.setColorFlag(true);
                            this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                        }
                    }
                } else if (string.equals("Reset to Generic Color") && this.clickedOnObject instanceof SMWThreadDataElement) {
                    int n = ((SMWThreadDataElement)this.clickedOnObject).getMappingID();
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n, 0);
                    globalMappingElement.setColorFlag(false);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                }
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MDWP04");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            SMWThread sMWThread = null;
            int n4 = n2 / this.trial.getPreferences().getBarSpacing() - 1;
            if (n4 < this.list[0].size()) {
                if (n4 != -1) {
                    sMWThread = (SMWThread)this.list[0].elementAt(n4);
                }
                if ((mouseEvent.getModifiers() & 0x10) == 0) {
                    if (n < this.barXCoord) {
                        this.clickedOnObject = sMWThread;
                        if (n4 == -1) {
                            this.popup1.show(this, mouseEvent.getX(), mouseEvent.getY());
                        } else {
                            this.popup2.show(this, mouseEvent.getX(), mouseEvent.getY());
                        }
                    } else if (n4 == -1) {
                        DataSessionIterator dataSessionIterator = new DataSessionIterator(this.list[1]);
                        while (dataSessionIterator.hasNext()) {
                            SMWThreadDataElement sMWThreadDataElement = (SMWThreadDataElement)dataSessionIterator.next();
                            if (n >= sMWThreadDataElement.getXEnd()) continue;
                            this.clickedOnObject = sMWThreadDataElement;
                            this.popup3.show(this, mouseEvent.getX(), mouseEvent.getY());
                            return;
                        }
                    } else {
                        DataSessionIterator dataSessionIterator = (DataSessionIterator)sMWThread.getFunctionListIterator();
                        while (dataSessionIterator.hasNext()) {
                            SMWThreadDataElement sMWThreadDataElement = (SMWThreadDataElement)dataSessionIterator.next();
                            if (n >= sMWThreadDataElement.getXEnd()) continue;
                            this.clickedOnObject = sMWThreadDataElement;
                            this.popup3.show(this, mouseEvent.getX(), mouseEvent.getY());
                            return;
                        }
                    }
                } else if (n < this.barXCoord) {
                    if (n4 == -1) {
                        ThreadDataWindow threadDataWindow = new ThreadDataWindow(this.trial, -1, -1, -1, this.sMWindow.getSMWData(), 0, this.debug());
                        this.trial.getSystemEvents().addObserver(threadDataWindow);
                        threadDataWindow.show();
                    } else {
                        ThreadDataWindow threadDataWindow = new ThreadDataWindow(this.trial, sMWThread.getNodeID(), sMWThread.getContextID(), sMWThread.getThreadID(), this.sMWindow.getSMWData(), 1, this.debug());
                        this.trial.getSystemEvents().addObserver(threadDataWindow);
                        threadDataWindow.show();
                    }
                } else if (n4 == -1) {
                    DataSessionIterator dataSessionIterator = new DataSessionIterator(this.list[1]);
                    while (dataSessionIterator.hasNext()) {
                        SMWThreadDataElement sMWThreadDataElement = (SMWThreadDataElement)dataSessionIterator.next();
                        if (n >= sMWThreadDataElement.getXEnd()) continue;
                        this.trial.getColorChooser().setHighlightColorID(sMWThreadDataElement.getMappingID());
                        MappingDataWindow mappingDataWindow = new MappingDataWindow(this.trial, sMWThreadDataElement.getMappingID(), this.sMWindow.getSMWData(), this.debug());
                        this.trial.getSystemEvents().addObserver(mappingDataWindow);
                        mappingDataWindow.show();
                        return;
                    }
                } else {
                    DataSessionIterator dataSessionIterator = (DataSessionIterator)sMWThread.getFunctionListIterator();
                    while (dataSessionIterator.hasNext()) {
                        SMWThreadDataElement sMWThreadDataElement = (SMWThreadDataElement)dataSessionIterator.next();
                        if (n >= sMWThreadDataElement.getXEnd()) continue;
                        this.trial.getColorChooser().setHighlightColorID(sMWThreadDataElement.getMappingID());
                        MappingDataWindow mappingDataWindow = new MappingDataWindow(this.trial, sMWThreadDataElement.getMappingID(), this.sMWindow.getSMWData(), this.debug());
                        this.trial.getSystemEvents().addObserver(mappingDataWindow);
                        mappingDataWindow.show();
                        return;
                    }
                }
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MDWP05");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        Dimension dimension = null;
        dimension = bl ? this.getSize() : this.sMWindow.getSize();
        dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.lastHeaderEndPosition);
        return dimension;
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        try {
            if (this.trial.userEventsPresent()) {
                this.tUESWItem.setEnabled(true);
            } else {
                this.tUESWItem.setEnabled(false);
            }
            if (this.trial.callPathDataPresent()) {
                this.threadCallpathItem.setEnabled(true);
            } else {
                this.threadCallpathItem.setEnabled(true);
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"SMW03");
        }
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public void changeInMultiples() {
        this.computeBarLength();
        this.repaint();
    }

    public void computeBarLength() {
        try {
            double d = this.sMWindow.getSliderValue();
            double d2 = this.sMWindow.getSliderMultiple();
            this.barLength = this.baseBarLength * (int)(d * d2);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MDWP06");
        }
    }

    private boolean resizePanel(FontMetrics fontMetrics, int n) {
        boolean bl = false;
        try {
            int n2 = (this.sMWindow.getData()[0].size() + 2) * this.barSpacing + 10;
            int n3 = n + this.barLength + 5;
            if (n2 != this.yPanelSize || n3 != this.xPanelSize) {
                this.yPanelSize = n2;
                this.xPanelSize = n3;
                this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
                bl = false;
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MDWP07");
        }
        return bl;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean debug() {
        return this.debug;
    }
}

