/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.loader;

import edu.uoregon.tau.dms.database.ConnectionManager;
import edu.uoregon.tau.dms.database.DB;
import edu.uoregon.tau.dms.loader.Load;
import jargs.gnu.CmdLineParser;

public class LoadExperiment {
    private Load load = null;
    private DB db = null;
    private static String EXP_USAGE = "USAGE: LoadExperiment [{-h,--help}] {-a,--applicationid} applicationID {-x,--xmlfile} filename\n";
    private ConnectionManager connector;

    public LoadExperiment(String string) {
        this.connector = new ConnectionManager(string);
    }

    public ConnectionManager getConnector() {
        return this.connector;
    }

    public Load getLoad() {
        if (this.load == null) {
            this.load = this.connector.getDB() == null ? new Load(this.connector.getParserClass()) : new Load(this.connector.getDB(), this.connector.getParserClass());
        }
        return this.load;
    }

    public String storeExp(String string, String string2) {
        String string3 = null;
        try {
            string3 = this.getLoad().parseExp(string2, string);
        }
        catch (Throwable throwable) {
            System.out.println("Error: " + throwable.getMessage());
            return null;
        }
        if (string3 == null || string3.trim().length() == 0) {
            System.out.println("Loadding experiment failed");
            return null;
        }
        return string3;
    }

    public static void main(String[] stringArray) {
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addBooleanOption('h', "help");
        CmdLineParser.Option option2 = cmdLineParser.addStringOption('g', "configfile");
        CmdLineParser.Option option3 = cmdLineParser.addStringOption('x', "xmlfile");
        CmdLineParser.Option option4 = cmdLineParser.addStringOption('a', "applicationid");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println(optionException.getMessage());
            System.err.println(EXP_USAGE);
            System.exit(-1);
        }
        Boolean bl = (Boolean)cmdLineParser.getOptionValue(option);
        String string = (String)cmdLineParser.getOptionValue(option2);
        String string2 = (String)cmdLineParser.getOptionValue(option3);
        String string3 = (String)cmdLineParser.getOptionValue(option4);
        if (bl != null && bl.booleanValue()) {
            System.err.println(EXP_USAGE);
            System.exit(-1);
        }
        if (string == null) {
            System.err.println("Please enter a valid config file.");
            System.err.println(EXP_USAGE);
            System.exit(-1);
        }
        if (string3 == null) {
            System.err.println("Please enter a valid application ID.");
            System.err.println(EXP_USAGE);
            System.exit(-1);
        }
        if (string2 == null) {
            System.err.println("Please enter a valid experiment XML file.");
            System.err.println(EXP_USAGE);
            System.exit(-1);
        }
        LoadExperiment loadExperiment = new LoadExperiment(string);
        try {
            loadExperiment.getConnector().connect();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        int n = 0;
        String string4 = loadExperiment.storeExp(string3, string2);
        if (string4 != null) {
            n = Integer.parseInt(string4);
        }
        loadExperiment.getConnector().dbclose();
    }
}

