/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.database.DB;
import edu.uoregon.tau.dms.database.DBConnector;
import edu.uoregon.tau.dms.dss.DataSession;
import edu.uoregon.tau.dms.dss.Metric;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class Trial
implements Serializable {
    private int trialID;
    private int experimentID;
    private int applicationID;
    private String name;
    private Vector metric;
    protected DataSession dataSession = null;
    private String[] fields;
    private static String[] fieldNames;
    private static int[] fieldTypes;

    public Trial(int n) {
        this.fields = new String[n];
    }

    public Trial(Trial trial) {
        this.name = trial.getName();
        this.applicationID = trial.getApplicationID();
        this.experimentID = trial.getExperimentID();
        this.trialID = trial.getID();
        this.fields = trial.fields;
    }

    public int getNodeCount() {
        System.err.println("Do not use trial.getNodeCount");
        return -1;
    }

    public int getNumContextsPerNode() {
        System.err.println("Do not use trial.getNumContextsPerNode");
        return -1;
    }

    public int getNumThreadsPerContext() {
        System.err.println("Do not use trial.getNumThreadsPerContext");
        return -1;
    }

    public int[] getMaxNCTNumbers() {
        System.err.println("Do not use trial.getMaxNCTNumbers");
        return new int[3];
    }

    public int getNumFields() {
        return this.fields.length;
    }

    public String getFieldName(int n) {
        return fieldNames[n];
    }

    public int getFieldType(int n) {
        return fieldTypes[n];
    }

    public String getField(int n) {
        return this.fields[n];
    }

    public void setField(int n, String string) {
        if (DBConnector.isIntegerType(fieldTypes[n]) && string != null) {
            try {
                int n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        if (DBConnector.isFloatingPointType(fieldTypes[n]) && string != null) {
            try {
                double d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        this.fields[n] = string;
    }

    public int getID() {
        return this.trialID;
    }

    public int getExperimentID() {
        return this.experimentID;
    }

    public int getApplicationID() {
        return this.applicationID;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public DataSession getDataSession() {
        return this.dataSession;
    }

    public int getMetricCount() {
        if (this.metric == null) {
            return 0;
        }
        return this.metric.size();
    }

    public Vector getMetrics() {
        return this.metric;
    }

    public String getMetricName(int n) {
        if (this.metric != null && n < this.metric.size()) {
            return ((Metric)this.metric.elementAt(n)).getName();
        }
        return null;
    }

    public void setID(int n) {
        this.trialID = n;
    }

    public void setExperimentID(int n) {
        this.experimentID = n;
    }

    public void setApplicationID(int n) {
        this.applicationID = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDataSession(DataSession dataSession) {
        this.dataSession = dataSession;
    }

    public void addMetric(Metric metric) {
        if (this.metric == null) {
            this.metric = new Vector();
        }
        this.metric.addElement(metric);
    }

    private void getTrialMetrics(DB dB) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select id, name ");
        stringBuffer.append("from " + dB.getSchemaPrefix() + "metric ");
        stringBuffer.append("where trial = ");
        stringBuffer.append(this.getID());
        stringBuffer.append(" order by id ");
        try {
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                Metric metric = new Metric();
                metric.setID(resultSet.getInt(1));
                metric.setName(resultSet.getString(2));
                metric.setTrialID(this.getID());
                this.addMetric(metric);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void getMetaData(DB dB) {
        if (fieldNames != null) {
            return;
        }
        try {
            int n;
            ResultSet resultSet = null;
            Object var2_3 = null;
            Object var3_4 = null;
            DatabaseMetaData databaseMetaData = dB.getMetaData();
            resultSet = dB.getDBType().compareTo("oracle") == 0 ? databaseMetaData.getColumns(null, null, "TRIAL", "%") : databaseMetaData.getColumns(null, null, "trial", "%");
            Vector<String> vector = new Vector<String>();
            Vector<Integer> vector2 = new Vector<Integer>();
            while (resultSet.next()) {
                n = resultSet.getInt("DATA_TYPE");
                String string = resultSet.getString("COLUMN_NAME");
                String string2 = resultSet.getString("TYPE_NAME");
                if (!DBConnector.isReadAbleType(n) || string.toUpperCase().compareTo("ID") == 0 || string.toUpperCase().compareTo("NAME") == 0 || string.toUpperCase().compareTo("APPLICATION") == 0 || string.toUpperCase().compareTo("EXPERIMENT") == 0) continue;
                vector.add(resultSet.getString("COLUMN_NAME"));
                vector2.add(new Integer(n));
            }
            resultSet.close();
            fieldNames = new String[vector.size()];
            fieldTypes = new int[vector2.size()];
            for (n = 0; n < vector2.size(); ++n) {
                Trial.fieldNames[n] = (String)vector.get(n);
                Trial.fieldTypes[n] = (Integer)vector2.get(n);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public static Vector getTrialList(DB dB, String string) {
        try {
            Object object;
            Trial.getMetaData(dB);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("select t.id, t.experiment, e.application, ");
            stringBuffer.append("t.name");
            for (int i = 0; i < fieldNames.length; ++i) {
                stringBuffer.append(", t." + fieldNames[i]);
            }
            stringBuffer.append(" from " + dB.getSchemaPrefix() + "trial t inner join " + dB.getSchemaPrefix() + "experiment e ");
            stringBuffer.append("on t.experiment = e.id ");
            stringBuffer.append(string);
            stringBuffer.append(" order by t.id ");
            Vector<Object> vector = new Vector<Object>();
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                object = new Trial(fieldNames.length);
                int n = 1;
                ((Trial)object).setID(resultSet.getInt(n++));
                ((Trial)object).setExperimentID(resultSet.getInt(n++));
                ((Trial)object).setApplicationID(resultSet.getInt(n++));
                ((Trial)object).setName(resultSet.getString(n++));
                for (int i = 0; i < fieldNames.length; ++i) {
                    ((Trial)object).setField(i, resultSet.getString(n++));
                }
                vector.addElement(object);
            }
            resultSet.close();
            object = vector.elements();
            while (object.hasMoreElements()) {
                Trial trial = (Trial)object.nextElement();
                trial.getTrialMetrics(dB);
            }
            return vector;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public int saveTrial(DB dB) {
        boolean bl = this.exists(dB);
        int n = 0;
        try {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            if (bl) {
                stringBuffer.append("UPDATE " + dB.getSchemaPrefix() + "trial SET name = ?, experiment = ?");
                for (n2 = 0; n2 < this.getNumFields(); ++n2) {
                    if (!DBConnector.isWritableType(this.getFieldType(n2))) continue;
                    stringBuffer.append(", " + this.getFieldName(n2) + " = ?");
                }
                stringBuffer.append(" WHERE id = ?");
            } else {
                stringBuffer.append("INSERT INTO " + dB.getSchemaPrefix() + "trial (name, experiment");
                for (n2 = 0; n2 < this.getNumFields(); ++n2) {
                    if (!DBConnector.isWritableType(this.getFieldType(n2))) continue;
                    stringBuffer.append(", " + this.getFieldName(n2));
                }
                stringBuffer.append(") VALUES (?, ?");
                for (n2 = 0; n2 < this.getNumFields(); ++n2) {
                    if (!DBConnector.isWritableType(this.getFieldType(n2))) continue;
                    stringBuffer.append(", ?");
                }
                stringBuffer.append(")");
            }
            PreparedStatement preparedStatement = dB.prepareStatement(stringBuffer.toString());
            int n3 = 1;
            preparedStatement.setString(n3++, this.name);
            preparedStatement.setInt(n3++, this.experimentID);
            for (int i = 0; i < this.getNumFields(); ++i) {
                if (!DBConnector.isWritableType(this.getFieldType(i))) continue;
                preparedStatement.setString(n3++, this.getField(i));
            }
            if (bl) {
                preparedStatement.setInt(n3, this.trialID);
            }
            preparedStatement.executeUpdate();
            preparedStatement.close();
            if (bl) {
                n = this.trialID;
            } else {
                String string = new String();
                string = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM trial" : (dB.getDBType().compareTo("oracle") == 0 ? "select " + dB.getSchemaPrefix() + "trial_id_seq.currval FROM dual" : "select currval('trial_id_seq');"));
                n = Integer.parseInt(dB.getDataItem(string));
            }
            if (!bl) {
                Trial.getMetaData(dB);
                this.fields = new String[fieldNames.length];
            }
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while saving the trial.");
            sQLException.printStackTrace();
        }
        return n;
    }

    public static void deleteTrial(DB dB, int n) {
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.getDBType().compareTo("mysql") == 0 ? dB.prepareStatement(" DELETE atomic_location_profile.* FROM " + dB.getSchemaPrefix() + "atomic_location_profile LEFT JOIN " + dB.getSchemaPrefix() + "atomic_event ON atomic_location_profile.atomic_event = atomic_event.id WHERE atomic_event.trial = ?") : dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "atomic_location_profile WHERE atomic_event in (SELECT id FROM " + dB.getSchemaPrefix() + "atomic_event WHERE trial = ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "atomic_event WHERE trial = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = dB.getDBType().compareTo("mysql") == 0 ? dB.prepareStatement(" DELETE interval_location_profile.* FROM " + dB.getSchemaPrefix() + "interval_location_profile LEFT JOIN " + dB.getSchemaPrefix() + "interval_event ON interval_location_profile.interval_event = interval_event.id WHERE interval_event.trial = ?") : dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "interval_location_profile WHERE interval_event IN (SELECT id FROM " + dB.getSchemaPrefix() + "interval_event WHERE trial = ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = dB.getDBType().compareTo("mysql") == 0 ? dB.prepareStatement(" DELETE interval_mean_summary.* FROM interval_mean_summary LEFT JOIN interval_event ON interval_mean_summary.interval_event = interval_event.id WHERE interval_event.trial = ?") : dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "interval_mean_summary WHERE interval_event IN (SELECT id FROM " + dB.getSchemaPrefix() + "interval_event WHERE trial = ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = dB.getDBType().compareTo("mysql") == 0 ? dB.prepareStatement(" DELETE interval_total_summary.* FROM interval_total_summary LEFT JOIN interval_event ON interval_total_summary.interval_event = interval_event.id WHERE interval_event.trial = ?") : dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "interval_total_summary WHERE interval_event IN (SELECT id FROM " + dB.getSchemaPrefix() + "interval_event WHERE trial = ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "interval_event WHERE trial = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "metric WHERE trial = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = dB.prepareStatement(" DELETE FROM " + dB.getSchemaPrefix() + "trial WHERE id = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while deleting the trial.");
            sQLException.printStackTrace();
        }
    }

    private boolean exists(DB dB) {
        boolean bl = false;
        try {
            PreparedStatement preparedStatement = dB.prepareStatement("SELECT name FROM " + dB.getSchemaPrefix() + "trial WHERE id = ?");
            preparedStatement.setInt(1, this.trialID);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                bl = true;
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while saving the application.");
            sQLException.printStackTrace();
        }
        return bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (fieldNames == null) {
            fieldNames = (String[])objectInputStream.readObject();
        }
        if (fieldTypes == null) {
            fieldTypes = (int[])objectInputStream.readObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(fieldNames);
        objectOutputStream.writeObject(fieldTypes);
    }
}

