/*
 * ResourceTreeIterator.h - TaskJuggler
 *
 * Copyright (c) 2001, 2002, 2003, 2004 by Chris Schlaeger <cs@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * $Id: ResourceTreeIterator.h 1214 2005-11-17 20:05:36Z cs $
 */

#ifndef _ResourceTreeIterator_h_
#define _ResourceTreeIterator_h_

#include "CoreAttributesTreeIterator.h"

template <class T, class R>
class ResourceTreeIteratorT : public virtual T
{
public:
    ResourceTreeIteratorT(R* r, IterationMode m = leavesOnly)
        : T(r, m) { }
    virtual ~ResourceTreeIteratorT() { }

    R* operator*() { return (R*) T::current; }
    R* operator++()
    {
        return (R*) T::operator++();
    }
} ;

typedef ResourceTreeIteratorT<CoreAttributesTreeIterator, Resource>
    ResourceTreeIterator;
typedef ResourceTreeIteratorT<ConstCoreAttributesTreeIterator, const Resource>
    ConstResourceTreeIterator;

#endif

